/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulePanel;
import com.sygate.scm.console.ui.policy.firewall.WindowsFirewallRulePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FirewallSettingsPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JPanel topPanel;
    private JCheckBox enableChk;
    private JRadioButton simpleModeSelectedRadio;
    private JRadioButton advanceModeSelectedRadio;
    private static String ADVANCE_MODE = "Advance";
    private static String SIMPLE_MODE = "Simple";
    private FirewallRulePanel firewallrulePanel;
    private String confirmModeSwitchMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallSettingPane.ConfirmModeSwitch");
    private String confirmModeSwitchDialogTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallSettingPane.title.ConfirmModeSwitch");
    private String advanceLable = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.radio.advance");
    private String simpleLable = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.radio.simple");

    @Override
    public String getContentSensitiveHelpToken() {
        if (this.firewallrulePanel != null) {
            String help = this.firewallrulePanel.getContentSensitiveHelpToken();
            return help;
        }
        return "sesm_policies_dialog_fw_rules_rules";
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)this.getFirewallrulePanel(), "Center");
        this.setVisible(true);
    }

    public FirewallSettingsPanel(GroupPolicyObject groupPolicyObject, String locationName) {
        this(groupPolicyObject, locationName, false);
    }

    public FirewallSettingsPanel(GroupPolicyObject groupPolicyObject, String locationName, boolean isViewMode) {
        if (this.firewallrulePanel == null) {
            this.firewallrulePanel = new WindowsFirewallRulePanel(groupPolicyObject, locationName, false);
            this.firewallrulePanel.setVisible(false);
        }
        this.initialize();
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new GridBagLayout());
        }
        ModeListner modeListner = new ModeListner();
        this.simpleModeSelectedRadio = new JRadioButton(this.simpleLable, true);
        this.simpleModeSelectedRadio.addItemListener(modeListner);
        this.advanceModeSelectedRadio = new JRadioButton(this.advanceLable);
        this.advanceModeSelectedRadio.addItemListener(modeListner);
        ButtonGroup group = new ButtonGroup();
        group.add(this.simpleModeSelectedRadio);
        group.add(this.advanceModeSelectedRadio);
        String enableChkLable = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.checkbox.enabled");
        this.enableChk = new JCheckBox(enableChkLable);
        this.enableChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FirewallSettingsPanel.this.enableAppropriate();
            }
        });
        this.topPanel.add((Component)this.enableChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 0, 0), 0, 0));
        this.topPanel.add((Component)this.simpleModeSelectedRadio, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 50, 0, 0), 0, 0));
        this.topPanel.add((Component)this.advanceModeSelectedRadio, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 50, 20, 0), 0, 0));
        this.topPanel.add(Box.createGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
        return this.topPanel;
    }

    public void setMode() {
        if (this.firewallrulePanel.getFirewallPolicy().getOptMode() == null) {
            this.firewallrulePanel.getFirewallPolicy().setOptMode(ADVANCE_MODE);
        }
        if (this.firewallrulePanel.getFirewallPolicy().getOptMode().equals(SIMPLE_MODE)) {
            this.simpleModeSelectedRadio.setSelected(true);
        } else {
            this.advanceModeSelectedRadio.setSelected(true);
        }
        this.enableAppropriate();
    }

    public String getMode() {
        return this.simpleModeSelectedRadio.isSelected() ? SIMPLE_MODE : ADVANCE_MODE;
    }

    private void enableAppropriate() {
        if (!this.enableChk.isSelected()) {
            this.simpleModeSelectedRadio.setEnabled(false);
            this.advanceModeSelectedRadio.setEnabled(false);
            this.firewallrulePanel.setVisible(false);
        } else {
            this.simpleModeSelectedRadio.setEnabled(true);
            this.advanceModeSelectedRadio.setEnabled(true);
            if (this.firewallrulePanel != null) {
                if (this.advanceModeSelectedRadio.isSelected()) {
                    this.firewallrulePanel.setVisible(true);
                    this.firewallrulePanel.setDefaultRowSelection(0);
                } else if (this.simpleModeSelectedRadio.isSelected()) {
                    this.firewallrulePanel.setVisible(false);
                }
            }
        }
    }

    public FirewallRulePanel getFirewallrulePanel() {
        return this.firewallrulePanel;
    }

    public void setFirewallrulePanel(FirewallRulePanel firewallrulePanel) {
        this.firewallrulePanel = firewallrulePanel;
    }

    public boolean isPolicyEnabled() {
        return this.enableChk.isSelected();
    }

    public void setEnableChk(Boolean enableChk) {
        this.enableChk.setSelected(enableChk);
    }

    public boolean isAdvanceModeSelected() {
        return this.advanceModeSelectedRadio.isSelected();
    }

    private class ModeListner
    implements ItemListener {
        private ModeListner() {
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            int returnflag = 0;
            if ((JRadioButton)ev.getSource() == FirewallSettingsPanel.this.simpleModeSelectedRadio && FirewallSettingsPanel.this.simpleModeSelectedRadio.isSelected() && (returnflag = JOptionPane.showConfirmDialog(Manager.getFrame(), FirewallSettingsPanel.this.confirmModeSwitchMessage, FirewallSettingsPanel.this.confirmModeSwitchDialogTitle, 0, 2)) == 1) {
                FirewallSettingsPanel.this.advanceModeSelectedRadio.setSelected(true);
            }
            FirewallSettingsPanel.this.enableAppropriate();
        }
    }
}

