/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceTrigger;
import com.sygate.scm.common.configobject.schema.Guid;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.firewall.FirewallRuleList;
import com.sygate.scm.console.ui.policy.firewall.NetworkInterfaceHandler;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FirewallRuleObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.NetworkInterfaceGroupObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class FirewallRulesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final String NO = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.No");
    public static final String ENABLED = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Enabled");
    public static final String NAME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Name");
    public static final String SEVERITY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Severity");
    public static final String APPLICATION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Application");
    public static final String HOST = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Host");
    public static final String TIME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Time");
    public static final String SERVICE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Service");
    public static final String INTERFACE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Interface");
    public static final String SCREEN_SAVER = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.ScreenSaver");
    public static final String ACTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Action");
    public static final String TRACKING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Tracking");
    public static final String CREATED_BY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.CreatedAt");
    public static final String DESCRIPTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Description");
    public static final String USE_IN_AGENT = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.UseInAgent");
    public static final String SECURITY_LEVEL_TYPE_HIGH = "H";
    public static final String SECURITY_LEVEL_TYPE_MEDIUM = "M";
    public static final String SECURITY_LEVEL_TYPE_LOW = "L";
    public static final String SECURITY_LEVEL_TYPE_NONE = "N";
    public static final String SECURITY_RULE_BELOW_SECURITY_LEVEL_TYPE = "B";
    private ArrayList<String> columnNames;
    private final String[] enterpriseColumnNames = new String[]{NO, ENABLED, NAME, ACTION, APPLICATION, HOST, SERVICE, TRACKING, SEVERITY, INTERFACE, TIME, SCREEN_SAVER, CREATED_BY, DESCRIPTION};
    private final String[] enterpriseColumnNamesForMac = new String[]{NO, ENABLED, NAME, ACTION, HOST, SERVICE, TRACKING, SEVERITY, CREATED_BY, DESCRIPTION};
    private final String[] smallBusinessColumnNames = new String[]{NO, ENABLED, NAME, ACTION, APPLICATION, HOST, SERVICE, TRACKING};
    private int osType = 1;
    private boolean readOnly = false;
    private GroupPolicyObject groupPolicyObject;
    private FirewallRuleList fireWallRules;
    private List<String> ruleNames = null;

    public FirewallRulesTableModel(GroupPolicyObject groupPolicyObject) {
        this(groupPolicyObject, 1);
    }

    public FirewallRulesTableModel(GroupPolicyObject groupPolicyObject, int osType) {
        this.groupPolicyObject = groupPolicyObject;
        this.osType = osType;
        String[] ruleColumnNames = this.enterpriseColumnNames;
        switch (osType) {
            case 1: {
                ruleColumnNames = LicenseObject.getInstance().isSBProduct() ? this.smallBusinessColumnNames : this.enterpriseColumnNames;
                break;
            }
            case 2: {
                ruleColumnNames = LicenseObject.getInstance().isSBProduct() ? this.smallBusinessColumnNames : this.enterpriseColumnNamesForMac;
                break;
            }
        }
        this.columnNames = new ArrayList<String>(Arrays.asList(ruleColumnNames));
        this.fireWallRules = this.getFirewallRuleList();
    }

    public FirewallRuleObject createNewRule() {
        FirewallRuleObject newRule = new FirewallRuleObject();
        String ruleName = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.RuleName");
        newRule.setName(this.getUniqueName(ruleName, 0));
        newRule.setCreatedBy(this.getGroupName());
        this.addAllAdapter(newRule);
        newRule.setRuleType(SECURITY_LEVEL_TYPE_NONE);
        return newRule;
    }

    public void appendRule(FirewallRuleObject newRule) {
        this.insertRule(this.fireWallRules.size(), newRule);
    }

    public void insertEnforedRule(int index, FirewallRuleObject newRule) {
        this.fireWallRules.addEnforcedRule(index, newRule);
        this.fireTableRowsInserted(index, index + 1);
    }

    public void insertRule(int index, FirewallRuleObject newRule) {
        this.fireWallRules.add(index, newRule);
        this.fireTableRowsInserted(index, index + 1);
    }

    public void deleteRule(int row) {
        this.fireWallRules.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void moveUP(int row) {
        this.fireWallRules.moveUp(row);
    }

    public void moveDown(int row) {
        this.fireWallRules.moveDown(row);
        this.fireTableRowsUpdated(row, row + 1);
    }

    public void removeInheritableRules() {
        this.fireWallRules.removeInheritableRules();
        this.fireTableRowsInserted(0, this.fireWallRules.size() - 1);
    }

    public void update() {
        this.fireWallRules.update();
    }

    public void updateRules() {
        this.fireWallRules.updateRules();
    }

    protected String getGroupName() {
        if (this.groupPolicyObject == null) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.Library");
        }
        return this.groupPolicyObject.getGroupName();
    }

    private FirewallRuleList getFirewallRuleList() {
        if (this.fireWallRules == null) {
            this.fireWallRules = new FirewallRuleList();
        }
        return this.fireWallRules;
    }

    private void addAllAdapter(FirewallRuleObject newRule) {
        ArrayList<NetworkInterfaceGroupObject> existingInterfaceGroups = NetworkInterfaceHandler.getInstance().getInterfaceGroups();
        for (int i = 0; i < existingInterfaceGroups.size(); ++i) {
            NetworkInterfaceGroupObject groupObject = existingInterfaceGroups.get(i);
            FwNetworkInterfaceGroup group = groupObject.getFwInterfaceGroup();
            String interfaceName = group.getName();
            if (!interfaceName.equalsIgnoreCase("All Adapters")) continue;
            ObjReference ref = new ObjReference();
            ref.setTargetId(group.getId());
            ref.setTargetType(group.getObjectTypeName());
            ref.setName(group.getName());
            FwNetworkInterfaceTrigger interfaceTrigger = new FwNetworkInterfaceTrigger();
            interfaceTrigger.addObjReference(ref);
            newRule.setInterfaceTrigger(interfaceTrigger);
            newRule.setInterfaces(new ArrayList<NetworkInterfaceGroupObject>());
            newRule.getInterfaces().add(groupObject);
            break;
        }
    }

    public int getindexFireWallRule(FirewallRuleObject obj) {
        return this.fireWallRules.indexOf(obj);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setRules(FirewallRuleSystem fwRuleSystem) {
        this.fireWallRules.setRules(fwRuleSystem, this.getGroupName());
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.fireWallRules.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        FirewallRuleObject ruleObject = this.fireWallRules.get(row);
        if (ruleObject != null) {
            if (this.osType == 1) {
                return ruleObject.getValueAt(row, column);
            }
            return ruleObject.getValueForMacAt(row, column);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        FirewallRuleObject ruleObject = this.fireWallRules.get(row);
        if (ruleObject != null) {
            if (this.osType == 1) {
                ruleObject.setValueAt(row, column, value);
            } else {
                ruleObject.setValueForMacAt(row, column, value);
            }
            this.fireTableRowsUpdated(row, row);
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    protected ArrayList<String> getColumnNames() {
        return this.columnNames;
    }

    public FirewallRuleObject getRuleObject(int row) {
        return this.fireWallRules.get(row);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.readOnly ? false : this.fireWallRules.get(row).isCellEditable(column, this.osType);
    }

    public void setRuleObject(FirewallRuleObject value, int row) {
        this.fireWallRules.set(row, value);
        this.fireTableRowsUpdated(row, row);
    }

    public String getUniqueName(String ruleName, int startNumber) {
        int j = startNumber;
        String ruleNameTemplate = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulesTableModel.RuleNameTemplate");
        String newName = MessageFormat.format(ruleNameTemplate, ruleName, j);
        while (this.fireWallRules.isRuleNameExisting(newName, -1)) {
            newName = MessageFormat.format(ruleNameTemplate, ruleName, ++j);
        }
        return newName;
    }

    public void setInheritableRules(List<List<FirewallRuleObject>> inheritableRules) {
        this.fireWallRules.setInheritableRules(inheritableRules);
        this.fireTableDataChanged();
    }

    public boolean isNameExisting(String name, int row) {
        return this.fireWallRules.isRuleNameExisting(name, row);
    }

    public List<Guid> getIgnoredParentRuleIds() {
        return this.fireWallRules.getIgnoredParentRuleIds();
    }

    protected FirewallRuleSystem getFirewallRuleSystem() {
        return this.fireWallRules.getFirewallRuleSystem();
    }

    List<String> getRuleNames() {
        if (this.ruleNames == null) {
            this.ruleNames = new ArrayList<String>();
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.ruleNames.add(this.getRuleObject(i).getName());
            }
        }
        return this.ruleNames;
    }

    public int getEnforcedRuleSize() {
        return this.fireWallRules.getEnforcedRuleSize();
    }

    public int getBaselineRuleSize() {
        return this.fireWallRules.getBaselineRuleSize();
    }
}

