/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.BaselineFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.EnforcedFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.FirewallRule;
import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.FwApplicationTrigger;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.FwHostTrigger;
import com.sygate.scm.common.configobject.schema.FwServiceTrigger;
import com.sygate.scm.common.configobject.schema.FwTimeTrigger;
import com.sygate.scm.common.configobject.schema.SoApplicationContainer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.AdditionalTextDialog;
import com.sygate.scm.console.ui.policy.firewall.FirewallNotificationPanel;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulesTableModel;
import com.sygate.scm.console.ui.policy.firewall.Handler.FirewallPolicyHandler;
import com.sygate.scm.console.ui.policy.firewall.RuleNameCellEditor;
import com.sygate.scm.console.ui.policy.firewall.dialog.ApplicationListDialog;
import com.sygate.scm.console.ui.policy.firewall.dialog.CreateRuleWizardDialog;
import com.sygate.scm.console.ui.policy.firewall.dialog.FirewallRuleHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostListDialog;
import com.sygate.scm.console.ui.policy.firewall.dialog.ScheduleListDialog;
import com.sygate.scm.console.ui.policy.firewall.dialog.ServiceListDialog;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FirewallRuleObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostContainerObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostEnableObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.ui.policy.firewall.popup.ActionPopup;
import com.sygate.scm.console.ui.policy.firewall.popup.InterfacePopup;
import com.sygate.scm.console.ui.policy.firewall.popup.ScreenSaverPopup;
import com.sygate.scm.console.ui.policy.firewall.popup.TrackingPopup;
import com.sygate.scm.console.ui.policy.firewall.renderer.CheckRenderer;
import com.sygate.scm.console.ui.policy.firewall.renderer.ComboCellEditor;
import com.sygate.scm.console.ui.policy.firewall.renderer.InterfaceRenderer;
import com.sygate.scm.console.ui.policy.firewall.renderer.ListObjectCellRenderer;
import com.sygate.scm.console.ui.policy.firewall.renderer.SingleValueRenderer;
import com.sygate.scm.console.ui.policy.firewall.renderer.TrackingRenderer;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.xml.sax.SAXException;

public abstract class FirewallRulePanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 6651046121462981778L;
    public static final int FORE_GROUND_INDEX = 0;
    public static final int BACK_GROUND_INDEX = 1;
    private static final Border CELL_BORDER = BorderFactory.createEmptyBorder(3, 0, 3, 0);
    private static final int ROW_HEIGHT = 16;
    private JRuleTable firewallRulesTable;
    private FirewallRulesTableModel firewallRulesModel;
    private Map<String, String> firewallRuleTableColumnNames = null;
    private Action editAction;
    private Action addRuleAction;
    private Action copyRuleAction;
    private Action pasteRuleAction;
    private Action deleteRuleAction;
    private Action enableRuleAction;
    private Action moveUpAction;
    private Action moveDownAction;
    private Action importAction;
    private Action exportAction;
    private Action addAction;
    private Action addBlankRuleAction;
    private ActionPopup actionPopupMenu;
    private JCheckBoxMenuItem enableRuleItem;
    private JCheckBox inheritRulesCheck;
    private JPopupMenu rulePopupMenu;
    private JPopupMenu impExpPopup;
    private TrackingPopup trackingPopupMenu;
    private ScreenSaverPopup screenSaverPopupMenu;
    private InterfacePopup interfacePopupMenu;
    private JPanel contentPanel;
    private JScrollPane rulesPanel;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel buttonPanel;
    private final JTabbedPane jtabPane = new JTabbedPane();
    private JButton addRuleButton;
    private JButton deleteRuleButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton addBlankRuleButton;
    protected FwFirewallPolicy firewallPolicy;
    private FirewallRuleSystem fwRuleSystem;
    private FirewallNotificationPanel notificationPanel;
    private final GroupPolicyObject groupPolicyObject;
    private final String locationName;
    private boolean readOnly = false;
    private boolean isViewMode = false;
    private boolean saved = false;
    private int selectedRowIndex;
    private final float[] viewModeColSizes = new float[]{0.1f, 0.1f, 0.4f, 0.2f, 0.2f};
    private final float[] smallBusinessColSizes = new float[]{0.02f, 0.06f, 0.19f, 0.085f, 0.08f, 0.07f, 0.19f, 0.07f};
    private final float[] colSizes;
    private LicenseObject licenseObject = LicenseObject.getInstance();

    public FirewallRulePanel(GroupPolicyObject groupPolicyObject, String locationName, float[] colSizes, boolean isViewMode) {
        this.groupPolicyObject = groupPolicyObject;
        this.locationName = locationName;
        this.isViewMode = isViewMode;
        this.colSizes = isViewMode ? this.viewModeColSizes : (this.licenseObject.isSBProduct() ? this.smallBusinessColSizes : colSizes);
        this.init();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return this.jtabPane.getSelectedComponent().getName();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setRulesTable();
        this.setRenderers();
        this.notificationPanel = new FirewallNotificationPanel(this.isMacRulePanel());
        if (this.isViewMode) {
            this.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getRulesPanel()), "Center");
        } else {
            this.jtabPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.rules"), this.getRulePanel());
            this.jtabPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.notifications"), UIUtilities.createScrollPaneWithoutBoard(this.notificationPanel.getFirewallNotificationPanel()));
            this.add(this.jtabPane);
        }
        this.enableTables(!this.readOnly && !this.isViewMode);
        this.firewallRulesModel = this.getFirewallRulesTableModel();
    }

    public void setDefaultRowSelection(int row) {
        if (this.firewallRulesTable.getModel().getRowCount() > 0) {
            this.firewallRulesTable.changeSelection(row, 0, false, false);
        }
    }

    private JPanel getRulePanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel(new BorderLayout());
        }
        this.contentPanel.setName("sesm_policies_dialog_fw_rules_rules");
        this.contentPanel.add((Component)this.getTopPanel(), "North");
        this.contentPanel.add((Component)this.getCenterPanel(), "Center");
        return this.contentPanel;
    }

    public void setFirewallPolicy(FwFirewallPolicy firewallPolicy) {
        this.firewallPolicy = firewallPolicy;
        this.setValues();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.enableTables(!readOnly && !this.isViewMode);
        UIUtilities.setContainerStatus(this.getButtonsPanel(), !readOnly);
        this.notificationPanel.setReadOnly();
        if (!readOnly && !this.isViewMode) {
            this.getInheritRulesCheck().setEnabled(this.groupPolicyObject != null && !this.groupPolicyObject.isTopGroup());
            this.notificationPanel.resetDisabledItem();
        }
        this.validate();
    }

    private void setValues() {
        this.fwRuleSystem = this.getFirewallRuleSystem();
        this.notificationPanel.setPolicy(this.firewallPolicy);
        this.firewallRulesModel.setRules(this.fwRuleSystem);
        if (this.getFirewallRulesTableModel().getRowCount() > 0) {
            this.setRowHeights();
        }
        this.getInheritRulesCheck().setEnabled(this.groupPolicyObject != null && !this.groupPolicyObject.isTopGroup());
        Boolean mergeLocalAndParentRules = this.fwRuleSystem.getOptMergeLocalAndParentRules();
        if (mergeLocalAndParentRules != null) {
            this.getInheritRulesCheck().setSelected(mergeLocalAndParentRules);
        }
        Dimension size = this.getRulesPanel().getPreferredSize();
        int ruleNumber = this.getFirewallRulesTableModel().getRowCount();
        if (ruleNumber > 6) {
            this.setTablePreferredScrollableViewportSize(size.width - 13);
        } else {
            this.setTablePreferredScrollableViewportSize(size.width - 1);
        }
    }

    private void setRowHeights() {
        FirewallRulesTableModel tableModel = (FirewallRulesTableModel)this.firewallRulesTable.getModel();
        int count = tableModel.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.updateRowHeight(i, tableModel.getRuleObject(i));
        }
    }

    public void updateRowHeight(int row, FirewallRuleObject ruleObject) {
        int colCount = this.firewallRulesTable.getColumnModel().getColumnCount();
        this.firewallRulesTable.setRowHeight(row, this.getPreferredRowHeight(ruleObject, colCount <= 5));
    }

    private int getPreferredCellHeight(FirewallRuleObject ruleObject, String colIdentifier, Object value) {
        TableColumn column = this.getTableColumn(colIdentifier, this.firewallRulesTable);
        if (null == column) {
            return 0;
        }
        TableCellRenderer renderer = column.getCellRenderer();
        if (null == renderer) {
            return 0;
        }
        Component component = renderer.getTableCellRendererComponent(this.firewallRulesTable, value, false, false, 0, 0);
        if (null == component) {
            return 0;
        }
        Dimension dimension = component.getPreferredSize();
        if (null == dimension) {
            return 0;
        }
        return dimension.height;
    }

    private int getPreferredRowHeight(FirewallRuleObject ruleObject, boolean isViewMode) {
        int maxSize = 16;
        if (ruleObject != null && !isViewMode) {
            maxSize = this.getPreferredCellHeight(ruleObject, FirewallRulesTableModel.NAME, ruleObject.getName());
            maxSize = Math.max(maxSize, this.getPreferredCellHeight(ruleObject, FirewallRulesTableModel.APPLICATION, ruleObject.getApplications()));
            maxSize = Math.max(maxSize, this.getPreferredCellHeight(ruleObject, FirewallRulesTableModel.HOST, ruleObject.getHosts()));
            maxSize = Math.max(maxSize, this.getPreferredCellHeight(ruleObject, FirewallRulesTableModel.TIME, ruleObject.getSchedules()));
            maxSize = Math.max(maxSize, this.getPreferredCellHeight(ruleObject, FirewallRulesTableModel.INTERFACE, ruleObject.getInterfacesForDisplayInTable()));
            maxSize = Math.max(maxSize, this.getPreferredCellHeight(ruleObject, FirewallRulesTableModel.SERVICE, ruleObject.getProtocolContainers()));
            maxSize = Math.max(maxSize, this.getPreferredCellHeight(ruleObject, FirewallRulesTableModel.ACTION, ruleObject.getAction()));
            maxSize = Math.max(maxSize, this.getPreferredCellHeight(ruleObject, FirewallRulesTableModel.TRACKING, ruleObject.getTracking()));
        }
        return maxSize;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            String rulesList = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.label.rulesList");
            this.topPanel = new AvTemplatePane(rulesList, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.InfoPolicyDescription"));
        }
        return this.topPanel;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel(new BorderLayout(0, 5));
            this.centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 30, 5, 30));
            this.centerPanel.add((Component)this.getInheritPanel(), "North");
            this.centerPanel.add((Component)this.getRulesPanel(), "Center");
            this.centerPanel.add((Component)this.getButtonsPanel(), "South");
        }
        return this.centerPanel;
    }

    private JPanel getInheritPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getInheritRulesCheck(), "West");
        return panel;
    }

    private JScrollPane getRulesPanel() {
        if (this.rulesPanel == null) {
            this.rulesPanel = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)this.rulesPanel, (JTable)this.firewallRulesTable);
            this.rulesPanel.setColumnHeaderView(this.firewallRulesTable.getTableHeader());
            Dimension size = this.firewallRulesTable.getPreferredScrollableViewportSize();
            size.height /= 2;
            if (!this.isViewMode) {
                size.width *= 2;
            }
            this.rulesPanel.setPreferredSize(size);
        }
        return this.rulesPanel;
    }

    private void enableTables(boolean enabled) {
        this.firewallRulesTable.setEnabled(enabled);
        this.getFirewallRulesTableModel().setReadOnly(!enabled);
    }

    public void setTablePreferredScrollableViewportSize(float width) {
        UIUtilities.resizeColumns(this.firewallRulesTable, this.colSizes, width, !this.isViewMode);
    }

    private JCheckBox getInheritRulesCheck() {
        if (this.inheritRulesCheck == null) {
            this.inheritRulesCheck = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.checkbox.InheritFirewallRules"));
            this.inheritRulesCheck.setEnabled(this.groupPolicyObject != null && !this.groupPolicyObject.isTopGroup());
            this.inheritRulesCheck.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    if (ev.getStateChange() == 1) {
                        FirewallRulePanel.this.setParentRules();
                    } else {
                        FirewallRulePanel.this.removeParentRules();
                    }
                }
            });
        }
        return this.inheritRulesCheck;
    }

    private JTable setRulesTable() {
        if (this.firewallRulesTable == null) {
            this.firewallRulesTable = this.getRulesTable(this.getFirewallRulesTableModel());
        }
        return this.firewallRulesTable;
    }

    private JRuleTable getRulesTable(FirewallRulesTableModel model) {
        if (this.firewallRulesTable == null) {
            this.firewallRulesTable = new JRuleTable(this);
            if (this.isViewMode) {
                this.firewallRulesTable.setAutoResizeMode(4);
            } else {
                this.firewallRulesTable.setRowHeight(30);
                this.firewallRulesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
                this.firewallRulesTable.addMouseListener(this.getNewTableMouseListener());
                this.firewallRulesTable.setAutoResizeMode(0);
                this.firewallRulesTable.getSelectionModel().addListSelectionListener(this.getNewTableSelectionListener(this.firewallRulesTable, model));
                this.firewallRulesTable.setSelectionMode(2);
            }
            this.firewallRulesTable.setModel(model);
            this.firewallRulesTable.setCellSelectionEnabled(true);
        }
        return this.firewallRulesTable;
    }

    private MouseListener getNewTableMouseListener() {
        MouseAdapter tableMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                FirewallRulePanel.this.mayShowPopup(ev);
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                if (ev.isPopupTrigger()) {
                    FirewallRulePanel.this.mayShowPopup(ev);
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (ev.isPopupTrigger()) {
                    FirewallRulePanel.this.mayShowPopup(ev);
                }
            }
        };
        return tableMouseListener;
    }

    private boolean checkSecurityLevelRuleClicked(MouseEvent ev) {
        JTable firewallRulesTable = (JTable)ev.getSource();
        int rowCount = firewallRulesTable.rowAtPoint(ev.getPoint());
        FirewallRuleObject ruleObject = this.firewallRulesModel.getRuleObject(rowCount);
        return ruleObject.isSecurityRule() || ruleObject.isBelowSecurityRule();
    }

    public JTable getFirewallRuleTable() {
        return this.firewallRulesTable;
    }

    private void disableAllButtons() {
        this.addRuleButton.setEnabled(false);
        this.deleteRuleButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
    }

    private void mayShowPopup(MouseEvent ev) {
        if (this.licenseObject.isSBProduct()) {
            // empty if block
        }
        int colNumber = this.firewallRulesTable.columnAtPoint(ev.getPoint());
        int rowCount = this.firewallRulesTable.rowAtPoint(ev.getPoint());
        if (rowCount < 0 || colNumber < 0) {
            return;
        }
        if (this.licenseObject.isSBProduct() && rowCount >= this.getSecurityLevelRuleRow()) {
            return;
        }
        int[] rows = this.getSelectedRows(true, ev);
        if (this.licenseObject.isSBProduct() && this.checkSecurityLevelRuleClicked(ev)) {
            this.disableAllButtons();
        } else if (!this.readOnly && !this.isViewMode && this.firewallRulesTable.isEnabled()) {
            this.addRuleButton.setEnabled(true);
            if (rows == null || rows.length == 0) {
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
                this.deleteRuleButton.setEnabled(false);
                if (!this.licenseObject.isSBProduct() && ev.isPopupTrigger()) {
                    this.showImpExpPopupMenu(ev);
                }
            } else {
                FirewallRuleObject ruleObject;
                if (this.licenseObject.isSBProduct() && this.checkSecurityLevelRuleClicked(ev)) {
                    this.disableAllButtons();
                }
                if (this.licenseObject.isSBProduct() && rowCount == this.getSecurityLevelRuleRow() - 1) {
                    this.moveDownButton.setEnabled(false);
                } else if (rowCount == this.firewallRulesModel.getRowCount() - 1) {
                    this.moveDownButton.setEnabled(this.firewallRulesModel.getBaselineRuleSize() == 0);
                }
                if (rowCount == 0) {
                    this.moveUpButton.setEnabled(this.firewallRulesModel.getEnforcedRuleSize() == 0);
                }
                if ((ruleObject = this.firewallRulesModel.getRuleObject(rows[0])).getType() == 1) {
                    return;
                }
                if (ev.getClickCount() == 2) {
                    if (colNumber == this.getTableColumnIndex(FirewallRulesTableModel.APPLICATION, this.firewallRulesTable)) {
                        this.showApplicationList();
                    } else if (colNumber == this.getTableColumnIndex(FirewallRulesTableModel.HOST, this.firewallRulesTable)) {
                        this.showHostList();
                    } else if (colNumber == this.getTableColumnIndex(FirewallRulesTableModel.SERVICE, this.firewallRulesTable)) {
                        this.showServiceList();
                    } else if (!this.licenseObject.isSBProduct() && colNumber == this.getTableColumnIndex(FirewallRulesTableModel.TIME, this.firewallRulesTable)) {
                        this.showScheduleList();
                    } else if (!this.licenseObject.isSBProduct() && colNumber == this.getTableColumnIndex(FirewallRulesTableModel.DESCRIPTION, this.firewallRulesTable)) {
                        this.showDescriptionDialog();
                    } else {
                        this.popupContextMenu(ev, colNumber);
                    }
                }
                if (ev.isPopupTrigger() && !this.isInheritedRulesSelected()) {
                    this.popupContextMenu(ev, colNumber);
                }
            }
        }
    }

    private void popupContextMenu(MouseEvent ev, int colNumber) {
        int[] rows = this.getSelectedRows(true, ev);
        FirewallRuleObject ruleObject = this.firewallRulesModel.getRuleObject(rows[0]);
        if (!this.licenseObject.isSBProduct() && colNumber == this.getTableColumnIndex(FirewallRulesTableModel.INTERFACE, this.firewallRulesTable)) {
            this.showInterfacePopup(ev, rows[0]);
        } else if (colNumber == this.getTableColumnIndex(FirewallRulesTableModel.ACTION, this.firewallRulesTable)) {
            this.showActionPopup(ev, rows[0]);
        } else if (colNumber == this.getTableColumnIndex(FirewallRulesTableModel.TRACKING, this.firewallRulesTable)) {
            this.showTrackingPopup(ev, rows[0]);
        } else if (!this.licenseObject.isSBProduct() && colNumber == this.getTableColumnIndex(FirewallRulesTableModel.CREATED_BY, this.firewallRulesTable)) {
            this.getEnableRuleCheck().setSelected(ruleObject.getEnabled());
            this.getRulePopupMenu().show(ev.getComponent(), ev.getX(), ev.getY());
        } else if (!this.licenseObject.isSBProduct() && colNumber == this.getTableColumnIndex(FirewallRulesTableModel.SCREEN_SAVER, this.firewallRulesTable)) {
            this.showScreenSaverPopup(ev, rows[0]);
        } else {
            this.getEnableRuleCheck().setSelected(ruleObject.getEnabled());
            if (!this.checkSecurityLevelRuleClicked(ev)) {
                this.getRulePopupMenu().show(ev.getComponent(), ev.getX(), ev.getY());
            }
        }
    }

    private int[] getSelectedRows(boolean forceSelection, MouseEvent ev) {
        int[] rows = null;
        boolean ctrlKeyPressed = (ev.getModifiers() & 2) != 0;
        Point clickedPoint = ev.getPoint();
        rows = this.firewallRulesTable.getSelectedRows();
        if (forceSelection && clickedPoint != null) {
            int row = this.firewallRulesTable.rowAtPoint(clickedPoint);
            int column = this.firewallRulesTable.columnAtPoint(clickedPoint);
            if (row != -1 && this.outOfRange(row, rows) && !ctrlKeyPressed && ev.isPopupTrigger()) {
                rows = new int[]{row};
                this.firewallRulesTable.changeSelection(rows[0], 0, false, false);
                this.firewallRulesTable.editCellAt(rows[0], column);
            }
            if ((rows = this.firewallRulesTable.getSelectedRows()).length == 1) {
                this.firewallRulesTable.changeSelection(rows[0], column, false, false);
                this.firewallRulesTable.editCellAt(rows[0], column);
            }
        }
        return rows;
    }

    private boolean outOfRange(int row, int[] rows) {
        boolean outOfRange = true;
        if (rows != null) {
            for (int i = 0; i < rows.length; ++i) {
                if (row != rows[i]) continue;
                outOfRange = false;
                break;
            }
        }
        return outOfRange;
    }

    private TableColumn getTableColumn(String colIdentifier, JTable table) {
        TableColumnModel colModel = table.getColumnModel();
        int index = this.getTableColumnIndex(colIdentifier, table);
        return index == -1 ? null : colModel.getColumn(index);
    }

    private int getTableColumnIndex(String colIdentifier, JTable table) {
        int index = -1;
        if (!this.firewallRuleTableColumnNames.containsKey(colIdentifier)) {
            return index;
        }
        TableColumnModel colModel = table.getColumnModel();
        try {
            index = colModel.getColumnIndex(colIdentifier);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            index = -1;
        }
        return index;
    }

    private ListSelectionListener getNewTableSelectionListener(JTable table, FirewallRulesTableModel model) {
        ListSelectionListener tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                ListSelectionModel lsm;
                if (!(ev.getValueIsAdjusting() || FirewallRulePanel.this.readOnly || FirewallRulePanel.this.isViewMode || !FirewallRulePanel.this.firewallRulesTable.isEnabled() || (lsm = (ListSelectionModel)ev.getSource()).isSelectionEmpty())) {
                    FirewallRulePanel.this.getExport().setEnabled(true);
                    FirewallRulePanel.this.selectedRowIndex = lsm.getMinSelectionIndex();
                    if (FirewallRulePanel.this.selectedRowIndex >= 0) {
                        if (FirewallRulePanel.this.licenseObject.isSBProduct() && FirewallRulePanel.this.isSecurityOrBelowSecurityRuleClicked(FirewallRulePanel.this.selectedRowIndex)) {
                            FirewallRulePanel.this.disableAllButtons();
                            return;
                        }
                        int[] selectedRows = FirewallRulePanel.this.firewallRulesTable.getSelectedRows();
                        if (selectedRows.length >= 1 && selectedRows[0] >= FirewallRulePanel.this.firewallRulesModel.getEnforcedRuleSize() + FirewallRulePanel.this.firewallRulesModel.getBaselineRuleSize()) {
                            if (FirewallRulePanel.this.firewallRulesModel.getBaselineRuleSize() != 0 || FirewallRulePanel.this.firewallRulesModel.getEnforcedRuleSize() != 0) {
                                FirewallRulePanel.this.firewallRulesTable.setRowSelectionInterval(0, 0);
                            } else {
                                FirewallRulePanel.this.disableAllButtons();
                                return;
                            }
                        }
                        FirewallRulePanel.this.getDeleteRuleButton().setEnabled(true);
                        FirewallRulePanel.this.setMoveUpOrDownButtonState(FirewallRulePanel.this.firewallRulesTable.getSelectedRows());
                        if (FirewallRulePanel.this.selectedRowIndex == 0 && FirewallRulePanel.this.getSecurityLevelRuleRow() == FirewallRulePanel.this.selectedRowIndex + 1) {
                            FirewallRulePanel.this.getMoveUpButton().setEnabled(false);
                        }
                    }
                    FirewallRulePanel.this.updateButtonState(lsm);
                }
            }
        };
        return tableSelectionListener;
    }

    private void updateButtonState(ListSelectionModel lsm) {
        this.selectedRowIndex = lsm.getMinSelectionIndex();
        this.addRuleButton.setEnabled(true);
        if (this.selectedRowIndex < 0) {
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.deleteRuleButton.setEnabled(false);
        } else if (this.licenseObject.isSBProduct() && this.selectedRowIndex == this.getSecurityLevelRuleRow() - 1) {
            this.moveDownButton.setEnabled(false);
        }
    }

    private boolean isSecurityOrBelowSecurityRuleClicked(int selectedRowIndex) {
        FirewallRuleObject ruleObject = this.firewallRulesModel.getRuleObject(selectedRowIndex);
        return ruleObject.isSecurityRule() || ruleObject.isBelowSecurityRule();
    }

    private FirewallRulesTableModel getFirewallRulesTableModel() {
        if (this.firewallRulesModel == null) {
            this.firewallRulesModel = new FirewallRulesTableModel(this.groupPolicyObject, this.getOperatingSystemPlatform());
            ArrayList<String> columnNames = this.firewallRulesModel.getColumnNames();
            this.firewallRuleTableColumnNames = new HashMap<String, String>(columnNames.size());
            for (String columnName : columnNames) {
                this.firewallRuleTableColumnNames.put(columnName, columnName);
            }
        }
        return this.firewallRulesModel;
    }

    private void setRenderers() {
        TableColumn descriptionColumn;
        TableColumn screenSaverColumn;
        TableColumn timeColumn;
        TableColumn createdByColumn;
        TableColumn interfaceColumn;
        TableColumn severityColumn;
        TableColumn serviceColumn;
        TableColumn hostColumn;
        TableColumn applicationsColumn;
        TableColumn enableColumn;
        TableColumn trackingColumn;
        TableColumn actionColumn;
        TableColumn nameColumn;
        TableColumn noColumn = this.getTableColumn(FirewallRulesTableModel.NO, this.firewallRulesTable);
        if (noColumn != null) {
            noColumn.setCellRenderer(new SingleValueRenderer(this));
        }
        if ((nameColumn = this.getTableColumn(FirewallRulesTableModel.NAME, this.firewallRulesTable)) != null) {
            nameColumn.setCellRenderer(new SingleValueRenderer(this));
        }
        if ((actionColumn = this.getTableColumn(FirewallRulesTableModel.ACTION, this.firewallRulesTable)) != null) {
            actionColumn.setCellRenderer(new SingleValueRenderer(this));
        }
        if ((trackingColumn = this.getTableColumn(FirewallRulesTableModel.TRACKING, this.firewallRulesTable)) != null) {
            trackingColumn.setCellRenderer(new TrackingRenderer(this));
        }
        if ((enableColumn = this.getTableColumn(FirewallRulesTableModel.ENABLED, this.firewallRulesTable)) != null) {
            enableColumn.setCellRenderer(new CheckRenderer(this));
            DefaultCellEditor chkCellEditor = new DefaultCellEditor(this.getEnabledCheckBox());
            enableColumn.setCellEditor(chkCellEditor);
        }
        if ((applicationsColumn = this.getTableColumn(FirewallRulesTableModel.APPLICATION, this.firewallRulesTable)) != null) {
            applicationsColumn.setCellRenderer(new ListObjectCellRenderer(this));
        }
        if ((hostColumn = this.getTableColumn(FirewallRulesTableModel.HOST, this.firewallRulesTable)) != null) {
            hostColumn.setCellRenderer(new ListObjectCellRenderer(this));
        }
        if ((serviceColumn = this.getTableColumn(FirewallRulesTableModel.SERVICE, this.firewallRulesTable)) != null) {
            serviceColumn.setCellRenderer(new ListObjectCellRenderer(this));
        }
        if ((severityColumn = this.getTableColumn(FirewallRulesTableModel.SEVERITY, this.firewallRulesTable)) != null) {
            severityColumn.setCellRenderer(new SingleValueRenderer(this));
        }
        if ((interfaceColumn = this.getTableColumn(FirewallRulesTableModel.INTERFACE, this.firewallRulesTable)) != null) {
            interfaceColumn.setCellRenderer(new InterfaceRenderer(this));
        }
        if ((createdByColumn = this.getTableColumn(FirewallRulesTableModel.CREATED_BY, this.firewallRulesTable)) != null) {
            createdByColumn.setCellRenderer(new SingleValueRenderer(this));
        }
        if ((timeColumn = this.getTableColumn(FirewallRulesTableModel.TIME, this.firewallRulesTable)) != null) {
            timeColumn.setCellRenderer(new ListObjectCellRenderer(this));
        }
        if ((screenSaverColumn = this.getTableColumn(FirewallRulesTableModel.SCREEN_SAVER, this.firewallRulesTable)) != null) {
            screenSaverColumn.setCellRenderer(new SingleValueRenderer(this));
        }
        if ((descriptionColumn = this.getTableColumn(FirewallRulesTableModel.DESCRIPTION, this.firewallRulesTable)) != null) {
            descriptionColumn.setCellRenderer(new SingleValueRenderer(this));
        }
    }

    private JCheckBox getEnabledCheckBox() {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setHorizontalAlignment(0);
        checkBox.setVerticalAlignment(1);
        return checkBox;
    }

    private JTextField getRuleNameTextField() {
        RestrictedPlainDocument doc = new RestrictedPlainDocument(256);
        doc.setValidator("\"/\\*?<>|:", false);
        JTextField ruleNameTextField = new JTextField(doc, "", 0);
        return ruleNameTextField;
    }

    private void setMultiRowPopup(JPopupMenu popupMenu) {
        if (popupMenu != null) {
            popupMenu.removeAll();
            popupMenu.add(this.getDeleteRule());
            if (!this.licenseObject.isSBProduct()) {
                popupMenu.add(this.getExport());
            }
        }
    }

    private ScreenSaverPopup getScreenSaverPopupMenu() {
        this.screenSaverPopupMenu = new ScreenSaverPopup();
        int row = this.firewallRulesTable.getSelectedRowCount();
        if (row > 1) {
            this.setMultiRowPopup(this.screenSaverPopupMenu);
            return this.screenSaverPopupMenu;
        }
        this.screenSaverPopupMenu.addSeparator();
        this.appendRuleActions(this.screenSaverPopupMenu);
        return this.screenSaverPopupMenu;
    }

    private boolean isInheritedRulesSelected() {
        boolean isInheritedRulesSelected = false;
        int[] rows = this.firewallRulesTable.getSelectedRows();
        if (rows != null && rows.length > 0 && this.firewallRulesModel != null) {
            for (int i = 0; i < rows.length; ++i) {
                FirewallRuleObject fwObj = this.firewallRulesModel.getRuleObject(rows[i]);
                if (fwObj == null || !fwObj.isInherited()) continue;
                isInheritedRulesSelected = true;
                break;
            }
        }
        return isInheritedRulesSelected;
    }

    private InterfacePopup getInterfacePopupMenu() {
        this.interfacePopupMenu = new InterfacePopup();
        int row = this.firewallRulesTable.getSelectedRowCount();
        if (row > 1) {
            this.setMultiRowPopup(this.interfacePopupMenu);
            return this.interfacePopupMenu;
        }
        this.interfacePopupMenu.addSeparator();
        this.appendRuleActions(this.interfacePopupMenu);
        return this.interfacePopupMenu;
    }

    private ActionPopup getActionPopupMenu(MouseEvent ev) {
        this.actionPopupMenu = new ActionPopup(this.isMacRulePanel());
        int row = this.firewallRulesTable.getSelectedRowCount();
        if (row > 1) {
            this.setMultiRowPopup(this.actionPopupMenu);
            return this.actionPopupMenu;
        }
        if (!this.checkSecurityLevelRuleClicked(ev)) {
            this.actionPopupMenu.addSeparator();
            this.appendRuleActions(this.actionPopupMenu);
        }
        return this.actionPopupMenu;
    }

    private TrackingPopup getTrackingPopupMenu(MouseEvent ev) {
        this.trackingPopupMenu = new TrackingPopup(this.isMacRulePanel());
        int row = this.firewallRulesTable.getSelectedRowCount();
        if (row > 1) {
            this.setMultiRowPopup(this.trackingPopupMenu);
            return this.trackingPopupMenu;
        }
        if (!this.checkSecurityLevelRuleClicked(ev)) {
            this.trackingPopupMenu.addSeparator();
            this.appendRuleActions(this.trackingPopupMenu);
        }
        return this.trackingPopupMenu;
    }

    private void appendRuleActions(JPopupMenu menu) {
        if (!this.licenseObject.isSBProduct()) {
            menu.add(this.getAddBlankRule());
        }
        menu.add(this.getAddRule());
        menu.add(this.getDeleteRule());
        menu.addSeparator();
        menu.add(this.getCopyRule());
        menu.add(this.getPasteRule());
        menu.addSeparator();
        menu.add(this.getMoveUp());
        menu.add(this.getMoveDown());
        if (!this.licenseObject.isSBProduct()) {
            menu.addSeparator();
            menu.add(this.getImport());
            menu.add(this.getExport());
        }
        this.setMoveUpOrDownActionState(this.firewallRulesTable.getSelectedRows());
    }

    private JPopupMenu getRulePopupMenu() {
        this.rulePopupMenu = new JPopupMenu();
        int row = this.firewallRulesTable.getSelectedRowCount();
        int colNumber = this.firewallRulesTable.getSelectedColumn();
        if (row > 1) {
            this.setMultiRowPopup(this.rulePopupMenu);
            return this.rulePopupMenu;
        }
        if (this.licenseObject.isSBProduct() && colNumber != this.getTableColumnIndex(FirewallRulesTableModel.ENABLED, this.firewallRulesTable) && colNumber != this.getTableColumnIndex(FirewallRulesTableModel.NO, this.firewallRulesTable) && colNumber != this.getTableColumnIndex(FirewallRulesTableModel.NAME, this.firewallRulesTable)) {
            this.rulePopupMenu.add(this.getEdit());
            this.rulePopupMenu.addSeparator();
        } else if (!this.licenseObject.isSBProduct() && colNumber != this.getTableColumnIndex(FirewallRulesTableModel.ENABLED, this.firewallRulesTable) && colNumber != this.getTableColumnIndex(FirewallRulesTableModel.CREATED_BY, this.firewallRulesTable) && colNumber != this.getTableColumnIndex(FirewallRulesTableModel.NO, this.firewallRulesTable) && colNumber != this.getTableColumnIndex(FirewallRulesTableModel.NAME, this.firewallRulesTable) && colNumber != this.getTableColumnIndex(FirewallRulesTableModel.SEVERITY, this.firewallRulesTable)) {
            this.rulePopupMenu.add(this.getEdit());
            this.rulePopupMenu.addSeparator();
        }
        this.appendRuleActions(this.rulePopupMenu);
        return this.rulePopupMenu;
    }

    private Action getEdit() {
        if (this.editAction == null) {
            this.editAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.action.Edit")){
                private static final long serialVersionUID = 7829001183506708618L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    int selectedColumn = FirewallRulePanel.this.firewallRulesTable.getSelectedColumn();
                    int selectedRow = FirewallRulePanel.this.firewallRulesTable.getSelectedRow();
                    if (selectedRow < 0 || selectedColumn < 0) {
                        return;
                    }
                    if (selectedColumn == FirewallRulePanel.this.getTableColumnIndex(FirewallRulesTableModel.APPLICATION, FirewallRulePanel.this.firewallRulesTable)) {
                        FirewallRulePanel.this.showApplicationList();
                    } else if (selectedColumn == FirewallRulePanel.this.getTableColumnIndex(FirewallRulesTableModel.HOST, FirewallRulePanel.this.firewallRulesTable)) {
                        FirewallRulePanel.this.showHostList();
                    } else if (selectedColumn == FirewallRulePanel.this.getTableColumnIndex(FirewallRulesTableModel.SERVICE, FirewallRulePanel.this.firewallRulesTable)) {
                        FirewallRulePanel.this.showServiceList();
                    } else if (selectedColumn == FirewallRulePanel.this.getTableColumnIndex(FirewallRulesTableModel.TIME, FirewallRulePanel.this.firewallRulesTable)) {
                        FirewallRulePanel.this.showScheduleList();
                    } else if (selectedColumn == FirewallRulePanel.this.getTableColumnIndex(FirewallRulesTableModel.DESCRIPTION, FirewallRulePanel.this.firewallRulesTable)) {
                        FirewallRulePanel.this.showDescriptionDialog();
                    } else {
                        boolean isEditing = FirewallRulePanel.this.firewallRulesTable.editCellAt(selectedRow, selectedColumn);
                        if (isEditing) {
                            final int sRow = selectedRow;
                            final int sCol = selectedColumn;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    FirewallRulePanel.this.firewallRulesTable.editCellAt(sRow, sCol);
                                }
                            });
                        }
                    }
                }
            };
        }
        return this.editAction;
    }

    private Action getAddRule() {
        if (this.addRuleAction == null) {
            this.addRuleAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.action.AddRule")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FirewallRulePanel.this.addRule();
                }
            };
        }
        return this.addRuleAction;
    }

    private Action getAddBlankRule() {
        if (this.addBlankRuleAction == null) {
            this.addBlankRuleAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.action.AddBlankRule")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FirewallRulePanel.this.addBlankRule();
                }
            };
        }
        return this.addBlankRuleAction;
    }

    private Action getAdd() {
        if (this.addAction == null) {
            this.addAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.action.Add")){
                private static final long serialVersionUID = -490213343156077727L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FirewallRulePanel.this.addRule();
                }
            };
        }
        return this.addAction;
    }

    private void addRule() {
        FirewallRuleObject newRuleObject = this.firewallRulesModel.createNewRule();
        FirewallRuleHandler.getInstance().setFirewallRulesModel(this.firewallRulesModel);
        CreateRuleWizardDialog dialog = new CreateRuleWizardDialog(newRuleObject, this.isMacRulePanel());
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            FirewallRuleObject ruleObject = dialog.getObject();
            this.addRuleAfterCurrentRow(ruleObject);
        }
        FirewallRuleHandler.getInstance().clearData();
    }

    private void addBlankRule() {
        FirewallRuleObject newRuleObject = this.firewallRulesModel.createNewRule();
        this.addRuleAfterCurrentRow(newRuleObject);
        FirewallRuleHandler.getInstance().clearData();
    }

    private void addRuleAfterCurrentRow(FirewallRuleObject ruleObject) {
        if (this.licenseObject.isSBProduct() && this.getSecurityLevelRuleRow() == 0) {
            this.insertAtRow(ruleObject, 0);
        } else {
            int selectedRow = this.firewallRulesTable.getSelectedRow();
            if (selectedRow == -1 || this.isSelectedRowEnforcedRule(selectedRow)) {
                this.insertEnforcedRule(ruleObject, this.getInsertionLocation(selectedRow));
            } else {
                this.insertAtRow(ruleObject, this.getInsertionLocation(selectedRow));
            }
        }
    }

    private void appendRuleAfterLastRow(FirewallRuleObject ruleObject) {
        this.insertAtRow(ruleObject, this.getInsertionLocation(this.firewallRulesTable.getRowCount() - 1));
    }

    private boolean isSelectedRowEnforcedRule(int selectedRow) {
        return selectedRow < ((FirewallRulesTableModel)this.firewallRulesTable.getModel()).getEnforcedRuleSize();
    }

    private void insertEnforcedRule(FirewallRuleObject ruleObject, int rowToInsert) {
        if (this.firewallRulesTable != null && ruleObject != null && rowToInsert >= 0) {
            ruleObject.setNo(rowToInsert);
            ((FirewallRulesTableModel)this.firewallRulesTable.getModel()).insertEnforedRule(rowToInsert, ruleObject);
            this.firewallRulesTable.setRowSelectionInterval(rowToInsert, rowToInsert);
            this.firewallRulesTable.scrollRectToVisible(this.firewallRulesTable.getCellRect(rowToInsert, 0, true));
            this.updateRowHeight(rowToInsert, ruleObject);
        }
    }

    private void insertAtRow(FirewallRuleObject ruleObject, int rowToInsert) {
        if (this.firewallRulesTable != null && ruleObject != null && rowToInsert >= 0) {
            ruleObject.setNo(rowToInsert);
            ((FirewallRulesTableModel)this.firewallRulesTable.getModel()).insertRule(rowToInsert, ruleObject);
            this.firewallRulesTable.setRowSelectionInterval(rowToInsert, rowToInsert);
            this.firewallRulesTable.scrollRectToVisible(this.firewallRulesTable.getCellRect(rowToInsert, 0, true));
            this.updateRowHeight(rowToInsert, ruleObject);
        }
    }

    private int getInsertionLocation(int rowSelected) {
        int rowToInsert = -1;
        if (this.firewallRulesTable != null && this.firewallRulesTable.getModel() != null && this.firewallRulesTable.getModel() instanceof FirewallRulesTableModel) {
            FirewallRulesTableModel tableModel = (FirewallRulesTableModel)this.firewallRulesTable.getModel();
            int enforcedRuleRowCount = tableModel.getEnforcedRuleSize();
            int totalRowCount = tableModel.getRowCount();
            if (totalRowCount == 0 || enforcedRuleRowCount == 0) {
                return 0;
            }
            rowToInsert = rowSelected == -1 ? this.getInsertLocationForEnforcedRule(0, tableModel, enforcedRuleRowCount) : (rowSelected < enforcedRuleRowCount ? this.getInsertLocationForEnforcedRule(rowSelected, tableModel, enforcedRuleRowCount) : this.getInsertLocationForBaseLineRule(rowSelected, tableModel, enforcedRuleRowCount));
        }
        return rowToInsert;
    }

    private int getInsertLocationForBaseLineRule(int currentSelected, FirewallRulesTableModel tableModel, int enforcedRuleRowCount) {
        FirewallRuleObject firewallRuleObject = tableModel.getRuleObject(currentSelected);
        if (!firewallRuleObject.isInherited()) {
            return currentSelected;
        }
        int insertLocation = enforcedRuleRowCount;
        while (currentSelected + 1 > enforcedRuleRowCount) {
            firewallRuleObject = tableModel.getRuleObject(currentSelected);
            if (!firewallRuleObject.isInherited()) {
                insertLocation = currentSelected;
                break;
            }
            --currentSelected;
        }
        return insertLocation;
    }

    private int getInsertLocationForEnforcedRule(int beginIndex, FirewallRulesTableModel tableModel, int enforcedRuleRowCount) {
        int insertLocation = 0;
        while (beginIndex < enforcedRuleRowCount) {
            FirewallRuleObject firewallRuleObject = tableModel.getRuleObject(beginIndex);
            if (!firewallRuleObject.isInherited()) {
                insertLocation = beginIndex;
                break;
            }
            ++beginIndex;
        }
        if (beginIndex == enforcedRuleRowCount) {
            insertLocation = enforcedRuleRowCount;
        }
        return insertLocation;
    }

    private Action getCopyRule() {
        if (this.copyRuleAction == null) {
            this.copyRuleAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.action.CopyRule")){
                private static final long serialVersionUID = -4263694673106486408L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FirewallRuleObject fwObj;
                    FirewallRulePanel.this.getFirewallRulesTableModel().update();
                    int[] selRows = FirewallRulePanel.this.firewallRulesTable.getSelectedRows();
                    if (FirewallRulePanel.this.firewallRulesModel != null && (fwObj = FirewallRulePanel.this.firewallRulesModel.getRuleObject(selRows[0])) != null) {
                        fwObj.setOsPlatform(FirewallRulePanel.this.getOperatingSystemPlatform());
                        PolicyHandler.copyObject(fwObj);
                    }
                }
            };
        }
        return this.copyRuleAction;
    }

    private Action getPasteRule() {
        if (this.pasteRuleAction == null) {
            this.pasteRuleAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.action.PasteRule")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FirewallRulePanel.this.pasteRule();
                }
            };
        }
        this.pasteRuleAction.setEnabled(PolicyHandler.hasCopiedObject(FirewallRuleObject.class));
        return this.pasteRuleAction;
    }

    private Action getDeleteRule() {
        if (this.deleteRuleAction == null) {
            this.deleteRuleAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.action.DeleteRule")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (FirewallRulePanel.this.deleteRule()) {
                        FirewallRulePanel.this.deleteRuleButton.setEnabled(false);
                        FirewallRulePanel.this.moveUpButton.setEnabled(false);
                        FirewallRulePanel.this.moveDownButton.setEnabled(false);
                    }
                }
            };
        }
        return this.deleteRuleAction;
    }

    private void pasteRule() {
        this.getFirewallRulesTableModel().update();
        FirewallRuleObject fwObj = null;
        try {
            fwObj = (FirewallRuleObject)PolicyHandler.getPastedObject();
            if (fwObj != null) {
                int os = fwObj.getOsPlatform();
                if (os != this.getOperatingSystemPlatform()) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), this.getPastePlatformErrorMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.title.PasteRule"), 0);
                    return;
                }
                String fwObjName = fwObj.getName();
                if (fwObjName.length() > 125) {
                    String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.ConfirmPasteRule");
                    int confirmOption = JOptionPane.showConfirmDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.title.PasteRule"), 0, 2);
                    if (confirmOption == 0) {
                        fwObjName = fwObjName.substring(0, 124);
                    } else {
                        return;
                    }
                }
                fwObj.setName(this.firewallRulesModel.getUniqueName(fwObjName, 2));
                fwObj.setCreatedBy(this.firewallRulesModel.getGroupName());
            }
        }
        catch (Exception ex) {
            System.out.println("Failed to get pasted object, ex = ");
            LoggerUtilities.logException((Throwable)ex);
            fwObj = null;
        }
        if (this.firewallRulesModel != null && fwObj != null) {
            this.addRuleAfterCurrentRow(fwObj);
        }
    }

    private boolean deleteRule() {
        this.getFirewallRulesTableModel().update();
        boolean isDeleted = false;
        int[] selRows = this.firewallRulesTable.getSelectedRows();
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.ConfirmRemoveRule");
        if (selRows.length == this.firewallRulesModel.getRowCount()) {
            message = this.getAllRuleRemoveConfirmMessage();
        } else if (selRows.length > 1) {
            message = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.ConfirmRemoveRules"), selRows.length);
        }
        int confirmOption = JOptionPane.showConfirmDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.title.DeleteRule"), 0, 2);
        if (confirmOption == 0) {
            for (int i = selRows.length - 1; i >= 0; --i) {
                FirewallRuleObject fwObj = this.firewallRulesModel.getRuleObject(selRows[i]);
                if (this.licenseObject.isSBProduct()) {
                    if (fwObj.isSecurityRule() || fwObj.isBelowSecurityRule()) continue;
                    this.firewallRulesModel.deleteRule(selRows[i]);
                    if (this.selectedRowIndex >= this.getSecurityLevelRuleRow() - 1) continue;
                    this.firewallRulesTable.setRowSelectionInterval(this.selectedRowIndex, this.selectedRowIndex);
                    continue;
                }
                this.firewallRulesModel.deleteRule(selRows[i]);
            }
            isDeleted = true;
        }
        return isDeleted;
    }

    private Action getEnableRule() {
        if (this.enableRuleAction == null) {
            this.enableRuleAction = new AbstractAction(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.action.EnableRule")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    int selectedRow = FirewallRulePanel.this.firewallRulesTable.getSelectedRow();
                    Object check = ev.getSource();
                    Boolean value = false;
                    if (check instanceof JCheckBoxMenuItem) {
                        value = ((JCheckBoxMenuItem)check).isSelected();
                        FirewallRulePanel.this.firewallRulesTable.setValueAt(value, selectedRow, FirewallRulePanel.this.getTableColumnIndex(FirewallRulesTableModel.ENABLED, FirewallRulePanel.this.firewallRulesTable));
                    }
                    if (!value.booleanValue()) {
                        FirewallRulePanel.this.firewallRulesTable.getSelectionModel().clearSelection();
                    }
                }
            };
        }
        return this.enableRuleAction;
    }

    private JCheckBoxMenuItem getEnableRuleCheck() {
        if (this.enableRuleItem == null) {
            this.enableRuleItem = new JCheckBoxMenuItem(this.getEnableRule());
            this.enableRuleItem.setSelected(true);
        }
        return this.enableRuleItem;
    }

    private Action getMoveUp() {
        if (this.moveUpAction == null) {
            this.moveUpAction = new AbstractAction(UIText.get(3075)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    int i;
                    int[] actualSelectedRows = FirewallRulePanel.this.firewallRulesTable.getSelectedRows();
                    if (actualSelectedRows.length <= 0) {
                        return;
                    }
                    ArrayList<Integer> selectedRowsList = new ArrayList<Integer>();
                    boolean firstBaselineRuleFlag = false;
                    for (int i2 = 0; i2 < actualSelectedRows.length; ++i2) {
                        if (FirewallRulePanel.this.licenseObject.isSEPSBProduct()) {
                            FirewallRuleObject ruleObject = FirewallRulePanel.this.firewallRulesModel.getRuleObject(actualSelectedRows[i2]);
                            if (ruleObject.isBelowSecurityRule() || ruleObject.isSecurityRule()) {
                                continue;
                            }
                        } else if (FirewallRulePanel.this.selectedRowIndex == 0) {
                            if (FirewallRulePanel.this.firewallRulesModel.getEnforcedRuleSize() == 0) {
                                FirewallRulePanel.this.getMoveUpButton().setEnabled(true);
                            } else {
                                FirewallRulePanel.this.getMoveUpButton().setEnabled(false);
                                continue;
                            }
                        }
                        if (actualSelectedRows[i2] == FirewallRulePanel.this.firewallRulesModel.getEnforcedRuleSize()) {
                            firstBaselineRuleFlag = true;
                        }
                        selectedRowsList.add(actualSelectedRows[i2]);
                    }
                    if (selectedRowsList.isEmpty()) {
                        return;
                    }
                    Integer[] rows = selectedRowsList.toArray(new Integer[0]);
                    int[] selectedRows = new int[rows.length];
                    for (i = 0; i < selectedRows.length; ++i) {
                        selectedRows[i] = rows[i];
                    }
                    for (i = 0; i < selectedRows.length; ++i) {
                        FirewallRulePanel.this.firewallRulesModel.moveUP(selectedRows[i]);
                        FirewallRulePanel.this.setRowHeights();
                    }
                    FirewallRulePanel.this.firewallRulesTable.clearSelection();
                    if (selectedRows.length == 1) {
                        if (firstBaselineRuleFlag) {
                            FirewallRulePanel.this.firewallRulesTable.setRowSelectionInterval(selectedRows[0], selectedRows[0]);
                        } else {
                            FirewallRulePanel.this.firewallRulesTable.setRowSelectionInterval(selectedRows[0] - 1, selectedRows[0] - 1);
                        }
                    } else {
                        int i3;
                        int[] postSelectRows = new int[selectedRows.length];
                        if (selectedRows[0] == 0) {
                            for (i3 = 0; i3 < selectedRows.length; ++i3) {
                                postSelectRows[i3] = selectedRows[i3];
                            }
                        } else {
                            for (i3 = 0; i3 < selectedRows.length; ++i3) {
                                postSelectRows[i3] = selectedRows[i3] - 1;
                            }
                        }
                        if (postSelectRows[0] >= 0) {
                            FirewallRulePanel.this.firewallRulesTable.setRowSelectionInterval(postSelectRows[0], postSelectRows[0]);
                        }
                        for (int j = 1; j < postSelectRows.length; ++j) {
                            FirewallRulePanel.this.firewallRulesTable.addRowSelectionInterval(postSelectRows[j], postSelectRows[j]);
                        }
                    }
                    FirewallRulePanel.this.setRowHeights();
                }
            };
        }
        return this.moveUpAction;
    }

    private Action getMoveDown() {
        if (this.moveDownAction == null) {
            this.moveDownAction = new AbstractAction(UIText.get(3074)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    int[] selectedRows = FirewallRulePanel.this.firewallRulesTable.getSelectedRows();
                    int maxRowNumCanMoveDown = FirewallRulePanel.this.firewallRulesModel.getRowCount() - 1;
                    if (FirewallRulePanel.this.licenseObject.isSBProduct() && FirewallRulePanel.this.getSecurityLevelRuleRow() > 0) {
                        maxRowNumCanMoveDown = FirewallRulePanel.this.getSecurityLevelRuleRow() - 1;
                    }
                    boolean lastEnforcedRuleFlag = false;
                    for (int i = selectedRows.length - 1; i >= 0; --i) {
                        FirewallRuleObject ruleobject = FirewallRulePanel.this.firewallRulesModel.getRuleObject(selectedRows[i]);
                        if (FirewallRulePanel.this.licenseObject.isSBProduct() && selectedRows[i] >= maxRowNumCanMoveDown && ruleobject.isSecurityRule()) {
                            FirewallRulePanel.this.moveDownButton.setEnabled(false);
                            return;
                        }
                        if (selectedRows[i] == FirewallRulePanel.this.firewallRulesModel.getEnforcedRuleSize() - 1) {
                            lastEnforcedRuleFlag = true;
                        }
                        FirewallRulePanel.this.firewallRulesModel.moveDown(selectedRows[i]);
                        if (selectedRows[i] == FirewallRulePanel.this.firewallRulesTable.getRowCount()) {
                            FirewallRulePanel.this.firewallRulesTable.clearSelection();
                            selectedRows = FirewallRulePanel.this.incrementRows(selectedRows, i);
                        }
                        FirewallRulePanel.this.setRowHeights();
                    }
                    FirewallRulePanel.this.firewallRulesTable.clearSelection();
                    int rowCount = FirewallRulePanel.this.firewallRulesTable.getRowCount();
                    if (selectedRows.length == 1 || selectedRows[0] == 0) {
                        if (lastEnforcedRuleFlag) {
                            FirewallRulePanel.this.firewallRulesTable.setRowSelectionInterval(selectedRows[0], selectedRows[0]);
                        } else {
                            FirewallRulePanel.this.firewallRulesTable.setRowSelectionInterval(selectedRows[0] + 1, selectedRows[0] + 1);
                        }
                    } else {
                        int i;
                        int[] postSelectRows = new int[selectedRows.length];
                        if (selectedRows[0] == rowCount) {
                            for (i = selectedRows.length - 1; i >= 0; --i) {
                                postSelectRows[i] = selectedRows[i];
                            }
                        } else {
                            for (i = selectedRows.length - 1; i >= 0; --i) {
                                postSelectRows[i] = selectedRows[i] + 1;
                            }
                        }
                        if (postSelectRows[0] >= 0) {
                            FirewallRulePanel.this.firewallRulesTable.setRowSelectionInterval(postSelectRows[postSelectRows.length - 1], postSelectRows[postSelectRows.length - 1]);
                        }
                        for (int j = postSelectRows.length - 2; j >= 0; --j) {
                            FirewallRulePanel.this.firewallRulesTable.addRowSelectionInterval(postSelectRows[j], postSelectRows[j]);
                        }
                    }
                }
            };
        }
        return this.moveDownAction;
    }

    private Action getImport() {
        if (this.importAction == null) {
            this.importAction = new AbstractAction(UIText.get(2049)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FirewallRulePanel.this.importFwRule();
                }
            };
        }
        return this.importAction;
    }

    private Action getExport() {
        if (this.exportAction == null) {
            this.exportAction = new AbstractAction(UIText.get(1031)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent action) {
                    if (FirewallRulePanel.this.firewallRulesTable.getSelectedRowCount() > 0) {
                        FirewallRulePanel.this.exportFwRuleForSelection();
                    } else {
                        FirewallRulePanel.this.exportFwRule();
                    }
                }
            };
        }
        return this.exportAction;
    }

    private void importFwRule() {
        String errMsg = null;
        EnforcedFirewallRuleArray enfArray = null;
        BaselineFirewallRuleArray baseArray = null;
        try {
            ConfigObject newObj;
            WashIDHandler washer;
            HashMap<String, TopLevelObject> newObjSet;
            String newName;
            FirewallRule fwRule;
            int i;
            FwFirewallPolicy policy = (FwFirewallPolicy)PolicyHandler.importPolicy();
            if (policy == null) {
                return;
            }
            FirewallRuleSystem fwRuleSystem = this.getFirewallRuleSystem(policy);
            if (fwRuleSystem != null && fwRuleSystem.getOptEnforcedFirewallRuleArray() != null) {
                enfArray = fwRuleSystem.getOptEnforcedFirewallRuleArray();
            }
            if (fwRuleSystem != null && fwRuleSystem.getOptBaselineFirewallRuleArray() != null) {
                baseArray = fwRuleSystem.getOptBaselineFirewallRuleArray();
            }
            this.getFirewallRulesTableModel().update();
            List<String> ruleNames = this.getFirewallRulesTableModel().getRuleNames();
            boolean hasRule = false;
            if (enfArray != null) {
                for (i = 0; i < enfArray.getFirewallRuleCount(); ++i) {
                    fwRule = enfArray.getFirewallRule(i);
                    if (ruleNames != null && !ruleNames.isEmpty()) {
                        newName = PolicyHandler.validateFWPolicyRuleName(fwRule.getName(), ruleNames, 255);
                        if (newName == null) {
                            return;
                        }
                        hasRule = true;
                        fwRule.setName(newName);
                    }
                    newObjSet = new HashMap<String, TopLevelObject>();
                    washer = new WashIDHandler();
                    newObj = washer.duplicateObject((ConfigObject)fwRule, newObjSet);
                    this.insertAtRow(new FirewallRuleObject((FirewallRule)newObj), this.firewallRulesModel.getEnforcedRuleSize() - 1);
                    continue;
                }
            }
            if (baseArray != null) {
                for (i = 0; i < baseArray.getFirewallRuleCount(); ++i) {
                    fwRule = baseArray.getFirewallRule(i);
                    if (ruleNames != null && !ruleNames.isEmpty()) {
                        newName = PolicyHandler.validateFWPolicyRuleName(fwRule.getName(), ruleNames, 255);
                        if (newName == null) {
                            return;
                        }
                        hasRule = true;
                        fwRule.setName(newName);
                    }
                    newObjSet = new HashMap();
                    washer = new WashIDHandler();
                    newObj = washer.duplicateObject((ConfigObject)fwRule, newObjSet);
                    this.appendRuleAfterLastRow(new FirewallRuleObject((FirewallRule)newObj));
                    continue;
                }
            }
            if (!hasRule) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.NoCompoundRulesInImportFile"));
            } else {
                this.getFirewallRulesTableModel().updateRules();
            }
        }
        catch (SAXException se) {
            errMsg = se.getMessage();
        }
        catch (IOException ioe) {
            errMsg = ioe.getMessage();
        }
        catch (ValidationException ve) {
            errMsg = ve.getMessage();
        }
        catch (Exception ex) {
            errMsg = ex.getMessage();
        }
        if (errMsg != null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.ImportErrorDescription"), errMsg), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.title.ImportCompoundRule"), 0);
        }
    }

    private void exportFwRule() {
        int rowCount = this.getFirewallRulesTableModel().getRowCount();
        int[] selectedRows = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            selectedRows[i] = i;
        }
        this.exportFwRuleForSelection(selectedRows);
    }

    private void exportFwRuleForSelection() {
        int[] selectedRows = this.firewallRulesTable.getSelectedRows();
        this.exportFwRuleForSelection(selectedRows);
    }

    private void exportFwRuleForSelection(int[] selectedRows) {
        this.getFirewallRulesTableModel().update();
        EnforcedFirewallRuleArray enfFwRulArray = new EnforcedFirewallRuleArray();
        BaselineFirewallRuleArray basFwRulArray = new BaselineFirewallRuleArray();
        System.out.println("Selected row count--->" + selectedRows.length);
        for (int i = 0; i < selectedRows.length; ++i) {
            FirewallRuleObject fwObj = this.getFirewallRulesTableModel().getRuleObject(selectedRows[i]);
            if (StringUtilities.isEmpty((String)fwObj.getName())) {
                JOptionPane.showMessageDialog(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.FirewallRuleNameRequired"));
                return;
            }
            if (selectedRows[i] < this.firewallRulesModel.getEnforcedRuleSize()) {
                enfFwRulArray.addFirewallRule(fwObj.getFirewallRule());
                continue;
            }
            basFwRulArray.addFirewallRule(fwObj.getFirewallRule());
        }
        FwFirewallPolicy newFirewallPolicy = new FwFirewallPolicy();
        FirewallRuleSystem newFwRuleSystem = new FirewallRuleSystem();
        newFwRuleSystem.setOptEnforcedFirewallRuleArray(enfFwRulArray);
        newFwRuleSystem.setOptBaselineFirewallRuleArray(basFwRulArray);
        this.setFirewallRuleSystem(newFirewallPolicy, newFwRuleSystem);
        this.setSecurtySetting(newFirewallPolicy);
        if (StringUtilities.isEmpty((String)this.firewallPolicy.getName())) {
            String policyName = this.validatePolicyName("");
            if (policyName == null) {
                return;
            }
            newFirewallPolicy.setName(policyName);
        } else {
            newFirewallPolicy.setName(this.firewallPolicy.getName());
            newFirewallPolicy.setId(new GUIDGenerator().getGUIDString());
            PolicyHandler.exportPolicy((ConfigObject)newFirewallPolicy, newFirewallPolicy.getName());
        }
    }

    private JPanel getButtonsPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            UIUtilities.layoutButtonPanel(this.buttonPanel, new JButton[]{this.getAddRuleButton(), this.getAddBlankRuleButton(), this.getDeleteRuleButton(), this.getMoveUpButton(), this.getMoveDownButton()}, 0, 4, true, false, 1);
        }
        return this.buttonPanel;
    }

    private JButton getAddBlankRuleButton() {
        if (this.addBlankRuleButton == null) {
            this.addBlankRuleButton = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.button.AddBlankRule"));
            this.addBlankRuleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FirewallRulePanel.this.addBlankRule();
                }
            });
        }
        if (this.licenseObject.isSBProduct()) {
            this.addBlankRuleButton.setVisible(false);
        }
        return this.addBlankRuleButton;
    }

    private JButton getAddRuleButton() {
        if (this.addRuleButton == null) {
            this.addRuleButton = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.button.AddRule"));
            this.addRuleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    FirewallRulePanel.this.addRule();
                }
            });
        }
        return this.addRuleButton;
    }

    private JButton getDeleteRuleButton() {
        if (this.deleteRuleButton == null) {
            this.deleteRuleButton = new JButton(UIText.get(772));
            this.deleteRuleButton.setEnabled(false);
            this.deleteRuleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (FirewallRulePanel.this.deleteRule()) {
                        FirewallRulePanel.this.deleteRuleButton.setEnabled(false);
                        FirewallRulePanel.this.moveUpButton.setEnabled(false);
                        FirewallRulePanel.this.moveDownButton.setEnabled(false);
                    }
                }
            });
        }
        return this.deleteRuleButton;
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton(this.getMoveUp());
            this.moveUpButton.setEnabled(false);
        }
        return this.moveUpButton;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton(this.getMoveDown());
            this.moveDownButton.setEnabled(false);
        }
        return this.moveDownButton;
    }

    private void showActionPopup(MouseEvent ev, int rowNumber) {
        ActionPopup popupMenu = this.getActionPopupMenu(ev);
        int row = this.firewallRulesTable.getSelectedRowCount();
        if (row == 1) {
            popupMenu.setRulesTable(this.firewallRulesTable);
            popupMenu.show(ev, rowNumber);
        } else {
            popupMenu.show(ev, -1);
        }
    }

    private void showTrackingPopup(MouseEvent ev, int rowNumber) {
        TrackingPopup popupMenu = this.getTrackingPopupMenu(ev);
        int row = this.firewallRulesTable.getSelectedRowCount();
        if (row == 1) {
            popupMenu.addSeparator();
            popupMenu.setRulesTable(this.firewallRulesTable);
            popupMenu.show(ev, rowNumber);
        } else {
            popupMenu.show(ev, -1);
        }
    }

    private void showScreenSaverPopup(MouseEvent ev, int rowNumber) {
        ScreenSaverPopup popupMenu = this.getScreenSaverPopupMenu();
        int row = this.firewallRulesTable.getSelectedRowCount();
        if (row == 1) {
            popupMenu.setRulesTable(this.firewallRulesTable);
            popupMenu.show(ev, rowNumber);
        } else {
            popupMenu.show(ev, -1);
        }
    }

    private void showInterfacePopup(MouseEvent ev, int rowNumber) {
        InterfacePopup popupMenu = this.getInterfacePopupMenu();
        int row = this.firewallRulesTable.getSelectedRowCount();
        if (row == 1) {
            popupMenu.setRulesTable(this.firewallRulesTable);
            popupMenu.show(ev, rowNumber);
        } else {
            popupMenu.show(ev, -1);
        }
    }

    private void showDescriptionDialog() {
        int selectedRow = this.firewallRulesTable.getSelectedRow();
        FirewallRuleObject ruleObject = this.firewallRulesModel.getRuleObject(selectedRow);
        String desc = ruleObject.getDescription();
        AdditionalTextDialog dlg = new AdditionalTextDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.title.EnterDescription"), desc, 1024);
        if (dlg.isOk()) {
            ruleObject.setDescription(dlg.getAdditionalText());
            this.firewallRulesModel.setRuleObject(ruleObject, selectedRow);
        }
        dlg.dispose();
    }

    private void showApplicationList() {
        int selectedRow = this.firewallRulesTable.getSelectedRow();
        FirewallRuleObject ruleObject = this.firewallRulesModel.getRuleObject(selectedRow);
        FwApplicationTrigger appTrigger = ruleObject.getApplicationTrigger();
        FwApplicationTrigger appTriggerCopy = null;
        if (appTrigger == null) {
            appTriggerCopy = new FwApplicationTrigger();
        } else {
            try {
                byte[] copyArray = appTrigger.getBytes();
                appTriggerCopy = (FwApplicationTrigger)AbstractSchema.readXML((byte[])copyArray);
            }
            catch (Exception ex) {
                System.out.println("Failed to copy Application Trigger" + ex.getMessage());
            }
        }
        ApplicationListDialog dialog = new ApplicationListDialog(appTriggerCopy);
        if (dialog.isOk()) {
            SoApplicationContainer cont = appTriggerCopy.getSoApplicationContainer();
            if (cont.getExecutableCount() > 0) {
                ruleObject.setApplicationTrigger(appTriggerCopy);
            } else {
                ruleObject.setApplicationTrigger(null);
            }
            ruleObject.setApplications(dialog.getNewApplications());
            this.firewallRulesModel.setRuleObject(ruleObject, selectedRow);
            this.updateRowHeight(selectedRow, ruleObject);
        }
    }

    private void showHostList() {
        int selectedRow = this.firewallRulesTable.getSelectedRow();
        FirewallRuleObject ruleObject = this.firewallRulesModel.getRuleObject(selectedRow);
        FwHostTrigger hostTrigger = ruleObject.getHostTrigger();
        FwHostTrigger hostTriggerCopy = null;
        if (hostTrigger == null) {
            hostTriggerCopy = new FwHostTrigger();
        } else {
            try {
                byte[] copyArray = hostTrigger.getBytes();
                hostTriggerCopy = (FwHostTrigger)AbstractSchema.readXML((byte[])copyArray);
            }
            catch (Exception ex) {
                System.out.println("Failed to copy Host Trigger" + ex.getMessage());
            }
        }
        HostListDialog dialog = new HostListDialog(hostTriggerCopy, this.isMacRulePanel());
        if (!dialog.isCancel()) {
            ruleObject.setHostTrigger(hostTriggerCopy);
            ArrayList<HostObject> newHostObjects = dialog.getNewHostObjects();
            ruleObject.setHosts(newHostObjects);
            boolean[] directionOccured = new boolean[4];
            ArrayList<HostContainerObject> hostContainerObjectList = FirewallPolicyHandler.getHostContainerObjects(hostTriggerCopy);
            for (HostContainerObject hostContainerObject : hostContainerObjectList) {
                if (!directionOccured[hostContainerObject.getDirection()]) {
                    directionOccured[hostContainerObject.getDirection()] = true;
                    this.addAllHostsToContainerObject(hostContainerObject, newHostObjects);
                    continue;
                }
                ArrayList<HostObject> addresses = hostContainerObject.getAllAddress();
                int i = 0;
                while (i < addresses.size()) {
                    hostContainerObject.deleteHostObject(addresses.get(i));
                }
            }
            this.firewallRulesModel.setRuleObject(ruleObject, selectedRow);
            this.updateRowHeight(selectedRow, ruleObject);
        }
    }

    private void addAllHostsToContainerObject(HostContainerObject hostContainerObject, ArrayList<HostObject> hostObjectList) {
        int direction = hostContainerObject.getDirection();
        String strDirection = HostEnableObject.getDirectionDesc(direction);
        ArrayList<HostObject> addresses = hostContainerObject.getAllAddress();
        int i = 0;
        while (i < addresses.size()) {
            hostContainerObject.deleteHostObject(addresses.get(i));
        }
        for (HostObject hostObject : hostObjectList) {
            if (!strDirection.equals(hostObject.getDirection())) continue;
            hostContainerObject.addHostObject(hostObject);
        }
    }

    private void showServiceList() {
        int selectedRow = this.firewallRulesTable.getSelectedRow();
        FirewallRuleObject ruleObject = this.firewallRulesModel.getRuleObject(selectedRow);
        FwServiceTrigger serviceTrigger = ruleObject.getServiceTrigger();
        FwServiceTrigger serviceTriggerCopy = null;
        if (serviceTrigger == null) {
            serviceTriggerCopy = new FwServiceTrigger();
        } else {
            try {
                byte[] copyArray = serviceTrigger.getBytes();
                serviceTriggerCopy = (FwServiceTrigger)AbstractSchema.readXML((byte[])copyArray);
            }
            catch (Exception ex) {
                System.out.println("Failed to copy Service Trigger" + ex.getMessage());
            }
        }
        ServiceListDialog dialog = new ServiceListDialog(serviceTriggerCopy, this.isMacRulePanel());
        if (dialog.isOk()) {
            ruleObject.setServiceTrigger(serviceTriggerCopy);
            ruleObject.setProtocolContainers(dialog.getServiceContainers());
            this.firewallRulesModel.setRuleObject(ruleObject, selectedRow);
            this.updateRowHeight(selectedRow, ruleObject);
        }
        dialog.dispose();
    }

    private void showScheduleList() {
        int selectedRow = this.firewallRulesTable.getSelectedRow();
        FirewallRuleObject ruleObject = this.firewallRulesModel.getRuleObject(selectedRow);
        FwTimeTrigger timeTrigger = ruleObject.getTimeTrigger();
        FwTimeTrigger timeTriggerCopy = null;
        if (timeTrigger == null) {
            timeTriggerCopy = new FwTimeTrigger();
        } else {
            try {
                byte[] copyArray = timeTrigger.getBytes();
                timeTriggerCopy = (FwTimeTrigger)AbstractSchema.readXML((byte[])copyArray);
            }
            catch (Exception ex) {
                System.out.println("Failed to copy Time Trigger" + ex.getMessage());
            }
        }
        ScheduleListDialog dialog = new ScheduleListDialog(timeTriggerCopy);
        if (!dialog.isCancel()) {
            ruleObject.setTimeTrigger(timeTriggerCopy);
            ruleObject.setSchedules(dialog.getNewSchedules());
            this.firewallRulesModel.setRuleObject(ruleObject, selectedRow);
            this.updateRowHeight(selectedRow, ruleObject);
        }
    }

    public void updateValues() {
        this.getFirewallRulesTableModel().updateRules();
        if (this.isMacRulePanel()) {
            this.firewallPolicy.getOptMacFwFirewallPolicy().setSecuritySetting(this.notificationPanel.getSecuritySetting());
        } else {
            this.firewallPolicy.setSecuritySetting(this.notificationPanel.getSecuritySetting());
        }
        this.fwRuleSystem = this.firewallRulesModel.getFirewallRuleSystem();
        boolean inherit = this.getInheritRulesCheck().isSelected();
        this.fwRuleSystem.setOptMergeLocalAndParentRules(Boolean.valueOf(inherit));
        this.saved = true;
    }

    public boolean isSaved() {
        return this.saved;
    }

    private void setParentRules() {
        if (this.groupPolicyObject == null) {
            return;
        }
        GroupObject groupObject = this.groupPolicyObject.getGroupObject();
        if (groupObject == null) {
            return;
        }
        try {
            List<List<FirewallRuleObject>> inheritableRules = FirewallPolicyHandler.getInheritedRules(groupObject, this.locationName, this.getOperatingSystemPlatform());
            this.getFirewallRulesTableModel().setInheritableRules(inheritableRules);
            this.setRowHeights();
        }
        catch (ConsoleException ex) {
            System.out.println("Faild to fetch Inheritable rules " + ex.getMessage());
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void removeParentRules() {
        this.getFirewallRulesTableModel().removeInheritableRules();
        this.setRowHeights();
    }

    private void enableButtons(FirewallRuleObject ruleObject) {
        this.getMoveUpButton().setEnabled(!ruleObject.isInherited());
        this.getMoveDownButton().setEnabled(!ruleObject.isInherited());
        this.getDeleteRuleButton().setEnabled(!ruleObject.isInherited());
    }

    private void setMoveUpOrDownButtonState(int[] selectedRows) {
        boolean firstMoveupDisable = true;
        boolean firstMoveDownDisable = true;
        if (selectedRows.length <= 0) {
            return;
        }
        FirewallRuleObject currentRuleObject = this.firewallRulesModel.getRuleObject(selectedRows[0]);
        this.enableButtons(currentRuleObject);
        if (this.licenseObject.isSBProduct() && selectedRows[selectedRows.length - 1] >= this.getSecurityLevelRuleRow() - 1) {
            this.getMoveDownButton().setEnabled(false);
            return;
        }
        if (selectedRows[selectedRows.length - 1] == this.firewallRulesTable.getRowCount() - 1) {
            this.getMoveDownButton().setEnabled(false);
            return;
        }
        for (int selectedRow : selectedRows) {
            if (firstMoveupDisable) {
                firstMoveupDisable = this.isMoveUpable(currentRuleObject, selectedRow);
                this.getMoveUpButton().setEnabled(firstMoveupDisable);
            }
            if (!firstMoveDownDisable) continue;
            firstMoveDownDisable = this.isMoveDownable(currentRuleObject, selectedRow);
            this.getMoveDownButton().setEnabled(firstMoveDownDisable);
        }
    }

    private void setMoveUpOrDownActionState(int[] selectedRows) {
        boolean firstMoveupDisable = true;
        boolean firstMoveDownDisable = true;
        for (int selectedRow : selectedRows) {
            FirewallRuleObject currentRuleObject = this.firewallRulesModel.getRuleObject(selectedRow);
            if (selectedRow == this.getSecurityLevelRuleRow() - 1) {
                this.getMoveDown().setEnabled(false);
                return;
            }
            if (firstMoveupDisable) {
                firstMoveupDisable = this.isMoveUpable(currentRuleObject, selectedRow);
                this.getMoveUp().setEnabled(firstMoveupDisable);
            }
            if (!firstMoveDownDisable) continue;
            firstMoveDownDisable = this.isMoveDownable(currentRuleObject, selectedRow);
            this.getMoveDown().setEnabled(firstMoveDownDisable);
        }
    }

    private boolean isMoveUpable(FirewallRuleObject currentRuleObject, int selectedRow) {
        boolean isMoveUpable = false;
        if (currentRuleObject.getType() != 1) {
            isMoveUpable = selectedRow != 0 && (selectedRow <= 0 || this.firewallRulesModel.getRuleObject(selectedRow - 1).getType() != 1 || selectedRow > this.firewallRulesModel.getEnforcedRuleSize() - 1);
        }
        return isMoveUpable;
    }

    private boolean isMoveDownable(FirewallRuleObject currentRuleObject, int selectedRow) {
        boolean isMoveDownable = false;
        if (currentRuleObject.getType() != 1) {
            isMoveDownable = selectedRow != this.firewallRulesModel.getRowCount() - 1 && (selectedRow >= this.firewallRulesModel.getRowCount() - 1 || this.firewallRulesModel.getRuleObject(selectedRow + 1).getType() != 1 || selectedRow <= this.firewallRulesModel.getEnforcedRuleSize() - 1);
        }
        return isMoveDownable;
    }

    private String validatePolicyName(String name) {
        if (name == null) {
            return null;
        }
        if (name.trim().length() == 0) {
            String input = JOptionPane.showInputDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.EnterPolicyName"), "");
            return this.validatePolicyName(input);
        }
        return name;
    }

    private void showImpExpPopupMenu(MouseEvent ev) {
        this.impExpPopup = this.getImpExpPopup();
        this.firewallRulesTable.clearSelection();
        if (this.getFirewallRulesTableModel().getRowCount() == 0) {
            this.getExport().setEnabled(false);
        }
        this.impExpPopup.show(ev.getComponent(), ev.getX(), ev.getY());
    }

    private JPopupMenu getImpExpPopup() {
        if (this.impExpPopup == null) {
            this.impExpPopup = new JPopupMenu();
            this.impExpPopup.add(this.getAdd());
            if (!this.licenseObject.isSBProduct()) {
                this.impExpPopup.add(this.getAddBlankRule());
            }
            this.impExpPopup.add(this.getPasteRule());
            this.impExpPopup.add(this.getImport());
            this.impExpPopup.add(this.getExport());
        }
        return this.impExpPopup;
    }

    public Font getFont(JTable table, int row) {
        FirewallRulesTableModel tableModel;
        FirewallRuleObject ruleObject;
        if (table != null && table.getModel() != null && table.getModel() instanceof FirewallRulesTableModel && row >= 0 && null != (ruleObject = (tableModel = (FirewallRulesTableModel)table.getModel()).getRuleObject(row)) && ruleObject.isInherited()) {
            return this.getFont().deriveFont(2);
        }
        return this.getFont();
    }

    public Color[] getColor(JTable table, int row, int column) {
        FirewallRulesTableModel tableModel;
        FirewallRuleObject ruleObject;
        Color[] color = new Color[]{UIColorUtilities.DEFAULT_FOREGROUND, UIColorUtilities.DEFAULT_BACKGROUND};
        if (table != null && table.getModel() != null && table.getModel() instanceof FirewallRulesTableModel && row >= 0 && (ruleObject = (tableModel = (FirewallRulesTableModel)table.getModel()).getRuleObject(row)) != null) {
            if (this.isRowSelected(table, row)) {
                color[1] = this.isMultiSelection(table) ? UIColorUtilities.DEFAULT_SELECTION_BACKGROUND : (this.isColumnSelected(table, column) ? UIColorUtilities.CELL_SELECTION_BACKGROUND : UIColorUtilities.DEFAULT_SELECTION_BACKGROUND);
            } else if (row % 2 > 0) {
                color[1] = UIColorUtilities.TABLE_STRIPE;
            }
            if (ruleObject.isInherited()) {
                color[0] = UIColorUtilities.CONTROL_DISABLED_FOREGROUND;
            }
        }
        return color;
    }

    private boolean isRowSelected(JTable table, int row) {
        return table != null && row >= 0 ? this.itemExists(table.getSelectedRows(), row) : false;
    }

    private boolean isColumnSelected(JTable table, int column) {
        return table != null && column >= 0 ? this.itemExists(table.getSelectedColumns(), column) : false;
    }

    private boolean itemExists(int[] items, int item) {
        boolean isItemExists = false;
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i] != item) continue;
                isItemExists = true;
                break;
            }
        }
        return isItemExists;
    }

    private boolean isMultiSelection(JTable table) {
        boolean isMultiSelection = false;
        if (table != null) {
            int[] rows = table.getSelectedRows();
            isMultiSelection = rows.length > 1;
        }
        return isMultiSelection;
    }

    private int[] incrementRows(int[] rows, int index) {
        int[] newRows = new int[rows.length - 1];
        int i = rows.length - 2;
        while (i >= 0) {
            newRows[i] = rows[i];
            --i;
            --index;
        }
        return newRows;
    }

    public boolean isValidate() {
        boolean isValid = true;
        int firewallRulecount = this.getFirewallRulesTableModel().getRowCount();
        for (int j = 0; j < firewallRulecount; ++j) {
            FirewallRuleObject ruleObject = this.getFirewallRulesTableModel().getRuleObject(j);
            if (ruleObject.hasName()) continue;
            String message = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.EnterEnforcedRuleNameAtRow"), j + 1);
            JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.title.RuleName"), 2);
            isValid = false;
        }
        return isValid;
    }

    public int getSecurityLevelRuleRow() {
        int rowCount = 0;
        for (rowCount = this.firewallRulesTable.getRowCount() - 1; rowCount > 0; --rowCount) {
            FirewallRuleObject ruleObject = this.firewallRulesModel.getRuleObject(rowCount);
            if (!ruleObject.isSecurityRule()) continue;
            if (!ruleObject.isMediumSecurityRule()) break;
            --rowCount;
            break;
        }
        return rowCount;
    }

    public FwFirewallPolicy getFirewallPolicy() {
        return this.firewallPolicy;
    }

    public Border getCellBorder() {
        return CELL_BORDER;
    }

    private boolean isMacRulePanel() {
        return this.getOperatingSystemPlatform() == 2;
    }

    protected abstract int getOperatingSystemPlatform();

    public abstract FirewallRuleSystem getFirewallRuleSystem();

    protected abstract FirewallRuleSystem getFirewallRuleSystem(FwFirewallPolicy var1);

    protected abstract void setFirewallRuleSystem(FwFirewallPolicy var1, FirewallRuleSystem var2);

    protected abstract void setSecurtySetting(FwFirewallPolicy var1);

    protected abstract String getAllRuleRemoveConfirmMessage();

    protected abstract String getPastePlatformErrorMessage();

    public class JRuleTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        private RuleNameCellEditor nameCellEditor = null;
        private ComboCellEditor comboCellEditor = null;

        private JRuleTable(FirewallRulePanel rulePanel) {
            this.nameCellEditor = new RuleNameCellEditor(rulePanel.getRuleNameTextField());
            JComboBox<String> comboBox = new JComboBox<String>(FirewallRuleObject.getAllSeverity());
            comboBox.setBorder(BorderFactory.createEmptyBorder());
            this.comboCellEditor = new ComboCellEditor(rulePanel, comboBox);
            this.comboCellEditor.setClickCountToStart(2);
            ((DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        }

        public void updateRowHeight(int row, FirewallRuleObject ruleObject) {
            FirewallRulePanel.this.updateRowHeight(row, ruleObject);
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            ListSelectionModel sm = this.getSelectionModel();
            TableColumnModel cm = this.getColumnModel();
            int[] selectedRows = this.getSelectedRows();
            if (extend) {
                int anchor = sm.getAnchorSelectionIndex();
                if (anchor == rowIndex && selectedRows.length == 1) {
                    int columnAnchor = cm.getSelectionModel().getAnchorSelectionIndex();
                    sm.setSelectionInterval(rowIndex, rowIndex);
                    cm.getSelectionModel().setSelectionInterval(columnAnchor, columnIndex);
                } else {
                    boolean anchorSelect = sm.isSelectedIndex(anchor);
                    if (toggle) {
                        if (anchorSelect) {
                            sm.addSelectionInterval(anchor, rowIndex);
                        } else {
                            sm.removeSelectionInterval(anchor, rowIndex);
                        }
                    } else {
                        sm.setSelectionInterval(anchor, rowIndex);
                    }
                }
            } else {
                boolean rowSelect = sm.isSelectedIndex(rowIndex);
                if (toggle) {
                    if (rowSelect) {
                        sm.removeSelectionInterval(rowIndex, rowIndex);
                    } else {
                        sm.addSelectionInterval(rowIndex, rowIndex);
                    }
                } else {
                    sm.setSelectionInterval(rowIndex, rowIndex);
                    cm.getSelectionModel().setSelectionInterval(columnIndex, columnIndex);
                }
            }
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == FirewallRulePanel.this.getTableColumnIndex(FirewallRulesTableModel.NAME, FirewallRulePanel.this.firewallRulesTable)) {
                return this.nameCellEditor;
            }
            if (!FirewallRulePanel.this.licenseObject.isSBProduct() && column == FirewallRulePanel.this.getTableColumnIndex(FirewallRulesTableModel.SEVERITY, FirewallRulePanel.this.firewallRulesTable)) {
                return this.comboCellEditor;
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public void paintComponent(Graphics graphic) {
            super.paintComponent(graphic);
            if (FirewallRulePanel.this.getFirewallRulesTableModel().getRowCount() != 0) {
                Color clr = this.getGridColor();
                graphic.setColor(UIColorUtilities.FW_RULE_BLUE_LINE);
                int height = this.getEnforcedRuleTableHeight() - 3;
                graphic.fillRect(0, height, this.getSize().width, 5);
                graphic.setColor(clr);
                graphic.drawRect(-1, height, this.getSize().width, 5);
            }
        }

        private int getEnforcedRuleTableHeight() {
            int ruleRowHeight = 0;
            for (int ruleNo = FirewallRulePanel.this.getFirewallRulesTableModel().getEnforcedRuleSize(); ruleNo > 0; --ruleNo) {
                ruleRowHeight += this.getRowHeight(ruleNo - 1);
            }
            return ruleRowHeight;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (dim.height > 0) {
                AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> dim.height += this.getRowCount() * 4 + 3);
            }
            return dim;
        }
    }
}

