/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.configobject.schema.BaselineFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.EnforcedFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.FirewallRule;
import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.Guid;
import com.sygate.scm.common.configobject.schema.IgnoredParentFirewallRuleIdArray;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FirewallRuleObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class FirewallRuleList
implements List<FirewallRuleObject> {
    private List<FirewallRuleObject> baselineRuleObjects = new ArrayList<FirewallRuleObject>();
    private List<FirewallRuleObject> enforcedRuleObjects = new ArrayList<FirewallRuleObject>();
    private List<FirewallRuleObject> inheritableRuleObjects = new ArrayList<FirewallRuleObject>();
    private List<Guid> ignoredRuleIds = new ArrayList<Guid>();
    private IgnoredParentFirewallRuleIdArray ignoredRuleIdArray;
    private FirewallRuleSystem fwRuleSystem;

    public void setRules(FirewallRuleSystem fwRulSystem, String groupName) {
        this.fwRuleSystem = fwRulSystem != null ? fwRulSystem : new FirewallRuleSystem();
        this.clear();
        EnforcedFirewallRuleArray enforcedRuleArray = this.fwRuleSystem.getOptEnforcedFirewallRuleArray();
        if (enforcedRuleArray == null) {
            enforcedRuleArray = new EnforcedFirewallRuleArray();
        }
        this.assignRules(enforcedRuleArray.getFirewallRule(), this.enforcedRuleObjects, groupName);
        BaselineFirewallRuleArray baseLineRuleArray = this.fwRuleSystem.getOptBaselineFirewallRuleArray();
        if (baseLineRuleArray == null) {
            baseLineRuleArray = new BaselineFirewallRuleArray();
        }
        this.assignRules(baseLineRuleArray.getFirewallRule(), this.baselineRuleObjects, groupName);
        this.ignoredRuleIdArray = this.fwRuleSystem.getOptIgnoredParentFirewallRuleIdArray();
        if (this.ignoredRuleIdArray == null) {
            this.ignoredRuleIdArray = new IgnoredParentFirewallRuleIdArray();
        }
    }

    private void assignRules(Vector<FirewallRule> fwRules, List<FirewallRuleObject> ruleList, String groupName) {
        if (fwRules != null) {
            for (FirewallRule rule : fwRules) {
                FirewallRuleObject ruleObject = new FirewallRuleObject(rule);
                ruleObject.setCreatedBy(groupName);
                ruleList.add(ruleObject);
            }
        }
    }

    public void setInheritableRules(List<List<FirewallRuleObject>> inheritableRules) {
        List<FirewallRuleObject> enforcedInheritableRules = inheritableRules.get(0);
        List<FirewallRuleObject> baseLineInheritableRules = inheritableRules.get(1);
        boolean isInheritableRuleObjectsCleared = false;
        if (this.inheritableRuleObjects != null && this.inheritableRuleObjects.isEmpty()) {
            if (enforcedInheritableRules != null) {
                if (enforcedInheritableRules.size() > 0) {
                    this.inheritableRuleObjects.clear();
                    isInheritableRuleObjectsCleared = true;
                }
                Iterator<FirewallRuleObject> itr = enforcedInheritableRules.iterator();
                int count = 0;
                while (itr.hasNext()) {
                    FirewallRuleObject ruleObject = itr.next();
                    if (this.contains(ruleObject)) {
                        this.remove(ruleObject);
                    }
                    FirewallRule rule = ruleObject.getFirewallRule();
                    ruleObject.setType(1);
                    ruleObject.setEnabled(!this.isRuleIdIgnored(rule.getId()));
                    ruleObject.setFwRuleType(1);
                    this.inheritableRuleObjects.add(ruleObject);
                    this.addEnforcedRule(count, ruleObject);
                    ++count;
                }
            }
            if (baseLineInheritableRules != null) {
                if (baseLineInheritableRules.size() > 0 && !isInheritableRuleObjectsCleared) {
                    this.inheritableRuleObjects.clear();
                }
                for (FirewallRuleObject ruleObject : baseLineInheritableRules) {
                    if (this.contains(ruleObject)) {
                        this.remove(ruleObject);
                    }
                    FirewallRule rule = ruleObject.getFirewallRule();
                    ruleObject.setType(1);
                    ruleObject.setEnabled(!this.isRuleIdIgnored(rule.getId()));
                    ruleObject.setFwRuleType(2);
                    this.inheritableRuleObjects.add(ruleObject);
                    this.add(ruleObject);
                }
            }
        }
    }

    public void removeInheritableRules() {
        if (this.inheritableRuleObjects != null && this.inheritableRuleObjects.size() > 0) {
            this.removeAll(this.inheritableRuleObjects);
            this.inheritableRuleObjects.clear();
        }
    }

    private boolean isRuleIdIgnored(String ruleId) {
        boolean isIgnored = false;
        if (this.ignoredRuleIdArray != null) {
            for (Guid guid : this.ignoredRuleIdArray.getGuid()) {
                String content;
                if (guid == null || (content = guid.getContent()) == null || !content.equals(ruleId)) continue;
                isIgnored = true;
                break;
            }
        }
        return isIgnored;
    }

    public List<Guid> getIgnoredParentRuleIds() {
        if (this.inheritableRuleObjects != null) {
            for (FirewallRuleObject ruleObject : this.inheritableRuleObjects) {
                FirewallRule rule;
                if (ruleObject == null || ruleObject.getEnabled() || (rule = ruleObject.getFirewallRule()) == null) continue;
                String ruleId = rule.getId();
                Guid guid = new Guid();
                guid.setContent(ruleId);
                this.ignoredRuleIds.add(guid);
            }
        }
        return this.ignoredRuleIds;
    }

    public boolean isRuleNameExisting(String name, int row) {
        return this.checkDuplicateName(name, this.baselineRuleObjects, row - this.getEnforcedRuleSize()) || this.checkDuplicateName(name, this.enforcedRuleObjects, row);
    }

    private boolean checkDuplicateName(String name, List<FirewallRuleObject> rules, int row) {
        boolean isExist = false;
        FirewallRuleObject ruleObject = null;
        String ruleName = null;
        for (int i = 0; i < rules.size(); ++i) {
            ruleObject = rules.get(i);
            if (ruleObject == null || ruleObject.isInherited() || (ruleName = ruleObject.getName()) == null || !ruleName.equalsIgnoreCase(name) || i == row) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public void moveUp(int row) {
        FirewallRuleObject previousRule;
        if (row == this.getEnforcedRuleSize()) {
            FirewallRuleObject currentRule = this.baselineRuleObjects.get(0);
            this.enforcedRuleObjects.add(currentRule);
            this.baselineRuleObjects.remove(0);
        } else if (row > 0 && row < this.getEnforcedRuleSize()) {
            FirewallRuleObject previousRule2 = this.enforcedRuleObjects.get(row - 1);
            if (!previousRule2.isInherited()) {
                FirewallRuleObject currentRule = this.enforcedRuleObjects.get(row);
                this.enforcedRuleObjects.set(row - 1, currentRule);
                this.enforcedRuleObjects.set(row, previousRule2);
            }
        } else if (row > this.getEnforcedRuleSize() && !(previousRule = this.baselineRuleObjects.get(row - 1 - this.getEnforcedRuleSize())).isInherited()) {
            FirewallRuleObject currentRule = this.baselineRuleObjects.get(row - this.getEnforcedRuleSize());
            this.baselineRuleObjects.set(row - 1 - this.getEnforcedRuleSize(), currentRule);
            this.baselineRuleObjects.set(row - this.getEnforcedRuleSize(), previousRule);
        }
    }

    public void moveDown(int row) {
        if (row == this.getEnforcedRuleSize() - 1) {
            FirewallRuleObject rule = this.enforcedRuleObjects.get(row);
            this.baselineRuleObjects.add(0, rule);
            this.enforcedRuleObjects.remove(row);
        } else if (row >= 0 && row < this.getEnforcedRuleSize() - 1) {
            FirewallRuleObject currentRule = this.enforcedRuleObjects.get(row);
            FirewallRuleObject nextRule = this.enforcedRuleObjects.get(row + 1);
            if (!nextRule.isInherited()) {
                this.enforcedRuleObjects.set(row + 1, currentRule);
                this.enforcedRuleObjects.set(row, nextRule);
            }
        } else if (row >= this.getEnforcedRuleSize()) {
            FirewallRuleObject currentRule = this.baselineRuleObjects.get(row - this.getEnforcedRuleSize());
            FirewallRuleObject nextRule = this.baselineRuleObjects.get(row + 1 - this.getEnforcedRuleSize());
            if (!nextRule.isInherited()) {
                this.baselineRuleObjects.set(row + 1 - this.getEnforcedRuleSize(), currentRule);
                this.baselineRuleObjects.set(row - this.getEnforcedRuleSize(), nextRule);
            }
        }
    }

    protected int getBaselineRuleSize() {
        return this.baselineRuleObjects.size();
    }

    protected int getEnforcedRuleSize() {
        return this.enforcedRuleObjects.size();
    }

    public void update() {
        FirewallRuleObject ruleObject;
        Iterator<FirewallRuleObject> itrBaseline = this.baselineRuleObjects.iterator();
        Iterator<FirewallRuleObject> itrEnforce = this.enforcedRuleObjects.iterator();
        while (itrBaseline.hasNext()) {
            ruleObject = itrBaseline.next();
            if (ruleObject == null || ruleObject.isInherited()) continue;
            ruleObject.update();
        }
        while (itrEnforce.hasNext()) {
            ruleObject = itrEnforce.next();
            if (ruleObject == null || ruleObject.isInherited()) continue;
            ruleObject.update();
        }
    }

    public void updateRules() {
        int rowIndex;
        FirewallRule rule;
        int i;
        BaselineFirewallRuleArray baseLineRuleArray;
        int i2;
        this.update();
        List<Guid> ignoredRuleIds = this.getIgnoredParentRuleIds();
        IgnoredParentFirewallRuleIdArray clonedIgnoredRuleIdArray = (IgnoredParentFirewallRuleIdArray)this.ignoredRuleIdArray.clone();
        for (i2 = 0; i2 < clonedIgnoredRuleIdArray.getGuidCount(); ++i2) {
            Guid oldId = clonedIgnoredRuleIdArray.getGuid(i2);
            if (ignoredRuleIds.contains(oldId)) continue;
            this.ignoredRuleIdArray.removeGuid(oldId);
        }
        clonedIgnoredRuleIdArray = null;
        for (i2 = 0; i2 < ignoredRuleIds.size(); ++i2) {
            if (i2 >= this.ignoredRuleIdArray.getGuidCount()) {
                this.ignoredRuleIdArray.addGuid(ignoredRuleIds.get(i2));
                continue;
            }
            this.ignoredRuleIdArray.setGuid(i2, ignoredRuleIds.get(i2));
        }
        EnforcedFirewallRuleArray enforcedRuleArray = this.fwRuleSystem.getOptEnforcedFirewallRuleArray();
        if (enforcedRuleArray == null) {
            enforcedRuleArray = new EnforcedFirewallRuleArray();
        }
        if ((baseLineRuleArray = this.fwRuleSystem.getOptBaselineFirewallRuleArray()) == null) {
            baseLineRuleArray = new BaselineFirewallRuleArray();
        }
        for (i = baseLineRuleArray.getFirewallRuleCount() - 1; i >= 0; --i) {
            rule = baseLineRuleArray.getFirewallRule(i);
            rowIndex = this.indexOf(new FirewallRuleObject(rule));
            if (rowIndex != -1 && rowIndex >= this.getEnforcedRuleSize()) continue;
            baseLineRuleArray.removeFirewallRule(rule);
        }
        for (i = enforcedRuleArray.getFirewallRuleCount() - 1; i >= 0; --i) {
            rule = enforcedRuleArray.getFirewallRule(i);
            rowIndex = this.indexOf(new FirewallRuleObject(rule));
            if (rowIndex != -1 && rowIndex < this.getEnforcedRuleSize()) continue;
            enforcedRuleArray.removeFirewallRule(rule);
        }
        int baseRuleCount = baseLineRuleArray.getFirewallRuleCount();
        int j = 0;
        for (int i3 = this.getEnforcedRuleSize(); i3 < this.size(); ++i3) {
            FirewallRuleObject tempObj = this.get(i3);
            if (tempObj.isInherited()) continue;
            if (j >= baseRuleCount) {
                baseLineRuleArray.addFirewallRule(tempObj.getFirewallRule());
                continue;
            }
            baseLineRuleArray.setFirewallRule(j++, tempObj.getFirewallRule());
        }
        int enforceRuleCount = enforcedRuleArray.getFirewallRuleCount();
        int j2 = 0;
        for (int i4 = 0; i4 < this.getEnforcedRuleSize(); ++i4) {
            FirewallRuleObject tempObj = this.get(i4);
            if (tempObj.isInherited()) continue;
            if (j2 >= enforceRuleCount) {
                enforcedRuleArray.addFirewallRule(tempObj.getFirewallRule());
                continue;
            }
            enforcedRuleArray.setFirewallRule(j2++, tempObj.getFirewallRule());
        }
        this.fwRuleSystem.setOptEnforcedFirewallRuleArray(enforcedRuleArray);
        this.fwRuleSystem.setOptBaselineFirewallRuleArray(baseLineRuleArray);
        this.fwRuleSystem.setOptIgnoredParentFirewallRuleIdArray(this.ignoredRuleIdArray);
    }

    public FirewallRuleSystem getFirewallRuleSystem() {
        return this.fwRuleSystem;
    }

    @Override
    public boolean add(FirewallRuleObject newRule) {
        this.add(this.size(), newRule);
        return true;
    }

    @Override
    public void add(int index, FirewallRuleObject newRule) {
        int fwRuleType = newRule.getFwRuleType();
        if (fwRuleType == 1) {
            this.addEnforcedRule(index, newRule);
        } else if (fwRuleType == 2) {
            this.addBaseLineRule(index - this.getEnforcedRuleSize(), newRule);
        } else if (index <= this.getEnforcedRuleSize()) {
            this.addEnforcedRule(index, newRule);
        } else {
            this.addBaseLineRule(index - this.getEnforcedRuleSize(), newRule);
        }
    }

    public void addEnforcedRule(int index, FirewallRuleObject newRule) {
        this.enforcedRuleObjects.add(index, newRule);
    }

    public void addBaseLineRule(int index, FirewallRuleObject newRule) {
        this.baselineRuleObjects.add(index, newRule);
    }

    @Override
    public void clear() {
        this.enforcedRuleObjects.clear();
        this.baselineRuleObjects.clear();
    }

    @Override
    public boolean contains(Object obj) {
        return this.enforcedRuleObjects.contains(obj) || this.baselineRuleObjects.contains(obj);
    }

    @Override
    public FirewallRuleObject get(int row) {
        if (row < this.getEnforcedRuleSize()) {
            return this.enforcedRuleObjects.get(row);
        }
        return this.baselineRuleObjects.get(row - this.getEnforcedRuleSize());
    }

    @Override
    public int indexOf(Object obj) {
        if (this.enforcedRuleObjects.contains(obj)) {
            return this.enforcedRuleObjects.indexOf(obj);
        }
        if (this.baselineRuleObjects.contains(obj)) {
            return this.baselineRuleObjects.indexOf(obj) + this.getEnforcedRuleSize();
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.enforcedRuleObjects.isEmpty() && this.baselineRuleObjects.isEmpty();
    }

    @Override
    public int lastIndexOf(Object obj) {
        if (this.enforcedRuleObjects.contains(obj)) {
            return this.enforcedRuleObjects.lastIndexOf(obj);
        }
        if (this.baselineRuleObjects.contains(obj)) {
            return this.baselineRuleObjects.lastIndexOf(obj);
        }
        return -1;
    }

    @Override
    public boolean remove(Object obj) {
        if (this.enforcedRuleObjects.contains(obj)) {
            return this.enforcedRuleObjects.remove(obj);
        }
        if (this.baselineRuleObjects.contains(obj)) {
            return this.baselineRuleObjects.remove(obj);
        }
        return false;
    }

    @Override
    public FirewallRuleObject remove(int index) {
        if (index < this.getEnforcedRuleSize()) {
            return this.enforcedRuleObjects.remove(index);
        }
        return this.baselineRuleObjects.remove(index - this.getEnforcedRuleSize());
    }

    @Override
    public FirewallRuleObject set(int index, FirewallRuleObject newRule) {
        if (index < this.getEnforcedRuleSize()) {
            return this.enforcedRuleObjects.set(index, newRule);
        }
        return this.baselineRuleObjects.set(index - this.getEnforcedRuleSize(), newRule);
    }

    @Override
    public int size() {
        return this.getBaselineRuleSize() + this.getEnforcedRuleSize();
    }

    @Override
    public boolean addAll(int index, Collection<? extends FirewallRuleObject> col) {
        if (index < this.getEnforcedRuleSize()) {
            return this.enforcedRuleObjects.addAll(index, col);
        }
        return this.baselineRuleObjects.addAll(index - this.getEnforcedRuleSize(), col);
    }

    @Override
    public ListIterator<FirewallRuleObject> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<FirewallRuleObject> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<FirewallRuleObject> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends FirewallRuleObject> col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        return this.enforcedRuleObjects.removeAll(col) && this.baselineRuleObjects.removeAll(col);
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FirewallRuleObject> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        throw new UnsupportedOperationException();
    }
}

