/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.configobject.schema.AskAppPrompt;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.LocalAppBlockingNotification;
import com.sygate.scm.common.configobject.schema.SecuritySetting;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.dialog.AdditionalTextDialog;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FirewallNotificationPanel {
    private JPanel notificationPanel;
    private AlwaysEnabledButton blockedTextButton;
    private AlwaysEnabledButton askTextButton;
    private JCheckBox enableBlockedNotificationCheck;
    private JCheckBox addAditionalTextCheck;
    private String appPromptString;
    private String blockAppString;
    private AskAppPrompt appPrompt;
    private LocalAppBlockingNotification blockAppNotification;
    private SecuritySetting securitySetting;
    private boolean isOsTypeMac = false;

    public FirewallNotificationPanel(boolean isMac) {
        this.isOsTypeMac = isMac;
    }

    JPanel getFirewallNotificationPanel() {
        if (this.notificationPanel == null) {
            this.notificationPanel = this.getNotificationPanel();
        }
        return this.notificationPanel;
    }

    private JPanel getNotificationPanel() {
        String notif = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.notifications");
        String desc = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.notifiDescription");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new AvTemplatePane(notif, desc), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getBlockedApplicationNotificationCheck(), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(20, 40, 0, 0), 0, 0));
        if (!this.isOsTypeMac) {
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.label.AddAdditionalText")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 70, 0, 20), 0, 0));
            panel.add((Component)this.getBlockedApplicationTextButton(), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 20), 0, 0));
        }
        if (!LicenseObject.getInstance().isSBProduct() && !this.isOsTypeMac) {
            panel.add((Component)this.getAskApplicationTextCheck(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 40, 0, 0), 0, 0));
            panel.add((Component)this.getAskApplicationTextButton(), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 0, 20), 0, 0));
        }
        this.notificationPanel = new JPanel(new BorderLayout());
        this.notificationPanel.setName("sesm_policies_dialog_fw_rules_notifications");
        panel.setName("sesm_policies_dialog_fw_rules_notifications");
        this.notificationPanel.add((Component)panel, "North");
        return this.notificationPanel;
    }

    private JCheckBox getBlockedApplicationNotificationCheck() {
        if (this.enableBlockedNotificationCheck == null) {
            this.enableBlockedNotificationCheck = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.checkbox.NotifyAppsBlocked"));
            if (!this.isOsTypeMac) {
                this.enableBlockedNotificationCheck.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent ev) {
                        FirewallNotificationPanel.this.getBlockedApplicationTextButton().setEnabled(FirewallNotificationPanel.this.enableBlockedNotificationCheck.isEnabled() && FirewallNotificationPanel.this.enableBlockedNotificationCheck.isSelected());
                    }
                });
            }
        }
        return this.enableBlockedNotificationCheck;
    }

    private JButton getBlockedApplicationTextButton() {
        if (this.blockedTextButton == null) {
            this.blockedTextButton = new AlwaysEnabledButton(UIText.get(4616));
            this.blockedTextButton.setEnabled(false);
            this.blockedTextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    AdditionalTextDialog dlg = new AdditionalTextDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.EnterAdditionalText"), FirewallNotificationPanel.this.blockAppString);
                    ReadOnlyUtils.disableDialogIfNeeded(FirewallNotificationPanel.this.askTextButton, dlg);
                    if (dlg.isOk()) {
                        FirewallNotificationPanel.this.blockAppString = dlg.getAdditionalText();
                    }
                    dlg.dispose();
                }
            });
        }
        return this.blockedTextButton;
    }

    private JCheckBox getAskApplicationTextCheck() {
        if (this.addAditionalTextCheck == null) {
            this.addAditionalTextCheck = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.checkbox.AddAdditionalText"));
            this.addAditionalTextCheck.setBounds(0, 50, 300, 20);
            this.addAditionalTextCheck.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ev) {
                    FirewallNotificationPanel.this.getAskApplicationTextButton().setEnabled(FirewallNotificationPanel.this.addAditionalTextCheck.isEnabled() && FirewallNotificationPanel.this.addAditionalTextCheck.isSelected());
                }
            });
        }
        return this.addAditionalTextCheck;
    }

    private JButton getAskApplicationTextButton() {
        if (this.askTextButton == null) {
            this.askTextButton = new AlwaysEnabledButton(UIText.get(4616));
            this.askTextButton.setEnabled(false);
            this.askTextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    AdditionalTextDialog dlg = new AdditionalTextDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.EnterAdditionalText"), FirewallNotificationPanel.this.appPromptString);
                    ReadOnlyUtils.disableDialogIfNeeded(FirewallNotificationPanel.this.askTextButton, dlg);
                    if (dlg.isOk()) {
                        FirewallNotificationPanel.this.appPromptString = dlg.getAdditionalText();
                    }
                    dlg.dispose();
                }
            });
        }
        return this.askTextButton;
    }

    public void setReadOnly() {
        this.getBlockedApplicationNotificationCheck().setEnabled(false);
        if (!this.isOsTypeMac) {
            this.getBlockedApplicationTextButton().setEnabled(false);
            this.getAskApplicationTextCheck().setEnabled(false);
            this.getAskApplicationTextButton().setEnabled(false);
        }
    }

    private AskAppPrompt getAppPrompt() {
        if (this.appPrompt == null) {
            this.appPrompt = new AskAppPrompt();
        }
        this.appPrompt.setOptEnable(Boolean.valueOf(this.getAskApplicationTextCheck().isSelected()));
        if (this.appPromptString != null) {
            this.appPrompt.setOptAdditionalText(this.appPromptString);
        }
        return this.appPrompt;
    }

    private LocalAppBlockingNotification getBlockedApplicationNotification() {
        if (this.blockAppNotification == null) {
            this.blockAppNotification = new LocalAppBlockingNotification();
        }
        this.blockAppNotification.setOptEnable(Boolean.valueOf(this.getBlockedApplicationNotificationCheck().isSelected()));
        if (this.blockAppString != null) {
            this.blockAppNotification.setOptAdditionalText(this.blockAppString);
        }
        return this.blockAppNotification;
    }

    protected void resetDisabledItem() {
        if (!this.isOsTypeMac) {
            if (this.blockedTextButton != null) {
                this.blockedTextButton.setEnabled(this.enableBlockedNotificationCheck.isSelected());
            }
            if (this.askTextButton != null) {
                this.askTextButton.setEnabled(this.addAditionalTextCheck.isSelected());
            }
        }
    }

    public void setPolicy(FwFirewallPolicy firewallPolicy) {
        this.securitySetting = this.isOsTypeMac ? firewallPolicy.getOptMacFwFirewallPolicy().getSecuritySetting() : firewallPolicy.getSecuritySetting();
        this.blockAppNotification = this.securitySetting.getOptLocalAppBlockingNotification();
        boolean isBlockApp = false;
        if (this.blockAppNotification != null) {
            Boolean enable = this.blockAppNotification.getOptEnable();
            if (enable == null) {
                enable = this.blockAppNotification.getDefEnable();
            }
            isBlockApp = enable;
        }
        this.getBlockedApplicationNotificationCheck().setSelected(isBlockApp);
        if (this.blockAppNotification != null && !this.isOsTypeMac) {
            this.blockAppString = this.blockAppNotification.getOptAdditionalText();
        }
        if (!this.isOsTypeMac) {
            this.appPrompt = this.securitySetting.getOptAskAppPrompt();
            boolean isAskApp = false;
            if (this.appPrompt != null) {
                Boolean enable = this.appPrompt.getOptEnable();
                if (enable == null) {
                    enable = this.appPrompt.getDefEnable();
                }
                isAskApp = enable;
            }
            this.getAskApplicationTextCheck().setSelected(isAskApp);
            if (this.appPrompt != null) {
                this.appPromptString = this.appPrompt.getOptAdditionalText();
            }
        }
    }

    public SecuritySetting getSecuritySetting() {
        if (!this.isOsTypeMac) {
            this.securitySetting.setOptAskAppPrompt(this.getAppPrompt());
        }
        this.securitySetting.setOptLocalAppBlockingNotification(this.getBlockedApplicationNotification());
        return this.securitySetting;
    }
}

