/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.creamtec.core.StringUtilities;
import com.sygate.scm.common.configobject.schema.FwActiveResponse;
import com.sygate.scm.common.configobject.schema.FwAntiIpSpoofing;
import com.sygate.scm.common.configobject.schema.FwAntiMacSpoofing;
import com.sygate.scm.common.configobject.schema.FwDosProtection;
import com.sygate.scm.common.configobject.schema.FwOsFingerprintMasq;
import com.sygate.scm.common.configobject.schema.FwPortScan;
import com.sygate.scm.common.configobject.schema.FwStealthModeBrowsing;
import com.sygate.scm.common.configobject.schema.SecuritySetting;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AdvancedSettingPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String ANTI_IP = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.InfoAgentPreventsSpoofing");
    private static final String ANTI_MAC_DESC = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.AntiMACDescription");
    private static final String STEALTH_MODE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.InfoStealthMode");
    private static final String STEALTH_MODE_CAUTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.StealthSettings.caution");
    private static final String FINGER_PRINT = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.InfoFingerPrint");
    protected JCheckBox jcbxDenOfServ = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.checkbox.EnableDoSChecking"));
    protected JCheckBox jcbxPortScan = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.checkbox.EnablePortscan"));
    protected JCheckBox jcbxAntiMac = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.checkbox.EnableAntiMACSpoofing"));
    protected final JCheckBox jcbxAutoBlock = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.checkbox.EnableAutoBlockingViolatorsIP"));
    private JCheckBox jCbxStealthMode = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.checkbox.EnableStealthModeBrowsing"));
    private JCheckBox jCbxAntiIP = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.checkbox.EnableAntiIPSpoofing"));
    private JCheckBox jCbxFingerPrint = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.checkbox.EnableOSFingerprintMasquerading"));
    private JLabel jLStealthMode;
    protected final JTextField jTFBlockTime = new JTextField(10);
    protected SecuritySetting securitySetting;
    private static final int MIN_COUNT = 1;
    private static final int MAX_COUNT = 999999;
    private static final String MAX_MIN_COUNT_MSG = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.MaxMinCountMsg");

    public AdvancedSettingPanel() {
        this.initialize();
    }

    public void updateSecuritySettings() {
        FwAntiIpSpoofing ipspoofing = this.securitySetting.getOptFwAntiIpSpoofing();
        if (ipspoofing == null) {
            ipspoofing = new FwAntiIpSpoofing();
            this.securitySetting.setOptFwAntiIpSpoofing(ipspoofing);
        }
        ipspoofing.setOptEnable(Boolean.valueOf(this.jCbxAntiIP.isSelected()));
        FwDosProtection fwDosProtection = this.securitySetting.getOptFwDosProtection();
        if (fwDosProtection == null) {
            fwDosProtection = new FwDosProtection();
            this.securitySetting.setOptFwDosProtection(fwDosProtection);
        }
        fwDosProtection.setOptEnable(Boolean.valueOf(this.jcbxDenOfServ.isSelected()));
        FwPortScan fwPortScan = this.securitySetting.getOptFwPortScan();
        if (fwPortScan == null) {
            fwPortScan = new FwPortScan();
            this.securitySetting.setOptFwPortScan(fwPortScan);
        }
        fwPortScan.setOptEnable(Boolean.valueOf(this.jcbxPortScan.isSelected()));
        FwAntiMacSpoofing macSpoofing = this.securitySetting.getOptFwAntiMacSpoofing();
        if (macSpoofing == null) {
            macSpoofing = new FwAntiMacSpoofing();
            this.securitySetting.setOptFwAntiMacSpoofing(macSpoofing);
        }
        macSpoofing.setOptEnable(Boolean.valueOf(this.jcbxAntiMac.isSelected()));
        FwActiveResponse fwActiveResponse = this.securitySetting.getOptFwActiveResponse();
        if (fwActiveResponse == null) {
            fwActiveResponse = new FwActiveResponse();
            this.securitySetting.setOptFwActiveResponse(fwActiveResponse);
        }
        if (this.jcbxAutoBlock.isSelected()) {
            fwActiveResponse.setOptEnable(Boolean.TRUE);
        } else {
            fwActiveResponse.setOptEnable(Boolean.FALSE);
        }
        String seconds = this.jTFBlockTime.getText();
        if (!StringUtilities.isEmpty((String)seconds)) {
            fwActiveResponse.setOptDefaultAbusePeriod(Long.valueOf(seconds));
        } else {
            fwActiveResponse.setOptDefaultAbusePeriod(fwActiveResponse.getDefDefaultAbusePeriod());
        }
        FwStealthModeBrowsing fwStealth = this.securitySetting.getOptFwStealthModeBrowsing();
        if (fwStealth == null) {
            fwStealth = new FwStealthModeBrowsing();
            this.securitySetting.setOptFwStealthModeBrowsing(fwStealth);
        }
        fwStealth.setOptEnable(Boolean.valueOf(this.jCbxStealthMode.isSelected()));
        FwOsFingerprintMasq fwFinger = this.securitySetting.getOptFwOsFingerprintMasq();
        if (fwFinger == null) {
            fwFinger = new FwOsFingerprintMasq();
            this.securitySetting.setOptFwOsFingerprintMasq(fwFinger);
        }
        fwFinger.setOptEnable(Boolean.valueOf(this.jCbxFingerPrint.isSelected()));
    }

    protected void initialize() {
        UIFontUtilities.setBoldFont((JComponent)this.jcbxDenOfServ);
        UIFontUtilities.setBoldFont((JComponent)this.jcbxPortScan);
        UIFontUtilities.setBoldFont((JComponent)this.jcbxAntiMac);
        UIFontUtilities.setBoldFont((JComponent)this.jcbxAutoBlock);
        UIFontUtilities.setBoldFont((JComponent)this.jCbxStealthMode);
        UIFontUtilities.setBoldFont((JComponent)this.jCbxAntiIP);
        UIFontUtilities.setBoldFont((JComponent)this.jCbxFingerPrint);
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 0));
        this.add(this.getTrafficSettingPanel());
        this.add(this.getStealthSettingSettingPanel());
    }

    protected JPanel getTrafficSettingPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        String denialOfServicesInfo = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPane.InfoDenialOfServices");
        String portScanInfo = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPane.InfoPortscan");
        panel.add((Component)new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.title.ProtectionSettings"), null, false), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (!LicenseObject.getInstance().isSBProduct()) {
            panel.add((Component)this.jcbxPortScan, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 20), 0, 0));
            panel.add((Component)new DescriptionTextArea(portScanInfo, 2, 40), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
            panel.add((Component)this.jcbxDenOfServ, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 20), 0, 0));
            panel.add((Component)new DescriptionTextArea(denialOfServicesInfo, 1, 40), new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        }
        if (LicenseObject.getInstance().isSBProduct()) {
            this.jcbxDenOfServ.setSelected(false);
            this.jcbxPortScan.setSelected(false);
        }
        panel.add((Component)this.jcbxAntiMac, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 20), 0, 0));
        panel.add((Component)new DescriptionTextArea(ANTI_MAC_DESC, 1, 40), new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        if (!LicenseObject.getInstance().isSBProduct()) {
            panel.add((Component)this.jcbxAutoBlock, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 20, 0, 20), 0, 0));
            JPanel blockpanel = new JPanel();
            blockpanel.setLayout(new GridBagLayout());
            blockpanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.BlockIPForNumberOfSeconds")), new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
            RestrictedPlainDocument integerValues = new RestrictedPlainDocument(6);
            integerValues.setValidator("1234567890", true);
            this.jTFBlockTime.setDocument(integerValues);
            blockpanel.add((Component)this.jTFBlockTime, new GridBagConstraints(2, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            long maxLimit = 0xFFFFFFFFL;
            NumberPlainDocument doc = new NumberPlainDocument(1L, maxLimit, true);
            this.jTFBlockTime.setDocument(doc);
            this.jcbxAutoBlock.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent action) {
                    AdvancedSettingPanel.this.autoBlockChanged();
                }
            });
            panel.add((Component)blockpanel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 20, 0, 20), 0, 0));
        }
        return panel;
    }

    protected void autoBlockChanged() {
        this.jTFBlockTime.setEditable(this.jcbxAutoBlock.isEnabled() && this.jcbxAutoBlock.isSelected());
    }

    private JPanel getStealthSettingSettingPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.title.StealthSettings"), null, false), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)this.getCautionPanel(STEALTH_MODE_CAUTION, 2, 40), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 20, 5, 20), 0, 0));
        panel.add((Component)this.jCbxStealthMode, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 20), 0, 0));
        panel.add((Component)new DescriptionTextArea(STEALTH_MODE, 2, 40), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        panel.add((Component)this.jCbxAntiIP, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 20), 0, 0));
        panel.add((Component)new DescriptionTextArea(ANTI_IP, 1, 40), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        panel.add((Component)this.jCbxFingerPrint, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 20), 0, 0));
        panel.add((Component)new DescriptionTextArea(FINGER_PRINT, 2, 40), new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 5, 20), 0, 0));
        return panel;
    }

    private JPanel getCautionPanel(String strText, int rows, int cols) {
        this.jLStealthMode = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "AdvancedSettingPanel.checkbox.StealthModeCaution"));
        this.jLStealthMode.setForeground(UIColorUtilities.ERROR_FOREGROUND);
        this.jLStealthMode.setFont(UIFontUtilities.SUBTITLE_FONT);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(CustomLookAndFeel.SIMPLE_BORDER);
        panel.add((Component)this.jLStealthMode, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new DescriptionTextArea(strText, rows, cols), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        return panel;
    }

    protected void setValues() {
        FwAntiIpSpoofing fwAntiIp = this.securitySetting.getOptFwAntiIpSpoofing();
        FwAntiMacSpoofing fwAntiMacSpoofing = this.securitySetting.getOptFwAntiMacSpoofing();
        FwStealthModeBrowsing fwStealthMode = this.securitySetting.getOptFwStealthModeBrowsing();
        FwOsFingerprintMasq fwFingerPrint = this.securitySetting.getOptFwOsFingerprintMasq();
        FwDosProtection fwDosProtection = this.securitySetting.getOptFwDosProtection();
        FwPortScan fwPortScan = this.securitySetting.getOptFwPortScan();
        FwActiveResponse fwActiveResponse = this.securitySetting.getOptFwActiveResponse();
        boolean allowAntiIp = false;
        if (fwAntiIp != null) {
            allowAntiIp = !Boolean.FALSE.equals(fwAntiIp.getOptEnable());
        }
        this.jCbxAntiIP.setSelected(allowAntiIp);
        boolean allowAntiMac = false;
        if (fwAntiMacSpoofing != null) {
            allowAntiMac = fwAntiMacSpoofing.getOptEnable();
        }
        this.jcbxAntiMac.setSelected(allowAntiMac);
        if (fwActiveResponse == null) {
            fwActiveResponse = new FwActiveResponse();
            fwActiveResponse.setOptEnable(fwActiveResponse.getDefEnable());
            fwActiveResponse.setOptDefaultAbusePeriod(fwActiveResponse.getDefDefaultAbusePeriod());
            this.securitySetting.setOptFwActiveResponse(fwActiveResponse);
        }
        boolean allowAutoBlock = fwActiveResponse.getOptEnable();
        this.jcbxAutoBlock.setSelected(allowAutoBlock);
        Long blockTime = Math.abs(fwActiveResponse.getOptDefaultAbusePeriod() == null ? fwActiveResponse.getDefDefaultAbusePeriod() : fwActiveResponse.getOptDefaultAbusePeriod());
        if (blockTime == 0L || blockTime > 0xFFFFFFFFL) {
            System.out.print("\nFirewall has block time period set as:" + blockTime.toString() + " seconds, ");
            blockTime = blockTime == 0L ? 1L : 0xFFFFFFFFL;
            System.out.println(" floored to: " + blockTime.toString() + " seconds.");
        }
        this.jTFBlockTime.setText(blockTime.toString());
        this.autoBlockChanged();
        boolean stealthMode = false;
        if (fwStealthMode != null) {
            stealthMode = !Boolean.FALSE.equals(fwStealthMode.getOptEnable());
        }
        this.jCbxStealthMode.setSelected(stealthMode);
        boolean fingerPrint = false;
        if (fwFingerPrint != null) {
            fingerPrint = !Boolean.FALSE.equals(fwFingerPrint.getOptEnable());
        }
        this.jCbxFingerPrint.setSelected(fingerPrint);
        boolean denialOfServices = false;
        if (fwDosProtection != null) {
            denialOfServices = !Boolean.FALSE.equals(fwDosProtection.getOptEnable());
        }
        this.jcbxDenOfServ.setSelected(denialOfServices);
        boolean portScan = false;
        if (fwPortScan != null) {
            portScan = !Boolean.FALSE.equals(fwPortScan.getOptEnable());
        }
        this.jcbxPortScan.setSelected(portScan);
    }

    public void setSecuritySetting(SecuritySetting securitySetting) {
        this.securitySetting = securitySetting;
        this.setValues();
    }

    public void setReadOnly() {
        this.jcbxDenOfServ.setEnabled(false);
        this.jcbxPortScan.setEnabled(false);
        this.jcbxAntiMac.setEnabled(false);
        this.jCbxStealthMode.setEnabled(false);
        this.jCbxAntiIP.setEnabled(false);
        this.jCbxFingerPrint.setEnabled(false);
        this.jcbxAutoBlock.setEnabled(false);
        this.jTFBlockTime.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_advanced_settings";
    }

    private boolean valueInRange(String value, int min, int max) {
        boolean inRange = true;
        int realValue = 0;
        try {
            inRange = value == null || value.trim().length() == 0 ? false : (realValue = Integer.parseInt(value)) <= max && realValue >= min;
        }
        catch (Exception ex) {
            inRange = false;
        }
        return inRange;
    }

    public boolean isValidate() {
        boolean isValid = true;
        if (!LicenseObject.getInstance().isSBProduct() && !this.valueInRange(this.jTFBlockTime.getText().trim(), 1, 999999)) {
            Object[] obj = new Object[]{Integer.toString(1), Integer.toString(999999)};
            String fm = MessageFormat.format(MAX_MIN_COUNT_MSG, obj);
            JOptionPane.showMessageDialog(this, fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.title.Error"), 0);
            this.jTFBlockTime.requestFocusInWindow();
            isValid = false;
        }
        return isValid;
    }
}

