/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.logicobject.WhiteListObject;
import com.sygate.scm.console.ui.policy.explorer.whitelist.InProgressDlg;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardData;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.NativeCommandUtilities;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValues;
import java.awt.Container;
import java.io.File;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.Vector;
import javax.swing.JOptionPane;

public class WhiteListWorker
extends SwingWorker {
    protected WhiteListWizardData data;
    protected WhiteListObject whitelist;
    protected String dialogTitle;
    protected String finishMsg;
    private boolean isDone;
    private Container parent;
    private InProgressDlg progressDlg;

    public WhiteListWorker(WhiteListWizardData data) {
        this.data = data;
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public Container getParent() {
        return this.parent;
    }

    public void setFinishMsg(String finishMsg) {
        this.finishMsg = finishMsg;
    }

    public String getFinishMsg() {
        return this.finishMsg;
    }

    public WhiteListObject getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(WhiteListObject whitelist) {
        this.whitelist = whitelist;
    }

    public boolean begin() {
        this.setFinishMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.theFingerprintFileNameIsInvalid"));
        this.progressDlg = new InProgressDlg(this, this.dialogTitle);
        this.start();
        this.progressDlg.setLocationRelativeTo(this.getParent());
        this.progressDlg.setVisible(!Env.isUnitTest());
        if (this.isCancelled()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.theActionIsCancelledByTheUser"), this.dialogTitle, -1);
            return false;
        }
        return true;
    }

    public Object construct() {
        try {
            this.isDone = this.doWork();
        }
        catch (Exception ex) {
            System.err.println("WhiteListWorker>> construct: Exception..." + ex.getMessage());
        }
        return null;
    }

    public void finished() {
        this.progressDlg.showFinished(this.isDone, this.finishMsg);
    }

    protected boolean isCancelled() {
        if (this.progressDlg != null) {
            return this.progressDlg.isCancelled();
        }
        return false;
    }

    protected boolean setErrorMsg(String msg) {
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.error") + msg, -1);
        return false;
    }

    protected void setProgressMsg(String msg, int value) {
        this.progressDlg.appendMessage(msg);
        if (value > 0) {
            this.progressDlg.setProgress(value);
        }
    }

    protected void setCanCancel(boolean canCancel) {
        this.progressDlg.setButtonEnabled(canCancel);
    }

    protected boolean createOrEmptyDir(String dir) {
        int result = this.createDir(dir);
        if (result != 0) {
            return false;
        }
        return Utility.emptyDir((String)dir, (boolean)false);
    }

    protected String generateTempDir(WhiteListObject o) {
        if (o == null || !o.isValid()) {
            return null;
        }
        String path = NativeCommandUtilities.getTempDir() + File.separator + "_ComputerImage_" + o.getId();
        return path;
    }

    protected boolean generateChecksumFileFromList(String checksumFileName, FingerprintListHashValues list) {
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.generatingATempFingerprintFile"), 6);
        if (!WhiteListHandler.saveFingerprintListAsFile(list, checksumFileName, this.whitelist)) {
            Object[] obj = new Object[]{checksumFileName};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.failedToSaveTheFingerprintsIntoFile");
            String fm = MessageFormat.format(str, obj);
            return this.setErrorMsg(fm);
        }
        return true;
    }

    protected boolean saveChecksumFile(String checksumeFileName, boolean master) {
        if (checksumeFileName == null || checksumeFileName.length() < 1) {
            String errMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.theFingerprintFileNameIsInvalid");
            this.setFinishMsg(errMsg);
            return this.setErrorMsg(errMsg);
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.addingTheFingerprintFileIntoTheServer"), -1);
        PhysicalFile pf = null;
        try {
            String name = (master ? "Master_" : "Delta_") + this.data.getName();
            pf = SoftwarePackageHandler.addPhysicalFile(name, checksumeFileName, new GUIDGenerator().getGUIDString(), null, true);
        }
        catch (Throwable ex) {
            this.handleServerBusyException(ex);
            return this.setErrorMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.failedToAddTheFingerprintFileIntoServer"));
        }
        this.whitelist.setImageFile(pf, master);
        return true;
    }

    protected void handleServerBusyException(Throwable ex) {
        if (ex instanceof ConsoleException) {
            if (((ConsoleException)ex).getErrorCode() == 369360896) {
                Optional.ofNullable(this.progressDlg).ifPresent(dlg -> dlg.appendMessage(ex.getMessage()));
                this.setFinishMsg(ex.getMessage());
            }
            ConsoleLogger.log(ex);
        }
    }

    protected boolean processImportedWhiteList(WhiteListObject whitelist, FingerprintListHashValues set) {
        if (whitelist == null || !whitelist.isValid()) {
            return this.setErrorMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.failedToTheImportedFile"));
        }
        if (this.isCancelled()) {
            return false;
        }
        if (!this.processImportedWhiteListFile(whitelist, true, set)) {
            return false;
        }
        if (this.isCancelled()) {
            return false;
        }
        return this.processImportedWhiteListFile(whitelist, false, set);
    }

    protected boolean processImportedWhiteListFile(WhiteListObject whitelist, boolean master, FingerprintListHashValues set) {
        byte[] data;
        try {
            data = WhiteListHandler.getChecksumeFile(whitelist, master);
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.failedToGetTheFingerprintFile");
            String fm = MessageFormat.format(str, whitelist.getName());
            return this.setErrorMsg(fm);
        }
        if (data == null) {
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.failedToReadTheFingerprintFile");
            String fm = MessageFormat.format(str, whitelist.getName());
            return this.setErrorMsg(fm);
        }
        if (data.length < 1) {
            return true;
        }
        if (!WhiteListHandler.readFingerprintListFromBytes(data, set)) {
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.failedToProcessTheFingerprintFile");
            String fm = MessageFormat.format(str, whitelist.getName());
            return this.setErrorMsg(fm);
        }
        return true;
    }

    protected boolean doWork() throws Exception {
        throw new ConsoleException("To be implemented");
    }

    private int createDir(String strDir) {
        if (strDir == null || strDir.length() <= 0) {
            return -1;
        }
        if (strDir.endsWith(File.separator)) {
            strDir = strDir.substring(0, strDir.length() - 1);
        }
        int iResult = -2;
        File f = new File(strDir);
        if (f.exists()) {
            iResult = f.isDirectory() ? 0 : 1;
        } else {
            int i;
            Vector<String> vParents = new Vector<String>();
            vParents.addElement(strDir);
            File tempFile = new File(strDir);
            String strParent = tempFile.getParent();
            while (strParent != null) {
                tempFile = new File(strParent);
                if (tempFile.exists()) {
                    strParent = tempFile.getAbsolutePath();
                    break;
                }
                vParents.addElement(strParent);
                strParent = tempFile.getParent();
            }
            for (i = vParents.size() - 1; i > -1; --i) {
                tempFile = new File((String)vParents.elementAt(i));
                if (tempFile.mkdir()) continue;
                strParent = (String)vParents.elementAt(i);
                iResult = 10;
                ++i;
                break;
            }
            if (iResult == 10) {
                for (i = 0; i < vParents.size(); ++i) {
                    tempFile = new File((String)vParents.elementAt(i));
                    Utility.delete((File)tempFile);
                }
            } else {
                iResult = f.exists() ? (f.isDirectory() ? 0 : 1) : -2;
            }
        }
        return iResult;
    }

    public boolean isAllDone() {
        return this.isDone;
    }
}

