/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardData;
import com.sygate.scm.console.ui.policy.util.FileFingerprintOperations;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class WhiteListWizardOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean isCreateFingerprintList = true;
    private static final String PAGE_NAME = "whitelistwizardoptionspanel";
    private final JRadioButton jRBCreating = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.createTheFileFingerprintListByImporting"), true);
    private final JRadioButton jRBCombining = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.createTheFileFingerprintListByCombining"), true);
    private final JRadioButton jRBAppend = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.appendAFingerprintToThisFile"), true);
    private final JRadioButton jRBAppendOther = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.appendOtherFingerprintListsToThisFile"), true);
    private final JRadioButton jRBReplace = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.replaceThisFileWithAFingerprintFile"), true);
    private final JRadioButton jRBRemove = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.removeFileFingerprintsFromThisFile"), true);
    private final JTextArea jTAPoolDesc = new DescriptionTextArea("");

    public WhiteListWizardOptionsPanel(boolean createFingerprintList) {
        this.isCreateFingerprintList = createFingerprintList;
        this.initialize();
    }

    public FileFingerprintOperations getFileFingerprintOperation() {
        if (this.isCreateFingerprintList) {
            if (this.jRBCreating.isSelected()) {
                return FileFingerprintOperations.CREATING;
            }
            return FileFingerprintOperations.COMBINING;
        }
        if (this.jRBAppend.isSelected()) {
            return FileFingerprintOperations.APPENDING;
        }
        if (this.jRBAppendOther.isSelected()) {
            return FileFingerprintOperations.APPENDING_OTHER;
        }
        if (this.jRBReplace.isSelected()) {
            return FileFingerprintOperations.REPLACING;
        }
        return FileFingerprintOperations.REMOVING;
    }

    public void updateData(WhiteListWizardData data) {
        data.setFileFingerprintOperation(this.getFileFingerprintOperation());
        this.updateAppend();
    }

    private void initialize() {
        String content;
        String title;
        UIUtilities.setName(this.jRBCreating, PAGE_NAME, UIUtilities.ComponentType.JRADIOBUTTON, "Creating");
        UIUtilities.setName(this.jRBCombining, PAGE_NAME, UIUtilities.ComponentType.JRADIOBUTTON, "Combining");
        if (this.isCreateFingerprintList) {
            title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.createFileFingerprintList");
            content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.addFileFingerprintListContent");
        } else {
            title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.editFileFingerprintList");
            content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.editFingerprintListContent");
        }
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        ButtonGroup group = new ButtonGroup();
        if (this.isCreateFingerprintList) {
            group.add(this.jRBCreating);
            group.add(this.jRBCombining);
        } else {
            group.add(this.jRBAppend);
            group.add(this.jRBAppendOther);
            group.add(this.jRBReplace);
            group.add(this.jRBRemove);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
        if (this.isCreateFingerprintList) {
            panel.add((Component)this.jRBCreating, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
            panel.add((Component)this.jRBCombining, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        } else {
            panel.add((Component)this.jRBAppend, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
            panel.add((Component)this.jRBAppendOther, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)this.jRBReplace, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)this.jRBRemove, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)this.jTAPoolDesc, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 0), 0, 0));
        }
        this.updateAppend();
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.add(headPanel);
        this.add(panel);
    }

    protected void updateAppend() {
        try {
            int count = WhiteListHandler.getComputerImagesCountFromPool();
            boolean isEnabled = count > 1;
            this.jRBCombining.setEnabled(isEnabled);
            this.jRBAppendOther.setEnabled(isEnabled);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }
}

