/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.sepm.ajaxswing.support.ComponentUtils;
import com.sygate.scm.common.help.HelpUtil;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.HTMLEditorPane;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardData;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.UIText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WhiteListWizardImportLocalFilePanel
extends JPanel
implements FileOpener {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LEN_FILENAME = 255;
    private static final String PAGE_NAME = "whitelistwizardimportlocalfilepanel";
    private static final String AUTOMATION_ID_BROWSE_BUTTON = "Browse";
    private JTextField jTFFile = new JTextField(40);
    private JButton jBBrowse = new JButton(UIText.get(257));
    private String filePath;
    private JPanel headPanel = null;
    private Dimension wizardSize;
    JPanel bodyPanel = new JPanel(new GridBagLayout());

    public WhiteListWizardImportLocalFilePanel(Dimension wizardSize) {
        this.wizardSize = wizardSize;
        UIUtilities.setName(this.jBBrowse, PAGE_NAME, UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_BROWSE_BUTTON);
    }

    public void updateData(WhiteListWizardData data) {
        data.setFileName(this.filePath);
    }

    public boolean validatePanel() {
        if (this.filePath == null || this.filePath.length() < 1 || this.filePath.length() > 255) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.pleaseInputAValidFileName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.error"), 0);
            return false;
        }
        File file = new File(this.filePath);
        if (!file.exists()) {
            Object[] obj = new Object[]{AjaxSwingUtil.getDisplayFileName(file)};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.doesNotExist");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.error"), 0);
            return false;
        }
        return true;
    }

    public void initialize(boolean isRemoving) {
        RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
        this.jTFFile.setDocument(doc);
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> this.jTFFile.setEditable(false));
        String urlLink = HelpUtil.getHelpUrl((String)"sesm_computersnusers_policies_system_lockdown_sha256");
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.importFromLocal");
        String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.youNeedToSpecifyThePath");
        String importLegacyMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.msg.importLegacyMsg");
        String learnMore = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.learnMore");
        String learnMoreLink = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.helpLink"), urlLink, learnMore);
        this.headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        this.jBBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WhiteListWizardImportLocalFilePanel.this.btBrowse_actionPerformed(e);
            }
        });
        ComponentUtils.setFileOpener((JComponent)this.jBBrowse, (FileOpener)this);
        this.bodyPanel = new JPanel(new GridBagLayout());
        this.bodyPanel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
        this.bodyPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.specifyTheFingerprintFilePath")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.bodyPanel.add((Component)this.jTFFile, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.bodyPanel.add((Component)this.jBBrowse, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
        if (!isRemoving) {
            HTMLEditorPane legacyMsgPane = new HTMLEditorPane((Component)this.bodyPanel);
            legacyMsgPane.setPreferredSize(new Dimension(this.wizardSize.width * 4 / 5, this.wizardSize.height / 5));
            legacyMsgPane.setText(importLegacyMsg);
            this.bodyPanel.add((Component)legacyMsgPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(30, 0, 0, 0), 0, 0));
            HTMLEditorPane learnMorePane = new HTMLEditorPane((Component)this.bodyPanel);
            learnMorePane.setPreferredSize(new Dimension(this.wizardSize.width * 4 / 5, 15));
            learnMorePane.setText(learnMoreLink);
            this.bodyPanel.add((Component)learnMorePane, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.add(this.headPanel);
        this.add(this.bodyPanel);
    }

    public void updatePanel(String title, String content, boolean isRemoving) {
        this.initialize(isRemoving);
        this.headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        this.removeAll();
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.add(this.headPanel);
        this.add(this.bodyPanel);
    }

    public void openFile(File file) {
        if (file != null) {
            this.jTFFile.setText(AjaxSwingUtil.getDisplayFileName(file));
            this.filePath = file.getAbsolutePath();
        }
    }

    private void btBrowse_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        if (fc.showOpenDialog(this) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (file != null) {
            this.jTFFile.setText(AjaxSwingUtil.getDisplayFileName(file));
            this.filePath = file.getAbsolutePath();
        }
    }

    public void setFocus() {
        this.jTFFile.requestFocusInWindow();
    }
}

