/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.logicobject.WhiteListObject;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardData;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class WhiteListWizardImportListPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String PAGE_NAME = "whitelistwizardimportlistpanel";
    private static final String AUTOMATION_ID_LIST_FILES = "ListFiles";
    private static final String AUTOMATION_ID_LIST_FILES_CHECKBOX = "ListFilesCheckBox_";
    private static final String AUTOMATION_ID_LIST_FILES_TEXT = "ListFilesText_";
    private final WhiteListCheckBoxList listFiles = new WhiteListCheckBoxList();

    public WhiteListWizardImportListPanel() {
        this.initialize();
    }

    public void setData(WhiteListWizardData data) {
        this.listFiles.init(data.getBaseWhiteList());
    }

    public void updateData(WhiteListWizardData data) {
        data.setWhiteList(this.listFiles.getSelection());
    }

    public void updateHeadPanel(String title, String content) {
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)headPanel, "North");
        this.add((Component)new JScrollPane(this.listFiles), "Center");
    }

    public boolean validatePanel() {
        ArrayList<WhiteListObject> list = this.listFiles.getSelection();
        if (list == null || list.size() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportListPanel.pleaseSelectAtLeastOneItem"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportListPanel.error"), 0);
            return false;
        }
        return true;
    }

    private void initialize() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportListPanel.combineFingerprintLists");
        String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportListPanel.selectFingerprintListsToCombine");
        UIUtilities.setName(this.listFiles, PAGE_NAME, UIUtilities.ComponentType.JLIST, AUTOMATION_ID_LIST_FILES);
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        this.setLayout(new BorderLayout());
        this.add((Component)headPanel, "North");
        this.add((Component)new JScrollPane(this.listFiles), "Center");
    }

    private static class WhiteListCheckBoxRenderer
    extends JPanel
    implements ListCellRenderer<WhiteListObject> {
        private static final long serialVersionUID = 1L;
        JCheckBox check = new JCheckBox();
        JLabel label;

        public WhiteListCheckBoxRenderer(JList<WhiteListObject> list) {
            this.add(this.check);
            this.label = new JLabel();
            this.add(this.label);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends WhiteListObject> list, WhiteListObject value, int index, boolean isSelected, boolean hasFocus) {
            this.label.setPreferredSize(new Dimension(500, this.label.getPreferredSize().height));
            WhiteListObject item = value;
            boolean enabled = list.isEnabled() && item.isGuiEnabled();
            this.setEnabled(enabled);
            this.check.setSelected(item.isSelected());
            this.check.setEnabled(enabled);
            this.label.setText(item.getName());
            this.label.setEnabled(enabled);
            UIUtilities.setName(this.check, WhiteListWizardImportListPanel.PAGE_NAME, UIUtilities.ComponentType.JLIST, WhiteListWizardImportListPanel.AUTOMATION_ID_LIST_FILES_CHECKBOX + index);
            UIUtilities.setName(this.label, WhiteListWizardImportListPanel.PAGE_NAME, UIUtilities.ComponentType.JLIST, WhiteListWizardImportListPanel.AUTOMATION_ID_LIST_FILES_TEXT + index);
            return this;
        }

        public int getCheckBoxWidth() {
            return this.check.getWidth();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d_check = this.check.getPreferredSize();
            Dimension d_label = this.label.getPreferredSize();
            return new Dimension(d_check.width + d_label.width, d_check.height < d_label.height ? d_label.height : d_check.height);
        }

        @Override
        public void doLayout() {
            Dimension d_check = this.check.getPreferredSize();
            Dimension d_label = this.getPreferredSize();
            int y_check = 0;
            int y_label = 0;
            if (d_check.height < d_label.height) {
                y_check = (d_label.height - d_check.height) / 2;
            } else {
                y_label = (d_check.height - d_label.height) / 2;
            }
            this.check.setLocation(0, y_check);
            this.check.setBounds(0, y_check, d_check.width, d_check.height);
            this.label.setLocation(d_check.width, y_label);
            this.label.setBounds(d_check.width, y_label, d_label.width, d_label.height);
        }
    }

    private static class WhiteListCheckBoxList
    extends JList<WhiteListObject> {
        private static final long serialVersionUID = 1L;

        public WhiteListCheckBoxList() {
            this.initialize();
        }

        private void initialize() {
            this.setModel(new DefaultListModel());
            this.setCellRenderer(new WhiteListCheckBoxRenderer(this));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!this.isEnabled()) {
                        return;
                    }
                    int index = this.locationToIndex(e.getPoint());
                    if (index < 0) {
                        return;
                    }
                    WhiteListCheckBoxRenderer renderer = (WhiteListCheckBoxRenderer)this.getCellRenderer();
                    int checkWidth = renderer.getCheckBoxWidth();
                    int eventX = e.getPoint().x;
                    int startX = this.indexToLocation((int)index).x;
                    if (eventX >= startX && eventX <= startX + checkWidth) {
                        WhiteListObject item;
                        item.setSelected((item = (WhiteListObject)this.getModel().getElementAt(index)).isGuiEnabled() && !item.isSelected());
                        Rectangle rect = this.getCellBounds(index, index);
                        this.repaint(rect);
                    }
                }
            });
        }

        public ArrayList<WhiteListObject> getSelection() {
            ArrayList<WhiteListObject> list = new ArrayList<WhiteListObject>();
            ListModel listModel = this.getModel();
            int size = listModel.getSize();
            for (int i = 0; i < size; ++i) {
                WhiteListObject item = (WhiteListObject)listModel.getElementAt(i);
                if (!item.isSelected()) continue;
                list.add(item);
            }
            return list;
        }

        public void init(WhiteListObject whitelistBase) {
            DefaultListModel listModel = (DefaultListModel)this.getModel();
            listModel.removeAllElements();
            try {
                ArrayList<ComputerImage> list = WhiteListHandler.getComputerImagesFromPool();
                for (ComputerImage image : list) {
                    WhiteListObject o = new WhiteListObject(image);
                    if (whitelistBase != null && whitelistBase.getId().equals(o.getId())) continue;
                    listModel.addElement(o);
                }
            }
            catch (Exception ex) {
                System.out.println("WhiteListCheckBoxList>> init: Exception...");
                LoggerUtilities.logException((Throwable)ex);
            }
        }
    }
}

