/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardData;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WhiteListWizardEntryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LEN_NAME = 255;
    private static final int MAX_LEN_DESCRIPTION = 255;
    private static final String PAGE_NAME = "whitelistwizardentrypanel";
    private static final String AUTOMATION_ID_NAME_TEXT_FIELD = "Name";
    private static final String AUTOMATION_ID_DESCRIPTION_TEXT_AREA = "Description";
    private JTextField jTFName = new JTextField(new RestrictedPlainDocument(255), "", 20);
    private JTextArea jTADesc = new JTextArea(5, 20);

    public WhiteListWizardEntryPanel() {
        this.initialize();
    }

    public void updateData(WhiteListWizardData data) {
        data.setName(this.jTFName.getText().trim());
        data.setDescription(this.jTADesc.getText().trim());
    }

    public boolean validatePanel() {
        String name = this.jTFName.getText().trim();
        if (name.length() == 0 || name.length() > 255) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardEntryPanel.pleaseInputAValidName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardEntryPanel.error"), 0);
            return false;
        }
        String description = this.jTADesc.getText();
        if (description.length() > 255) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardEntryPanel.theDescriptionIsTooLong"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardEntryPanel.error"), 0);
            return false;
        }
        try {
            if (WhiteListHandler.getComputerImageByName(name) != null) {
                Object[] obj = new Object[]{name};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardEntryPanel.theFileFingerprintAlreadyExists");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardEntryPanel.error"), 0);
                return false;
            }
        }
        catch (Throwable ex) {
            System.err.println("WhiteListWizardEntryPanel->validatePanel: Can't get computer image.");
        }
        return true;
    }

    private void initialize() {
        UIUtilities.setName(this.jTFName, PAGE_NAME, UIUtilities.ComponentType.TEXTFIELD, AUTOMATION_ID_NAME_TEXT_FIELD);
        UIUtilities.setName(this.jTADesc, PAGE_NAME, UIUtilities.ComponentType.TEXTAREA, AUTOMATION_ID_DESCRIPTION_TEXT_AREA);
        RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
        this.jTADesc.setDocument(doc);
        this.jTADesc.setWrapStyleWord(true);
        this.jTADesc.setLineWrap(true);
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardEntryPanel.title.informationOfNewFileFingerprintList");
        String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardEntryPanel.youCanSpecifyTheNameAndDescriptionHere");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 80, 10, 80));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardEntryPanel.label.name")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTFName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardEntryPanel.label.description")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTextArea)this.jTADesc);
        panel.add((Component)scrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.add(headPanel);
        this.add(panel);
    }

    public void setFocus() {
        this.jTFName.requestFocusInWindow();
    }
}

