/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.logicobject.WhiteListObject;
import com.sygate.scm.console.ui.client.WarningIconCellRenderer;
import com.sygate.scm.console.ui.policy.explorer.common.NonAppliablePolicyPanelBase;
import com.sygate.scm.console.ui.policy.explorer.whitelist.EditWhiteListWizard;
import com.sygate.scm.console.ui.policy.explorer.whitelist.FileFingerPrintPropertiesDlg;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.WarningButton;
import com.sygate.scm.console.ui.util.renderer.JLabelCellRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValues;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class WhiteListPanel
extends NonAppliablePolicyPanelBase {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_ID_WHITELIST_TABLE = "WhitelistTable";
    private static final String[] TABLE_COLOMN_NAMES = new String[]{"", MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.column.name"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.column.description"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.column.fileCount"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.column.updateTime")};
    private static final int[] TABLE_COLUMN_MAP = new int[]{0, 1, 2, 3, 4};
    private static final float[] TABLE_COLUMN_WIDTHS = new float[]{0.0f, 0.3f, 0.4f, 0.1f, 0.2f};
    private static String[] str = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.html.fileFingerprintLists"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.html.fileFingerprintListsIncludeTheChecksums")};
    private static final String TITLE_DESCRIPTION = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HTML>  <HEAD>    <style type=\"text/css\">" + HTMLUtilities.getStyleSheet() + "    </style>  </HEAD>  <BODY>      <P class=\"headline\">" + str[0] + "      </P>    <TABLE width=100% border='0' cellspacing='1' align='left' valign='top'>      <TR>        <TD>" + str[1] + "        </TD>      </TR>    </TABLE>  </BODY></HTML>";

    public WhiteListPanel() {
        this.initialize();
        this.jTTable.setDefaultRenderer(JLabelData.class, new JLabelCellRenderer(false));
        this.jTTable.getColumnModel().getColumn(0).setMaxWidth(0);
        this.jTTable.getColumnModel().getColumn(0).setMinWidth(0);
        UIUtilities.setName(this.jTTable, "policyPage", UIUtilities.ComponentType.JTABLE, AUTOMATION_ID_WHITELIST_TABLE);
    }

    @Override
    public boolean getCanExport() {
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_pane_policy_components";
    }

    @Override
    protected void refreshModel(SortableTableModel model) throws ConsoleException {
        model.removeAll();
        boolean hasWarning = false;
        for (ComputerImage image : WhiteListHandler.getComputerImagesFromDB()) {
            WhiteListObject obj = new WhiteListObject(image);
            model.addRow(obj);
            if (!obj.hasWarning()) continue;
            hasWarning = true;
        }
        TableColumn warningColumn = this.jTTable.getColumnModel().getColumn(0);
        int width = hasWarning ? 30 : 0;
        warningColumn.setMaxWidth(width);
        warningColumn.setMinWidth(width);
        UIUtilities.resizeColumns(this.jTTable, TABLE_COLUMN_WIDTHS, this.getWidth());
    }

    @Override
    protected String getHTMLName() {
        return "whitelist_temp.htm";
    }

    @Override
    protected String getTitleAndDescription() {
        return TITLE_DESCRIPTION;
    }

    @Override
    protected void setColumnRenderers(JTable thisTable) {
        thisTable.getColumnModel().getColumn(0).setCellRenderer(new WarningIconCellRenderer());
    }

    @Override
    protected String[] getTableColumnName() {
        return TABLE_COLOMN_NAMES;
    }

    @Override
    protected int[] getTableColumnMapping() {
        return TABLE_COLUMN_MAP;
    }

    @Override
    protected float[] getTableColumnWidths() {
        return TABLE_COLUMN_WIDTHS;
    }

    @Override
    protected int getItemType() {
        return 130;
    }

    @Override
    protected boolean isActionEnabled() {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        return !AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context) && this.jTTable.getSelectedRow() != -1;
    }

    @Override
    protected boolean isEditActionEnabled() {
        if (!this.isActionEnabled()) {
            return false;
        }
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        WhiteListObject wlObj = (WhiteListObject)model.getRow(this.jTTable.getSelectedRow());
        return !wlObj.isCollectedByCommand() && !wlObj.isCollectedByWebService();
    }

    @Override
    protected String getEditDisabledToolTip() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.Noneditable.ToolTip");
    }

    @Override
    protected void doAdd() {
        WhiteListHandler.addWhiteList();
    }

    @Override
    public boolean isSupportAboutDialog() {
        return true;
    }

    @Override
    protected void doAbout() {
        try {
            SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
            WhiteListObject wlObj = (WhiteListObject)model.getRow(this.jTTable.getSelectedRow());
            new FileFingerPrintPropertiesDlg(wlObj);
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log("Exception while displaying properties dialog for fingerprint list");
            ConsoleLogger.log(ex);
        }
    }

    @Override
    protected void doEdit() {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.readonlyusercannotedit"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.editfingerprint"), -1);
            return;
        }
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        WhiteListObject wlObj = (WhiteListObject)model.getRow(this.jTTable.getSelectedRow());
        EditWhiteListWizard wizard = new EditWhiteListWizard(wlObj);
        wizard.dispose();
    }

    @Override
    protected void doDelete() {
        block4: {
            int ret = JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.youAreAboutToDeleteFileFingerprint"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.deleteFileFingerprint"), 0);
            if (ret != 0) {
                return;
            }
            SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
            WhiteListObject wlObj = (WhiteListObject)model.getRow(this.jTTable.getSelectedRow());
            if (WhiteListHandler.canDelete(wlObj)) {
                try {
                    WhiteListHandler.deleteWhiteList(wlObj);
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    if (!ex.needRelogin()) break block4;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
    }

    @Override
    protected void doExport() {
        block6: {
            try {
                SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
                WhiteListObject wlObj = (WhiteListObject)model.getRow(this.jTTable.getSelectedRow());
                JFileChooser fc = new JFileChooser();
                fc.setApproveButtonText(UIText.get(3584));
                fc.setSelectedFile(new File(wlObj.getName() + ".txt"));
                fc.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.export.title"));
                fc.updateUI();
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    fc.setDialogType(1);
                    if (0 != fc.showSaveDialog(this) || fc.getSelectedFile() == null) {
                        return;
                    }
                } else if (0 != fc.showOpenDialog(this) || fc.getSelectedFile() == null) {
                    return;
                }
                String fileName = fc.getSelectedFile().getAbsolutePath();
                FingerprintListHashValues set = new FingerprintListHashValues();
                byte[] dataMaster = WhiteListHandler.getChecksumeFile(wlObj, true);
                WhiteListHandler.readFingerprintListFromBytes(dataMaster, set);
                byte[] dataDelta = WhiteListHandler.getChecksumeFile(wlObj, false);
                WhiteListHandler.readFingerprintListFromBytes(dataDelta, set);
                WhiteListHandler.saveFingerprintListAsFile(set, fileName, null);
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                if (!ex.needRelogin()) break block6;
                Manager.frame.showLoginPanel();
            }
        }
    }

    @Override
    protected String getPolicyTypeName() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListPanel.title");
    }

    @Override
    protected void retrieveTableSelection(TableRow selectedRow) {
        if (selectedRow == null) {
            return;
        }
        WhiteListObject selList = (WhiteListObject)selectedRow;
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            WhiteListObject list = (WhiteListObject)model.getRow(i);
            if (!list.getId().equals(selList.getId())) continue;
            this.jTTable.setRowSelectionInterval(i, i);
            break;
        }
    }

    @Override
    protected void mouseClicked(MouseEvent e) {
        int row;
        super.mouseClicked(e);
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (e.getClickCount() == 1) {
            int row2 = this.jTTable.rowAtPoint(e.getPoint());
            int col = this.jTTable.columnAtPoint(e.getPoint());
            if (row2 < 0 || col < 0) {
                return;
            }
            if (col == 0 && this.jTTable.getColumnModel().getColumn(0).getCellRenderer().getClass() == WarningIconCellRenderer.class) {
                WarningButton warningIcon = (WarningButton)this.jTTable.getValueAt(row2, col);
                warningIcon.doClick();
            }
        } else if (e.getClickCount() == 2 && (row = this.jTTable.rowAtPoint(e.getPoint())) >= 0) {
            this.executeTask(3, null);
        }
    }

    @Override
    protected void mouseMoved(MouseEvent e) {
        int row = this.jTTable.rowAtPoint(e.getPoint());
        int col = this.jTTable.columnAtPoint(e.getPoint());
        if (col == 0 && this.jTTable.getColumnModel().getColumn(0).getCellRenderer().getClass() == WarningIconCellRenderer.class) {
            WarningButton warningIcon = (WarningButton)this.jTTable.getValueAt(row, col);
            if (warningIcon.getWarningEnabled()) {
                this.jTTable.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.jTTable.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            this.jTTable.setCursor(Cursor.getDefaultCursor());
        }
    }
}

