/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWorker;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;

public class InProgressDlg
extends JDialog {
    private static final String AUTOMATION_ID_JBSTOP = "WhitelistInProgressDlgStopOrClose";
    private static final long serialVersionUID = 1L;
    private JButton jBStop = new JButton(UIText.get(4621));
    private JProgressBar jProgressBar = new JProgressBar();
    private JTextArea jTAMessage = new JTextArea(10, 40);
    private JPanel mainPanel = new JPanel();
    private boolean canCancelled = true;
    private boolean isCancelled;

    public InProgressDlg(WhiteListWorker worker, String title) {
        super(Manager.getFrame(), title, true);
        this.setDefaultCloseOperation(0);
        this.initialize();
        UiUtilities.centerComponent((Component)this);
        UIUtilities.setName(this.jBStop, "policyPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_JBSTOP);
        this.pack();
    }

    public void appendMessage(String message) {
        this.jTAMessage.append(message + System.getProperty("line.separator"));
        try {
            this.jTAMessage.scrollRectToVisible(this.jTAMessage.modelToView(this.jTAMessage.getLineStartOffset(this.jTAMessage.getLineCount() - 1)));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void stop() {
        if (this.canCancelled) {
            this.isCancelled = true;
        }
        this.dispose();
    }

    public void setButtonEnabled(boolean enabled) {
        this.canCancelled = enabled;
        this.jBStop.setEnabled(enabled);
    }

    public void setProgress(int value) {
        this.jProgressBar.setValue(value);
    }

    public void showFinished(boolean showOK, String text) {
        this.canCancelled = false;
        if (!showOK) {
            this.mainPanel.removeAll();
            this.mainPanel.add((Component)new JLabel(UIManager.getIcon("OptionPane.errorIcon")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.mainPanel.add((Component)new JTextArea(text), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 15, 0, 0), 10, 0));
            this.mainPanel.add((Component)this.jBStop, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.mainPanel.validate();
            this.pack();
        } else {
            this.mainPanel.remove(this.jProgressBar);
            this.mainPanel.add((Component)new JLabel(text, new ImageIcon(Toolkit.getDefaultToolkit().getImage("tasklist_result_ok.png")), 0), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.mainPanel.validate();
        }
        this.setDefaultCloseOperation(2);
        this.jBStop.setEnabled(true);
        this.jBStop.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "InProgressDlg.btnClose"));
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.jBStop);
    }

    private void initialize() {
        this.jBStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InProgressDlg.this.stop();
            }
        });
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.jBStop);
        this.jTAMessage.setEditable(false);
        this.jProgressBar.setMaximum(10);
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.mainPanel.add((Component)this.jProgressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "InProgressDlg.lbMessages")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)new JScrollPane(this.jTAMessage), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.jBStop, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }
}

