/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.WhiteListObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileFingerPrintPropertiesDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private JTextField jTFID = new JTextField(30);
    private JTextField jTFName = new JTextField(30);
    private JTextField jTFDesc = new JTextField();
    private JTextField jTFSource = new JTextField();
    private JTextField jTFAdminName = new JTextField();
    private JTextField jTFCreateTime = new JTextField();
    private JTextField jTFModifyTime = new JTextField();
    private WhiteListObject wlObj = null;

    public FileFingerPrintPropertiesDlg(WhiteListObject wlObj) throws ConsoleException {
        super(Manager.getFrame(), "", true, false);
        this.wlObj = wlObj;
        Object[] obj = new Object[]{wlObj.getName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.propertiesTitle");
        String fm = MessageFormat.format(str, obj);
        this.setTitle(fm);
        this.initialize();
        this.initData();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private void initialize() {
        RestrictedPlainDocument descriptionDoc = new RestrictedPlainDocument(1024);
        this.jTFDesc.setDocument(descriptionDoc);
        this.jTFID.setEditable(false);
        this.jTFName.setEditable(false);
        this.jTFDesc.setEditable(false);
        this.jTFSource.setEditable(false);
        this.jTFAdminName.setEditable(false);
        this.jTFCreateTime.setEditable(false);
        this.jTFModifyTime.setEditable(false);
        JPanel upPanel = new JPanel(new GridBagLayout());
        upPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.IDLabel")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFID, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.nameLabel")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.descriptionLabel")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFDesc, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.Source")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFSource, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.createdByLabel")), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFAdminName, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.dateCreatedLabel")), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFCreateTime, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        upPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.lastModifiedLabel")), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        upPanel.add((Component)this.jTFModifyTime, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.addClientDetailsIfPresent(upPanel), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private void initData() throws ConsoleException {
        this.jTFID.setText(this.wlObj.getId());
        this.jTFID.setToolTipText(this.jTFID.getText());
        this.jTFName.setText(this.wlObj.getName());
        this.jTFName.setToolTipText(this.jTFName.getText());
        String description = this.wlObj.getDescription().getText();
        this.jTFDesc.setText(description);
        this.jTFSource.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.Source." + this.wlObj.getSource()));
        this.jTFSource.setToolTipText(this.jTFSource.getText());
        this.jTFAdminName.setText(this.wlObj.getImage().getOptCreator());
        this.jTFAdminName.setToolTipText(this.jTFAdminName.getText());
        this.jTFCreateTime.setText(this.wlObj.getCreationTimeLongFormat());
        this.jTFCreateTime.setToolTipText(this.jTFCreateTime.getText());
        this.jTFModifyTime.setText(this.wlObj.getUpdateTimeLongFormat());
        this.jTFModifyTime.setToolTipText(this.jTFModifyTime.getText());
    }

    @Override
    protected boolean isCancelButtonShown() {
        return false;
    }

    @Override
    protected String getOkButtonText() {
        return UIText.get(519);
    }

    private JPanel addClientDetailsIfPresent(JPanel contentPanel) {
        JPanel tempPanel = null;
        if (!"".equals(this.wlObj.getHardwareKey()) && this.wlObj.getHardwareKey().length() > 0) {
            String clientDetailsHeader = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.client.title");
            ClientDetailsPane clientDetailsPane = new ClientDetailsPane(clientDetailsHeader);
            tempPanel = new JPanel(new BorderLayout());
            tempPanel.add((Component)contentPanel, "Center");
            tempPanel.add((Component)clientDetailsPane, "South");
        } else {
            tempPanel = contentPanel;
        }
        return tempPanel;
    }

    private class ClientDetailsPane
    extends AvTemplatePane {
        private static final long serialVersionUID = 1L;
        private JTextField jTFCompName;
        private JTextField jTFHwKey;
        private JTextField jTFIPAddr;
        private JTextField jTFOS;

        public ClientDetailsPane(String title) {
            super(title, null);
            this.jTFCompName = new JTextField();
            this.jTFHwKey = new JTextField();
            this.jTFIPAddr = new JTextField();
            this.jTFOS = new JTextField();
            this.initialize();
            this.initData();
        }

        private void initialize() {
            this.jTFCompName.setEditable(false);
            this.jTFHwKey.setEditable(false);
            this.jTFIPAddr.setEditable(false);
            this.jTFOS.setEditable(false);
            JPanel clientPanel = new JPanel(new GridBagLayout());
            clientPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            clientPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.client.compName")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            clientPanel.add((Component)this.jTFCompName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
            clientPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.client.hwkey")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            clientPanel.add((Component)this.jTFHwKey, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
            clientPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.client.ipAddr")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            clientPanel.add((Component)this.jTFIPAddr, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
            clientPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FileFingerPrintPropertiesDlg.client.os")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            clientPanel.add((Component)this.jTFOS, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
            this.add(clientPanel);
        }

        private void initData() {
            this.jTFCompName.setText(FileFingerPrintPropertiesDlg.this.wlObj.getComputerName());
            this.jTFCompName.setToolTipText(this.jTFCompName.getText());
            this.jTFHwKey.setText(FileFingerPrintPropertiesDlg.this.wlObj.getHardwareKey());
            this.jTFHwKey.setToolTipText(this.jTFHwKey.getText());
            this.jTFIPAddr.setText(FileFingerPrintPropertiesDlg.this.wlObj.getComputerIPv4());
            this.jTFIPAddr.setToolTipText(this.jTFIPAddr.getText());
            this.jTFOS.setText(FileFingerPrintPropertiesDlg.this.wlObj.getComputerOS());
            this.jTFOS.setToolTipText(this.jTFOS.getText());
        }
    }
}

