/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.logicobject.WhiteListObject;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardData;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWorker;
import com.sygate.scm.console.ui.policy.util.FileFingerprintOperations;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValues;
import com.sygate.scm.util.systemlockdown.FingerprintListHelper;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListException;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class EditWhiteListWorker
extends WhiteListWorker {
    private PhysicalFile fileOldMaster;
    FingerprintListHashValues listMaster = new FingerprintListHashValues();

    public EditWhiteListWorker(WhiteListObject whitelist, WhiteListWizardData data) {
        super(data);
        this.whitelist = whitelist;
        this.fileOldMaster = whitelist.getPhysicalFile(true);
        this.dialogTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.title.editFileFingerprint");
        this.finishMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.errorHappened");
    }

    @Override
    protected boolean doWork() throws FingerprintListException, ConsoleException {
        String tempDir = this.generateTempDir(this.whitelist);
        if (!this.createTempDir(tempDir)) {
            return false;
        }
        if (!this.retrieveChecksumsFromEditedWhiteList()) {
            return false;
        }
        if (this.data.getFileFingerprintOperation() == FileFingerprintOperations.APPENDING && !this.doAppend() || this.data.getFileFingerprintOperation() == FileFingerprintOperations.APPENDING_OTHER && !this.doAppendOther() || this.data.getFileFingerprintOperation() == FileFingerprintOperations.REPLACING && !this.doReplace() || this.data.getFileFingerprintOperation() == FileFingerprintOperations.REMOVING && !this.doRemove()) {
            return false;
        }
        String masterFileName = tempDir + File.separator + "master.txt";
        if (!this.generateChecksumFileFromList(masterFileName, this.listMaster)) {
            return false;
        }
        if (!this.saveChecksumFiles(masterFileName)) {
            return false;
        }
        return this.cleanUp(tempDir);
    }

    protected boolean createTempDir(String tempDir) {
        if (tempDir == null || tempDir.length() < 1) {
            return this.setErrorMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.failedToGenerateATempDir"));
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.creatingATemporaryDirectory"), 1);
        if (!this.createOrEmptyDir(tempDir)) {
            Object[] obj = new Object[]{tempDir};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.failedToCreateTheTempDir");
            String fm = MessageFormat.format(str, obj);
            return this.setErrorMsg(fm);
        }
        return true;
    }

    protected boolean retrieveChecksumsFromEditedWhiteList() {
        if (this.isCancelled()) {
            return false;
        }
        Object[] obj = new Object[]{this.whitelist.getName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.retrievingFingerprintFromEdited");
        String fm = MessageFormat.format(str, obj);
        this.setProgressMsg(fm, 2);
        if (!this.processImportedWhiteListFile(this.whitelist, true, this.listMaster)) {
            return false;
        }
        return !this.isCancelled();
    }

    protected boolean doAppend() throws FingerprintListException {
        if (this.isCancelled()) {
            return false;
        }
        String sourceFileName = this.data.getFileName();
        Object[] obj = new Object[]{sourceFileName};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.retrievingFingerprintsFromTheLocalFile");
        String fm = MessageFormat.format(str, obj);
        this.setProgressMsg(fm, 4);
        File file = new File(sourceFileName);
        if (!file.exists()) {
            str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.theLocalFileDoesnotExist");
            fm = MessageFormat.format(str, obj);
            return this.setErrorMsg(fm);
        }
        try {
            ArrayList<FingerprintListHashValues> toAppend = new ArrayList<FingerprintListHashValues>();
            toAppend.add(WhiteListHandler.readFingerprintListFromFile(sourceFileName));
            FingerprintListHelper.mergeFingerprintList((FingerprintListHashValues)this.listMaster, toAppend);
        }
        catch (FingerprintListException ex) {
            throw new FingerprintListException("Append fingerprint list failed: " + ex.getMessage());
        }
        return true;
    }

    protected boolean doAppendOther() throws FingerprintListException {
        if (this.isCancelled()) {
            return false;
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.importingFingerprintsFromTheDeleted"), 4);
        ArrayList<WhiteListObject> listImport = this.data.getWhiteList();
        if (listImport == null || listImport.isEmpty()) {
            return this.setErrorMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.thereIsNoSelectedFileFingerprint"));
        }
        ArrayList<FingerprintListHashValues> toAppendOther = new ArrayList<FingerprintListHashValues>();
        for (int i = 0; i < listImport.size(); ++i) {
            WhiteListObject whiteListObject = listImport.get(i);
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.processingImportedWhitelist");
            this.setProgressMsg(MessageFormat.format(msg, this.whitelist.getName()), -1);
            FingerprintListHashValues listDelta = new FingerprintListHashValues();
            if (!this.processImportedWhiteList(whiteListObject, listDelta)) {
                return false;
            }
            toAppendOther.add(listDelta);
        }
        try {
            FingerprintListHelper.mergeFingerprintList((FingerprintListHashValues)this.listMaster, toAppendOther);
        }
        catch (FingerprintListException ex) {
            throw new FingerprintListException("Appending other fingerprint lists failed: " + ex.getMessage());
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.doneWithProcessingImportedFileFingerprints"), -1);
        return true;
    }

    protected boolean doReplace() throws FingerprintListException {
        if (this.isCancelled()) {
            return false;
        }
        String sourceFileName = this.data.getFileName();
        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.retrievingFingerprintsFromTheLocalFile");
        this.setProgressMsg(MessageFormat.format(msg, sourceFileName), 4);
        File file = new File(sourceFileName);
        if (!file.exists()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.theLocalFileDoesnotExist");
            return this.setErrorMsg(MessageFormat.format(msg, sourceFileName));
        }
        try {
            this.listMaster = WhiteListHandler.readFingerprintListFromFile(sourceFileName);
        }
        catch (FingerprintListException ex) {
            throw new FingerprintListException("Replace fingerprint list failed: " + ex.getMessage());
        }
        return true;
    }

    protected boolean doRemove() throws FingerprintListException {
        if (this.isCancelled()) {
            return false;
        }
        String sourceFileName = this.data.getFileName();
        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.retrievingFingerprintsFromTheLocalFile");
        this.setProgressMsg(MessageFormat.format(msg, sourceFileName), 4);
        if (!new File(sourceFileName).exists()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.theLocalFileDoesnotExist");
            return this.setErrorMsg(MessageFormat.format(msg, sourceFileName));
        }
        List<FingerprintListHashValues> toRemove = List.of(WhiteListHandler.readFingerprintListFromFile(sourceFileName));
        FingerprintListHelper.removeFingerprintList((FingerprintListHashValues)this.listMaster, toRemove);
        if (this.listMaster.isEmpty()) {
            String errMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWorker.allFingerprintWereRemoved");
            this.setFinishMsg(errMsg);
            return false;
        }
        return true;
    }

    protected boolean cleanUp(String tempDir) throws ConsoleException {
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.removingTheTemporaryFolderAndFiles"), 9);
        this.removeOldPhysicalFile();
        if (!Utility.emptyDir((String)tempDir, (boolean)true)) {
            Object[] obj = new Object[]{tempDir};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.warningCannotDeleteTheTemporaryDirectory");
            String fm = MessageFormat.format(str, obj);
            this.setProgressMsg(fm, -1);
            this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.warningYouNeedToDeleteItByYourself"), -1);
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.done"), 10);
        this.finishMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.completedSuccessfully");
        return true;
    }

    private boolean saveChecksumFiles(String primaryFileName) {
        if (this.isCancelled()) {
            return false;
        }
        this.setCanCancel(false);
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.addingPrimaryFingerprintFile"), 7);
        if (!this.saveChecksumFile(primaryFileName, true)) {
            return false;
        }
        Object[] obj = new Object[]{this.whitelist.getName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.updatingTheFileFingerprint");
        String fm = MessageFormat.format(str, obj);
        this.setProgressMsg(fm, 8);
        if (!this.updateWhiteListToServer()) {
            return false;
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.updated"), -1);
        return true;
    }

    private boolean updateWhiteListToServer() {
        try {
            WhiteListHandler.updateWhiteList(this.whitelist);
            return true;
        }
        catch (ValidationException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return this.setErrorMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.internalObjectError"));
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            return this.setErrorMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.failedToUpdateTheFileFingerprint"));
        }
    }

    private void removeOldPhysicalFile() throws ConsoleException {
        block3: {
            if (this.fileOldMaster != null) {
                try {
                    WhiteListHandler.deletePhysicalFile(this.fileOldMaster);
                }
                catch (ConsoleException ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    if (!ex.needRelogin()) break block3;
                    throw ex;
                }
            }
        }
    }
}

