/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.WhiteListObject;
import com.sygate.scm.console.ui.policy.explorer.whitelist.EditWhiteListWorker;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardData;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardImportListPanel;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardImportLocalFilePanel;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardOptionsPanel;
import com.sygate.scm.console.ui.policy.util.FileFingerprintOperations;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.WizardBase;
import java.awt.Component;
import java.awt.Dimension;

public class EditWhiteListWizard
extends WizardBase {
    private static final long serialVersionUID = 1L;
    private static final int STAGE_COUNT = 4;
    private static final int WELCOME_STAGE = 0;
    private static final int OPTION_STAGE = 1;
    private static final int LOCAL_STAGE = 2;
    private static final int COMPLETE_STAGE = 3;
    private static final int LIST_STAGE = 4;
    private static final String PAGE_NAME = "editwhitelistwizard";
    private static final String AUTOMATION_ID_WELCOME_PANEL = "WelcomePanel";
    private static final String AUTOMATION_ID_OPTIONS_PANEL = "OptionsPanel";
    private static final String AUTOMATION_ID_LOCAL_PANEL = "LocalPanel";
    private static final String AUTOMATION_ID_LIST_PANEL = "ListPanel";
    private static final String AUTOMATION_ID_COMPLETE_PANEL = "CompletePanel";
    private static final String AUTOMATION_ID_NEXT_BUTTON = "Next";
    private static final String AUTOMATION_ID_BACK_BUTTON = "Back";
    private static final String AUTOMATION_ID_OK_BUTTON = "Ok";
    private static final String AUTOMATION_ID_CANCEL_BUTTON = "Cancel";
    private static final String TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWizard.title.editFileFingerprint");
    private static final String WELCOME_HEADING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWizard.heading.editFileFingerprintListWelcome");
    private static final String COMPLETE_HEADING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWizard.heading.editFileFingerprintListComplete");
    private static final String WELCOME_INSTRUCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWizard.editAFileFingerprintList");
    private static final String COMPLETE_INSTRUCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "EditWhiteListWorker.completedSuccessfully");
    private final WizardBase.WelcomeAndFinishPanel welcomePanel = new WizardBase.WelcomeAndFinishPanel(this, 0, WELCOME_HEADING, WELCOME_INSTRUCTION);
    private final WhiteListWizardImportLocalFilePanel localPanel = new WhiteListWizardImportLocalFilePanel(this.welcomePanel.getPreferredSize());
    private final WhiteListWizardOptionsPanel optionPanel = new WhiteListWizardOptionsPanel(false);
    private WhiteListWizardImportListPanel listPanel = new WhiteListWizardImportListPanel();
    private final WizardBase.WelcomeAndFinishPanel completePanel = new WizardBase.WelcomeAndFinishPanel(this, 1, COMPLETE_HEADING, COMPLETE_INSTRUCTION);
    private WhiteListWizardData data = new WhiteListWizardData();
    private WhiteListObject whitelist;

    public EditWhiteListWizard(WhiteListObject whitelist) {
        super(TITLE, true, WizardBase.HelpButtonState.OFF);
        this.whitelist = whitelist;
        this.data.setBaseWhiteList(whitelist);
        this.data.setAddMode(false);
        this.listPanel.setData(this.data);
        this.addStage(this.welcomePanel, 0);
        this.addStage(this.optionPanel, 1);
        this.addStage(this.localPanel, 2);
        this.addStage(this.listPanel, 4);
        this.addStage(this.completePanel, 3);
        Dimension size = this.welcomePanel.getPreferredSize();
        this.welcomePanel.setPreferredSize(new Dimension(size.width * 4 / 5, size.height));
        this.completePanel.setPreferredSize(new Dimension(size.width * 4 / 5, size.height));
        UIUtilities.setName(this.welcomePanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_WELCOME_PANEL);
        UIUtilities.setName(this.optionPanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_OPTIONS_PANEL);
        UIUtilities.setName(this.localPanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_LOCAL_PANEL);
        UIUtilities.setName(this.listPanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_LIST_PANEL);
        UIUtilities.setName(this.completePanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_COMPLETE_PANEL);
        UIUtilities.setName(this.jBNext, PAGE_NAME, UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_NEXT_BUTTON);
        UIUtilities.setName(this.jBBack, PAGE_NAME, UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_BACK_BUTTON);
        UIUtilities.setName(this.jBOk, PAGE_NAME, UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_OK_BUTTON);
        UIUtilities.setName(this.jBCancel, PAGE_NAME, UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_CANCEL_BUTTON);
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected boolean validatePanel(int stage) {
        if (stage == 2 || stage == 4) {
            boolean isValidate = false;
            if (this.getCurrentStageIndex() == 2) {
                isValidate = this.localPanel.validatePanel();
                if (isValidate) {
                    this.optionPanel.updateData(this.data);
                    this.localPanel.updateData(this.data);
                }
            } else {
                isValidate = this.listPanel.validatePanel();
                if (isValidate) {
                    this.optionPanel.updateData(this.data);
                    this.listPanel.updateData(this.data);
                }
            }
            if (isValidate) {
                EditWhiteListWorker worker = new EditWhiteListWorker(this.whitelist, this.data);
                worker.setParent(this);
                worker.begin();
                return worker.isAllDone();
            }
            return isValidate;
        }
        return true;
    }

    @Override
    protected int getPreviousStage(int stage) {
        if (stage == 4) {
            return 1;
        }
        return super.getPreviousStage(stage);
    }

    @Override
    protected void prepareNext(int stage) {
        if (stage == 2) {
            FileFingerprintOperations op = this.optionPanel.getFileFingerprintOperation();
            if (op == FileFingerprintOperations.APPENDING_OTHER) {
                this.setCurrentStageIndex(4);
            } else {
                this.setCurrentStageIndex(2);
            }
            this.updatePanel();
        }
        if (stage >= 4) {
            this.setCurrentStageIndex(3);
        }
    }

    @Override
    protected int getStageCount() {
        return 4;
    }

    @Override
    protected boolean disableBackButtonAtCompletePanel() {
        return true;
    }

    @Override
    protected boolean disableCancelButtonAtCompletePanel() {
        return true;
    }

    private void updatePanel() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportListPanel.combineFingerprintLists");
        String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportListPanel.selectFingerprintListsToCombine");
        if (this.optionPanel.getFileFingerprintOperation() == FileFingerprintOperations.APPENDING_OTHER) {
            title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportListPanel.appendFingerprintLists");
            content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportListPanel.youCanSelectTheFileFingerprintListToAppend");
        }
        this.listPanel.updateHeadPanel(title, content);
        title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.importFromLocal");
        content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardImportLocalFilePanel.youNeedToSpecifyThePath");
        boolean isRemoving = false;
        if (this.optionPanel.getFileFingerprintOperation() == FileFingerprintOperations.REMOVING) {
            title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.removeFileFingerprintsFromFileTitle");
            isRemoving = true;
        } else if (this.optionPanel.getFileFingerprintOperation() == FileFingerprintOperations.REPLACING) {
            title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "WhiteListWizardOptionsPanel.replaceFileFingerprintListTitle");
        }
        this.localPanel.updatePanel(title, content, isRemoving);
    }
}

