/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.WhiteListHandler;
import com.sygate.scm.console.logicobject.WhiteListObject;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardData;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWorker;
import com.sygate.scm.console.ui.policy.util.FileFingerprintOperations;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.systemlockdown.FingerprintListHashValues;
import com.sygate.scm.util.systemlockdown.exception.FingerprintListException;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;

public class AddWhiteListWorker
extends WhiteListWorker {
    private String tempDir;
    private String checkSumFilePath = null;

    public AddWhiteListWorker(WhiteListWizardData data) {
        super(data);
        this.whitelist = WhiteListObject.newInstance(data.getName(), data.getDescription());
        this.whitelist.getImage().setOptSource(ComputerImage.CONSOLE);
        this.dialogTitle = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.title.addFileFingerprintList");
        this.finishMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.errorHappened");
    }

    @Override
    protected boolean doWork() throws FingerprintListException {
        this.tempDir = this.generateTempDir(this.whitelist);
        if (this.tempDir == null || StringUtilities.isEmpty((String)this.tempDir)) {
            return this.setErrorMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.failedToGenerateATempDir"));
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.creatingATemporaryDirectory"), 1);
        if (!this.createOrEmptyDir(this.tempDir)) {
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.failedToCreateTheTempDir");
            return this.setErrorMsg(MessageFormat.format(str, this.tempDir));
        }
        if (this.data.getFileFingerprintOperation() == FileFingerprintOperations.CREATING && !this.doCreate() || this.data.getFileFingerprintOperation() == FileFingerprintOperations.COMBINING && !this.doCombine()) {
            return false;
        }
        if (StringUtilities.isEmpty((String)this.checkSumFilePath) || !this.saveMasterChecksumFileAndWhiteList(this.checkSumFilePath)) {
            this.checkSumFilePath = null;
            return false;
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.removingTheTemporaryFolderAndFiles"), 9);
        if (!Utility.emptyDir((String)this.tempDir, (boolean)true)) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.warningCannotDeleteTheTemporaryDirectory");
            this.setProgressMsg(MessageFormat.format(msg, this.tempDir), -1);
            this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.warningYouNeedToDeleteItByYourself"), -1);
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.done"), 10);
        this.finishMsg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.completedSuccessfully");
        return true;
    }

    private boolean doCreate() {
        String sourceFileName = this.data.getFileName();
        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.importingFromTheLocalFile");
        this.setProgressMsg(MessageFormat.format(msg, sourceFileName), 2);
        File file = new File(sourceFileName);
        if (!file.exists()) {
            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.theLocalFileDoesnotExist");
            return this.setErrorMsg(MessageFormat.format(msg, sourceFileName));
        }
        String checksumFileName = this.generateChecksumFile(file);
        if (StringUtilities.isEmpty((String)checksumFileName)) {
            return false;
        }
        this.checkSumFilePath = checksumFileName;
        return true;
    }

    private boolean doCombine() {
        if (this.isCancelled()) {
            return false;
        }
        ArrayList<WhiteListObject> listImport = this.data.getWhiteList();
        if (listImport == null || listImport.isEmpty()) {
            return this.setErrorMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.thereIsNoSelectedFileFingerprintToBeImported"));
        }
        FingerprintListHashValues list = new FingerprintListHashValues();
        for (WhiteListObject whiteListObject : listImport) {
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.processingImportedFileFingerprint");
            this.setProgressMsg(MessageFormat.format(str, whiteListObject.getName()), -1);
            if (this.processImportedWhiteList(whiteListObject, list)) continue;
            return false;
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.doneWithProcessingImportedFileFingerprint"), 6);
        String checksumFileName = this.tempDir + File.separator + "master.txt";
        this.generateChecksumFileFromList(checksumFileName, list);
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.doneWithProcessingImportedFileFingerprint"), 6);
        this.checkSumFilePath = checksumFileName;
        return true;
    }

    private boolean saveMasterChecksumFileAndWhiteList(String checksumFileName) {
        if (this.isCancelled()) {
            return false;
        }
        this.setCanCancel(false);
        if (!this.saveChecksumFile(checksumFileName, true)) {
            return false;
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.addingTheNewFileFingerprint"), 8);
        return this.addWhiteListToServer();
    }

    private boolean addWhiteListToServer() {
        try {
            WhiteListHandler.addWhiteList(this.whitelist);
            return true;
        }
        catch (ValidationException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return this.setErrorMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.internalObjectError"));
        }
        catch (Throwable ex) {
            this.handleServerBusyException(ex);
            return this.setErrorMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.failedToAddTheNewFileFingerprint"));
        }
    }

    private String generateChecksumFile(File sourceFile) {
        if (this.isCancelled()) {
            return null;
        }
        String sourceFileName = sourceFile.getAbsolutePath();
        String tempFileName = this.tempDir + File.separator + sourceFile.getName();
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.processingTheLocalFile"), 3);
        if (!WhiteListHandler.processFingerprintListFile(sourceFileName, tempFileName, this.whitelist)) {
            this.setErrorMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.failedToProcessTheLocalFile"));
            return null;
        }
        this.setProgressMsg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWorker.generatedAFingerprintFile"), 4);
        return tempFileName;
    }
}

