/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.whitelist;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.policy.explorer.whitelist.AddWhiteListWorker;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardData;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardEntryPanel;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardImportListPanel;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardImportLocalFilePanel;
import com.sygate.scm.console.ui.policy.explorer.whitelist.WhiteListWizardOptionsPanel;
import com.sygate.scm.console.ui.policy.util.FileFingerprintOperations;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.WizardBase;
import java.awt.Component;
import java.awt.Dimension;

public class AddWhiteListWizard
extends WizardBase {
    private static final long serialVersionUID = 1L;
    private static final int STAGE_COUNT = 5;
    private static final int WELCOME_STAGE = 0;
    private static final int ENTRY_STAGE = 1;
    private static final int OPTION_STAGE = 2;
    private static final int LOCAL_STAGE = 3;
    private static final int COMPLETE_STAGE = 4;
    private static final int LIST_STAGE = 5;
    private static final String PAGE_NAME = "addwhitelistwizard";
    private static final String AUTOMATION_ID_WELCOME_PANEL = "WelcomePanel";
    private static final String AUTOMATION_ID_ENTRY_PANEL = "EntryPanel";
    private static final String AUTOMATION_ID_OPTIONS_PANEL = "OptionsPanel";
    private static final String AUTOMATION_ID_LOCAL_PANEL = "LocalPanel";
    private static final String AUTOMATION_ID_LIST_PANEL = "ListPanel";
    private static final String AUTOMATION_ID_COMPLETE_PANEL = "CompletePanel";
    private static final String AUTOMATION_ID_NEXT_BUTTON = "Next";
    private static final String AUTOMATION_ID_BACK_BUTTON = "Back";
    private static final String AUTOMATION_ID_OK_BUTTON = "Ok";
    private static final String AUTOMATION_ID_CANCEL_BUTTON = "Cancel";
    private static final String TITLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWizard.title.addFileFingerprintList");
    private static final String WELCOME_HEADING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWizard.heading.addFileFingerprintListWelcome");
    private static final String COMPLETE_HEADING = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWizard.heading.addFileFingerprintListComplete");
    private static final String WELCOME_INSTRUCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWizard.addAFileFingerprintListToPolicyLibrary");
    private static final String COMPLETE_INSTRUCTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AddWhiteListWizard.addAFileFingerPrintList");
    private final WizardBase.WelcomeAndFinishPanel welcomePanel = new WizardBase.WelcomeAndFinishPanel(this, 0, WELCOME_HEADING, WELCOME_INSTRUCTION);
    private final WhiteListWizardEntryPanel entryPanel = new WhiteListWizardEntryPanel();
    private final WhiteListWizardOptionsPanel optionPanel = new WhiteListWizardOptionsPanel(true);
    private final WhiteListWizardImportLocalFilePanel localPanel = new WhiteListWizardImportLocalFilePanel(this.welcomePanel.getPreferredSize());
    private WhiteListWizardImportListPanel listPanel = new WhiteListWizardImportListPanel();
    private final WizardBase.WelcomeAndFinishPanel completePanel = new WizardBase.WelcomeAndFinishPanel(this, 1, COMPLETE_HEADING, COMPLETE_INSTRUCTION);
    private WhiteListWizardData data = new WhiteListWizardData();
    private AddWhiteListWorker worker;

    public AddWhiteListWizard() {
        super(TITLE, true, WizardBase.HelpButtonState.OFF);
        this.data.setBaseWhiteList(null);
        this.data.setAddMode(true);
        this.addStage(this.welcomePanel, 0);
        this.addStage(this.entryPanel, 1);
        this.addStage(this.optionPanel, 2);
        this.addStage(this.localPanel, 3);
        this.addStage(this.listPanel, 5);
        this.addStage(this.completePanel, 4);
        Dimension size = this.welcomePanel.getPreferredSize();
        this.welcomePanel.setPreferredSize(new Dimension(size.width * 4 / 5, size.height));
        this.completePanel.setPreferredSize(new Dimension(size.width * 4 / 5, size.height));
        this.localPanel.initialize(false);
        UIUtilities.setName(this.welcomePanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_WELCOME_PANEL);
        UIUtilities.setName(this.entryPanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_ENTRY_PANEL);
        UIUtilities.setName(this.optionPanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_OPTIONS_PANEL);
        UIUtilities.setName(this.localPanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_LOCAL_PANEL);
        UIUtilities.setName(this.listPanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_LIST_PANEL);
        UIUtilities.setName(this.completePanel, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_COMPLETE_PANEL);
        UIUtilities.setName(this.jBNext, PAGE_NAME, UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_NEXT_BUTTON);
        UIUtilities.setName(this.jBBack, PAGE_NAME, UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_BACK_BUTTON);
        UIUtilities.setName(this.jBOk, PAGE_NAME, UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_OK_BUTTON);
        UIUtilities.setName(this.jBCancel, PAGE_NAME, UIUtilities.ComponentType.BUTTON, AUTOMATION_ID_CANCEL_BUTTON);
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected boolean validatePanel(int stage) {
        if (stage == 1) {
            return this.entryPanel.validatePanel();
        }
        if (stage == 2) {
            this.listPanel.setData(this.data);
            this.addStage(this.listPanel, 5);
        } else if (stage == 3 || stage == 5) {
            boolean isValidate = this.getCurrentStageIndex() == 3 ? this.localPanel.validatePanel() : this.listPanel.validatePanel();
            if (isValidate) {
                this.entryPanel.updateData(this.data);
                this.optionPanel.updateData(this.data);
                if (this.getCurrentStageIndex() == 3) {
                    this.localPanel.updateData(this.data);
                } else {
                    this.listPanel.updateData(this.data);
                }
                this.worker = new AddWhiteListWorker(this.data);
                this.worker.setParent(this);
                this.worker.begin();
                boolean isDone = this.worker.isAllDone();
                return isDone;
            }
            return isValidate;
        }
        return true;
    }

    public AddWhiteListWorker getWorker() {
        return this.worker;
    }

    @Override
    protected int getPreviousStage(int stage) {
        if (stage == 5) {
            return 2;
        }
        return super.getPreviousStage(stage);
    }

    @Override
    protected void prepareNext(int stage) {
        System.out.println("Prepare Next : " + stage);
        if (stage == 3) {
            FileFingerprintOperations op = this.optionPanel.getFileFingerprintOperation();
            if (op == FileFingerprintOperations.CREATING) {
                this.setCurrentStageIndex(3);
            } else {
                this.setCurrentStageIndex(5);
            }
        }
        if (stage >= 5) {
            this.setCurrentStageIndex(4);
        }
    }

    @Override
    protected int getStageCount() {
        return 5;
    }

    @Override
    protected boolean disableBackButtonAtCompletePanel() {
        return true;
    }

    @Override
    protected boolean disableCancelButtonAtCompletePanel() {
        return true;
    }

    @Override
    protected void showStage(int stage) {
        switch (stage) {
            case 1: {
                this.entryPanel.setFocus();
                break;
            }
            case 3: {
                this.localPanel.setFocus();
                break;
            }
        }
        super.showStage(stage);
    }

    @Override
    protected String getDefaultContentSensitiveHelpToken() {
        return "sesm_policies_dialog_add_file_fingerprint";
    }
}

