/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.ste;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServiceTypeHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.explorer.common.NonAppliablePolicyPanelBase;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolContainerObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.HTMLUtilities;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ServiceTypePanel
extends NonAppliablePolicyPanelBase {
    private static final long serialVersionUID = 1L;
    private static final String[] TABLE_COLUMN_NAME = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServiceTypePanel.column.name"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServiceTypePanel.column.content")};
    private static final int[] TABLE_COLUMN_MAP = new int[]{0, 1};
    private static final float[] TABLE_COLUMN_WIDTHS = new float[]{0.3f, 0.7f};
    private static String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServiceTypePanel.html.titleDescripton");
    private static final String TITLE_DESCRIPTION = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HTML>  <HEAD>    <style type=\"text/css\">" + HTMLUtilities.getStyleSheet() + "    </style>  </HEAD>  <BODY>      <P class=\"headline\">    \t\t Network Services      </P>    <TABLE width=100% border='0' cellspacing='1' align='left' valign='top'>      <TR>\t       <TD>" + str + "</TD>      </TR>    </TABLE>  </BODY></HTML>";

    public ServiceTypePanel() {
        this.initialize();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_pane_policy_components";
    }

    @Override
    protected void refreshModel(SortableTableModel model) throws ConsoleException {
        model.setDataVector(new Vector<TableRow>(ServiceTypeHandler.getInstance().getServicesFromDB()));
        model.fireTableDataChanged();
    }

    @Override
    protected String getHTMLName() {
        return "servicetype_temp.htm";
    }

    @Override
    protected String getTitleAndDescription() {
        return TITLE_DESCRIPTION;
    }

    @Override
    protected String[] getTableColumnName() {
        return TABLE_COLUMN_NAME;
    }

    @Override
    protected int[] getTableColumnMapping() {
        return TABLE_COLUMN_MAP;
    }

    @Override
    protected float[] getTableColumnWidths() {
        return TABLE_COLUMN_WIDTHS;
    }

    @Override
    protected int getItemType() {
        return this.isActionEnabled() ? 131 : 62;
    }

    @Override
    protected boolean isActionEnabled() {
        int selIndex = this.jTTable.getSelectedRow();
        if (selIndex == -1) {
            return false;
        }
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        return !((ProtocolContainerObject)model.getRow(selIndex)).isSystemType();
    }

    @Override
    protected void doAdd() {
        ServiceTypeHandler.getInstance().addService(this.jTTable);
    }

    @Override
    protected void doEdit() {
        if (!this.isActionEnabled()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServiceTypePanel.cantEditNetworkService"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServiceTypePanel.editNetworkService"), -1);
            return;
        }
        ServiceTypeHandler.getInstance().editService(this.jTTable);
    }

    @Override
    protected void doDelete() {
        if (!this.isActionEnabled()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServiceTypePanel.cantDeleteNetworkService"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServiceTypePanel.deleteNetworkService"), -1);
            return;
        }
        ServiceTypeHandler.getInstance().deleteService(this.jTTable);
    }

    @Override
    protected String getPolicyTypeName() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServiceTypePanel.title");
    }

    @Override
    protected void retrieveTableSelection(TableRow selectedRow) {
        if (selectedRow == null) {
            return;
        }
        ProtocolContainerObject selService = (ProtocolContainerObject)selectedRow;
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            ProtocolContainerObject service = (ProtocolContainerObject)model.getRow(i);
            if (!selService.getServiceGroup().getId().equals(service.getServiceGroup().getId())) continue;
            this.jTTable.setRowSelectionInterval(i, i);
            break;
        }
    }
}

