/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.sle;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.logicobject.ServerListPool;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.dialog.ServerListEditorDlg;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyApplyHelper;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyUtil;
import com.sygate.scm.console.ui.policy.explorer.sle.ServerListPoolPane;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class ServerListHandler
extends BasePolicyHandler {
    private static ServerListHandler handler;

    private ServerListHandler() {
        this.policyPoolPane = new ServerListPoolPane();
    }

    public static synchronized ServerListHandler getInstance() {
        if (handler == null) {
            handler = new ServerListHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public void deletePolicy(JComponent source, PolicyObjectBase policy) {
        if (!this.isCorrectPolicyType(policy)) {
            return;
        }
        if (((ServerListObject)policy).isDefaultList()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServerListHandler.defaultPolicyManagerListCannotBeDeleted"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServerListHandler.deletePolicyManagerList__"), 1);
            return;
        }
        super.deletePolicy(source, policy);
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        return true;
    }

    @Override
    protected void updatePolicyObject(PolicyObjectBase policy, PolicyObjectBase newPolicy) {
        if (newPolicy != null) {
            ((ServerListObject)policy).setSemServerList((ServerListObject)newPolicy);
        }
    }

    protected boolean isAnyPolicyInUse(PolicyObjectBase policy) {
        return PolicyApplyHelper.isAnyServerListInUse(PolicyUtil.getLocTreeModel(), (ServerListObject)policy);
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return null;
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return null;
    }

    @Override
    protected PolicyObjectBase getNewPolicy(AppliablePolicyPool pool) throws ConsoleException {
        ServerListObject slObj = new ServerListObject();
        slObj.setOnlyHttps(true);
        slObj.setName(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServerListHandler.newPolicyManagerList"));
        List<String> nameList = pool.getAllName();
        String newName = PolicyHandler.adjustName(slObj.getName(), nameList, this.getPolicyNameLength());
        if (newName == null) {
            return null;
        }
        slObj.setName(newName);
        ServerListEditorDlg dlg = new ServerListEditorDlg();
        dlg.setObject(slObj, (ServerListPool)pool);
        dlg.setVisible(true);
        return dlg.isOk() ? slObj : null;
    }

    @Override
    protected PolicyObjectBase getEditPolicy(JComponent source, AppliablePolicyPool pool, PolicyObjectBase policy) throws ConsoleException {
        ServerListEditorDlg dlg = new ServerListEditorDlg(true);
        ServerListObject newPolicy = ((ServerListObject)policy).getClone();
        dlg.setObject(newPolicy, (ServerListPool)pool);
        dlg.setVisible(true);
        return dlg.isOk() ? newPolicy : null;
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(ServerListObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 255;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof ServerListObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServerListHandler.applyPolicyManagerList");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServerListHandler.replacePolicyManagerList");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServerListHandler.thisIsTheOnlyPolicyManagerList");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return "";
    }

    @Override
    protected String getDeletePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServerListHandler.deletePolicyManagerList_");
    }

    @Override
    protected String getDeletePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServerListHandler.deletePolicyManagerList");
    }

    @Override
    protected String getImportFailMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ServerListHandler.failedToImportThePolicyManagerList");
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof SemServerList) {
            return new ServerListObject((SemServerList)obj);
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        if (infoObj.isDefaultServerList()) {
            return new ServerListObject(GUIManager.getDefaultServerList(infoObj.getId()), true);
        }
        return new ServerListObject(DataobjectManager.getInstance().getSemServerList(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return ServerListPool.getServerListPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new ServerListPool(domain);
    }
}

