/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.override;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.PolicyOverride;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.override.OverridePolicyPoolPane;
import com.sygate.scm.console.ui.policy.override.OverridePolicyDialog;
import com.sygate.scm.console.ui.policy.override.logicobject.OverridePolicyObject;
import com.sygate.scm.console.ui.policy.override.logicobject.OverridePolicyPoolObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.Arrays;
import java.util.List;

public class OverridePolicyHandler
extends BasePolicyHandler {
    private static OverridePolicyHandler handler;

    private OverridePolicyHandler() {
        this.policyPoolPane = new OverridePolicyPoolPane();
    }

    public static synchronized OverridePolicyHandler getInstance() {
        if (handler == null) {
            handler = new OverridePolicyHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        return true;
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new OverridePolicyDialog(pool);
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new OverridePolicyDialog(pool, true);
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(OverridePolicyObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 255;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof OverridePolicyObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyOverrideHandler.applyPolicyOverride");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyOverrideHandler.replacePolicyOverride");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyOverrideHandler.thisIsTheOnlyPolicyOverrideIn");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyOverrideHandler.withdrawPolicyOverride");
    }

    @Override
    protected String getImportFailMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyOverrideHandler.failedToImportThePolicy");
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof PolicyOverride) {
            return new OverridePolicyObject((TopLevelObject)((PolicyOverride)obj));
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        return new OverridePolicyObject((TopLevelObject)DataobjectManager.getInstance().getPolicyOverride(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return OverridePolicyPoolObject.getPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new OverridePolicyPoolObject(domain);
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OverridePolicyPoolPane.title.policyOverrides");
    }
}

