/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.osp;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.ExportedPackage;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.osprotect.IOpAppProtTemplateRetriever;
import com.sygate.scm.common.osprotect.SEPMigrationBlockDetector;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppProtectionPolicyObject;
import com.sygate.scm.console.logicobject.AppProtectionPolicyPool;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.osp.ConsoleOpAppProtTemplateRetriever;
import com.sygate.scm.console.ui.policy.explorer.osp.OpAppProtectionPolicyPoolPane;
import com.sygate.scm.console.ui.policy.osprotect.dialog.OspPolicyDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.IOUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.template.TemplateManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.xml.sax.SAXException;

public class OpAppProtectionPolicyHandler
extends BasePolicyHandler {
    private static OpAppProtectionPolicyHandler handler;

    private OpAppProtectionPolicyHandler() {
        this.policyPoolPane = new OpAppProtectionPolicyPoolPane();
    }

    public static synchronized OpAppProtectionPolicyHandler getInstance() {
        if (null == handler) {
            handler = new OpAppProtectionPolicyHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    public AppProtectionPolicyObject importFile() throws ConsoleException {
        JFileChooser chooser = PolicyHandler.getExportFileChooser();
        chooser.setApproveButtonText(UIText.get(2048));
        chooser.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.handler.handler", "PolicyHandler.title.ImportRule"));
        chooser.updateUI();
        if (0 != chooser.showDialog(Manager.getFrame(), null)) {
            return null;
        }
        File file = chooser.getSelectedFile();
        return this.importFile(file);
    }

    private static boolean checkNeedSEPMigrationExclusions(Object[] objList) {
        try {
            ConsoleLogger.log("Start check SEP migration exclusions");
            if (objList == null || objList.length == 0) {
                return false;
            }
            OpAppProtectionPolicy appPolicy = (OpAppProtectionPolicy)objList[0];
            LinkedHashMap<String, TopLevelObject> objReferencePool = new LinkedHashMap<String, TopLevelObject>();
            PolicyHandler.extractTopLevelObject(objReferencePool, (ConfigObject)appPolicy, false);
            for (int i = 1; i < objList.length; ++i) {
                TopLevelObject obj = (TopLevelObject)objList[i];
                String id = obj.getId();
                if (!objReferencePool.containsKey(id)) continue;
                objReferencePool.put(id, obj);
            }
            ConsoleOpAppProtTemplateRetriever templateRetriever = new ConsoleOpAppProtTemplateRetriever(objReferencePool);
            GUID domainGUID = new GUID(DataobjectManager.getInstance().getLoginInformation().getOptDomainGUID());
            SEPMigrationBlockDetector blockDetector = new SEPMigrationBlockDetector(appPolicy, (IOpAppProtTemplateRetriever)templateRetriever, domainGUID);
            if (blockDetector.needExclusions() && 0 == JOptionPane.showConfirmDialog(Manager.getFrame(), new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.sepMigrationBlockerDetectedWarningMessage")), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.sepMigrationBlockerDetectedWarningTitle"), 0, 2)) {
                return true;
            }
        }
        catch (Exception e) {
            ConsoleLogger.log("Warning:  fail to check SEP migration during import policy. the exception is: " + e.getMessage());
        }
        return false;
    }

    public AppProtectionPolicyObject importFile(File file) throws ConsoleException {
        Object[] objList = this.readObjects(file);
        if (objList == null || objList.length == 0) {
            return null;
        }
        AppProtectionPolicyObject appProtObj = AppProtectionPolicyObject.importFile(objList, OpAppProtectionPolicyHandler.checkNeedSEPMigrationExclusions(objList));
        return appProtObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppProtectionPolicyObject importFile(String xmlFile) throws ConsoleException {
        BufferedInputStream is = new BufferedInputStream(TemplateManager.class.getResourceAsStream(xmlFile));
        Object[] objList = null;
        ExportedPackage exportedPackage = new ExportedPackage("sygate.spm.osp.policy", "1.0");
        Object[] obj = new Object[]{AjaxSwingUtil.getDisplayFileName(xmlFile)};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.cannotReadTheFile");
        String fm = MessageFormat.format(str, obj);
        try {
            SchemaContainer sc = exportedPackage.readXML((InputStream)is);
            objList = sc.getChildren().toArray();
        }
        catch (IOException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm);
        }
        catch (SAXException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm);
        }
        catch (ValidationException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm);
        }
        finally {
            IOUtilities.closeInputStream((InputStream)is);
        }
        if (objList == null) {
            return null;
        }
        AppProtectionPolicyObject appProtObj = AppProtectionPolicyObject.importFile(objList, false);
        return appProtObj;
    }

    @Override
    public void exportPolicy(JComponent source, PolicyObjectBase policy) {
        ExportedPackage exportedPackage = new ExportedPackage("sygate.spm.osp.policy", "1.0");
        PolicyHandler.exportPolicy((ConfigObject)policy.getSchemaObj(), policy.getName(), exportedPackage);
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        boolean isLicensed = LicenseObject.getInstance().isOSPretectionPolicy();
        if (!justCheckLicense && !isLicensed) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.theOSProtectionPolicyFeatureIsNotLicensed"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.notLicensed"), 0);
        }
        return isLicensed;
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        String title = this.hasLicense(true) ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.title.osProtectionPolicies") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.title.osprotectionPoliciesNotLicensed");
        return title;
    }

    @Override
    protected PolicyObjectBase importPolicy(File file) {
        try {
            if (file != null) {
                return this.importFile(file);
            }
            return this.importFile();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    @Override
    protected PolicyObjectBase importPolicy() {
        try {
            return this.importFile();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new OspPolicyDialog(pool);
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new OspPolicyDialog(pool, true);
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(AppProtectionPolicyObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 255;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof AppProtectionPolicyObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.applyOSProtectionPolicy");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.replaceOSProtectionPolicy");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.thisIsTheOnlyOSProtectionPolicy");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.withdrawOSProtectionPolicy");
    }

    @Override
    protected String getImportFailMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "OpAppProtectionPolicyHandler.failedToImportThePolicy");
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof OpAppProtectionPolicy) {
            return new AppProtectionPolicyObject((TopLevelObject)((OpAppProtectionPolicy)obj));
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        return new AppProtectionPolicyObject((TopLevelObject)DataobjectManager.getInstance().getOpAppProtectionPolicy(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return AppProtectionPolicyPool.getOpAppProtectionPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new AppProtectionPolicyPool(domain);
    }

    /*
     * Exception decompiling
     */
    private Object[] readObjects(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

