/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.ntr;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.NtrPolicy;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.NtrPolicyObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.ntr.NtrPolicyPoolPane;
import com.sygate.scm.console.ui.policy.ntr.NtrPolicyDialog;
import com.sygate.scm.console.ui.policy.ntr.logicobject.NtrPolicyPoolObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.Arrays;
import java.util.List;

public class NtrPolicyHandler
extends BasePolicyHandler {
    private static final MessageResourcesFile MSG_EXPLORER = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");
    private static NtrPolicyHandler handler;

    private NtrPolicyHandler() {
        this.policyPoolPane = new NtrPolicyPoolPane();
    }

    public static synchronized NtrPolicyHandler getInstance() {
        if (handler == null) {
            handler = new NtrPolicyHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        return true;
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new NtrPolicyDialog(pool);
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new NtrPolicyDialog(pool, true);
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(NtrPolicyObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 512;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof NtrPolicyObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MSG_EXPLORER.getString("NtrPolicyHandler.applyNtrPolicy");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MSG_EXPLORER.getString("NtrPolicyHandler.replaceNtrPolicy");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MSG_EXPLORER.getString("NtrPolicyHandler.thisIsTheOnlyNtrPolicyIn");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MSG_EXPLORER.getString("NtrPolicyHandler.withdrawNtrPolicy");
    }

    @Override
    protected String getImportFailMessage() {
        return MSG_EXPLORER.getString("NtrPolicyHandler.failedToImportThePolicy");
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        return MSG_EXPLORER.getString("NtrPolicyPoolPane.title.ntrPolicies");
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof NtrPolicy) {
            return new NtrPolicyObject((TopLevelObject)((NtrPolicy)obj));
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        return new NtrPolicyObject((TopLevelObject)DataobjectManager.getInstance().getNtrPolicy(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return NtrPolicyPoolObject.getPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new NtrPolicyPoolObject(domain);
    }
}

