/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.mem;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.MemPolicy;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.mem.MemPolicyPoolPane;
import com.sygate.scm.console.ui.policy.mem.MemPolicyDialog;
import com.sygate.scm.console.ui.policy.mem.logicobject.MemPolicyPoolObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.Arrays;
import java.util.List;

public class MemPolicyHandler
extends BasePolicyHandler {
    private static final MessageResourcesFile MSG_EXPLORER = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");
    private static MemPolicyHandler handler;

    private MemPolicyHandler() {
        this.policyPoolPane = new MemPolicyPoolPane();
    }

    public static synchronized MemPolicyHandler getInstance() {
        if (handler == null) {
            handler = new MemPolicyHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        return true;
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new MemPolicyDialog(pool);
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new MemPolicyDialog(pool, true);
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(MemPolicyObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 512;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof MemPolicyObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MSG_EXPLORER.getString("MemPolicyHandler.applyMemPolicy");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MSG_EXPLORER.getString("MemPolicyHandler.replaceMemPolicy");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MSG_EXPLORER.getString("MemPolicyHandler.thisIsTheOnlyMemPolicyIn");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MSG_EXPLORER.getString("MemPolicyHandler.withdrawMemPolicy");
    }

    @Override
    protected String getImportFailMessage() {
        return MSG_EXPLORER.getString("MemPolicyHandler.failedToImportThePolicy");
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        return MSG_EXPLORER.getString("MemPolicyPoolPane.title.memPolicies");
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof MemPolicy) {
            return new MemPolicyObject((TopLevelObject)((MemPolicy)obj));
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        return new MemPolicyObject((TopLevelObject)DataobjectManager.getInstance().getMemPolicy(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return MemPolicyPoolObject.getPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new MemPolicyPoolObject(domain);
    }
}

