/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.lu;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.GupRuleSets;
import com.sygate.scm.common.configobject.schema.LinuxLuPolicy;
import com.sygate.scm.common.configobject.schema.LuContentSourceInfo;
import com.sygate.scm.common.configobject.schema.LuPolicy;
import com.sygate.scm.common.configobject.schema.MacLuPolicy;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.LUPolicyUtils;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.LiveUpdatePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyPanel;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.lu.LiveUpdatePoolPane;
import com.sygate.scm.console.ui.policy.lu.LuPolicyDialog;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.Arrays;
import java.util.List;

public class LuPolicyHandler
extends BasePolicyHandler {
    private static LuPolicyHandler handler;

    private LuPolicyHandler() {
        this.policyPoolPane = new LiveUpdatePoolPane();
    }

    public static synchronized LuPolicyHandler getInstance() {
        if (null == handler) {
            handler = new LuPolicyHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        return true;
    }

    public PolicyPoolPane getPolicyPoolPane(TreeItem treeItem, PolicyPanel policyPanel) {
        ((LiveUpdatePoolPane)this.policyPoolPane).setPolicyPanel(policyPanel);
        this.policyPoolPane.updateObject();
        this.updatePolicyPoolPaneTitle(treeItem.getName());
        return this.policyPoolPane;
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        String title = this.hasLicense(true) ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuPolicyHandler.title.liveUpdatePolicies") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuPolicyHandler.title.liveUpdatePoliciesNotLicensed");
        return title;
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new LuPolicyDialog(pool);
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new LuPolicyDialog(pool, true);
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(LiveUpdateObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 255;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof LiveUpdateObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuPolicyHandler.applyLiveUpdatePolicy");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuPolicyHandler.replaceLiveUpdatePolicy");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuPolicyHandler.thisIsTheOnlyLiveUpdatePolicyIn");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuPolicyHandler.withdrawLiveUpdatePolicy");
    }

    @Override
    protected String getImportFailMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuPolicyHandler.failedToImportThePolicy");
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof LuPolicy) {
            return new LiveUpdateObject((TopLevelObject)((LuPolicy)obj));
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        return new LiveUpdateObject((TopLevelObject)DataobjectManager.getInstance().getLuPolicy(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return LiveUpdatePolicyPool.getLiveUpatePolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new LiveUpdatePolicyPool(domain);
    }

    @Override
    protected void handleCustomImportConfiguration(ConfigObject policy) {
        if (policy != null && policy instanceof LuPolicy) {
            LuPolicy defLuPolicy;
            LinuxLuPolicy linuxLuPolicy;
            LuPolicy defLuPolicy2;
            LuPolicy luPolicy = (LuPolicy)policy;
            MacLuPolicy macLuPolicy = luPolicy.getOptMacLuPolicy();
            if (macLuPolicy == null && (defLuPolicy2 = LUPolicyUtils.retrieveDefaultLuPolicy()) != null) {
                macLuPolicy = defLuPolicy2.getOptMacLuPolicy();
                luPolicy.setOptMacLuPolicy(macLuPolicy);
                LUPolicyUtils.copyLUSettingsFromWindowsToMacSection((LuPolicy)luPolicy, (MacLuPolicy)macLuPolicy);
            }
            if ((linuxLuPolicy = luPolicy.getOptLinuxLuPolicy()) == null && (defLuPolicy = LUPolicyUtils.retrieveDefaultLuPolicy()) != null) {
                linuxLuPolicy = defLuPolicy.getOptLinuxLuPolicy();
                luPolicy.setOptLinuxLuPolicy(linuxLuPolicy);
            }
            this.updateGUPSettings(luPolicy);
        } else if (policy == null) {
            System.out.println("handleCustomImportConfiguration: LU Content policy null ");
        } else {
            System.out.println("handleCustomImportConfiguration: LU Content policy incorrect: " + policy.getClass().getName());
        }
    }

    private void updateGUPSettings(LuPolicy luPolicy) {
        boolean isValuePresent;
        LuContentSourceInfo info = luPolicy.getOptLuContentSourceInfo();
        Boolean gupEnabled = info.getOptUseMasterClient();
        if (gupEnabled == null) {
            gupEnabled = info.getDefUseMasterClient();
        }
        if (!gupEnabled.booleanValue()) {
            return;
        }
        Boolean staticGupSelected = info.getOptStaticGupSelected();
        boolean bl = isValuePresent = info.getOptMasterClientHost() != null && !info.getOptMasterClientHost().trim().equals("");
        if (!isValuePresent) {
            info.setOptStaticGupSelected(Boolean.valueOf(false));
        } else if (staticGupSelected == null) {
            info.setOptStaticGupSelected(Boolean.valueOf(true));
        }
        Boolean dynamicGupSelected = info.getOptDynamicGupSelected();
        if (dynamicGupSelected == null) {
            GupRuleSets ruleSets = info.getOptGupRuleSets();
            if (ruleSets != null && ruleSets.getGupRuleSetCount() > 0) {
                info.setOptDynamicGupSelected(Boolean.valueOf(true));
            } else {
                info.setOptDynamicGupSelected(Boolean.valueOf(false));
            }
        }
    }
}

