/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.lu;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.LuAppliedContent;
import com.sygate.scm.common.configobject.schema.LuContentPolicy;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.LUPolicyUtils;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyApplyHelper;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyUtil;
import com.sygate.scm.console.ui.policy.explorer.common.dlg.PolicyApplyDialog;
import com.sygate.scm.console.ui.policy.explorer.lu.LiveUpdatePoolPane;
import com.sygate.scm.console.ui.policy.lu.LuContentPolicyDialog;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentPolicyPool;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.Arrays;
import java.util.List;

public class LuContentPolicyHandler
extends BasePolicyHandler {
    private static LuContentPolicyHandler handler;

    private LuContentPolicyHandler() {
        this.policyPoolPane = new LiveUpdatePoolPane();
    }

    public static synchronized LuContentPolicyHandler getInstance() {
        if (null == handler) {
            handler = new LuContentPolicyHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        return true;
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        String title = this.hasLicense(true) ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuContentPolicyHandler.title.liveUpdatePolicies") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuContentPolicyHandler.title.liveUpdatePoliciesNotLicensed");
        return title;
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new LuContentPolicyDialog(pool);
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new LuContentPolicyDialog(pool, true);
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(LiveUpdateContentObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 255;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof LiveUpdateContentObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuContentPolicyHandler.applyLiveUpdatePolicy");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuContentPolicyHandler.replaceLiveUpdatePolicy");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuContentPolicyHandler.thisIsTheOnlyLiveUpdatePolicyIn");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuContentPolicyHandler.withdrawLiveUpdatePolicy");
    }

    @Override
    protected String getImportFailMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LuContentPolicyHandler.failedToImportThePolicy");
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof LuContentPolicy) {
            return new LiveUpdateContentObject((TopLevelObject)((LuContentPolicy)obj));
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        return new LiveUpdateContentObject((TopLevelObject)DataobjectManager.getInstance().getLuContentPolicy(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return LiveUpdateContentPolicyPool.getPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new LiveUpdateContentPolicyPool(domain);
    }

    @Override
    protected PolicyApplyDialog createPolicyApplyDialog(String title, String type, PolicyObjectBase policy) {
        return new PolicyApplyDialog(title, type, (TreeItem)policy, true);
    }

    @Override
    protected PolicyApplyDialog createPolicyReplaceDialog(String title, String type, PolicyObjectBase policy, ObjInfoObject[] objArr) {
        return new PolicyApplyDialog(title, type, policy, true, objArr);
    }

    protected boolean isAnyPolicyInUse(PolicyObjectBase policy) {
        return PolicyApplyHelper.isAnyLuContentPolicyInUse(PolicyUtil.getLocTreeModel(), policy);
    }

    @Override
    public void handleCustomImportConfiguration(ConfigObject policy) {
        if (policy != null && policy instanceof LuContentPolicy) {
            LuAppliedContent macDefAppCntTemplate;
            LuContentPolicy defLuCntPolicy;
            LuContentPolicy luCntPolicy = (LuContentPolicy)policy;
            LuAppliedContent macAppCntInDB = LUPolicyUtils.retrieveClonedMacDefsContent((LuContentPolicy)luCntPolicy, (String)"MAC_AV_DEFS");
            if (macAppCntInDB == null) {
                defLuCntPolicy = LUPolicyUtils.retrieveDefaultLuContentPolicy();
                LuAppliedContent macDefAppCnt = LUPolicyUtils.retrieveClonedMacDefsContent((LuContentPolicy)defLuCntPolicy, (String)"MAC_AV_DEFS");
                LuAppliedContent defAppCnt = LUPolicyUtils.retrieveDefsContent((LuContentPolicy)luCntPolicy, (String)"AV_DEFS");
                if (macDefAppCnt != null) {
                    if (defAppCnt != null) {
                        macDefAppCnt.setOptEnabled(defAppCnt.getOptEnabled());
                    }
                    luCntPolicy.addLuAppliedContent(macDefAppCnt);
                }
            }
            if ((macAppCntInDB = LUPolicyUtils.retrieveDefsContent((LuContentPolicy)luCntPolicy, (String)"MAC_IPS")) == null && (macDefAppCntTemplate = LUPolicyUtils.retrieveClonedMacDefsContent((LuContentPolicy)(defLuCntPolicy = LUPolicyUtils.retrieveDefaultLuContentPolicy()), (String)"MAC_IPS")) != null) {
                luCntPolicy.addLuAppliedContent(macDefAppCntTemplate);
            }
        } else if (policy == null) {
            System.out.println("handleCustomImportConfiguration: LU Content policy null ");
        } else {
            System.out.println("handleCustomImportConfiguration: LU Content policy incorrect: " + policy.getClass().getName());
        }
    }
}

