/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.lu;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LiveUpdatePolicyPool;
import com.sygate.scm.console.ui.policy.PolicyPanel;
import com.sygate.scm.console.ui.policy.common.AppliablePolicy;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyPoolPane;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentObject;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateContentPolicyPool;
import com.sygate.scm.console.ui.policy.lu.logiobject.LiveUpdateObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LiveUpdatePoolPane
extends PolicyPoolPane {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSG_RES = MessageResources.getInstance();
    private static final String EXPLORER = "com.sygate.scm.console.ui.policy.explorer.explorer";
    private static final String[] LU_CONTENT_TABLE_COLUMN_NAME = new String[]{MSG_RES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyPoolPane.column.name"), MSG_RES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyPoolPane.column.description"), MSG_RES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LiveUpdatePoolPane.column.usingPolicy")};
    private JTabbedPane jTBPolicy;
    private JTable jTLuPolicy;
    private JTable jTLuContent;
    private PolicyPanel policyPanel;

    public LiveUpdatePoolPane() {
        this.title = MSG_RES.getString(EXPLORER, "LiveUpdatePoolPane.title.luPolicies");
        this.initialize();
    }

    public void setPolicyPanel(PolicyPanel policyPanel) {
        this.policyPanel = policyPanel;
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
        this.addTableSelectionListener(this.jTLuPolicy, listener);
        this.addTableSelectionListener(this.jTLuContent, listener);
    }

    @Override
    public int getTableSelectedItem() {
        if (this.isLuPolicySelected()) {
            return super.getTableSelectedItem();
        }
        if (this.getPolicyTable().getSelectedRow() == -1) {
            return 149;
        }
        return this.getPolicyItemType();
    }

    protected String getTitleIconName() {
        return "lu_policy.png";
    }

    @Override
    protected List<String> getAllIdFromPool() throws ConsoleException {
        return this.isLuPolicySelected() ? LiveUpdatePolicyPool.getLiveUpatePolicyPool().getAllId() : LiveUpdateContentPolicyPool.getPolicyPool().getAllId();
    }

    @Override
    protected boolean needHandleMessage(AppliablePolicy msgObj) {
        return this.isLuPolicySelected() ? msgObj instanceof LiveUpdateObject : msgObj instanceof LiveUpdateContentObject;
    }

    @Override
    protected String getPolicyId(Object policyObj) {
        return this.isLuPolicySelected() ? ((LiveUpdateObject)policyObj).getId() : ((LiveUpdateContentObject)policyObj).getId();
    }

    @Override
    protected int getPolicyItemType() {
        return this.isLuPolicySelected() ? 144 : 148;
    }

    @Override
    protected int getQuarantinePolicyItemType() {
        return this.isLuPolicySelected() ? 155 : 148;
    }

    @Override
    protected JComponent getTablePanel() {
        this.jTLuPolicy = this.createLuPolicyTable();
        this.jTLuContent = this.createLuContentTable();
        LicenseObject licenseObj = LicenseObject.getInstance();
        if (!licenseObj.isSNACOnlyProduct() && !licenseObj.isSBProduct()) {
            this.jTBPolicy = new JTabbedPane();
            this.jTBPolicy.addTab(MSG_RES.getString(EXPLORER, "LiveUpdatePoolPane.tab.luPolicy"), this.getTablePanel(this.jTLuPolicy));
            this.jTBPolicy.addTab(MSG_RES.getString(EXPLORER, "LiveUpdatePoolPane.tab.luContent"), this.getTablePanel(this.jTLuContent));
            this.jTBPolicy.setOpaque(false);
            AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> this.jTBPolicy.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.jTBPolicy.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    LiveUpdatePoolPane.this.updateObject();
                    if (LiveUpdatePoolPane.this.policyPanel != null) {
                        LiveUpdatePoolPane.this.policyPanel.valueChanged(new ListSelectionEvent(new Object(), 0, 0, true));
                    }
                }
            });
            return this.jTBPolicy;
        }
        JPanel luPolicyPane = new JPanel();
        luPolicyPane.setLayout(new BorderLayout());
        luPolicyPane.add((Component)this.getTablePanel(this.jTLuPolicy), "Center");
        luPolicyPane.setOpaque(false);
        return luPolicyPane;
    }

    @Override
    protected JTable getPolicyTable() {
        return this.isLuPolicySelected() ? this.jTLuPolicy : this.jTLuContent;
    }

    private JTable createLuPolicyTable() {
        try {
            return this.createPolicyTable(super.getTableColumnNames(), LiveUpdatePolicyPool.getLiveUpatePolicyPool().getInfoObjectList());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    private JTable createLuContentTable() {
        try {
            return this.createPolicyTable(LU_CONTENT_TABLE_COLUMN_NAME, LiveUpdateContentPolicyPool.getPolicyPool().getInfoObjectList());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    private boolean isLuPolicySelected() {
        if (null == this.jTBPolicy) {
            return true;
        }
        return this.jTBPolicy.getSelectedIndex() == 0;
    }

    private void addTableSelectionListener(JTable table, ListSelectionListener listener) {
        DefaultListSelectionModel selModel = (DefaultListSelectionModel)table.getSelectionModel();
        ListSelectionListener[] listeners = selModel.getListSelectionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (listener != listeners[i]) continue;
            return;
        }
        selModel.addListSelectionListener(listener);
    }
}

