/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.ids;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ExceptionEvent;
import com.sygate.scm.common.configobject.schema.ExceptionList;
import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.ids.IDSLibsPoolPane;
import com.sygate.scm.console.ui.policy.explorer.ids.IDSPolicyHandlerHelper;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsPolicyDialog;
import com.sygate.scm.console.ui.policy.ids.handler.IdsCategoryHelper;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyPoolObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.IdsUtility;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class IdsPolicyHandler
extends BasePolicyHandler {
    private static final MessageResourcesFile MSG_EXPLORER = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");
    private static IdsPolicyHandler handler;

    private IdsPolicyHandler() {
        this.policyPoolPane = new IDSLibsPoolPane();
    }

    public static synchronized IdsPolicyHandler getInstance() {
        if (handler == null) {
            handler = new IdsPolicyHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof IdsPolicy) {
            return new IdsPolicyObject((IdsPolicy)obj);
        }
        return null;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MSG_EXPLORER.getString("IDSLibraryHandler.applyIPSLibrary");
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return null;
    }

    @Override
    public void addPolicy(AppliablePolicyPool pool, JComponent source) {
        PolicyObjectBase policyObj;
        block4: {
            if (this.hasReadOnlyPermission()) {
                return;
            }
            if (!this.hasLicense(false)) {
                return;
            }
            policyObj = null;
            try {
                policyObj = this.getPolicyObject(pool);
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_EXPLORER.getString("BasePolicyHandler.error"), 0);
                if (!ex.needRelogin()) break block4;
                Manager.getFrame().showLoginPanel();
            }
        }
        this.addPolicy(source, policyObj);
    }

    private PolicyObjectBase getPolicyObject(AppliablePolicyPool pool) throws ConsoleException {
        IdsPolicyDialog dlg = new IdsPolicyDialog(pool);
        IdsPolicyObject fwObj = new IdsPolicyObject();
        dlg.setNewPolicy(true);
        List<String> nameList = pool.getAllName();
        String newName = PolicyHandler.adjustName(fwObj.getName(), nameList, this.getPolicyNameLength());
        if (newName == null) {
            return null;
        }
        fwObj.setName(newName);
        dlg.setObject(fwObj);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            this.checkApplied = true;
        }
        return dlg.isOk() ? fwObj : null;
    }

    @Override
    protected PolicyObjectBase getEditPolicy(JComponent source, AppliablePolicyPool pool, PolicyObjectBase policy) throws ConsoleException {
        IdsPolicyObject newPolicy = ((IdsPolicyObject)policy).getClone();
        IdsPolicyDialog dlg = new IdsPolicyDialog(pool, true);
        dlg.setObject(newPolicy);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            if (!dlg.isReadOnly()) {
                this.checkAppliedPolicyEnableStatus(newPolicy, true, false, MSG_EXPLORER.getString("BasePolicyHandler.policyDisabledAssignedQuestion"));
            }
            return newPolicy;
        }
        return null;
    }

    @Override
    protected void handleCustomImportConfiguration(ConfigObject policyObj) {
        if (policyObj != null && policyObj instanceof IdsPolicy) {
            ArrayList<String> removedEvents = new ArrayList<String>();
            removedEvents.addAll(this.handleBrowserProtectionExceptions((IdsPolicy)policyObj));
            if (removedEvents.size() > 0) {
                Collections.sort(removedEvents);
                String eventIds = StringUtilities.getCSV(removedEvents, (int)10);
                MessageResources msgRes = MessageResources.getInstance();
                String msg = MessageFormat.format(msgRes.getString("com.sygate.scm.console.handler.handler", "IDSPolicyHandler.IPSExceptionsModified"), eventIds);
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, msgRes.getString("com.sygate.scm.console.handler.handler", "PolicyHandler.title.ImportPolicy"), 2);
            }
        }
    }

    private Set<String> handleBrowserProtectionExceptions(IdsPolicy idsPolicy) {
        HashSet<String> removedEvents = new HashSet<String>();
        if (idsPolicy != null && idsPolicy.getOptExceptionList() != null) {
            ExceptionList exceptionList = idsPolicy.getOptExceptionList();
            Vector allExceptions = exceptionList.getExceptionEvent();
            for (ExceptionEvent event : allExceptions) {
                if (!IdsCategoryHelper.isBrowserProtectionSigInvalidAction(event)) continue;
                exceptionList.removeExceptionEvent(event);
                removedEvents.add(event.getEventId());
            }
        }
        return removedEvents;
    }

    @Override
    protected String getImportFailMessage() {
        return "";
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return null;
    }

    @Override
    protected int getPolicyNameLength() {
        return 255;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        String id = infoObj.getId();
        String type = infoObj.getTargetType();
        FwIdsLibrary idsLib = (FwIdsLibrary)DataobjectManager.getInstance().getObjectByGUID(type, id);
        return new IdsPolicyObject((TopLevelObject)idsLib);
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(IdsPolicyObject.class);
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return IdsPolicyPoolObject.getIdsPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new IdsPolicyPoolObject(domain);
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MSG_EXPLORER.getString("IDSLibraryHandler.thisIsTheOnlyIPSPolicyIn");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MSG_EXPLORER.getString("IDSLibraryHandler.replaceIPSLibrary");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MSG_EXPLORER.getString("IDSLibraryHandler.withdrawIPSLibrary");
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        boolean isLicensed = LicenseObject.getInstance().isIntrusionPreventionEnabled();
        if (!justCheckLicense && !isLicensed) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_EXPLORER.getString("IDSLibraryHandler.theIntrusionPreventionLibraryFeatureIsNotLicensed"), MSG_EXPLORER.getString("IDSLibraryHandler.notLicensed"), 0);
        }
        return isLicensed;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof IdsPolicyObject;
    }

    @Override
    public FileFilter getImportExportFileFilter(final boolean isImport) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = Utility.getFileExtension((File)f);
                if (isImport) {
                    return extension != null && (extension.equals("daz") || extension.equals("dat"));
                }
                return extension != null && extension.equals("dat");
            }

            @Override
            public String getDescription() {
                String des = "";
                des = isImport ? MSG_EXPLORER.getString("IDSLibraryHandler.IPSFileDatDaz") : MSG_EXPLORER.getString("IDSLibraryHandler.IPSFileDat");
                return des;
            }
        };
    }

    @Override
    protected PolicyObjectBase importPolicy() {
        PolicyObjectBase policy = super.importPolicy();
        if (null != policy) {
            IdsUtility.filterUnregulatedHosts((IdsPolicy)((IdsPolicy)policy.getSchemaObj()));
        }
        return policy;
    }

    @Override
    public void exportPolicy(JComponent source, PolicyObjectBase policy) {
        IDSPolicyHandlerHelper.exportPolicy(policy, this);
    }
}

