/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.ids;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.IOUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class IDSPolicyHandlerHelper {
    private static final MessageResourcesFile MSG_EXPLORER = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");
    private static final MessageResourcesFile MSG_HANDLER = new MessageResourcesFile("com.sygate.scm.console.handler.handler");

    public static void exportPolicy(PolicyObjectBase policy, BasePolicyHandler handler) {
        TopLevelObject schemaObj = policy.getSchemaObj();
        Hashtable<String, BufferedInputStream> physicalFileList = null;
        JFileChooser chooser = new JFileChooser();
        chooser.resetChoosableFileFilters();
        chooser.addChoosableFileFilter(handler.getImportExportFileFilter(false));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setApproveButtonText(UIText.get(1030));
        chooser.setDialogTitle(MSG_HANDLER.getString("PolicyHandler.title.ExportPolicy"));
        chooser.setSelectedFile(new File(policy.getName() + ".dat"));
        if (0 == chooser.showSaveDialog(Manager.getFrame())) {
            String errMsg = null;
            try {
                File exportFile = chooser.getSelectedFile();
                boolean exportFileHasPostfix = false;
                Object exportFileName = exportFile.getName().toLowerCase();
                exportFileHasPostfix = ((String)exportFileName).endsWith(".dat");
                if (!exportFileHasPostfix) {
                    exportFileName = (String)exportFileName + ".dat";
                }
                if (((String)exportFileName).length() > 255) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MSG_EXPLORER.getString("IDSLibraryHandler.ExportFileNameTooLong"), ((String)exportFileName).length()), MSG_EXPLORER.getString("IDSLibraryHandler.exportPolicy"), 0);
                    return;
                }
                int length = exportFile.getCanonicalPath().length();
                if (!exportFileHasPostfix) {
                    length += ".dat".length();
                }
                if (length > 255) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageFormat.format(MSG_EXPLORER.getString("IDSLibraryHandler.ExportFilePathTooLong"), length), MSG_EXPLORER.getString("IDSLibraryHandler.exportPolicy"), 0);
                    return;
                }
                if (exportFile.exists() && !AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    Object[] obj = new Object[]{exportFile.getPath()};
                    String str = MSG_EXPLORER.getString("IDSLibraryHandler.alreadyExists");
                    String fm = MessageFormat.format(str, obj);
                    int option = JOptionPane.showConfirmDialog(Manager.getFrame(), fm, MSG_EXPLORER.getString("IDSLibraryHandler.exportPolicy"), 2);
                    if (option == 2) {
                        return;
                    }
                }
                TopLevelObject abs = schemaObj;
                SchemaContainer sc = new SchemaContainer();
                sc.addChild((AbstractSchema)abs);
                PolicyHandler.addExtraInformationInPolicy(sc);
                LinkedHashMap<String, TopLevelObject> objReferencePool = new LinkedHashMap<String, TopLevelObject>();
                PolicyHandler.extractTopLevelObject(objReferencePool, (ConfigObject)schemaObj, true);
                for (Map.Entry oneEntry : objReferencePool.entrySet()) {
                    sc.addChild((AbstractSchema)oneEntry.getValue());
                    TopLevelObject obj = (TopLevelObject)oneEntry.getValue();
                    if (!(obj instanceof PhysicalFile)) continue;
                    PhysicalFile file = (PhysicalFile)obj;
                    String id = file.getObjReference().getTargetId();
                    InputStream is = GUIManager.getFile(id);
                    if (physicalFileList == null) {
                        physicalFileList = new Hashtable<String, BufferedInputStream>();
                    }
                    physicalFileList.put("trojan.dat", new BufferedInputStream(is));
                }
                ZipOutputStream zip = null;
                zip = exportFile.getName().indexOf(".dat") > 0 ? new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(exportFile))) : new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(exportFile + ".dat")));
                byte[] buff = new byte[1024];
                ZipEntry entry = new ZipEntry("sdi.xml");
                zip.putNextEntry(entry);
                sc.writeXML((OutputStream)zip);
                zip.closeEntry();
                if (physicalFileList != null && physicalFileList.size() != 0) {
                    Enumeration en = physicalFileList.keys();
                    while (en.hasMoreElements()) {
                        int len;
                        String fileName = (String)en.nextElement();
                        InputStream fileIS = (InputStream)physicalFileList.get(fileName);
                        entry = new ZipEntry(fileName);
                        zip.putNextEntry(entry);
                        while ((len = fileIS.read(buff, 0, 1024)) > 0) {
                            zip.write(buff, 0, len);
                        }
                        IOUtilities.closeInputStream((InputStream)fileIS);
                        zip.closeEntry();
                    }
                }
                zip.close();
            }
            catch (RuntimeException e) {
                errMsg = e.getMessage();
            }
            catch (Exception e) {
                errMsg = e.getMessage();
            }
            if (errMsg != null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSG_EXPLORER.getString("IDSLibraryHandler.failedToExportThePolicy") + errMsg);
            }
        }
    }
}

