/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.ids;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.PolicyPanel;
import com.sygate.scm.console.ui.policy.common.AppliablePolicy;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyPoolPane;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryPoolObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyPoolObject;
import com.sygate.scm.console.ui.util.CustomTableModel;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IDSLibsPoolPane
extends PolicyPoolPane {
    private static final long serialVersionUID = 1L;
    private JTabbedPane jTBPolicy;
    private JTable jTIDSPolicy;
    private JTable jTIDSLibrary;
    private PolicyPanel policyPanel;
    private static final String[] TABLE_COLUMN_NAME = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyPoolPane.column.name"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyPoolPane.column.description"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", LicenseObject.getInstance().isSBProduct() ? "IDSLibsPoolPane.column.usingPolicyForSB" : "IDSLibsPoolPane.column.usingPolicy")};
    private static final float[] TABLE_WIDTHS = new float[]{0.3f, 0.4f, 0.2f};

    public IDSLibsPoolPane() {
        this.title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "IDSLibsPoolPane.title.intrusionPreventionLibraries");
        this.initialize();
    }

    @Override
    protected float[] getTableColumnWidths() {
        return TABLE_WIDTHS;
    }

    @Override
    protected String[] getTableColumnNames() {
        return TABLE_COLUMN_NAME;
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
        this.addTableSelectionListener(this.jTIDSPolicy, listener);
        this.addTableSelectionListener(this.jTIDSLibrary, listener);
    }

    @Override
    protected JTable getPolicyTable() {
        return this.isIDSPolicySelected() ? this.jTIDSPolicy : this.jTIDSLibrary;
    }

    public boolean isIDSPolicySelected() {
        if (null == this.jTBPolicy) {
            return true;
        }
        return this.jTBPolicy.getSelectedIndex() == 0;
    }

    private void addTableSelectionListener(JTable table, ListSelectionListener listener) {
        DefaultListSelectionModel selModel = (DefaultListSelectionModel)table.getSelectionModel();
        ListSelectionListener[] listeners = selModel.getListSelectionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (listener != listeners[i]) continue;
            return;
        }
        selModel.addListSelectionListener(listener);
    }

    @Override
    protected List<String> getAllIdFromPool() throws ConsoleException {
        return IdsLibraryPoolObject.getIdsLibraryPoolObject().getAllId();
    }

    @Override
    public int getTableSelectedItem() {
        int type = super.getTableSelectedItem();
        if (type != -1) {
            return type;
        }
        if (this.isIDSPolicySelected()) {
            return 305;
        }
        return 66;
    }

    @Override
    protected ObjInfoObject[] getInfoObjListFromPool() throws ConsoleException {
        if (this.isIDSPolicySelected()) {
            return IdsLibraryPoolObject.getIdsLibraryPoolObject().getInfoObjectList();
        }
        return IdsPolicyPoolObject.getIdsPolicyPool().getInfoObjectList();
    }

    @Override
    protected boolean needHandleMessage(AppliablePolicy msgObj) {
        return msgObj instanceof IdsLibraryObject || msgObj instanceof IdsPolicyObject;
    }

    public void setPolicyPanel(PolicyPanel policyPanel) {
        this.policyPanel = policyPanel;
    }

    private JTable createIDSPolicyTable() {
        try {
            return this.createPolicyTable(TABLE_COLUMN_NAME, IdsPolicyPoolObject.getIdsPolicyPool().getInfoObjectList());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    private JTable createIDSLibraryTable() {
        try {
            return this.createPolicyTable(TABLE_COLUMN_NAME, IdsLibraryPoolObject.getIdsLibraryPoolObject().getInfoObjectList());
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    @Override
    protected JComponent getTablePanel() {
        this.jTIDSPolicy = this.createIDSPolicyTable();
        this.jTIDSLibrary = this.createIDSLibraryTable();
        LicenseObject licenseObj = LicenseObject.getInstance();
        if (!licenseObj.isSBProduct()) {
            this.jTBPolicy = new JTabbedPane();
            this.jTBPolicy.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "IDSLibsPoolPane.tab.idspolicy"), this.getTablePanel(this.jTIDSPolicy));
            this.jTBPolicy.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "IDSLibsPoolPane.tab.idslibrary"), this.getTablePanel(this.jTIDSLibrary));
            this.jTBPolicy.setOpaque(false);
            this.jTBPolicy.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.jTBPolicy.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    IDSLibsPoolPane.this.updateObject();
                    if (IDSLibsPoolPane.this.policyPanel != null) {
                        IDSLibsPoolPane.this.policyPanel.valueChanged(new ListSelectionEvent(new Object(), 0, 0, true));
                    }
                }
            });
            return this.jTBPolicy;
        }
        JPanel luPolicyPane = new JPanel();
        luPolicyPane.setLayout(new BorderLayout());
        luPolicyPane.add((Component)this.getTablePanel(this.jTIDSPolicy), "Center");
        luPolicyPane.setOpaque(false);
        return luPolicyPane;
    }

    @Override
    protected String getPolicyId(Object policyObj) {
        return ((PolicyObjectBase)policyObj).getId();
    }

    @Override
    protected int getPolicyItemType() {
        return this.getPolicyItemType(false);
    }

    @Override
    protected int getQuarantinePolicyItemType() {
        return this.getPolicyItemType(true);
    }

    private int getPolicyItemType(boolean isQuarantine) {
        int row = this.getPolicyTable().getSelectedRow();
        CustomTableModel ctm = (CustomTableModel)this.getPolicyTable().getModel();
        if (this.isIDSPolicySelected()) {
            if (row > -1) {
                IdsLibraryPoolObject.IDSObjInfoObject obj = (IdsLibraryPoolObject.IDSObjInfoObject)ctm.getRow(row);
                int type = obj.getIdsPoolObjectReferenceType(isQuarantine);
                return type;
            }
            return 143;
        }
        return 65;
    }

    @Override
    protected JMenuItem createAddMenuItem() {
        JMenuItem add = new JMenuItem(UIText.get(0));
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IDSLibsPoolPane.this.executeTask(0, null);
            }
        });
        return add;
    }
}

