/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.ids;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.ImportConfigObjHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyPanel;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.common.dlg.PolicyApplyDialog;
import com.sygate.scm.console.ui.policy.explorer.ids.IDSLibsPoolPane;
import com.sygate.scm.console.ui.policy.explorer.ids.IDSPolicyHandlerHelper;
import com.sygate.scm.console.ui.policy.ids.dialog.IdsEditor;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryPoolObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class IDSLibraryHandler
extends BasePolicyHandler {
    public static final long SYSTEM = 1L;
    private static final MessageResourcesFile MSG_EXPLORER = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");
    private static final MessageResourcesFile MSG_HANDLER = new MessageResourcesFile("com.sygate.scm.console.handler.handler");
    private static IDSLibraryHandler handler;
    private static JFileChooser chooser;

    private IDSLibraryHandler() {
        this.policyPoolPane = new IDSLibsPoolPane();
    }

    public static synchronized IDSLibraryHandler getInstance() {
        if (handler == null) {
            handler = new IDSLibraryHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public void deletePolicy(JComponent source, PolicyObjectBase policy) {
        if (!this.isCorrectPolicyType(policy)) {
            return;
        }
        try {
            int retCode;
            IdsLibraryPoolObject idsPool = IdsLibraryPoolObject.getIdsLibraryPoolObject();
            if (policy instanceof IdsLibraryObject && idsPool.isSystemLibrary((IdsLibraryObject)policy) && (retCode = JOptionPane.showConfirmDialog(Manager.getFrame(), new DescriptionTextArea(MSG_EXPLORER.getString("IDSLibraryHandler.deleteSystemIPSLibrary")), MSG_EXPLORER.getString("IDSLibraryHandler.deleteLibrary"), 0)) != 0) {
                return;
            }
        }
        catch (ConsoleException ex) {
            UIUtilities.showErrorDialog(ex.getMessage());
            Manager.getFrame().showLoginPanel();
        }
        super.deletePolicy(source, policy);
    }

    @Override
    public void importPolicy(JComponent source) {
        if (!this.hasLicense(false)) {
            return;
        }
        chooser.resetChoosableFileFilters();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setApproveButtonText(UIText.get(2048));
        chooser.setDialogTitle(MSG_HANDLER.getString("PolicyHandler.title.ImportPolicy"));
        chooser.addChoosableFileFilter(this.getImportExportFileFilter(true));
        if (0 != chooser.showOpenDialog(Manager.getFrame())) {
            return;
        }
        File f = chooser.getSelectedFile();
        this.importPolicy(source, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importPolicy(JComponent source, File file) {
        if (!this.hasLicense(false)) {
            return;
        }
        String name = file.getName();
        if (!name.endsWith(".daz") && !name.endsWith(".dat")) {
            UIUtilities.showErrorDialog(MSG_EXPLORER.getString("IDSLibraryHandler.invalidLibraryFile"));
            return;
        }
        Hashtable<String, File> importedPhysicalFiles = new Hashtable<String, File>();
        try {
            AbstractSchema schema = PolicyHandler.readZipFile(file, importedPhysicalFiles);
            if (schema == null) {
                throw new Exception(MSG_EXPLORER.getString("IDSLibraryHandler.invalidExportFile"));
            }
            if (!this.importIPS(source, schema, importedPhysicalFiles)) {
                UIUtilities.showErrorDialog(MSG_EXPLORER.getString("IDSLibraryHandler.failedToImportTheLibrary"));
                return;
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            String errMsg = e.getMessage();
            if (errMsg != null) {
                Object[] obj = new Object[]{errMsg};
                String str = MSG_EXPLORER.getString("IDSLibraryHandler.failedToImportTheIPSLibrary");
                UIUtilities.showErrorDialog(MessageFormat.format(str, obj));
            }
        }
        finally {
            Iterator<File> values = importedPhysicalFiles.values().iterator();
            while (values.hasNext()) {
                Utility.delete((File)values.next());
            }
        }
    }

    @Override
    public void exportPolicy(JComponent source, PolicyObjectBase policy) {
        IDSPolicyHandlerHelper.exportPolicy(policy, this);
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        String title = this.hasLicense(true) ? MSG_EXPLORER.getString("IDSLibraryHandler.intrusionPreventionLibraries") : MSG_EXPLORER.getString("IDSLibraryHandler.title.intrusionPreventionLibrariesNotLicensed");
        return title;
    }

    @Override
    protected PolicyApplyDialog createPolicyReplaceDialog(String title, String type, PolicyObjectBase policyObj, ObjInfoObject[] objArr) {
        ArrayList<ObjInfoObject> infoList = new ArrayList<ObjInfoObject>();
        String policyType = "";
        policyType = "FwIdsLibrary";
        for (int i = 0; i < objArr.length; ++i) {
            if (objArr[i].getTargetType().compareToIgnoreCase(policyType) != 0) continue;
            infoList.add(objArr[i]);
        }
        return new PolicyApplyDialog(title, type, policyObj, false, infoList.toArray(new ObjInfoObject[0]));
    }

    @Override
    protected PolicyApplyDialog createPolicyApplyDialog(String title, String type, PolicyObjectBase policyObj) {
        TopLevelObject policy = policyObj.getSchemaObj();
        boolean viewGroupOnly = policy instanceof FwIdsLibrary;
        return new PolicyApplyDialog(title, type, (TreeItem)policyObj, viewGroupOnly);
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return null;
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return null;
    }

    @Override
    protected PolicyObjectBase getNewPolicy(AppliablePolicyPool pool) throws ConsoleException {
        IdsLibraryObject libObject = new IdsLibraryObject();
        libObject.setName(MSG_EXPLORER.getString("IDSLibraryHandler.newIPSLibrary"));
        List<String> nameList = pool.getAllName();
        String newName = PolicyHandler.adjustName(libObject.getName(), nameList, this.getPolicyNameLength());
        if (newName == null) {
            return null;
        }
        libObject.setName(newName);
        IdsEditor dlg = new IdsEditor(libObject, null);
        if (dlg.isOk()) {
            this.checkApplied = true;
        }
        return dlg.isOk() ? libObject : null;
    }

    @Override
    protected PolicyObjectBase getEditPolicy(JComponent source, AppliablePolicyPool pool, PolicyObjectBase policy) throws ConsoleException {
        IdsLibraryObject newPolicy = ((IdsLibraryObject)policy).getClone();
        IdsEditor dlg = new IdsEditor(newPolicy, newPolicy.getName(), true);
        return dlg.isOk() ? newPolicy : null;
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(IdsLibraryObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 255;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof IdsLibraryObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MSG_EXPLORER.getString("IDSLibraryHandler.applyIPSLibrary");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MSG_EXPLORER.getString("IDSLibraryHandler.replaceIPSLibrary");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MSG_EXPLORER.getString("IDSLibraryHandler.thisIsTheOnlyIPSPolicyIn");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MSG_EXPLORER.getString("IDSLibraryHandler.withdrawIPSLibrary");
    }

    @Override
    protected String getDeletePolicyMessage() {
        return MSG_EXPLORER.getString("IDSLibraryHandler.deleteIPSLibrary_");
    }

    @Override
    protected String getDeletePolicyTitle() {
        return MSG_EXPLORER.getString("IDSLibraryHandler.deleteIPSLibrary");
    }

    @Override
    protected String getImportFailMessage() {
        return "";
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof FwIdsLibrary) {
            return new IdsLibraryObject((FwIdsLibrary)obj);
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        String id = infoObj.getId();
        String type = infoObj.getTargetType();
        FwIdsLibrary idsLib = (FwIdsLibrary)DataobjectManager.getInstance().getObjectByGUID(type, id);
        return new IdsLibraryObject(idsLib);
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return IdsLibraryPoolObject.getIdsLibraryPoolObject();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new IdsLibraryPoolObject(domain);
    }

    private boolean importIPS(JComponent source, AbstractSchema schema, Hashtable<String, File> physicalFiles) throws Exception {
        ConfigObject policy;
        Vector c = new Vector();
        if (schema instanceof FwIdsLibrary) {
            policy = (ConfigObject)schema;
            c.add(policy);
        } else {
            c = schema.getChildren();
            policy = (ConfigObject)c.get(0);
        }
        LinkedHashMap<String, TopLevelObject> objRefs = new LinkedHashMap<String, TopLevelObject>();
        PolicyHandler.extractTopLevelObject(objRefs, policy, false);
        PolicyHandler.retrieveReferredTopLevelObj(c, objRefs);
        ImportConfigObjHandler washer = new ImportConfigObjHandler();
        washer.setObjReferencePool(objRefs);
        washer.setPhysicalFiles(physicalFiles);
        TopLevelObject newObj = (TopLevelObject)washer.importObject(policy, new HashMap<String, TopLevelObject>());
        if (newObj instanceof FwIdsLibrary) {
            ((FwIdsLibrary)newObj).setOptObjAttributes(null);
            this.addPolicy(source, new IdsLibraryObject((FwIdsLibrary)newObj));
            return true;
        }
        return false;
    }

    public PolicyPoolPane getPolicyPoolPane(TreeItem treeItem, PolicyPanel policyPanel) {
        ((IDSLibsPoolPane)this.policyPoolPane).setPolicyPanel(policyPanel);
        this.policyPoolPane.updateObject();
        this.updatePolicyPoolPaneTitle(treeItem.getName());
        return this.policyPoolPane;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        boolean isLicensed = LicenseObject.getInstance().isIntrusionPreventionEnabled();
        if (!justCheckLicense && !isLicensed) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_EXPLORER.getString("IDSLibraryHandler.theIntrusionPreventionLibraryFeatureIsNotLicensed"), MSG_EXPLORER.getString("IDSLibraryHandler.notLicensed"), 0);
        }
        return isLicensed;
    }

    @Override
    public FileFilter getImportExportFileFilter(final boolean isImport) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = Utility.getFileExtension((File)f);
                if (isImport) {
                    return extension != null && (extension.equals("daz") || extension.equals("dat"));
                }
                return extension != null && extension.equals("dat");
            }

            @Override
            public String getDescription() {
                String des = "";
                des = isImport ? MSG_EXPLORER.getString("IDSLibraryHandler.IPSSigDatDaz") : MSG_EXPLORER.getString("IDSLibraryHandler.IPSSigFileDat");
                return des;
            }
        };
    }

    static {
        chooser = new JFileChooser();
    }
}

