/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.hosts;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.HostGroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.explorer.common.NonAppliablePolicyPanelBase;
import com.sygate.scm.console.ui.policy.explorer.common.dlg.LearnApplicationDialog;
import com.sygate.scm.console.ui.policy.hostgroup.HostGroupObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.util.ConsoleException;
import java.util.Vector;
import javax.swing.JOptionPane;

public class HostGroupPanel
extends NonAppliablePolicyPanelBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");
    private static final String[] TABLE_COLUMN_NAME = new String[]{res.getString("HostGroupPanel.column.name"), res.getString("HostGroupPanel.column.content")};
    private static final int[] TABLE_COLUMN_MAP = new int[]{0, 1};
    private static final float[] TABLE_COLUMN_WIDTHS = new float[]{0.3f, 0.7f};

    public HostGroupPanel() {
        this.initialize();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_pane_policy_components";
    }

    @Override
    protected void refreshModel(SortableTableModel model) throws ConsoleException {
        model.setDataVector(new Vector<TableRow>(HostGroupHandler.getInstance().getHostGroupsFromDB()));
        model.fireTableDataChanged();
    }

    @Override
    protected String getHTMLName() {
        return "";
    }

    @Override
    protected String getTitleAndDescription() {
        return "";
    }

    @Override
    protected String[] getTableColumnName() {
        return TABLE_COLUMN_NAME;
    }

    @Override
    protected int[] getTableColumnMapping() {
        return TABLE_COLUMN_MAP;
    }

    @Override
    protected float[] getTableColumnWidths() {
        return TABLE_COLUMN_WIDTHS;
    }

    @Override
    protected int getItemType() {
        return 9;
    }

    @Override
    protected boolean isActionEnabled() {
        int selIndex = this.jTTable.getSelectedRow();
        return selIndex >= 0;
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        this.refresh();
        if (taskIndex == 0) {
            this.doAdd();
        } else if (taskIndex == 1) {
            this.doImport();
        } else if (taskIndex == 14) {
            new LearnApplicationDialog();
        } else {
            int selRowCount = this.jTTable.getSelectedRowCount();
            if (selRowCount == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyPoolPane.policyDeleted"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyPoolPane.message"), 0);
                return;
            }
            if (taskIndex == 3) {
                this.doEdit();
            } else if (taskIndex == 4) {
                this.doDelete();
            } else if (taskIndex == 5) {
                this.doExport();
            }
        }
        this.refresh();
    }

    @Override
    protected void doExport() {
        HostGroupObject selectedHostGroup = this.getSelectedHostGroup();
        if (selectedHostGroup == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyPoolPane.policyDeleted"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyPoolPane.message"), 0);
            return;
        }
        PolicyHandler.exportPolicy((ConfigObject)selectedHostGroup.getHostGroup(), selectedHostGroup.getName());
    }

    private void doImport() {
        FwNetworkHostGroup newHostGroup = (FwNetworkHostGroup)HostGroupHandler.getInstance().importHostGroup();
        if (newHostGroup != null) {
            this.refresh();
            SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
            int rowCount = model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                HostGroupObject hostGroupObj = (HostGroupObject)model.getRow(i);
                if (!hostGroupObj.getHostGroup().getId().equals(newHostGroup.getId())) continue;
                this.jTTable.setRowSelectionInterval(i, i);
                break;
            }
        }
    }

    @Override
    protected void doAdd() {
        FwNetworkHostGroup newHostGroup = (FwNetworkHostGroup)HostGroupHandler.getInstance().addHostGroup(this.jTTable);
        if (newHostGroup != null) {
            this.refresh();
            SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
            int rowCount = model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                HostGroupObject hostGroupObj = (HostGroupObject)model.getRow(i);
                if (!hostGroupObj.getHostGroup().getId().equals(newHostGroup.getId())) continue;
                this.jTTable.setRowSelectionInterval(i, i);
                break;
            }
        }
    }

    @Override
    protected void doEdit() {
        HostGroupObject selectedHostGroup = this.getSelectedHostGroup();
        if (selectedHostGroup == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), res.getString("ServiceTypePanel.cantEditNetworkService"), res.getString("ServiceTypePanel.editNetworkService"), -1);
            return;
        }
        HostGroupHandler.getInstance().editHostGroup(selectedHostGroup);
    }

    @Override
    protected void doDelete() {
        HostGroupObject selectedHostGroup = this.getSelectedHostGroup();
        HostGroupHandler.getInstance().deleteHostGroup(selectedHostGroup);
    }

    @Override
    protected String getPolicyTypeName() {
        return res.getString("HostGroupPanel.title");
    }

    private HostGroupObject getSelectedHostGroup() {
        int selRow = this.jTTable.getSelectedRow();
        if (selRow == -1) {
            return null;
        }
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        return (HostGroupObject)model.getRow(selRow);
    }

    @Override
    protected void retrieveTableSelection(TableRow selectedRow) {
        if (selectedRow == null) {
            return;
        }
        HostGroupObject selHostGroup = (HostGroupObject)selectedRow;
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            HostGroupObject hostGroupObj = (HostGroupObject)model.getRow(i);
            if (!hostGroupObj.getHostGroup().getId().equals(selHostGroup.getHostGroup().getId())) continue;
            this.jTTable.setRowSelectionInterval(i, i);
            break;
        }
    }
}

