/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.hi;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.HiHostIntegrityPolicy;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.HostIntegrityObject;
import com.sygate.scm.console.logicobject.HostIntegrityPolicyPool;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.hi.HostIntegrityPolicyPoolPane;
import com.sygate.scm.console.ui.policy.hi.HiPolicyDialog;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;

public class HostIntegrityPolicyHandler
extends BasePolicyHandler {
    private static HostIntegrityPolicyHandler handler;

    private HostIntegrityPolicyHandler() {
        this.policyPoolPane = new HostIntegrityPolicyPoolPane();
    }

    public static synchronized HostIntegrityPolicyHandler getInstance() {
        if (handler == null) {
            handler = new HostIntegrityPolicyHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        boolean isLicensed = LicenseObject.getInstance().isHostIntegrityPolicy();
        if (!justCheckLicense && !isLicensed) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.theHostIntegrityPolicyFeatureIsNotLicensed"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.notLicensed"), 0);
        }
        return isLicensed;
    }

    @Override
    protected void updatePolicyObject(PolicyObjectBase policy, PolicyObjectBase newPolicy) {
        super.updatePolicyObject(policy, newPolicy);
        if (newPolicy != null) {
            ((HostIntegrityObject)policy).setPhysicalFileObject(((HostIntegrityObject)newPolicy).getPhysicalFileObject());
        }
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        String title = this.hasLicense(true) ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.title.hostIntegrityPolicies") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.title.hostIntegrityPoliciesNotLicensed");
        return title;
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new HiPolicyDialog(pool);
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new HiPolicyDialog(pool, true);
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(HostIntegrityObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 512;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof HostIntegrityObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.applyHostIntegrityPolicy");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.replaceHostIntegrityPolicy");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.thisIsTheOnlyHostIntegrityPolicyIn");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.withdrawHostIntegrityPolicy");
    }

    @Override
    protected String getImportFailMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.failedToImportThePolicy");
    }

    @Override
    protected boolean canBeApplied() throws ConsoleException {
        return LuUtility.canApplyHIPolicy();
    }

    @Override
    protected String getCannotApplyPolicyMsg() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "HostIntegrityPolicyHandler.cannotApplyHIPoliy_msg");
    }

    @Override
    public PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj != null && obj instanceof HiHostIntegrityPolicy) {
            HiHostIntegrityPolicy policy = (HiHostIntegrityPolicy)obj;
            return new HostIntegrityObject((TopLevelObject)policy);
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        return new HostIntegrityObject((TopLevelObject)DataobjectManager.getInstance().getHiHostIntegrityPolicy(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return HostIntegrityPolicyPool.getHostIntegrityPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new HostIntegrityPolicyPool(domain);
    }
}

