/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.fw;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.BaselineFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.FirewallRule;
import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.FwActiveResponse;
import com.sygate.scm.common.configobject.schema.FwAntiMacSpoofing;
import com.sygate.scm.common.configobject.schema.FwDosProtection;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.FwPortScan;
import com.sygate.scm.common.configobject.schema.FwSmartDhcp;
import com.sygate.scm.common.configobject.schema.FwSmartDns;
import com.sygate.scm.common.configobject.schema.SecuritySetting;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.FirewallPolicyObject;
import com.sygate.scm.console.logicobject.FirewallPolicyPool;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.fw.FirewallPolicyPoolPane;
import com.sygate.scm.console.ui.policy.firewall.Handler.FirewallPolicyHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.FwPolicyDialog;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class FwPolicyHandler
extends BasePolicyHandler {
    private static FwPolicyHandler handler;

    private FwPolicyHandler() {
        this.policyPoolPane = new FirewallPolicyPoolPane();
    }

    public static synchronized FwPolicyHandler getInstance() {
        if (null == handler) {
            handler = new FwPolicyHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        boolean isLicensed = LicenseObject.getInstance().isFirewallPolicy();
        if (!justCheckLicense && !isLicensed) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FwPolicyHandler.theFirewallPolicyFeatureIsNotLicensed"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FwPolicyHandler.notLicensec"), 0);
        }
        return isLicensed;
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        String title = this.hasLicense(true) ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FwPolicyHandler.title.firewallPolicies") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FwPolicyHandler.title.firewallPoliciesNotLicensed");
        return title;
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new FwPolicyDialog(pool);
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new FwPolicyDialog(pool, true);
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(FirewallPolicyObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 255;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof FirewallPolicyObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FwPolicyHandler.applyFirewallPolicy");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FwPolicyHandler.replaceFirewallPolicy");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FwPolicyHandler.thisIsTheOnlyFirewallPolicyIn");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FwPolicyHandler.withdrawFirewallPolicy");
    }

    @Override
    protected String getImportFailMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "FwPolicyHandler.failedToImportThePolicy");
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof FwFirewallPolicy) {
            return new FirewallPolicyObject((TopLevelObject)((FwFirewallPolicy)obj));
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        return new FirewallPolicyObject((TopLevelObject)DataobjectManager.getInstance().getFwFirewallPolicy(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return FirewallPolicyPool.getFirewallPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new FirewallPolicyPool(domain);
    }

    @Override
    protected void handleCustomImportConfiguration(ConfigObject policyObj) {
        if (policyObj != null && policyObj instanceof FwFirewallPolicy) {
            FwFirewallPolicy fwPolicy = (FwFirewallPolicy)policyObj;
            if (LicenseObject.getInstance().isSBProduct()) {
                this.addSecurityRuleIntoPolicy(fwPolicy);
            }
            if (fwPolicy.getOptMacFwFirewallPolicy() == null) {
                System.out.println("handleCustomImportConfiguration: Adding Fw Mac component.");
                this.addMacComponentToFwPolicy(fwPolicy);
            }
        } else if (policyObj == null) {
            System.out.println("handleCustomImportConfiguration: Firewall policy null ");
        } else {
            System.out.println("handleCustomImportConfiguration: Firewall policy incorrect: " + policyObj.getClass().getName());
        }
    }

    private void addMacComponentToFwPolicy(FwFirewallPolicy fwPolicy) {
        FirewallRuleSystem macFwRuleSystem = new FirewallRuleSystem();
        FirewallPolicyHandler.getMacFwFirewallPolicy(fwPolicy).setOptFirewallRuleSystem(macFwRuleSystem);
        SecuritySetting macSecSett = new SecuritySetting();
        FwSmartDhcp fwSmDhcp = new FwSmartDhcp();
        fwSmDhcp.setOptEnable(fwSmDhcp.getDefEnable());
        macSecSett.setOptFwSmartDhcp(fwSmDhcp);
        FwSmartDns fwSmDns = new FwSmartDns();
        fwSmDns.setOptEnable(fwSmDns.getDefEnable());
        macSecSett.setOptFwSmartDns(fwSmDns);
        FwPortScan fwPorScan = new FwPortScan();
        fwPorScan.setOptEnable(fwPorScan.getDefEnable());
        macSecSett.setOptFwPortScan(fwPorScan);
        FwDosProtection fwDosProtect = new FwDosProtection();
        fwDosProtect.setOptEnable(fwDosProtect.getDefEnable());
        macSecSett.setOptFwDosProtection(fwDosProtect);
        FwActiveResponse fwActRes = new FwActiveResponse();
        fwActRes.setOptEnable(fwActRes.getDefEnable());
        fwActRes.setOptDefaultAbusePeriod(fwActRes.getDefDefaultAbusePeriod());
        macSecSett.setOptFwActiveResponse(fwActRes);
        FwAntiMacSpoofing fwAntiMacSpoof = new FwAntiMacSpoofing();
        fwAntiMacSpoof.setOptEnable(fwAntiMacSpoof.getDefEnable());
        macSecSett.setOptFwAntiMacSpoofing(fwAntiMacSpoof);
        FirewallPolicyHandler.getMacFwFirewallPolicy(fwPolicy).setSecuritySetting(macSecSett);
    }

    private void addSecurityRuleIntoPolicy(FwFirewallPolicy fwPolicy) {
        if (fwPolicy != null) {
            BaselineFirewallRuleArray baseRuleArray;
            FirewallRuleSystem ruleSystem = fwPolicy.getOptFirewallRuleSystem();
            if (ruleSystem == null) {
                ruleSystem = new FirewallRuleSystem();
                fwPolicy.setOptFirewallRuleSystem(ruleSystem);
            }
            if ((baseRuleArray = ruleSystem.getOptBaselineFirewallRuleArray()) == null) {
                baseRuleArray = new BaselineFirewallRuleArray();
            }
            Vector rules = baseRuleArray.getFirewallRule();
            boolean aleadyExist = false;
            for (FirewallRule rule : rules) {
                String ruleType = rule.getOptRuleType();
                if (!"L".equalsIgnoreCase(ruleType) && !"M".equalsIgnoreCase(ruleType) && !"H".equalsIgnoreCase(ruleType)) continue;
                aleadyExist = true;
                break;
            }
            if (!aleadyExist) {
                try {
                    HashMap<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
                    FwFirewallPolicy refFWPolicy = PolicyHandler.getDefaultFirewallPolicy(newObjList);
                    Vector<FirewallRule> securityRules = this.getSecurityRuleFromPolicy(refFWPolicy);
                    for (FirewallRule rule : securityRules) {
                        baseRuleArray.addFirewallRule(rule);
                    }
                }
                catch (Exception e) {
                    LoggerUtilities.logException((Throwable)e);
                }
            }
        }
    }

    private Vector<FirewallRule> getSecurityRuleFromPolicy(FwFirewallPolicy fwPolicy) {
        BaselineFirewallRuleArray baseRuleArray;
        FirewallRuleSystem ruleSystem;
        Vector<FirewallRule> rules = new Vector<FirewallRule>();
        if (fwPolicy != null && (ruleSystem = fwPolicy.getOptFirewallRuleSystem()) != null && (baseRuleArray = ruleSystem.getOptBaselineFirewallRuleArray()) != null) {
            Vector baseRules = baseRuleArray.getFirewallRule();
            for (FirewallRule rule : baseRules) {
                String ruleType = rule.getOptRuleType();
                if (!"L".equalsIgnoreCase(ruleType) && !"M".equalsIgnoreCase(ruleType) && !"H".equalsIgnoreCase(ruleType)) continue;
                rules.add(rule);
            }
        }
        return rules;
    }
}

