/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.device;

import com.sygate.scm.common.configobject.schema.OpDevice;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.util.ConfigObjectUtils;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.UsbDeviceHandler;
import com.sygate.scm.console.logicobject.DeviceObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.client.PlatformIconNameCellRenderer;
import com.sygate.scm.console.ui.policy.explorer.common.NonAppliablePolicyPanelBase;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyApplyHelper;
import com.sygate.scm.console.ui.policy.osprotect.dialog.DeviceEditorDialog;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class HardwareDevicePanel
extends NonAppliablePolicyPanelBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");
    private static final String[] TABLE_COLUMN_NAME = new String[]{MSG_RES.getString("HardwareDevicePanel.column.deviceName"), MSG_RES.getString("HardwareDevicePanel.column.platform"), MSG_RES.getString("HardwareDevicePanel.column.Identification")};
    private static final int[] TABLE_COLUMN_MAP = new int[]{0, 6, 2};
    private static final float[] TABLE_COLUMN_WIDTHS = new float[]{0.4f, 0.1f, 0.5f};

    public HardwareDevicePanel() {
        this.initialize();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_pane_policy_components";
    }

    @Override
    protected void refreshModel(SortableTableModel model) throws ConsoleException {
        model.removeAll();
        ArrayList<OpDevice> list = UsbDeviceHandler.getAllDevicesFromPool();
        for (int i = 0; i < list.size(); ++i) {
            model.addRow(new DeviceObject(list.get(i)));
        }
    }

    @Override
    protected String getHTMLName() {
        return "hardwaredevices_temp.htm";
    }

    @Override
    protected String getTitleAndDescription() {
        return "";
    }

    @Override
    protected void setColumnRenderers(JTable thisTable) {
        thisTable.getColumnModel().getColumn(1).setCellRenderer(new PlatformIconNameCellRenderer());
    }

    @Override
    protected String[] getTableColumnName() {
        return TABLE_COLUMN_NAME;
    }

    @Override
    protected int[] getTableColumnMapping() {
        return TABLE_COLUMN_MAP;
    }

    @Override
    protected float[] getTableColumnWidths() {
        return TABLE_COLUMN_WIDTHS;
    }

    @Override
    protected int getItemType() {
        return this.isActionEnabled() ? 133 : 101;
    }

    @Override
    protected boolean isActionEnabled() {
        int selIndex = this.jTTable.getSelectedRow();
        if (selIndex == -1) {
            return false;
        }
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        return !((DeviceObject)model.getRow(selIndex)).isSystem();
    }

    @Override
    protected void doAdd() {
        DeviceEditorDialog dlg = new DeviceEditorDialog(null);
        if (dlg.isOk()) {
            try {
                UsbDeviceHandler.addDevice(dlg.getDeviceObject());
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        dlg.dispose();
    }

    @Override
    protected void doEdit() {
        if (!this.isActionEnabled()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("HardwareDevicePanel.cantEditSystemHardwareDevice"), MSG_RES.getString("HardwareDevicePanel.editHardwareDevice"), -1);
            return;
        }
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        DeviceObject dvObj = (DeviceObject)model.getRow(this.jTTable.getSelectedRow());
        try {
            DeviceObject newObj;
            DeviceEditorDialog dlg = new DeviceEditorDialog(new DeviceObject(dvObj.getCopyOfPolicyObject()));
            if (dlg.isOk() && !ConfigObjectUtils.isEqualObj((Object)(newObj = dlg.getDeviceObject()).getDevice(), (Object)dvObj.getDevice())) {
                UsbDeviceHandler.updateDevice(newObj);
            }
            dlg.dispose();
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("BasePolicyHandler.error"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    @Override
    protected void doDelete() {
        if (!this.isActionEnabled()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("HardwareDevicePanel.cantDeleteSystemHardwareDevice"), MSG_RES.getString("HardwareDevicePanel.deleteHardwareDevice"), -1);
            return;
        }
        int ret = UIUtilities.confirmYesNoOptionDialog(MSG_RES.getString("HardwareDevicePanel.youAreAboutToDeleteOneHardwareDevice"), MSG_RES.getString("HardwareDevicePanel.deleteHardwareDevice"));
        if (ret != 0) {
            return;
        }
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        DeviceObject dvObj = (DeviceObject)model.getRow(this.jTTable.getSelectedRow());
        if (PolicyApplyHelper.isDeviceInUse(dvObj)) {
            return;
        }
        try {
            UsbDeviceHandler.deleteDevices(dvObj);
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    protected String getPolicyTypeName() {
        return MSG_RES.getString("HardwareDevicePanel.title");
    }

    @Override
    protected void retrieveTableSelection(TableRow selectedRow) {
        if (selectedRow == null) {
            return;
        }
        DeviceObject selDevice = (DeviceObject)selectedRow;
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            DeviceObject device = (DeviceObject)model.getRow(i);
            if (!selDevice.getId().equals(device.getId())) continue;
            this.jTTable.setRowSelectionInterval(i, i);
            break;
        }
    }
}

