/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.common.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.common.AppliablePolicy;
import com.sygate.scm.console.ui.policy.explorer.common.LocationPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShowPolicyApplyDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;

    public ShowPolicyApplyDialog(AppliablePolicy policy) {
        super(Manager.getFrame(), "", true);
        this.setTitle(this.getTitle(policy.getName()));
        this.initialize(policy);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    private void initialize(AppliablePolicy policy) {
        this.getContentPane().add((Component)this.getInnerPanel(policy), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.jBCancel.setVisible(false);
        this.pack();
        this.setSize(700, 400);
    }

    private JPanel getInnerPanel(AppliablePolicy policy) {
        JLabel label = new JLabel(this.getLabelName(policy.getName()), this.getIcon(policy.getItemType()), 10);
        LocationPanel locPanel = new LocationPanel(policy);
        locPanel.setBorder(CustomLookAndFeel.SIMPLE_BORDER);
        locPanel.refresh();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)locPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        return panel;
    }

    private String getTitle(String name) {
        Object[] obj = new Object[]{name};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ShowPolicyApplyDialog.title");
        return MessageFormat.format(str, obj);
    }

    private String getLabelName(String name) {
        Object[] obj = new Object[]{name};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ShowPolicyApplyDialog.label");
        return MessageFormat.format(str, obj);
    }

    private Icon getIcon(int itemType) {
        String iconName = "firewall_policy.gif";
        switch (itemType) {
            case 56: {
                iconName = "host_integrity.gif";
                break;
            }
            case 63: {
                iconName = "os_protection.gif";
                break;
            }
            case 65: {
                iconName = "intrusion_prevention.gif";
                break;
            }
            case 60: {
                iconName = "policy_manager_list.png";
                break;
            }
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource(iconName)));
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_endpoint_security_manager_list_show_applied_groups_locations";
    }
}

