/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.common.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.monitor.MonitorAgent;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AbstractSelectableUIObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.explorer.common.ApplyMessageObject;
import com.sygate.scm.console.ui.policy.explorer.common.CheckItemTreeCellRenderer;
import com.sygate.scm.console.ui.policy.explorer.common.LocationCheckBoxTree;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyApplyHelper;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyUtil;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class PolicyApplyDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String EXPLORER = "com.sygate.scm.console.ui.policy.explorer.explorer";
    private static final String AUTOMATION_BUTTON_OK = "ButtonOK";
    private static final String AUTOMATION_CHECKBOX_GROUP = "CheckboxGroup";
    private static final String AUTOMATION_LOCATION_TREE = "LocationTree";
    private static final String APPLY_LOCATION_INFO = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.applyLocationInfo");
    private static final String REMOVE_LOCATION_INFO = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.removeLocationInfo");
    private static final String REPLACE_LOCATION_INFO = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.replaceLocationInfo");
    private static final String APPLY_LOCATION_WARN = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.applyLocationWarn");
    private static final String REMOVE_LOCATION_WARN = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.removeLocationWarn");
    private static final String REPLACE_LOCATION_WARN = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.replaceLocationWarn");
    private static final String APPLY_GROUP_INFO = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.applyGroupInfo");
    private static final String APPLY_GROUP_INFO_SBE = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.applyGroupInfo.SBE");
    private static final String REMOVE_GROUP_INFO = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.removeGroupInfo");
    private static final String REMOVE_GROUP_INFO_SBE = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.removeGroupInfo.SBE");
    private static final String REPLACE_GROUP_INFO = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.replaceGroupInfo");
    private static final String REPLACE_GROUP_INFO_SBE = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.replaceGroupInfo.SBE");
    private static final String APPLY_GROUP_WARN = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.applyGroupWarn");
    private static final String REMOVE_GROUP_WARN = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.removeGroupWarn");
    private static final String REPLACE_GROUP_WARN = MSGRES.getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyApplyDialog.replaceGroupWarn");
    private JLabel jLPolicyName = new JLabel();
    private DescriptionTextArea policyNameTextArea = new DescriptionTextArea();
    private JLabel jLNewPolicyName = new JLabel();
    private JComboBox<ObjInfoObject> jCmbReplaced = new JComboBox();
    private LocationCheckBoxTree locationTree = new LocationCheckBoxTree(new CheckItemTreeCellRenderer(true, true), true, false);
    private TreeItem treeItem;
    private String type;
    private boolean viewGrpsOnly;
    private LicenseObject licenseObject = LicenseObject.getInstance();

    public PolicyApplyDialog(String title, String type, TreeItem treeItem) {
        this(title, type, treeItem, false, null);
    }

    public PolicyApplyDialog(String title, String type, TreeItem treeItem, ObjInfoObject[] infoObj) {
        this(title, type, treeItem, false, infoObj);
    }

    public PolicyApplyDialog(String title, String type, TreeItem treeItem, boolean viewGrpsOnly) {
        this(title, type, treeItem, viewGrpsOnly, null);
    }

    public PolicyApplyDialog(String title, String type, TreeItem treeItem, boolean viewGrpsOnly, ObjInfoObject[] infoObj) {
        super(Manager.getFrame(), title, true);
        this.type = type;
        this.treeItem = treeItem;
        this.viewGrpsOnly = viewGrpsOnly;
        this.setData(infoObj);
        this.initialize();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    protected boolean isValidate() {
        if (!this.isValidData()) {
            return false;
        }
        String titleStr = "";
        String messageStr = "";
        if (this.type.equals("apply")) {
            titleStr = "PolicyApplyDialog.apply";
            messageStr = "PolicyApplyDialog.applyChanges";
        } else if (this.type.equals("remove")) {
            titleStr = "PolicyApplyDialog.withdraw";
            messageStr = "PolicyApplyDialog.withdrawChanges";
        } else if (this.type.equals("replace")) {
            titleStr = "PolicyApplyDialog.replace";
            messageStr = "PolicyApplyDialog.replaceChanges";
        }
        Object[] obj = this.getArgument();
        String str1 = MSGRES.getString(EXPLORER, messageStr);
        String fm1 = MessageFormat.format(str1, obj);
        String str2 = MSGRES.getString(EXPLORER, titleStr);
        String fm2 = MessageFormat.format(str2, obj);
        int res = JOptionPane.showConfirmDialog(Manager.getFrame(), fm1, fm2, 0);
        return res == 0;
    }

    @Override
    protected void commit() {
        if (this.getInfoObj() != null) {
            this.applyPolicy(this.locationTree.getModel(), this.treeItem, this.type, this.getInfoObj());
        } else {
            ConsoleLogger.log("PolicyApplyDialog >> commit() null InfoObject");
            if (this.type.equals("apply") || this.type.equals("remove")) {
                this.applyPolicy(this.locationTree.getModel(), this.treeItem, this.type, this.getInfoObj());
            }
        }
    }

    private ObjInfoObject getInfoObj() {
        ObjInfoObject infoObj = null;
        if (this.jCmbReplaced.getSelectedItem() != null) {
            infoObj = (ObjInfoObject)this.jCmbReplaced.getSelectedItem();
        }
        return infoObj;
    }

    @Override
    protected String getOkButtonText() {
        if (this.type.equals("apply")) {
            return UIText.get(18);
        }
        if (this.type.equals("remove")) {
            return UIText.get(5632);
        }
        return UIText.get(4356);
    }

    private void initialize() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)this.getTopPanel(), "North");
        panel.add((Component)this.getTreePanel(), "Center");
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        UIUtilities.setName(this.jBOk, "policyPage", UIUtilities.ComponentType.BUTTON, AUTOMATION_BUTTON_OK);
        UIUtilities.setName(this.locationTree, "policyPage", UIUtilities.ComponentType.JTREE, AUTOMATION_LOCATION_TREE);
        CheckItemTreeCellRenderer checkItemTreeCellRenderer = (CheckItemTreeCellRenderer)this.locationTree.getCellRenderer();
        UIUtilities.setName(checkItemTreeCellRenderer.getCheckBoxComponent(), "policyPage", UIUtilities.ComponentType.CHECKBOX, AUTOMATION_CHECKBOX_GROUP);
        this.pack();
    }

    private JPanel getTopPanel() {
        boolean isReplace = this.type.equals("replace");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        if (isReplace) {
            String msg = MSGRES.getString(EXPLORER, "PolicyApplyDialog.replaceMsg");
            panel.add((Component)new DescriptionTextArea(MessageFormat.format(msg, this.getArgument())), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 15, 0), 0, 0));
        }
        panel.add((Component)this.jLPolicyName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        Font font = this.policyNameTextArea.getFont();
        this.policyNameTextArea.setFont(font.deriveFont(1));
        panel.add((Component)this.policyNameTextArea, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        if (isReplace) {
            panel.add((Component)this.jLNewPolicyName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add(this.jCmbReplaced, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 20), 0, 0));
        }
        return panel;
    }

    private JPanel getTreePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.getBorderTitle()), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        panel.add((Component)this.getInfoPanel(), "North");
        JScrollPane jsPane = new JScrollPane(this.locationTree);
        jsPane.setPreferredSize(new Dimension(400, 200));
        panel.add((Component)jsPane, "Center");
        return panel;
    }

    private Box getInfoPanel() {
        JLabel caution = new JLabel(MSGRES.getString(EXPLORER, "PolicyApplyDialog.label.caution"));
        caution.setForeground(Color.RED);
        caution.setFont(UIFontUtilities.SUBTITLE_FONT);
        Box panel = Box.createVerticalBox();
        DescriptionTextArea infoDescription = new DescriptionTextArea(this.getInfo(), 2, 30);
        DescriptionTextArea warnDescription = new DescriptionTextArea(this.getWarn(), 1, 30);
        panel.add(infoDescription);
        panel.add(Box.createVerticalStrut(10));
        AjaxSwingCommonUtil.executeOneBasedOnWebConsoleRunning(() -> {
            infoDescription.setAlignmentX(1.0f);
            warnDescription.setAlignmentX(1.0f);
            JPanel cautionPanel = new JPanel(new BorderLayout());
            cautionPanel.add((Component)caution, "West");
            panel.add(cautionPanel);
        }, () -> panel.add(caution));
        panel.add(warnDescription);
        return panel;
    }

    private String getBorderTitle() {
        if (this.type.equals("apply")) {
            return MSGRES.getString(EXPLORER, "PolicyApplyDialog.title.applyTo");
        }
        if (this.type.equals("remove")) {
            return MSGRES.getString(EXPLORER, "PolicyApplyDialog.title.withdrawFrom");
        }
        return MSGRES.getString(EXPLORER, "PolicyApplyDialog.title.replaceHere");
    }

    private String getInfo() {
        return MessageFormat.format(this.getInfoMessage(), this.getArgument());
    }

    private String getInfoMessage() {
        if (this.type.equals("apply")) {
            if (this.licenseObject.isSBProduct()) {
                return APPLY_GROUP_INFO_SBE;
            }
            if (this.treeItem.getItemType() == 65 || this.treeItem.getItemType() == 148) {
                return APPLY_GROUP_INFO;
            }
            return APPLY_LOCATION_INFO;
        }
        if (this.type.equals("remove")) {
            if (this.licenseObject.isSBProduct()) {
                return REMOVE_GROUP_INFO_SBE;
            }
            if (this.treeItem.getItemType() == 65 || this.treeItem.getItemType() == 148) {
                return REMOVE_GROUP_INFO;
            }
            return REMOVE_LOCATION_INFO;
        }
        if (this.licenseObject.isSBProduct()) {
            return REPLACE_GROUP_INFO_SBE;
        }
        if (this.treeItem.getItemType() == 65 || this.treeItem.getItemType() == 148) {
            return REPLACE_GROUP_INFO;
        }
        return REPLACE_LOCATION_INFO;
    }

    private String getWarn() {
        return MessageFormat.format(this.getWarnMessage(), this.getArgument());
    }

    private String getWarnMessage() {
        if (this.type.equals("apply")) {
            if (this.treeItem.getItemType() == 65 || this.treeItem.getItemType() == 148 || this.licenseObject.isSBProduct()) {
                return APPLY_GROUP_WARN;
            }
            return APPLY_LOCATION_WARN;
        }
        if (this.type.equals("remove")) {
            if (this.treeItem.getItemType() == 65 || this.treeItem.getItemType() == 148 || this.licenseObject.isSBProduct()) {
                return REMOVE_GROUP_WARN;
            }
            return REMOVE_LOCATION_WARN;
        }
        if (this.treeItem.getItemType() == 65 || this.treeItem.getItemType() == 148 || this.licenseObject.isSBProduct()) {
            return REPLACE_GROUP_WARN;
        }
        return REPLACE_LOCATION_WARN;
    }

    protected void setData(ObjInfoObject[] infoObj) {
        boolean isReplace = this.type.equals("replace");
        Object[] obj = this.getArgument();
        String str = isReplace ? MSGRES.getString(EXPLORER, "PolicyApplyDialog.oldName") : MSGRES.getString(EXPLORER, "PolicyApplyDialog.name_");
        String label = MessageFormat.format(str, obj);
        this.jLPolicyName.setText(label);
        String policyName = this.treeItem != null ? this.treeItem.getName() : "";
        MonitorAgent.getInstance().startScenario(policyName + "_Assign_Dlg_Populate", "SEPM_Java");
        String eventId = MonitorAgent.getInstance().startEvent("UIRequest", null);
        this.policyNameTextArea.setText(policyName);
        if (isReplace && infoObj != null) {
            String str1 = MSGRES.getString(EXPLORER, "PolicyApplyDialog.newName_");
            String fm1 = MessageFormat.format(str1, obj);
            this.jLNewPolicyName.setText(fm1);
            this.initialReplacedPolicyComboBox(infoObj);
        }
        this.getGroupsAndLocations();
        MonitorAgent.getInstance().stopEvent(eventId);
        MonitorAgent.getInstance().stopScenario(policyName + "_Assign_Dlg_Populate");
    }

    private void getGroupsAndLocations() {
        String text = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.loadingMsg");
        this.locationTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(text)));
        SwingWorker worker = new SwingWorker(){
            private Exception exception = null;
            private TreeModel treeModel = null;

            public Object construct() {
                try {
                    this.treeModel = PolicyApplyDialog.this.getLocationTreeModel(PolicyApplyDialog.this.treeItem);
                }
                catch (Exception e) {
                    this.exception = e;
                }
                return null;
            }

            public void finished() {
                if (this.exception != null) {
                    String errorText = MessageResources.getInstance().getString(PolicyApplyDialog.EXPLORER, "PolicyApplyDialog.error.retrievingGroups");
                    String heading = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.errorMsg");
                    JOptionPane.showMessageDialog(Manager.getFrame(), errorText, heading, 0);
                    LoggerUtilities.logException((Throwable)this.exception);
                    return;
                }
                PolicyApplyDialog.this.locationTree.setModel(this.treeModel);
                PolicyApplyDialog.this.locationTree.setShowsRootHandles(true);
                AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
            }
        };
        worker.start();
    }

    private TreeModel getLocationTreeModel(TreeItem treeItem) {
        TreeItem policyObj = treeItem;
        if (treeItem instanceof ObjInfoObject) {
            policyObj = PolicyHelper.getPolicyObject((ObjInfoObject)treeItem);
        }
        if (this.viewGrpsOnly || LicenseObject.getInstance().isSBProduct()) {
            return PolicyUtil.getGroupTreeModel(policyObj, false, true);
        }
        return PolicyUtil.getLocTreeModel(policyObj, false, this.type.equals("apply"), true);
    }

    private Object[] getArgument() {
        switch (this.treeItem.getItemType()) {
            case 313: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.adaptivePolicy")};
            }
            case 43: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.firewallPolicy")};
            }
            case 56: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.hostIntegritypolicy")};
            }
            case 63: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.OSProtectionpolicy")};
            }
            case 60: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.policyManagerlist")};
            }
            case 144: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.liveUpdatePolicy")};
            }
            case 65: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.idsLibrary")};
            }
            case 143: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.idsPolicy")};
            }
            case 169: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.memPolicy")};
            }
            case 148: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.liveUpdateContentPolicy")};
            }
            case 134: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.antiVirusPolicy")};
            }
            case 128: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.policyOverride")};
            }
            case 137: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.tamperProtection")};
            }
            case 171: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.ntrPolicy")};
            }
            case 309: {
                return new Object[]{MSGRES.getString(EXPLORER, "PolicyApplyDialog.upgradePolicy")};
            }
        }
        return new Object[0];
    }

    private void initialReplacedPolicyComboBox(ObjInfoObject[] infoObj) {
        for (int i = 0; i < infoObj.length; ++i) {
            if (infoObj[i].getName().equals(this.treeItem.getName())) continue;
            this.jCmbReplaced.addItem(infoObj[i]);
        }
    }

    private boolean isValidData() {
        boolean isValid = true;
        String newName = null;
        ObjInfoObject objInfo = (ObjInfoObject)this.jCmbReplaced.getSelectedItem();
        if (objInfo != null) {
            newName = objInfo.getName();
            TreeItem treeItem = PolicyHelper.getPolicyObject(objInfo);
            try {
                PolicyObjectBase policyObjBase = (PolicyObjectBase)treeItem;
                if (policyObjBase instanceof MemPolicyObject && ((MemPolicyObject)policyObjBase).isExclusiveEdit()) {
                    JOptionPane.showMessageDialog(this, MSGRES.getString(EXPLORER, "PolicyApplyDialog.exclusiveEditSelectedPolicyMsg"), MSGRES.getString(EXPLORER, "PolicyPoolPane.message"), 1);
                    return false;
                }
            }
            catch (ClassCastException cce) {
                ConsoleLogger.log("PolicyApplyDialog >> isValidData(): Unable to cast " + cce.getMessage());
            }
        }
        if (this.type.equals("replace") && (newName == null || newName.equals(""))) {
            String str = MSGRES.getString(EXPLORER, "PolicyApplyDialog.invalidNewName");
            String fm = MessageFormat.format(str, this.getArgument());
            JOptionPane.showMessageDialog(this, MSGRES.getString(EXPLORER, "PolicyApplyDialog.pleaseEnterNewPolicyName"), fm, 0);
            isValid = false;
        }
        if (this.isEmptySelection()) {
            String selectableObject;
            String string = selectableObject = LicenseObject.getInstance().isSBProduct() ? MSGRES.getString(EXPLORER, "PolicyApplyDialog.groups") : MSGRES.getString(EXPLORER, "PolicyApplyDialog.groupsOrLocations");
            if (this.viewGrpsOnly) {
                selectableObject = MSGRES.getString(EXPLORER, "PolicyApplyDialog.groups");
            }
            Object[] obj = new Object[]{selectableObject};
            String str = MSGRES.getString(EXPLORER, "PolicyApplyDialog.pleaseSelectOneOrMore");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this, fm, MSGRES.getString(EXPLORER, "PolicyApplyDialog.emptySelection"), 0);
            isValid = false;
        }
        return isValid;
    }

    private boolean isEmptySelection() {
        TreeModel treeModel = this.locationTree.getModel();
        try {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)((DefaultTreeModel)treeModel).getRoot();
            if (parentNode == null) {
                return false;
            }
            ArrayList<TreeNode> nodeList = Collections.list(parentNode.breadthFirstEnumeration());
            Iterator nodeIt = nodeList.iterator();
            DefaultMutableTreeNode node = null;
            while (nodeIt.hasNext()) {
                AbstractSelectableUIObject selObj;
                node = (DefaultMutableTreeNode)nodeIt.next();
                Object obj = node.getUserObject();
                if (!(obj instanceof AbstractSelectableUIObject) || !(selObj = (AbstractSelectableUIObject)obj).isSelected()) continue;
                return false;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return true;
    }

    private ApplyMessageObject applyPolicy(TreeModel treeModel, TreeItem treeItem, String type, ObjInfoObject infoObj) {
        int itemType = treeItem.getItemType();
        switch (itemType) {
            case 43: 
            case 56: 
            case 63: 
            case 128: 
            case 134: 
            case 137: 
            case 143: 
            case 144: 
            case 169: 
            case 171: 
            case 309: 
            case 313: {
                return PolicyApplyHelper.applySharedPolicy(treeModel, (PolicyInt)((Object)treeItem), type, infoObj);
            }
            case 60: {
                return PolicyApplyHelper.applyServerList(treeModel, treeItem, type, infoObj);
            }
            case 65: {
                return PolicyApplyHelper.applyIPS(treeModel, treeItem, type, infoObj);
            }
            case 148: {
                return PolicyApplyHelper.applyLuContentPolicy(treeModel, treeItem, type, infoObj);
            }
        }
        return null;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        int itemType = this.treeItem.getItemType();
        switch (itemType) {
            case 43: 
            case 56: 
            case 63: 
            case 128: 
            case 134: 
            case 137: 
            case 143: 
            case 309: 
            case 313: {
                if (this.type.equals("apply")) {
                    return "sesm_policies_dialog_policy_apply";
                }
                if (this.type.equals("remove")) {
                    return "sesm_policies_dialog_policy_withdraw";
                }
                return "sesm_policies_dialog_policy_replace";
            }
            case 60: {
                if (this.type.equals("apply")) {
                    return "sesm_policies_dialog_endpoint_security_manager_list_apply";
                }
                return "sesm_policies_dialog_endpoint_security_manager_list_replace";
            }
            case 65: {
                if (this.type.equals("apply")) {
                    return "sesm_policies_dialog_policy_apply";
                }
                if (this.type.equals("remove")) {
                    return "sesm_policies_dialog_ids_library_withdraw";
                }
                return "sesm_policies_dialog_ids_library_replace";
            }
            case 144: 
            case 148: {
                if (this.type.equals("apply")) {
                    return "sesm_policies_dialog_policy_apply";
                }
                if (this.type.equals("remove")) {
                    return "sesm_policies_dialog_luc_withdraw";
                }
                return "sesm_policies_dialog_luc_replace";
            }
        }
        return null;
    }
}

