/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.common;

import com.sygate.scm.common.configobject.schema.IDS;
import com.sygate.scm.common.configobject.schema.Location;
import com.sygate.scm.common.configobject.schema.LuContentSelection;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemAgentPolicy;
import com.sygate.scm.common.configobject.schema.SemClientGroup;
import com.sygate.scm.common.configobject.schema.SemLocationConfig;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.CloudPolicyHandler;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractSelectableUIObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.CommunicationObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.QuarantineLocationObject;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.ConsoleOptions;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.explorer.common.LocationCheckBoxTree;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyObject;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.TimeCounter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PolicyUtil {
    private static final Logger logger = Logger.getLogger(PolicyUtil.class.getName());

    public static TreeModel getLocTreeModel() {
        try {
            DefaultMutableTreeNode parentNode = PolicyHandler.getGroupLocationTree();
            Enumeration enumeration = (Enumeration)Cast.cast(parentNode.breadthFirstEnumeration());
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)enumeration.nextElement();
                Object obj = aNode.getUserObject();
                if (!(obj instanceof AbstractSelectableUIObject)) continue;
                ((AbstractSelectableUIObject)obj).setDirectiveSelectable(PolicyUtil.isNodeSelectable(aNode));
            }
            return new DefaultTreeModel(parentNode);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyUtil.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
            return null;
        }
    }

    public static TreeModel getLocTreeModel(TreeItem treeItem, boolean isSelect, boolean considerIndirectSelectable, boolean excludeReadonly) {
        TimeCounter tcGetTree = new TimeCounter();
        ConsoleOptions options = ConsoleOptions.getInstance();
        try {
            TimeCounter tcGetObjInfoHashMap = new TimeCounter();
            HashMap<String, String> objInfoMap = AppliablePolicyPool.getObjInfoHashMap(treeItem.getItemType());
            logger.info("getObjInfoHashMap() " + tcGetObjInfoHashMap.toString());
            DefaultMutableTreeNode parentNode = null;
            TimeCounter tcGetGroupLocationTree = new TimeCounter();
            parentNode = options.isGetAllGroupLocationsEnabled() ? PolicyHandler.getGroupLocationTree(excludeReadonly) : PolicyHandler.getGroupLocationTree();
            logger.info("getGroupLocationTree() " + tcGetGroupLocationTree.toString());
            TimeCounter tcLocProp = new TimeCounter();
            String domainId = Manager.getCurrentDomainId();
            boolean cloudEnrolled = CloudUtil.isCloudEnrolled(domainId);
            List<DefaultMutableTreeNode> grpList = PolicyUtil.setLocationProperties((DefaultMutableTreeNode)parentNode.getRoot(), treeItem, isSelect, considerIndirectSelectable, objInfoMap, domainId, cloudEnrolled);
            logger.info("setLocationProperties() " + tcLocProp.toString());
            for (int i = 0; i < grpList.size(); ++i) {
                DefaultMutableTreeNode aNode = grpList.get(i);
                PolicyUtil.setPolicyGroupProperties(aNode, treeItem, isSelect);
            }
            PolicyUtil.removeGroupLeafNodeFromGroupLocationTree(parentNode, excludeReadonly);
            logger.info("getLocTreeModel() " + tcGetTree.toString());
            return new DefaultTreeModel(parentNode);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyUtil.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
            logger.info("getLocTreeModel() " + tcGetTree.toString());
            return null;
        }
    }

    public static TreeModel getGroupTreeModel() {
        return PolicyUtil.getGroupTreeModel(null, false);
    }

    public static TreeModel getGroupTreeModel(TreeItem policyObj, boolean isSelect) {
        return PolicyUtil.getGroupTreeModel(policyObj, isSelect, false);
    }

    public static TreeModel getGroupTreeModel(TreeItem policyObj, boolean isSelect, boolean excludeReadonly) {
        if (policyObj != null) {
            try {
                HashMap<String, String> objInfoMap = AppliablePolicyPool.getObjInfoHashMap(policyObj.getItemType());
                DefaultMutableTreeNode grpNode = GroupHandler.getGroupsRoot(true, excludeReadonly);
                if (grpNode == null) {
                    return new DefaultTreeModel(new DefaultMutableTreeNode(""));
                }
                Enumeration nodeEnumeration = (Enumeration)Cast.cast(grpNode.postorderEnumeration());
                ArrayList<DefaultMutableTreeNode> listNodes = new ArrayList<DefaultMutableTreeNode>();
                while (nodeEnumeration.hasMoreElements()) {
                    listNodes.add((DefaultMutableTreeNode)nodeEnumeration.nextElement());
                }
                for (DefaultMutableTreeNode aNode : listNodes) {
                    PolicyUtil.setGroupProperties(policyObj, aNode, isSelect, objInfoMap, excludeReadonly);
                }
                return new DefaultTreeModel(grpNode);
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyUtil.consoleError"), 0);
                Manager.getFrame().showLoginPanel();
            }
        }
        return null;
    }

    private static List<DefaultMutableTreeNode> setLocationProperties(DefaultMutableTreeNode node, TreeItem treeItem, boolean isSelect, boolean considerIndirectSelectable, HashMap<String, String> map, String domainId, boolean cloudEnrolled) throws ConsoleException {
        Enumeration nodeEnumeration = (Enumeration)Cast.cast(node.breadthFirstEnumeration());
        ArrayList<DefaultMutableTreeNode> grpList = new ArrayList<DefaultMutableTreeNode>();
        while (nodeEnumeration.hasMoreElements()) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)nodeEnumeration.nextElement();
            Object obj = aNode.getUserObject();
            if (obj instanceof LocationObject) {
                PolicyUtil.setLocationProperties((LocationObject)obj, treeItem, aNode, isSelect, considerIndirectSelectable, map, domainId, cloudEnrolled);
                continue;
            }
            if (!(obj instanceof GroupObject)) continue;
            if (treeItem.getItemType() == 60) {
                PolicyUtil.setServerListGroupProperties((GroupObject)obj, treeItem, aNode, isSelect, map);
                continue;
            }
            grpList.add(aNode);
        }
        return grpList;
    }

    private static void setLocationProperties(LocationObject locObj, TreeItem treeItem, DefaultMutableTreeNode aNode, boolean isSelect, boolean considerIndirectSelectable, HashMap<String, String> map, String domainId, boolean cloudEnrolled) throws ConsoleException {
        boolean updateObjectsBasedOnLocationObject = true;
        if (cloudEnrolled) {
            DefaultMutableTreeNode abc = (DefaultMutableTreeNode)aNode.getParent();
            GroupObject grpObj = (GroupObject)abc.getUserObject();
            SemClientGroup semClientGroup = grpObj.getSemClientGroup();
            int policyType = treeItem.getItemType();
            GUID domainGuid = new GUID(domainId);
            String policyId = treeItem.getId();
            CloudPolicyHandler cloudPolicyHandler = CloudPolicyHandler.getInstance();
            if (169 == policyType) {
                ObjReference cloudMemPolicy = cloudPolicyHandler.getPolicyFromCloudAppliedPolicyArray(semClientGroup, domainGuid, "MemPolicy", null, true);
                if (cloudMemPolicy != null) {
                    updateObjectsBasedOnLocationObject = false;
                    if (cloudMemPolicy.getTargetId().equals(policyId)) {
                        PolicyUtil.setLocationPropertiesForCloudPolicyAppliedLocation(locObj, considerIndirectSelectable, cloudMemPolicy, map);
                    }
                }
            } else if (308 == policyType) {
                ObjReference externalTdadPolicy = cloudPolicyHandler.getPolicyFromCloudAppliedPolicyArray(semClientGroup, domainGuid, "TdadPolicy", null, true);
                if (externalTdadPolicy != null) {
                    updateObjectsBasedOnLocationObject = false;
                    if (externalTdadPolicy.getTargetId().equals(policyId)) {
                        PolicyUtil.setLocationPropertiesForCloudPolicyAppliedLocation(locObj, considerIndirectSelectable, externalTdadPolicy, map);
                    }
                }
            } else if (128 == policyType) {
                ObjReference cloudExceptionsWhitelistPolicy = cloudPolicyHandler.getPolicyFromCloudAppliedPolicyArray(semClientGroup, domainGuid, "PolicyOverride", "WhiteList", true);
                if (cloudExceptionsWhitelistPolicy != null && cloudExceptionsWhitelistPolicy.getTargetId().equals(policyId)) {
                    PolicyUtil.setLocationPropertiesForCloudPolicyAppliedLocation(locObj, considerIndirectSelectable, cloudExceptionsWhitelistPolicy, map);
                    updateObjectsBasedOnLocationObject = false;
                } else {
                    ObjReference cloudExceptionsBlacklistPolicy = cloudPolicyHandler.getPolicyFromCloudAppliedPolicyArray(semClientGroup, domainGuid, "PolicyOverride", "BlackList", true);
                    if (cloudExceptionsBlacklistPolicy != null && cloudExceptionsBlacklistPolicy.getTargetId().equals(policyId)) {
                        PolicyUtil.setLocationPropertiesForCloudPolicyAppliedLocation(locObj, considerIndirectSelectable, cloudExceptionsBlacklistPolicy, map);
                        updateObjectsBasedOnLocationObject = false;
                    }
                }
            }
        }
        if (updateObjectsBasedOnLocationObject) {
            PolicyUtil.setLocationSelectableProperty(locObj, treeItem, aNode, considerIndirectSelectable);
            PolicyUtil.setLocationOtherProperties(locObj, treeItem, aNode, isSelect, map);
            PolicyUtil.setQuarantineProperties(locObj, treeItem, aNode, isSelect, map);
        }
    }

    private static void setLocationPropertiesForCloudPolicyAppliedLocation(LocationObject locObj, boolean considerIndirectSelectable, ObjReference cloudPolicy, HashMap<String, String> map) {
        locObj.setIndirectiveSelectable(considerIndirectSelectable);
        locObj.setApplied(true);
        locObj.setCurrentPolicy(true);
        String name = map.get(cloudPolicy.getTargetId());
        locObj.setAppliedPolicyName(name == null ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyUtil.local") : name);
        locObj.setSelected(false);
    }

    private static void setLocationSelectableProperty(LocationObject locObj, TreeItem treeItem, DefaultMutableTreeNode aNode, boolean considerIndirectSelectable) {
        if (considerIndirectSelectable) {
            locObj.setIndirectiveSelectable(PolicyUtil.isNodeIndirectSelectable(aNode, treeItem));
        }
        if (!(treeItem instanceof PolicyInt) && locObj.getCommunicationObject().getCommunication() == null) {
            locObj.setDirectiveSelectable(false);
        }
    }

    private static void setLocationOtherProperties(LocationObject locObj, TreeItem policy, DefaultMutableTreeNode aNode, boolean isSelect, HashMap<String, String> map) throws ConsoleException {
        String appliedId = null;
        if (policy instanceof PolicyInt) {
            appliedId = locObj.getAppliedPolicyObject().getAppliedPolicyId(policy.getItemType());
        } else {
            CommunicationObject comObj = locObj.getCommunicationObject();
            if (comObj.getCommunication() != null) {
                ServerListObject slList = comObj.getServerList();
                if (slList != null) {
                    appliedId = slList.getId();
                }
            } else {
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)aNode.getParent();
                GroupObject grp = (GroupObject)parentNode.getUserObject();
                PolicyUtil.copyProperties(locObj, grp);
                return;
            }
        }
        boolean isApplied = appliedId != null;
        locObj.setApplied(isApplied);
        if (isApplied) {
            String name = map.get(appliedId);
            locObj.setAppliedPolicyName(name == null ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyUtil.local") : name);
            locObj.setCurrentPolicy(appliedId.equals(policy.getId()));
        }
        if (isSelect) {
            locObj.setSelected(isApplied);
        }
    }

    private static void setPolicyGroupProperties(DefaultMutableTreeNode node, TreeItem treeItem, boolean isSelect) {
        GroupObject grpObj = (GroupObject)node.getUserObject();
        boolean areAllChildrenApplied = true;
        boolean doesAllChildrenHasCurrentPolicy = true;
        TreePath[] treePaths = LocationCheckBoxTree.getAllPaths(node);
        DefaultMutableTreeNode childNode = null;
        for (int i = 0; i < treePaths.length; ++i) {
            childNode = (DefaultMutableTreeNode)treePaths[i].getLastPathComponent();
            Object obj = childNode.getUserObject();
            if (!(obj instanceof LocationObject)) continue;
            areAllChildrenApplied = ((LocationObject)obj).isApplied();
            boolean bl = doesAllChildrenHasCurrentPolicy = doesAllChildrenHasCurrentPolicy && ((LocationObject)obj).isCurrentPolicy();
            if (!areAllChildrenApplied) break;
        }
        grpObj.setCurrentPolicy(doesAllChildrenHasCurrentPolicy);
        grpObj.setApplied(areAllChildrenApplied);
        if (isSelect) {
            grpObj.setSelected(areAllChildrenApplied);
        }
    }

    private static void setServerListGroupProperties(GroupObject grpObj, TreeItem treeItem, DefaultMutableTreeNode aNode, boolean isSelect, HashMap<String, String> map) throws ConsoleException {
        if (!PolicyHandler.isGroupInherit(grpObj)) {
            String appliedId = PolicyUtil.getAppliedServerListId(grpObj);
            boolean isApplied = appliedId != null;
            grpObj.setApplied(isApplied);
            if (isApplied) {
                String name = map.get(appliedId);
                grpObj.setAppliedPolicyName(name == null ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyUtil.local") : name);
                grpObj.setCurrentPolicy(appliedId.equals(treeItem.getId()));
            }
            if (isSelect) {
                grpObj.setSelected(isApplied);
            }
        } else {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)aNode.getParent();
            GroupObject grp = (GroupObject)parentNode.getUserObject();
            PolicyUtil.copyProperties(grpObj, grp);
        }
    }

    private static void setGroupProperties(TreeItem treeItem, DefaultMutableTreeNode aNode, boolean isSelect, HashMap<String, String> map, boolean excludeReadonly) throws ConsoleException {
        if (LicenseObject.getInstance().isSBProduct()) {
            PolicyUtil.setSBGroupProperties(treeItem, aNode, isSelect, map);
        } else if (treeItem instanceof IdsLibraryObject || treeItem instanceof IdsPolicyObject) {
            PolicyUtil.setIPSGroupProperties(treeItem, aNode, isSelect, map);
        } else {
            PolicyUtil.setLUGroupProperties(treeItem, aNode, isSelect, map, excludeReadonly);
        }
    }

    private static void setSBGroupProperties(TreeItem treeItem, DefaultMutableTreeNode aNode, boolean isSelect, HashMap<String, String> map) throws ConsoleException {
        GroupObject grpObj = (GroupObject)aNode.getUserObject();
        grpObj.setInherited(PolicyHandler.isGroupInherit(grpObj));
        grpObj.setDirectiveSelectable(PolicyUtil.isNodeSelectable(aNode));
        SemAgentPolicy policy = PolicyHandler.getSemAgentPolicyByGroupFromDB(grpObj);
        Location location = policy.getAutoLocation().getLocationArray().getLocation(0);
        String apGUID = null;
        ObjReference objRef = PolicyHandler.getSemALocationReference(location);
        apGUID = objRef.getTargetId();
        SemLocationConfig config = (SemLocationConfig)PolicyHandler.getObjectFromDB("SemLocationConfig", apGUID);
        Vector appliedPolicies = config.getOptAppliedPolicyArray().getChildren();
        int j = 0;
        for (j = 0; j < appliedPolicies.size() && !((ObjReference)appliedPolicies.get(j)).getTargetId().equals(treeItem.getId()); ++j) {
        }
        boolean isApplied = j != appliedPolicies.size();
        grpObj.setApplied(isApplied);
        if (isApplied) {
            grpObj.setAppliedPolicyName(map.get(treeItem.getId()));
            grpObj.setCurrentPolicy(true);
        }
        if (isSelect) {
            grpObj.setSelected(isApplied);
        }
    }

    private static void setIPSGroupProperties(TreeItem treeItem, DefaultMutableTreeNode aNode, boolean isSelect, HashMap<String, String> map) throws ConsoleException {
        GroupObject grpObj = (GroupObject)aNode.getUserObject();
        grpObj.setInherited(PolicyHandler.isGroupInherit(grpObj));
        grpObj.setDirectiveSelectable(PolicyUtil.isNodeSelectable(aNode));
        List<String> ids = PolicyUtil.getAppliedIDSIds(grpObj);
        boolean isApplied = ids.size() > 0;
        grpObj.setApplied(isApplied);
        if (isApplied) {
            StringBuffer names = new StringBuffer();
            boolean isCurrent = false;
            for (int i = 0; i < ids.size(); ++i) {
                String id = ids.get(i);
                String name = map.get(id);
                if (i > 0) {
                    names.append(", ");
                }
                names.append(name == null ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyUtil.local") : name);
                if (treeItem == null) continue;
                isCurrent |= id.equals(treeItem.getId());
            }
            grpObj.setAppliedPolicyName(names.toString());
            grpObj.setCurrentPolicy(isCurrent);
        }
        if (isSelect) {
            grpObj.setSelected(isApplied);
        }
    }

    private static void setLUGroupProperties(TreeItem treeItem, DefaultMutableTreeNode aNode, boolean isSelect, HashMap<String, String> map, boolean excludeReadonly) throws ConsoleException {
        String id = null;
        GroupObject grpObj = (GroupObject)aNode.getUserObject();
        boolean hasAccess = grpObj.canDirectiveSelectable();
        boolean isInherited = PolicyHandler.isGroupInherit(grpObj);
        grpObj.setInherited(isInherited);
        grpObj.setDirectiveSelectable(hasAccess && !isInherited);
        grpObj.setIndirectiveSelectable(PolicyUtil.getRecursiveIndirectiveSelectableForReadonlyGroups(aNode));
        SemAgentPolicy policy = PolicyHandler.getSemAgentPolicyByGroupFromDB(grpObj);
        LuContentSelection luSelect = policy.getOptLuContentSelection();
        if (luSelect != null) {
            id = luSelect.getObjReference().getTargetId();
        }
        boolean isApplied = id != null;
        grpObj.setApplied(isApplied);
        if (isApplied) {
            if (id.equals(treeItem.getId())) {
                grpObj.setAppliedPolicyName(map.get(id));
                grpObj.setCurrentPolicy(true);
            } else if (!excludeReadonly && aNode.getChildCount() == 0) {
                aNode.removeFromParent();
                aNode.removeAllChildren();
                aNode.setUserObject(null);
                return;
            }
        }
        if (isSelect) {
            grpObj.setSelected(isApplied);
        }
    }

    public static boolean getRecursiveIndirectiveSelectableForReadonlyGroups(DefaultMutableTreeNode aNode) {
        GroupObject grpObj = (GroupObject)aNode.getUserObject();
        if (aNode.getParent() == null || !grpObj.isInherited()) {
            return grpObj.canDirectiveSelectable();
        }
        return PolicyUtil.getRecursiveIndirectiveSelectableForReadonlyGroups((DefaultMutableTreeNode)aNode.getParent());
    }

    private static void setQuarantineProperties(LocationObject locObj, TreeItem policy, DefaultMutableTreeNode aNode, boolean isSelect, HashMap<String, String> map) throws ConsoleException {
        boolean isApplied;
        AppliedPolicyObject appliedObj = locObj.getAppliedPolicyObject();
        if (policy.getItemType() == 56 || appliedObj.getAppliedPolicyId(56) == null) {
            return;
        }
        String id = PolicyUtil.getAppliedQuarantinePolicyId(policy, appliedObj);
        boolean bl = isApplied = id != null;
        if (!isApplied) {
            return;
        }
        QuarantineLocationObject qtObj = new QuarantineLocationObject(locObj.getClone().getLocationObject());
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)aNode.getParent();
        if (parentNode.getUserObject() instanceof GroupObject) {
            qtObj.setDirectiveSelectable(!((GroupObject)parentNode.getUserObject()).isInherited());
        } else {
            qtObj.setDirectiveSelectable(PolicyUtil.isNodeSelectable(aNode));
        }
        qtObj.setApplied(isApplied);
        String name = map.get(id);
        qtObj.setAppliedPolicyName(name == null ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyUtil.local") : name);
        qtObj.setCurrentPolicy(id.equals(policy.getId()));
        if (isSelect) {
            qtObj.setSelected(isApplied);
        }
        aNode.add(new DefaultMutableTreeNode(qtObj));
    }

    private static String getAppliedQuarantinePolicyId(TreeItem policy, AppliedPolicyObject appliedObj) throws ConsoleException {
        String id = null;
        if (policy.getItemType() == 134) {
            id = appliedObj.getAppliedPolicyId(153);
            if (id == null) {
                id = appliedObj.getAppliedPolicyId(154);
            }
        } else if (policy.getItemType() == 43) {
            id = appliedObj.getAppliedPolicyId(121);
            if (id == null) {
                id = appliedObj.getAppliedPolicyId(122);
            }
        } else if (policy.getItemType() == 63) {
            id = appliedObj.getAppliedPolicyId(123);
            if (id == null) {
                id = appliedObj.getAppliedPolicyId(124);
            }
        } else if (policy.getItemType() == 128) {
            id = appliedObj.getAppliedPolicyId(157);
            if (id == null) {
                id = appliedObj.getAppliedPolicyId(158);
            }
        } else if (policy.getItemType() == 144) {
            id = appliedObj.getAppliedPolicyId(155);
            if (id == null) {
                id = appliedObj.getAppliedPolicyId(156);
            }
        } else if (policy.getItemType() == 143) {
            id = appliedObj.getAppliedPolicyId(161);
            if (id == null) {
                id = appliedObj.getAppliedPolicyId(162);
            }
        } else if (policy.getItemType() == 171) {
            id = appliedObj.getAppliedPolicyId(173);
            if (id == null) {
                id = appliedObj.getAppliedPolicyId(174);
            }
        } else if (policy.getItemType() == 309 && (id = appliedObj.getAppliedPolicyId(311)) == null) {
            id = appliedObj.getAppliedPolicyId(312);
        }
        return id;
    }

    private static String getAppliedServerListId(GroupObject grpObj) throws ConsoleException {
        GroupPolicyObject gpObject = PolicyHandler.getGroupPolicyByGroupFromDB(grpObj);
        return gpObject.getCommunicationObject().getServerListId();
    }

    public static List<String> getAppliedIDSIds(GroupObject grpObj) throws ConsoleException {
        ArrayList<String> appliedIds = new ArrayList<String>();
        SemAgentPolicy policy = PolicyHandler.getSemAgentPolicyByGroupFromDB(grpObj);
        IDS ids = policy.getOptIDS();
        if (ids != null) {
            for (ObjReference objReference : ids.getObjReference()) {
                appliedIds.add(objReference.getTargetId());
            }
        }
        return appliedIds;
    }

    private static boolean isNodeSelectable(DefaultMutableTreeNode node) {
        Object userObj = node.getUserObject();
        if (!(userObj instanceof GroupObject)) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
            userObj = parentNode.getUserObject();
        }
        return !PolicyHandler.isGroupInherit((GroupObject)userObj);
    }

    private static boolean isNodeIndirectSelectable(DefaultMutableTreeNode node, TreeItem treeItem) {
        Object userObj = node.getUserObject();
        if (userObj instanceof LocationObject) {
            boolean isInClientMode = ((LocationObject)userObj).getUserInterfaceObject().getMode() == 0;
            boolean isFirewallPolicy = treeItem.getItemType() == 43;
            return !isInClientMode || !isFirewallPolicy;
        }
        return true;
    }

    private static void copyProperties(AbstractSelectableUIObject to, AbstractSelectableUIObject from) {
        to.setApplied(from.isApplied());
        to.setAppliedPolicyName(from.getAppliedPolicyName());
        to.setCurrentPolicy(from.isCurrentPolicy());
        to.setSelected(from.isSelected());
    }

    public static void removeGroupLeafNodeFromGroupLocationTree(DefaultMutableTreeNode rootNode, boolean excludeReadonly) {
        if (rootNode == null || rootNode.getChildCount() == 0) {
            return;
        }
        Enumeration enumeration = (Enumeration)Cast.cast(rootNode.breadthFirstEnumeration());
        ArrayList<DefaultMutableTreeNode> leaves = new ArrayList<DefaultMutableTreeNode>();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(node.getUserObject() instanceof LocationObject)) continue;
            leaves.add(node);
        }
        block1: for (DefaultMutableTreeNode node : leaves) {
            DefaultMutableTreeNode parent = null;
            while (node != null) {
                parent = (DefaultMutableTreeNode)node.getParent();
                if (node.getUserObject() instanceof LocationObject) {
                    LocationObject location = (LocationObject)node.getUserObject();
                    if (parent.getUserObject() instanceof LocationObject) continue block1;
                    GroupObject grpObj = (GroupObject)parent.getUserObject();
                    int grpAccessConstraint = grpObj.getAccessConstraint();
                    if (excludeReadonly) {
                        if (1 != grpAccessConstraint && 2 != grpAccessConstraint) continue block1;
                        node.removeFromParent();
                        node = parent;
                        continue;
                    }
                    boolean isApplied = location.isCurrentPolicy();
                    if ((!isApplied || 1 != grpAccessConstraint) && isApplied) continue block1;
                    node.removeFromParent();
                    node = parent;
                    continue;
                }
                if (!(node.getUserObject() instanceof GroupObject)) continue;
                if (node.getChildCount() != 0) continue block1;
                node.removeFromParent();
                node = parent;
            }
        }
        if (rootNode.getChildCount() == 0) {
            rootNode.setUserObject(null);
        }
    }
}

