/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.common;

import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.sepm.ajaxswing.support.ComponentUtils;
import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.MemPolicyObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.policy.HistoryPane;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.common.AppliablePolicy;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.common.ExplorerConstants;
import com.sygate.scm.console.ui.policy.explorer.common.dlg.LearnApplicationDialog;
import com.sygate.scm.console.ui.policy.explorer.common.dlg.ShowPolicyApplyDialog;
import com.sygate.scm.console.ui.policy.override.logicobject.OverridePolicyObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.SwingWorkerExecutor;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.ui.util.TaskPanelBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.ExceptionHandler;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.MessageHandler;
import com.sygate.scm.console.util.MessageListener;
import com.sygate.scm.console.util.StatPingConsole;
import com.sygate.scm.console.util.TopicEvent;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public abstract class PolicyPoolPane
extends TaskPanelBase
implements ExplorerConstants,
MessageListener,
TaskPanel,
ContentSensitiveHelpPage,
FileOpener {
    private static final long serialVersionUID = 1L;
    private static final String AUTOMATION_POLICY_COLUMN_NAME = "ColumnPolicyName";
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");
    private static final String[] TABLE_COLUMN_NAME = new String[]{MSG_RES.getString("PolicyPoolPane.column.name"), MSG_RES.getString("PolicyPoolPane.column.description"), MSG_RES.getString(LicenseObject.getInstance().isSBProduct() ? "PolicyPoolPane.column.usingPolicyForSB" : "PolicyPoolPane.column.usingPolicy")};
    private static final float[] TABLE_WIDTHS = new float[]{0.3f, 0.5f, 0.2f};
    protected String title;
    private JTable jTPolicy;
    private HistoryPane historyPanel = new HistoryPane(true);
    private int osSpecificPolicyIdentifier = 1;
    protected boolean isCloudEnrolled = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        BasePolicyHandler handler = BasePolicyHandler.getInstance(this.getPolicyItemType());
        StatPingConsole.getInstance().logReportHits(18701, this);
        try {
            if (taskIndex == 0) {
                AppliablePolicyPool pool = this.updateObject();
                handler.addPolicy(pool, this);
            } else if (taskIndex == 1) {
                handler.importPolicy(this);
            } else if (taskIndex == 14) {
                new LearnApplicationDialog();
            } else if (taskIndex == 10) {
                handler.pastePolicy(this);
            } else {
                PolicyObjectBase policyObj = this.getSelectedPolicyObj();
                if (policyObj == null) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyPoolPane.policyDeleted"), MSG_RES.getString("PolicyPoolPane.message"), 0);
                    return;
                }
                if (taskIndex == 3) {
                    AppliablePolicyPool pool = this.updateObject();
                    handler.editPolicy(this, pool, policyObj);
                } else if (taskIndex == 4) {
                    handler.deletePolicy(this, policyObj);
                } else if (taskIndex == 5) {
                    handler.exportPolicy(this, policyObj);
                } else if (taskIndex == 6) {
                    handler.applyPolicy(policyObj);
                    this.invalidateAppliablePolicyPool();
                    this.refresh();
                } else if (taskIndex == 7) {
                    handler.withdrawPolicy(policyObj);
                    this.invalidateAppliablePolicyPool();
                    this.refresh();
                } else if (taskIndex == 8) {
                    handler.replacePolicy(policyObj);
                } else if (taskIndex == 9) {
                    PolicyHandler.copyObject(policyObj);
                    MainPanel.getCurrentPanel().valueChanged(new ListSelectionEvent(taskIndex, taskIndex, taskIndex, true));
                } else if (taskIndex == 11) {
                    new ShowPolicyApplyDialog(policyObj);
                }
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("PolicyPoolPane.consoleError"), 0);
        }
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
        DefaultListSelectionModel selModel = (DefaultListSelectionModel)this.getPolicyTable().getSelectionModel();
        ListSelectionListener[] listeners = selModel.getListSelectionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (listener != listeners[i]) continue;
            return;
        }
        selModel.addListSelectionListener(listener);
    }

    @Override
    public void refresh() {
        this.updateObject();
    }

    @Override
    public void handleMessage(TopicEvent topicEvt) {
        AppliablePolicy msgObj = (AppliablePolicy)topicEvt.getMessage();
        if (!this.needHandleMessage(msgObj)) {
            return;
        }
        this.updateObject();
        String topic = topicEvt.getTopic();
        if (topic.equals("added")) {
            TopicEvent topicEvt1 = new TopicEvent(this, "selectnode", msgObj);
            MessageHandler.getInstance().sendMessage(topicEvt1);
        }
    }

    public AppliablePolicyPool updateObject() {
        try {
            System.out.println("PolicyPoolPane> updateObject>> getPolicyItemType: " + this.getPolicyItemType());
            AppliablePolicyPool pool = AppliablePolicyPool.getPolicyPoolObject(this.getPolicyItemType());
            System.out.println("PolicyPoolPane> updateObject>> pool: " + pool);
            ObjInfoObject[] infoObjs = pool.getInfoObjectList();
            this.updateAppliedLocation(infoObjs);
            this.setChangeHistoryObject(this.getAllPolicyIds(infoObjs));
            return pool;
        }
        catch (ConsoleException ex) {
            System.out.println("PolicyPoolPane> updateObject>> Error while updating policy pool. Exception: " + ex.getMessage());
            LoggerUtilities.logException((Throwable)ex);
            System.out.println("PolicyPoolPane> updateObject>> Error while updating policy pool, stopping all threads and logging out.");
            GUIManager.stopAllBackgroupThreads();
            ExceptionHandler.handleConsoleException(ex, "com.sygate.scm.console.util.consoleutil", "DataobjectManager.msg.information");
            return null;
        }
    }

    public void openFile(File file) {
        BasePolicyHandler handler = BasePolicyHandler.getInstance(this.getPolicyItemType());
        try {
            handler.importPolicy(this, file);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("PolicyPoolPane.consoleError"), 0);
        }
    }

    protected boolean policyInUse() {
        boolean inUse;
        ObjInfoObject infoObj = this.getSelectedPolicyInfoObj();
        boolean bl = inUse = infoObj.getAppliedCount() > 0 || infoObj.getAppliedCount() == -1;
        if (inUse) {
            String msg = "";
            switch (infoObj.getItemType()) {
                case 60: {
                    msg = MSG_RES.getString("PolicyPoolPane.useOtherServerList");
                    break;
                }
                case 148: {
                    msg = MSG_RES.getString("PolicyPoolPane.replaceInGroupsBeforeDelete");
                    break;
                }
                case 65: {
                    msg = MSG_RES.getString("PolicyPoolPane.withdrawFromGroupsBeforeDelete");
                    break;
                }
                case 134: 
                case 144: {
                    msg = MSG_RES.getString(LicenseObject.getInstance().isSBProduct() ? "PolicyPoolPane.replaceInGroupsBeforeDelete" : "PolicyPoolPane.replaceInLocationsBeforeDelete");
                    break;
                }
                default: {
                    msg = MSG_RES.getString(LicenseObject.getInstance().isSBProduct() ? "PolicyPoolPane.replaceInGroupsBeforeDelete" : "PolicyPoolPane.withdrawFromLocationsBeforeDelete");
                }
            }
            String title = MSG_RES.getString("PolicyPoolPane.message.title.error");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, title, 0);
        }
        return inUse;
    }

    @Override
    protected Component getContentPanel() {
        JComponent tablePanel = this.getTablePanel();
        tablePanel.setMinimumSize(new Dimension(tablePanel.getMinimumSize().width, 30));
        this.historyPanel.setMinimumSize(new Dimension(this.historyPanel.getMinimumSize().width, 30));
        JSplitPane pane = new JSplitPane(0);
        pane.add((Component)tablePanel, "top");
        pane.add((Component)this.historyPanel, "bottom");
        pane.setResizeWeight(0.83);
        this.addListeners();
        return pane;
    }

    @Override
    protected String getTitleName() {
        return this.title;
    }

    protected void setChangeHistoryObject(List<String> list) {
        this.historyPanel.setObject(list);
    }

    protected void updateHistory() {
        this.historyPanel.updatePanel();
    }

    protected void setColumnRenderers(JTable thisTable) {
        for (int i = 0; i < this.getTableColumnNames().length; ++i) {
            if (!this.getTableColumnNames()[i].equals(MSG_RES.getString("PolicyPoolPane.column.name"))) continue;
            thisTable.getColumnModel().getColumn(i).setCellRenderer(new PolicyNameTableCellRenderer());
            return;
        }
    }

    protected String[] getTableColumnNames() {
        return TABLE_COLUMN_NAME;
    }

    protected float[] getTableColumnWidths() {
        return TABLE_WIDTHS;
    }

    protected JComponent getTablePanel() {
        return this.getTablePanel(this.getPolicyTable());
    }

    protected JComponent getTablePanel(JTable table) {
        JScrollPane pane = UIUtilities.createScrollPaneWithoutBoard(table);
        pane.getViewport().addMouseListener(new PolicyTableCellListener());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)pane, "Center");
        return pane;
    }

    protected JTable getPolicyTable() {
        if (this.jTPolicy == null) {
            try {
                this.jTPolicy = this.createPolicyTable(this.getTableColumnNames(), this.getInfoObjListFromPool());
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return this.jTPolicy;
    }

    protected JTable createPolicyTable(String[] columnNames, ObjInfoObject[] objInfos) {
        SortableTableModel model = new SortableTableModel();
        model.setColumnNames(columnNames);
        model.setDataVector(new Vector<TableRow>(Arrays.asList(objInfos)));
        StripesTable table = new StripesTable(model, true, true);
        model.addMouseListenerToHeaderInTable((JTable)((Object)table));
        ((Component)((Object)table)).addMouseListener(new PolicyTableCellListener());
        ((JTable)((Object)table)).getSelectionModel().setSelectionMode(0);
        UIUtilities.setTableColumnWidth((JTable)((Object)table), this.getTableColumnWidths(), (int)((JTable)((Object)table)).getPreferredScrollableViewportSize().getWidth());
        this.setColumnRenderers((JTable)((Object)table));
        return table;
    }

    protected ObjInfoObject[] getInfoObjListFromPool() throws ConsoleException {
        return AppliablePolicyPool.getPolicyPoolObject(this.getPolicyItemType()).getInfoObjectList();
    }

    protected abstract List<String> getAllIdFromPool() throws ConsoleException;

    protected abstract boolean needHandleMessage(AppliablePolicy var1);

    protected abstract String getPolicyId(Object var1);

    protected abstract int getPolicyItemType();

    protected abstract int getQuarantinePolicyItemType();

    protected JMenuItem createAddMenuItem() {
        JMenuItem add = new JMenuItem(UIText.get(5));
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyPoolPane.this.executeTask(0, null);
            }
        });
        return add;
    }

    protected boolean getAppliable() {
        return true;
    }

    private void addListeners() {
        MessageHandler msgHandler = MessageHandler.getInstance();
        msgHandler.addListener("added", this);
        msgHandler.addListener("deleted", this);
        msgHandler.addListener("edited", this);
        msgHandler.addListener("applied", this);
    }

    private ObjInfoObject getSelectedPolicyInfoObj() {
        int selRow = this.getPolicyTable().getSelectedRow();
        if (selRow == -1) {
            return null;
        }
        SortableTableModel model = (SortableTableModel)this.getPolicyTable().getModel();
        return (ObjInfoObject)model.getRow(selRow);
    }

    public PolicyObjectBase getSelectedPolicyObj() {
        ObjInfoObject infoObj = this.getSelectedPolicyInfoObj();
        if (infoObj == null) {
            return null;
        }
        return (PolicyObjectBase)PolicyHelper.getPolicyObject(infoObj);
    }

    private void retreveTableSelection(ObjInfoObject infoObj) {
        if (infoObj == null) {
            return;
        }
        SortableTableModel model = (SortableTableModel)this.getPolicyTable().getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            ObjInfoObject info = (ObjInfoObject)model.getRow(i);
            if (!infoObj.getId().equals(info.getId())) continue;
            this.getPolicyTable().setRowSelectionInterval(i, i);
            break;
        }
    }

    private void invalidateAppliablePolicyPool() throws Exception {
        AppliablePolicyPool pool = AppliablePolicyPool.getPolicyPoolObject(this.getPolicyItemType());
        ObjInfoObject[] infoObjs = pool.getInfoObjectList();
        for (int i = 0; i < infoObjs.length; ++i) {
            infoObjs[i].setAppliedCount(-1);
        }
        SortableTableModel model = (SortableTableModel)this.getPolicyTable().getModel();
        model.setDataVector(new Vector<TableRow>(Arrays.asList(infoObjs)));
        model.fireTableDataChanged();
    }

    private void updateAppliedLocation(final ObjInfoObject[] infoObj) {
        SwingWorker<HashMap<String, Integer>, Void> swingWorker = new SwingWorker<HashMap<String, Integer>, Void>(){

            @Override
            protected HashMap<String, Integer> doInBackground() throws Exception {
                AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().setUpdateBrowserInterval(2));
                return DataobjectManager.getInstance().getPoliciesAppliedCount(PolicyPoolPane.this.getAllPolicyIds(infoObj));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    HashMap appMap = (HashMap)this.get();
                    if (appMap != null) {
                        for (int i = 0; i < infoObj.length; ++i) {
                            Integer count = (Integer)appMap.get(infoObj[i].getId());
                            infoObj[i].setAppliedCount(count == null ? 0 : count);
                        }
                    }
                    ObjInfoObject selInfoObj = PolicyPoolPane.this.getSelectedPolicyInfoObj();
                    SortableTableModel model = (SortableTableModel)PolicyPoolPane.this.getPolicyTable().getModel();
                    model.setDataVector(new Vector<TableRow>(Arrays.asList(infoObj)));
                    model.fireTableDataChanged();
                    PolicyPoolPane.this.retreveTableSelection(selInfoObj);
                    model.sortTable(model.getSortedColumn(), model.getIsAscending());
                    AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)PolicyPoolPane.this.getPolicyTable(), true));
                }
                catch (InterruptedException ie) {
                    System.out.println("PolicyPoolPane> updateAppliedLocation>> InterruptedException: " + ie.getMessage());
                    return;
                }
                catch (CancellationException ce) {
                    System.out.println("PolicyPoolPane> updateAppliedLocation>> CancellationException: " + ce.getMessage());
                    return;
                }
                catch (Exception ex) {
                    System.out.println("PolicyPoolPane> updateAppliedLocation>>" + ex.getMessage());
                    if (ex instanceof ConsoleException && ((ConsoleException)ex).needRelogin()) {
                        return;
                    }
                    String errorText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.appliedCountError");
                    JOptionPane.showMessageDialog(Manager.getFrame(), errorText, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.errorMsg"), 0);
                    LoggerUtilities.logException((Throwable)ex);
                    return;
                }
                finally {
                    AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)0);
                }
            }
        };
        SwingWorkerExecutor.getInstance().execute(swingWorker);
    }

    private List<String> getAllPolicyIds(ObjInfoObject[] infoObjs) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < infoObjs.length; ++i) {
            ids.add(infoObjs[i].getId());
        }
        return ids;
    }

    @Override
    public int getTableSelectedItem() {
        if (this.getPolicyTable().getSelectedRow() == -1) {
            return -1;
        }
        return this.getPolicyItemType();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_pane_overview";
    }

    @Override
    public void setTitle(String newtitle) {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            Object[] obj = new Object[]{newtitle};
            String str = MSG_RES.getString("PolicyPoolPane.readOnlyTitle");
            this.title = MessageFormat.format(str, obj);
        } else {
            this.title = newtitle;
        }
        this.updateTitle(this.title);
    }

    public void setosSpecificPolicyIdentifier(int policyIdentifier) {
        this.osSpecificPolicyIdentifier = policyIdentifier;
    }

    public int getosSpecificPolicyIdentifier() {
        return this.osSpecificPolicyIdentifier;
    }

    private static class PolicyNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private PolicyNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            UIUtilities.setName((JComponent)comp, "policyPage", UIUtilities.ComponentType.JTABLE, "ColumnPolicyName_" + String.valueOf(value));
            return comp;
        }
    }

    private class PolicyTableCellMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        public PolicyTableCellMenu() {
            this.initialize();
        }

        private void initialize() {
            PolicyIntObjectBase policyObject;
            boolean isExclusiveEdit;
            boolean isCloudInUse;
            JMenuItem add = PolicyPoolPane.this.createAddMenuItem();
            JMenuItem delete = new JMenuItem(UIText.get(769));
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PolicyPoolPane.this.executeTask(4, null);
                }
            });
            JMenuItem edit = new JMenuItem(UIText.get(1024));
            edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PolicyPoolPane.this.executeTask(3, null);
                }
            });
            JMenuItem copy = new JMenuItem(UIText.get(520));
            copy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PolicyPoolPane.this.executeTask(9, null);
                }
            });
            JMenuItem paste = new JMenuItem(UIText.get(3840));
            paste.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PolicyPoolPane.this.executeTask(10, null);
                }
            });
            JMenuItem apply = new JMenuItem(UIText.get(19));
            apply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PolicyPoolPane.this.executeTask(6, null);
                }
            });
            JMenuItem importMenu = new JMenuItem(UIText.get(2049));
            ComponentUtils.setFileOpener((JComponent)importMenu, (FileOpener)PolicyPoolPane.this);
            importMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PolicyPoolPane.this.executeTask(1, null);
                }
            });
            JMenuItem export = new JMenuItem(UIText.get(1031));
            export.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PolicyPoolPane.this.executeTask(5, null);
                }
            });
            BasePolicyHandler handler = BasePolicyHandler.getInstance(PolicyPoolPane.this.getPolicyItemType());
            boolean isLicensed = handler.hasLicense(true);
            boolean isPolicySelected = PolicyPoolPane.this.getPolicyTable().getSelectedRowCount() > 0;
            add.setEnabled(isLicensed);
            delete.setEnabled(isPolicySelected);
            edit.setEnabled(isPolicySelected);
            copy.setEnabled(isLicensed && isPolicySelected);
            paste.setEnabled(PolicyHandler.hasCopiedObject(handler.getPolicyObjectClass()));
            apply.setEnabled(isLicensed && isPolicySelected && AdminObject.retrieveCurrentAdminObject().hasGroupFullAccessRight());
            importMenu.setEnabled(isLicensed);
            export.setEnabled(isPolicySelected);
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            boolean isReadOnly = AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context);
            if (PolicyPoolPane.this.getPolicyItemType() == 169) {
                isCloudInUse = CloudUtil.isCloudMemPolicyInUse();
                isExclusiveEdit = false;
                if (isPolicySelected) {
                    policyObject = (MemPolicyObject)PolicyPoolPane.this.getSelectedPolicyObj();
                    isExclusiveEdit = ((MemPolicyObject)policyObject).isExclusiveEdit();
                    System.out.println("PolicyPoolPane >> Mem Policy ID: " + policyObject.getId() + " , isCloudMemPolicyInUse: " + isCloudInUse + ", isExclusiveEdit: " + isExclusiveEdit);
                } else {
                    System.out.println("PolicyPoolPane >> isCloudMemPolicyInUse: " + isCloudInUse);
                }
                if (isCloudInUse) {
                    add.setEnabled(false);
                    copy.setEnabled(false);
                    importMenu.setEnabled(false);
                    apply.setEnabled(false);
                    add.setToolTipText(MSG_RES.getString("PolicyPoolPane.cloudManagedTaskTooltip"));
                    copy.setToolTipText(MSG_RES.getString("PolicyPoolPane.cloudManagedTaskTooltip"));
                    importMenu.setToolTipText(MSG_RES.getString("PolicyPoolPane.cloudManagedTaskTooltip"));
                    apply.setToolTipText(MSG_RES.getString("PolicyPoolPane.cloudManagedTaskTooltip"));
                }
                if (isPolicySelected && isExclusiveEdit) {
                    delete.setEnabled(false);
                    apply.setEnabled(false);
                    delete.setToolTipText(MSG_RES.getString("PolicyPoolPane.exclusiveEditTooltip"));
                    apply.setToolTipText(MSG_RES.getString("PolicyPoolPane.exclusiveEditTooltip"));
                }
            }
            if (PolicyPoolPane.this.getPolicyItemType() == 128) {
                isCloudInUse = CloudUtil.isCloudEnrolled(Manager.getCurrentDomainId());
                isExclusiveEdit = false;
                if (isPolicySelected) {
                    policyObject = (OverridePolicyObject)PolicyPoolPane.this.getSelectedPolicyObj();
                    isExclusiveEdit = ((OverridePolicyObject)policyObject).isExclusiveEdit();
                    System.out.println("PolicyPoolPane> initialize>> OverridePolicy ID: " + policyObject.getId() + " , isCloudEnrolled: " + isCloudInUse + ", isExclusiveEdit: " + isExclusiveEdit);
                } else {
                    System.out.println("PolicyPoolPane> initialize>> isCloudEnrolled: " + isCloudInUse);
                }
                if (isPolicySelected && isCloudInUse && isExclusiveEdit) {
                    delete.setEnabled(false);
                    copy.setEnabled(false);
                    paste.setEnabled(false);
                    apply.setEnabled(false);
                    delete.setToolTipText(MSG_RES.getString("PolicyPoolPane.exclusiveEditTooltip"));
                    copy.setToolTipText(MSG_RES.getString("PolicyPoolPane.exclusiveEditTooltip"));
                    paste.setToolTipText(MSG_RES.getString("PolicyPoolPane.exclusiveEditTooltip"));
                    apply.setToolTipText(MSG_RES.getString("PolicyPoolPane.exclusiveEditTooltip"));
                }
            }
            if (!isReadOnly) {
                this.add(add);
            }
            this.add(edit);
            if (!isReadOnly) {
                this.add(delete);
            }
            if (PolicyPoolPane.this.getAppliable()) {
                this.addSeparator();
                this.add(copy);
                if (!isReadOnly) {
                    this.add(paste);
                }
                this.addSeparator();
                this.add(apply);
                this.addSeparator();
                if (!isReadOnly) {
                    this.add(importMenu);
                }
                this.add(export);
            }
        }
    }

    private class PolicyTableCellListener
    extends MouseAdapter {
        private PolicyTableCellListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row = PolicyPoolPane.this.getPolicyTable().rowAtPoint(e.getPoint());
            if (row >= 0) {
                PolicyPoolPane.this.getPolicyTable().setRowSelectionInterval(row, row);
            } else {
                PolicyPoolPane.this.getPolicyTable().clearSelection();
            }
            if (row >= 0 && (e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
                PolicyPoolPane.this.executeTask(3, null);
            } else if ((e.getModifiers() & 4) != 0) {
                PolicyTableCellMenu popupMenu = new PolicyTableCellMenu();
                popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

