/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.common;

import com.sygate.scm.common.configobject.schema.AlSignature;
import com.sygate.scm.common.configobject.schema.AppliedPolicyArray;
import com.sygate.scm.common.configobject.schema.BaselineFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.DestinationHostTrigger;
import com.sygate.scm.common.configobject.schema.EnforcedFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.EnforcerGroup;
import com.sygate.scm.common.configobject.schema.EnforcerGroupTree;
import com.sygate.scm.common.configobject.schema.FirewallRule;
import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.FwHostTrigger;
import com.sygate.scm.common.configobject.schema.FwIdsLibrary;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceTrigger;
import com.sygate.scm.common.configobject.schema.FwServiceTrigger;
import com.sygate.scm.common.configobject.schema.FwUnregulatedHosts;
import com.sygate.scm.common.configobject.schema.GatewayAddress;
import com.sygate.scm.common.configobject.schema.IdsPolicy;
import com.sygate.scm.common.configobject.schema.LocalHostAddress;
import com.sygate.scm.common.configobject.schema.LocalHostTrigger;
import com.sygate.scm.common.configobject.schema.Location;
import com.sygate.scm.common.configobject.schema.LuContentSelection;
import com.sygate.scm.common.configobject.schema.MacAppProtectionSetting;
import com.sygate.scm.common.configobject.schema.MacOpBlockedDeviceList;
import com.sygate.scm.common.configobject.schema.MacOpDeviceBlocker;
import com.sygate.scm.common.configobject.schema.MacOpExcludedDeviceList;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.OpAppProtectionPolicy;
import com.sygate.scm.common.configobject.schema.OpBlockedDeviceClassArray;
import com.sygate.scm.common.configobject.schema.OpDeviceBlocker;
import com.sygate.scm.common.configobject.schema.OpExcludedDeviceArray;
import com.sygate.scm.common.configobject.schema.RemoteHostTrigger;
import com.sygate.scm.common.configobject.schema.SeEnforcerPolicy;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.configobject.schema.SourceHostTrigger;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractSelectableUIObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.CommunicationObject;
import com.sygate.scm.console.logicobject.DeviceObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.IDSObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyIntObjectBase;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.QuarantineLocationObject;
import com.sygate.scm.console.logicobject.ServerListObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.dialog.PolicyType;
import com.sygate.scm.console.ui.policy.explorer.common.ApplyMessageObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.NetworkInterfaceGroupObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolContainerObject;
import com.sygate.scm.console.ui.policy.hostgroup.HostGroupObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsLibraryObject;
import com.sygate.scm.console.ui.policy.ids.logicobject.IdsPolicyObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.HeadlessException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class PolicyApplyHelper {
    private static final int NETWORK_ADAPTER = 0;
    private static final int NETWORK_SERVICE = 1;
    private static final int HOST_GROUP = 2;
    private static final int HARDWARE_DEVICE = 3;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");

    public static boolean isAnyServerListInUse(TreeModel treeModel, ServerListObject slObj) {
        try {
            DataobjectManager dom = DataobjectManager.getInstance();
            SemSiteArray siteArray = dom.getSemConfigRoot().getSemSiteArray();
            for (int i = 0; i < siteArray.getObjReferenceCount(); ++i) {
                EnforcerGroupTree tree;
                ObjReference objReference = siteArray.getObjReference(i);
                SemSite semSite = dom.getSemSite(objReference.getTargetId());
                Boolean isSuspended = semSite.getOptSuspended();
                if (isSuspended == null) {
                    isSuspended = semSite.getDefSuspended();
                }
                if (isSuspended.booleanValue() || (tree = semSite.getOptEnforcerGroupTree()) == null) continue;
                EnforcerGroup root = tree.getEnforcerGroup();
                for (int j = 0; j < root.getEnforcerGroupCount(); ++j) {
                    EnforcerGroup group = root.getEnforcerGroup(j);
                    ObjReference ref = group.getObjReference();
                    SeEnforcerPolicy policy = dom.getSeEnforcerPolicy(ref.getTargetId());
                    ObjReference serverListRef = policy.getOptObjReference();
                    if (serverListRef == null || !slObj.getId().equals(serverListRef.getTargetId())) continue;
                    return true;
                }
            }
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)((DefaultTreeModel)treeModel).getRoot();
            if (parentNode == null) {
                return false;
            }
            ArrayList<TreeNode> nodeList = Collections.list(parentNode.breadthFirstEnumeration());
            Iterator nodeIt = nodeList.iterator();
            DefaultMutableTreeNode node = null;
            while (nodeIt.hasNext()) {
                LocationObject locObject;
                CommunicationObject comObj;
                node = (DefaultMutableTreeNode)nodeIt.next();
                Object obj = node.getUserObject();
                if (obj instanceof GroupObject) {
                    GroupObject grpObject = (GroupObject)obj;
                    GroupPolicyObject newObj = PolicyHandler.getGroupPolicyByGroupFromDB(grpObject);
                    CommunicationObject comObj2 = newObj.getCommunicationObject();
                    if (comObj2.getCommunication() == null) continue;
                    ServerListObject srvrLst = comObj2.getServerList();
                    if (!slObj.getName().equalsIgnoreCase(srvrLst.getName())) continue;
                    return true;
                }
                if (!(obj instanceof LocationObject) || (comObj = (locObject = (LocationObject)obj).getCommunicationObject()).getCommunication() == null) continue;
                ServerListObject srvrLst = comObj.getServerList();
                if (!slObj.getName().equalsIgnoreCase(srvrLst.getName())) continue;
                return true;
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return false;
    }

    public static boolean isNetworkServiceInUse(ProtocolContainerObject serviceObj) {
        return PolicyApplyHelper.isPolicyComponentInUse(1, serviceObj.getServiceGroup().getId(), 43);
    }

    public static boolean isNetworkAdapterInUse(NetworkInterfaceGroupObject adapterObj) {
        return PolicyApplyHelper.isPolicyComponentInUse(0, adapterObj.getId(), 43);
    }

    public static boolean isHostGroupInUse(HostGroupObject hostGroupObj) {
        if (PolicyApplyHelper.isPolicyComponentInUse(2, hostGroupObj.getId(), 43)) {
            return true;
        }
        System.err.println("\n\n******************* IDS policy *********************");
        return PolicyApplyHelper.isPolicyComponentInUse(2, hostGroupObj.getId(), 143);
    }

    public static boolean isDeviceInUse(DeviceObject deviceObj) {
        return PolicyApplyHelper.isPolicyComponentInUse(3, deviceObj.getId(), 63);
    }

    private static boolean isPolicyComponentInUse(int policyCompType, String policyCompId, int policyType) {
        try {
            ObjInfoObject[] infos = AppliablePolicyPool.getPolicyPoolObject(policyType).getInfoObjectList();
            HashMap<String, String> policyInfoObjs = new HashMap<String, String>();
            if (infos != null) {
                for (int i = 0; i < infos.length; ++i) {
                    if (policyType != 43 && policyType != 63 && (policyType != 143 || !infos[i].getTargetType().equals("IdsPolicy"))) continue;
                    policyInfoObjs.put(infos[i].getId(), infos[i].getName());
                }
            }
            for (Map.Entry policyInfoObj : policyInfoObjs.entrySet()) {
                if (!PolicyApplyHelper.isPolicyComponentInUse(policyCompType, policyCompId, policyType, (String)policyInfoObj.getKey())) continue;
                Object[] args = new Object[]{PolicyApplyHelper.getDisplayPolicyComponentTypeInMsg(policyCompType), policyInfoObj.getValue()};
                String msg = MessageFormat.format(MSG_RES.getString("PolicyApplyHelper.cantDeletePolicyCompMsg1"), args);
                String title = MessageFormat.format(MSG_RES.getString("PolicyApplyHelper.cantDeletePolicyCompTitle"), PolicyApplyHelper.getDisplayPolicyComponentTypeInTitle(policyCompType));
                JOptionPane.showMessageDialog(Manager.getFrame(), new DescriptionTextArea(msg), title, -1);
                return true;
            }
            DefaultMutableTreeNode grpRoot = GroupHandler.getGroups(false);
            if (grpRoot != null) {
                ArrayList<TreeNode> grpList = Collections.list(grpRoot.breadthFirstEnumeration());
                for (int i = 0; i < grpList.size(); ++i) {
                    DefaultMutableTreeNode grpNode = (DefaultMutableTreeNode)grpList.get(i);
                    GroupObject grpObj = (GroupObject)grpNode.getUserObject();
                    GroupPolicyObject gpObj = PolicyHandler.getGroupPolicyByGroupFromDB(grpObj);
                    if (gpObj.isInherit()) continue;
                    String groupName = grpObj.getFullGroupPath();
                    System.err.println("groupName: " + groupName);
                    List<LocationObject> locObjs = gpObj.getLocationsFromDB();
                    for (int j = 0; j < locObjs.size(); ++j) {
                        LocationObject locObject = locObjs.get(j);
                        System.err.println("\tLocation name: " + locObject.getName());
                        AppliedPolicyArray appPolicyArr = locObject.getAppliedPolicyObject().getPolicyArray();
                        for (int k = 0; k < appPolicyArr.getObjReferenceCount(); ++k) {
                            ObjReference objRef = appPolicyArr.getObjReference(k);
                            System.err.println("\t\tobjRef: " + objRef.getName() + "   " + objRef.getTargetType() + "  " + objRef.getTargetId());
                            if (!objRef.getTargetType().equals(PolicyType.getPolicyTargetTypeFromPolicyTreeItemType(policyType))) continue;
                            String policyId = objRef.getTargetId();
                            System.out.println("\t\t\ttargetId: " + policyId + "  " + objRef.getTargetType());
                            if (policyInfoObjs.containsKey(policyId) || !PolicyApplyHelper.isPolicyComponentInUse(policyCompType, policyCompId, policyType, policyId)) continue;
                            Object[] args = new Object[]{PolicyApplyHelper.getDisplayPolicyComponentTypeInMsg(policyCompType), locObject.getName(), groupName};
                            String message = MessageFormat.format(MSG_RES.getString("PolicyApplyHelper.cantDeletePolicyCompMsg2"), args);
                            String title = MessageFormat.format(MSG_RES.getString("PolicyApplyHelper.cantDeletePolicyCompTitle"), PolicyApplyHelper.getDisplayPolicyComponentTypeInTitle(policyCompType));
                            JOptionPane.showMessageDialog(Manager.getFrame(), new DescriptionTextArea(message), title, -1);
                            return true;
                        }
                        if (policyCompType != 2 || !PolicyApplyHelper.isHostGroupUsedInLocation(locObject, policyCompId, groupName)) continue;
                        return true;
                    }
                }
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        catch (HeadlessException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return false;
    }

    private static boolean isHostGroupUsedInLocation(LocationObject locObject, String hostGroupID, String groupName) {
        Location location = locObject.getLocationObject();
        boolean isInUse = false;
        for (int aj = 0; aj < location.getAlSignatureCount(); ++aj) {
            LocalHostAddress address;
            ObjReference objRef;
            int ii;
            int k;
            AlSignature agentAlSignature = location.getAlSignature(aj);
            for (k = 0; k < agentAlSignature.getGatewayAddressCount(); ++k) {
                GatewayAddress gatewayAddress = agentAlSignature.getGatewayAddress(k);
                for (ii = 0; ii < gatewayAddress.getObjReferenceCount(); ++ii) {
                    objRef = gatewayAddress.getObjReference(ii);
                    if (!hostGroupID.equals(objRef.getTargetId())) continue;
                    isInUse = true;
                    break;
                }
                if (isInUse) break;
            }
            if (!isInUse) {
                for (k = 0; k < agentAlSignature.getLocalHostAddressCount(); ++k) {
                    address = agentAlSignature.getLocalHostAddress(k);
                    for (ii = 0; ii < address.getObjReferenceCount(); ++ii) {
                        objRef = address.getObjReference(ii);
                        if (!hostGroupID.equals(objRef.getTargetId())) continue;
                        isInUse = true;
                        break;
                    }
                    if (isInUse) break;
                }
            }
            if (!isInUse) {
                for (k = 0; k < agentAlSignature.getDnsServerAddressCount(); ++k) {
                    address = agentAlSignature.getDnsServerAddress(k);
                    for (ii = 0; ii < address.getObjReferenceCount(); ++ii) {
                        objRef = address.getObjReference(ii);
                        if (!hostGroupID.equals(objRef.getTargetId())) continue;
                        isInUse = true;
                        break;
                    }
                    if (isInUse) break;
                }
            }
            if (!isInUse) {
                for (k = 0; k < agentAlSignature.getDhcpServerAddressCount(); ++k) {
                    address = agentAlSignature.getDhcpServerAddress(k);
                    for (ii = 0; ii < address.getObjReferenceCount(); ++ii) {
                        objRef = address.getObjReference(ii);
                        if (!hostGroupID.equals(objRef.getTargetId())) continue;
                        isInUse = true;
                        break;
                    }
                    if (isInUse) break;
                }
            }
            if (!isInUse) {
                for (k = 0; k < agentAlSignature.getWinsServerAddressCount(); ++k) {
                    address = agentAlSignature.getWinsServerAddress(k);
                    for (ii = 0; ii < address.getObjReferenceCount(); ++ii) {
                        objRef = address.getObjReference(ii);
                        if (!hostGroupID.equals(objRef.getTargetId())) continue;
                        isInUse = true;
                        break;
                    }
                    if (isInUse) break;
                }
            }
            if (!isInUse) {
                for (k = 0; k < agentAlSignature.getICMPRequestCount(); ++k) {
                    address = agentAlSignature.getICMPRequest(k);
                    for (ii = 0; ii < address.getObjReferenceCount(); ++ii) {
                        objRef = address.getObjReference(ii);
                        if (!hostGroupID.equals(objRef.getTargetId())) continue;
                        isInUse = true;
                        break;
                    }
                    if (isInUse) break;
                }
            }
            if (!isInUse) continue;
            Object[] args = new Object[]{PolicyApplyHelper.getDisplayPolicyComponentTypeInMsg(2), locObject.getName(), groupName};
            String message = MessageFormat.format(MSG_RES.getString("PolicyApplyHelper.cantDeletePolicyCompMsg2"), args);
            String title = MessageFormat.format(MSG_RES.getString("PolicyApplyHelper.cantDeletePolicyCompTitle"), PolicyApplyHelper.getDisplayPolicyComponentTypeInTitle(2));
            JOptionPane.showMessageDialog(Manager.getFrame(), new DescriptionTextArea(message), title, -1);
            break;
        }
        return isInUse;
    }

    private static boolean isPolicyComponentInUse(int policyCompType, String policyCompId, int policyType, String policyId) throws ConsoleException {
        switch (policyType) {
            case 43: {
                FwFirewallPolicy fw = DataobjectManager.getInstance().getFwFirewallPolicy(policyId);
                List<FirewallRule> fwRules = PolicyApplyHelper.getFwPolicyRules(fw);
                for (int i = 0; i < fwRules.size(); ++i) {
                    if (!PolicyApplyHelper.isTypeInUse(policyCompType, fwRules.get(i), policyCompId)) continue;
                    System.err.println("Debug: " + fw.getName() + "  " + fwRules.get(i).getName());
                    return true;
                }
                break;
            }
            case 143: {
                IdsPolicy ids = DataobjectManager.getInstance().getIdsPolicy(policyId);
                if (!PolicyApplyHelper.isHostGroupInUse(ids, policyCompId)) break;
                return true;
            }
            case 63: {
                OpAppProtectionPolicy osp = DataobjectManager.getInstance().getOpAppProtectionPolicy(policyId);
                if (!PolicyApplyHelper.isDeviceInUse(osp, policyCompId)) break;
                return true;
            }
        }
        return false;
    }

    private static boolean isTypeInUse(int type, FirewallRule fwRule, String policyCompId) {
        switch (type) {
            case 0: {
                return PolicyApplyHelper.isNetworkAdapterInUse(fwRule, policyCompId);
            }
            case 1: {
                return PolicyApplyHelper.isNetworkServiceInUse(fwRule, policyCompId);
            }
            case 2: {
                return PolicyApplyHelper.isHostGroupInUse(fwRule, policyCompId);
            }
        }
        return false;
    }

    private static boolean isNetworkAdapterInUse(FirewallRule rule, String policyCompId) {
        FwNetworkInterfaceTrigger trigger = rule.getTriggerCondition().getOptFwNetworkInterfaceTrigger();
        if (trigger != null) {
            for (int i = 0; i < trigger.getObjReferenceCount(); ++i) {
                if (!trigger.getObjReference(i).getTargetId().equals(policyCompId)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isNetworkServiceInUse(FirewallRule rule, String policyCompId) {
        FwServiceTrigger trigger = rule.getTriggerCondition().getOptFwServiceTrigger();
        if (trigger != null) {
            for (int i = 0; i < trigger.getObjReferenceCount(); ++i) {
                if (!trigger.getObjReference(i).getTargetId().equals(policyCompId)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isHostGroupInUse(FirewallRule rule, String policyCompId) {
        FwHostTrigger trigger = rule.getTriggerCondition().getOptFwHostTrigger();
        if (trigger != null) {
            DestinationHostTrigger destTrigger;
            SourceHostTrigger sourceTrigger;
            RemoteHostTrigger remoteTrigger;
            LocalHostTrigger localTrigger = trigger.getOptLocalHostTrigger();
            if (localTrigger != null) {
                for (int i = 0; i < localTrigger.getObjReferenceCount(); ++i) {
                    if (!localTrigger.getObjReference(i).getTargetId().equals(policyCompId)) continue;
                    return true;
                }
            }
            if ((remoteTrigger = trigger.getOptRemoteHostTrigger()) != null) {
                for (int i = 0; i < remoteTrigger.getObjReferenceCount(); ++i) {
                    if (!remoteTrigger.getObjReference(i).getTargetId().equals(policyCompId)) continue;
                    return true;
                }
            }
            if ((sourceTrigger = trigger.getOptSourceHostTrigger()) != null) {
                for (int i = 0; i < sourceTrigger.getObjReferenceCount(); ++i) {
                    if (!sourceTrigger.getObjReference(i).getTargetId().equals(policyCompId)) continue;
                    return true;
                }
            }
            if ((destTrigger = trigger.getOptDestinationHostTrigger()) != null) {
                for (int i = 0; i < destTrigger.getObjReferenceCount(); ++i) {
                    if (!destTrigger.getObjReference(i).getTargetId().equals(policyCompId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isHostGroupInUse(IdsPolicy ids, String policyCompId) {
        FwUnregulatedHosts hosts;
        if (ids != null && (hosts = ids.getOptFwUnregulatedHosts()) != null) {
            for (int i = 0; i < hosts.getObjReferenceCount(); ++i) {
                if (!hosts.getObjReference(i).getTargetId().equals(policyCompId)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isDeviceInUse(OpAppProtectionPolicy osp, String policyCompId) {
        OpDeviceBlocker deviceBloker;
        if (osp != null && (deviceBloker = osp.getAppProtectionSetting().getOptOpDeviceBlocker()) != null) {
            OpExcludedDeviceArray aDevices;
            OpBlockedDeviceClassArray bDevices = deviceBloker.getOptOpBlockedDeviceClassArray();
            if (bDevices != null) {
                for (int i = 0; i < bDevices.getObjReferenceCount(); ++i) {
                    if (!bDevices.getObjReference(i).getTargetId().equals(policyCompId)) continue;
                    return true;
                }
            }
            if ((aDevices = deviceBloker.getOptOpExcludedDeviceArray()) != null) {
                for (int i = 0; i < aDevices.getObjReferenceCount(); ++i) {
                    if (!aDevices.getObjReference(i).getTargetId().equals(policyCompId)) continue;
                    return true;
                }
            }
        }
        return PolicyApplyHelper.isMacDeviceInUse(osp, policyCompId);
    }

    private static boolean isMacDeviceInUse(OpAppProtectionPolicy osp, String policyCompId) {
        if (osp != null) {
            MacOpDeviceBlocker deviceBloker;
            MacAppProtectionSetting setting = osp.getOptMacAppProtectionSetting();
            MacOpDeviceBlocker macOpDeviceBlocker = deviceBloker = setting == null ? null : setting.getOptMacOpDeviceBlocker();
            if (deviceBloker != null) {
                MacOpExcludedDeviceList aDevices;
                MacOpBlockedDeviceList bDevices = deviceBloker.getOptMacOpBlockedDeviceList();
                if (bDevices != null) {
                    for (int i = 0; i < bDevices.getExtendedOpDeviceCount(); ++i) {
                        if (!bDevices.getExtendedOpDevice(i).getObjReference().getTargetId().equals(policyCompId)) continue;
                        return true;
                    }
                }
                if ((aDevices = deviceBloker.getOptMacOpExcludedDeviceList()) != null) {
                    for (int i = 0; i < aDevices.getExtendedOpDeviceCount(); ++i) {
                        if (!aDevices.getExtendedOpDevice(i).getObjReference().getTargetId().equals(policyCompId)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static String getDisplayPolicyComponentTypeInTitle(int type) {
        switch (type) {
            case 0: {
                return MSG_RES.getString("PolicyApplyHelper.networkAdapterT");
            }
            case 1: {
                return MSG_RES.getString("PolicyApplyHelper.networkServiceT");
            }
            case 2: {
                return MSG_RES.getString("PolicyApplyHelper.hostGroupT");
            }
            case 3: {
                return MSG_RES.getString("PolicyApplyHelper.hardwareDeviceT");
            }
        }
        return "";
    }

    private static String getDisplayPolicyComponentTypeInMsg(int type) {
        switch (type) {
            case 0: {
                return MSG_RES.getString("PolicyApplyHelper.networkAdapterM");
            }
            case 1: {
                return MSG_RES.getString("PolicyApplyHelper.networkServiceM");
            }
            case 2: {
                return MSG_RES.getString("PolicyApplyHelper.hostGroupM");
            }
            case 3: {
                return MSG_RES.getString("PolicyApplyHelper.hardwareDeviceM");
            }
        }
        return "";
    }

    public static boolean isAnyIDSLibInUse(TreeModel treeModel, PolicyObjectBase idsLibObj) {
        try {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)((DefaultTreeModel)treeModel).getRoot();
            if (parentNode == null) {
                return false;
            }
            ArrayList<TreeNode> nodeList = Collections.list(parentNode.breadthFirstEnumeration());
            Iterator nodeIt = nodeList.iterator();
            DefaultMutableTreeNode node = null;
            while (nodeIt.hasNext()) {
                GroupObject grpObject;
                GroupPolicyObject newObj;
                IDSObject idsObj;
                node = (DefaultMutableTreeNode)nodeIt.next();
                Object obj = node.getUserObject();
                if (!(obj instanceof GroupObject) || !(idsObj = (newObj = PolicyHandler.getGroupPolicyByGroup(grpObject = (GroupObject)obj)).getIDSObject()).isExisting(idsLibObj.getId()).booleanValue()) continue;
                return true;
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return false;
    }

    public static boolean isAnyLuContentPolicyInUse(TreeModel treeModel, PolicyObjectBase luContentPolicyObj) {
        try {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)((DefaultTreeModel)treeModel).getRoot();
            if (parentNode == null) {
                return false;
            }
            Iterator<TreeNode> nodeIt = Collections.list(parentNode.breadthFirstEnumeration()).iterator();
            DefaultMutableTreeNode node = null;
            while (nodeIt.hasNext()) {
                GroupPolicyObject grpPolicyObj;
                LuContentSelection luSel;
                node = (DefaultMutableTreeNode)nodeIt.next();
                Object obj = node.getUserObject();
                if (!(obj instanceof GroupObject) || (luSel = (grpPolicyObj = PolicyHandler.getGroupPolicyByGroup((GroupObject)obj)).getLuContentSelection()) == null || !luSel.getObjReference().getTargetId().equals(luContentPolicyObj.getId())) continue;
                return true;
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return false;
    }

    public static ApplyMessageObject applySharedPolicy(TreeModel treeModel, PolicyInt policyObj, String type, ObjInfoObject infoObj) {
        ArrayList<AbstractSelectableUIObject> list = new ArrayList<AbstractSelectableUIObject>(6);
        try {
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)((DefaultTreeModel)treeModel).getRoot();
            if (rootNode == null) {
                return null;
            }
            ArrayList<TreeNode> nodeList = Collections.list(rootNode.breadthFirstEnumeration());
            for (DefaultMutableTreeNode defaultMutableTreeNode : nodeList) {
                LocationObject locObject;
                List<LocationObject> locList;
                Object obj = defaultMutableTreeNode.getUserObject();
                if (LicenseObject.getInstance().isSBProduct() && obj != null && obj instanceof GroupObject && ((GroupObject)obj).isSelected() && !(locList = PolicyHandler.getGroupPolicyByGroupFromDB((GroupObject)obj).getLocationsFromDB()).isEmpty()) {
                    LocationObject loc = locList.get(0);
                    loc.setSelected(true);
                    loc.setDirty();
                    obj = loc;
                }
                if (obj == null || !(obj instanceof LocationObject)) continue;
                DefaultMutableTreeNode parentGroupNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                if (parentGroupNode != null && parentGroupNode.getUserObject() instanceof LocationObject) {
                    parentGroupNode = (DefaultMutableTreeNode)parentGroupNode.getParent();
                }
                if (parentGroupNode != null && parentGroupNode.getUserObject() instanceof GroupObject) {
                    GroupObject parentGroup = (GroupObject)parentGroupNode.getUserObject();
                    if (!LicenseObject.getInstance().isSBProduct() && parentGroup.isInherited()) continue;
                }
                if (!(locObject = (LocationObject)obj).isSelected() || !locObject.isDirty()) continue;
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                Object parentObj = parentNode != null ? parentNode.getUserObject() : null;
                AppliedPolicyObject appliedObj = null;
                if (parentObj != null && parentObj instanceof LocationObject) {
                    LocationObject parentLocationObject = (LocationObject)parentObj;
                    appliedObj = parentLocationObject.getAppliedPolicyObject(false);
                } else {
                    appliedObj = locObject.getAppliedPolicyObject(false);
                }
                policyObj = PolicyApplyHelper.getPolicyObject(locObject, policyObj);
                boolean isApplied = false;
                if (type.equals("apply")) {
                    appliedObj.addNewSharedPolicy(policyObj);
                    appliedObj.addDefaultQuarantinePolicies(policyObj);
                    isApplied = true;
                } else if (type.equals("remove")) {
                    if (appliedObj.existPolicy(policyObj)) {
                        appliedObj.removePolicy(policyObj, true);
                        isApplied = true;
                    }
                } else if (type.equals("replace")) {
                    PolicyInt newPolicy = (PolicyInt)((Object)PolicyHelper.getPolicyObject(infoObj));
                    newPolicy = PolicyApplyHelper.getPolicyObject(locObject, newPolicy);
                    String appliedPolicyId = appliedObj.getAppliedPolicyId(PolicyApplyHelper.getItemType(locObject, infoObj.getItemType()));
                    if (appliedPolicyId != null && appliedPolicyId.equals(policyObj.getId())) {
                        appliedObj.addNewSharedPolicy(newPolicy);
                        isApplied = true;
                    }
                }
                if (!isApplied) continue;
                locObject.setAppliedPolicyObject(appliedObj);
                PolicyApplyHelper.updateLocationObject(locObject);
                list.add(locObject);
            }
            return new ApplyMessageObject(list, type, infoObj == null ? null : infoObj.getName());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    public static ApplyMessageObject applyServerList(TreeModel treeModel, TreeItem treeItem, String type, ObjInfoObject infoObj) {
        ArrayList<AbstractSelectableUIObject> list = new ArrayList<AbstractSelectableUIObject>(6);
        ServerListObject slObj = (ServerListObject)treeItem;
        try {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)((DefaultTreeModel)treeModel).getRoot();
            if (parentNode == null) {
                return null;
            }
            ArrayList<TreeNode> nodeList = Collections.list(parentNode.breadthFirstEnumeration());
            for (DefaultMutableTreeNode defaultMutableTreeNode : nodeList) {
                GroupPolicyObject gpObject;
                CommunicationObject comObj;
                boolean isApplied;
                GroupObject gObject;
                AbstractSelectableUIObject obj = (AbstractSelectableUIObject)defaultMutableTreeNode.getUserObject();
                if (!obj.isSelected()) continue;
                if (obj instanceof LocationObject) {
                    boolean isApplied2;
                    CommunicationObject comObj2;
                    LocationObject locObject = (LocationObject)obj;
                    if (!locObject.isDirty() || (comObj2 = locObject.getCommunicationObject().getClone()).getCommunication() == null || !(isApplied2 = PolicyApplyHelper.updateServerListInCommunication(type, infoObj, slObj, comObj2))) continue;
                    locObject.setCommunication(comObj2);
                    PolicyApplyHelper.updateLocationObject(locObject);
                    list.add(locObject);
                    continue;
                }
                if (!(obj instanceof GroupObject) || !(gObject = (GroupObject)obj).isDirty() || !(isApplied = PolicyApplyHelper.updateServerListInCommunication(type, infoObj, slObj, comObj = (gpObject = PolicyHandler.getGroupPolicyByGroup(gObject, false)).getCommunicationObject().getClone()))) continue;
                gpObject.setCommunicationObject(comObj);
                PolicyHandler.updateGroupPolicy(gpObject);
                list.add(gObject);
            }
            return new ApplyMessageObject(list, type, infoObj == null ? null : infoObj.getName());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    private static boolean updateServerListInCommunication(String updateType, ObjInfoObject infoObjToReplaceWith, ServerListObject selSrvList, CommunicationObject comObj) throws ConsoleException {
        boolean isApplied = false;
        if (!updateType.equals("remove")) {
            if (updateType.equals("replace")) {
                ServerListObject newSlObjToReplaceWith = PolicyHelper.getServerListObject(infoObjToReplaceWith);
                ServerListObject existingSrvList = comObj.getServerList();
                if (existingSrvList != null && existingSrvList.getId().equals(selSrvList.getId())) {
                    comObj.setServerList(newSlObjToReplaceWith);
                    isApplied = true;
                }
            } else {
                isApplied = comObj.setServerList(selSrvList);
            }
        }
        return isApplied;
    }

    public static ApplyMessageObject applyIPS(TreeModel treeModel, TreeItem treeItem, String type, ObjInfoObject infoObj) {
        ArrayList<AbstractSelectableUIObject> list = new ArrayList<AbstractSelectableUIObject>();
        try {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)((DefaultTreeModel)treeModel).getRoot();
            if (parentNode == null) {
                return null;
            }
            ArrayList<TreeNode> nodeList = Collections.list(parentNode.breadthFirstEnumeration());
            Iterator nodeIt = nodeList.iterator();
            while (nodeIt.hasNext()) {
                FwIdsLibrary fwLib;
                GroupObject grpObject;
                Object obj = ((DefaultMutableTreeNode)nodeIt.next()).getUserObject();
                if (!(obj instanceof GroupObject) || !(grpObject = (GroupObject)obj).isSelected() || !grpObject.isDirty()) continue;
                String appliedPolicyName = grpObject.getAppliedPolicyName();
                appliedPolicyName = appliedPolicyName == null ? "" : appliedPolicyName;
                GroupPolicyObject newObj = PolicyHandler.getGroupPolicyByGroupFromDB(grpObject);
                IDSObject idsObj = newObj.getIDSObject();
                if (type.equals("apply")) {
                    if (treeItem instanceof IdsLibraryObject) {
                        fwLib = ((IdsLibraryObject)treeItem).getFwIdsLibrary();
                        idsObj.setEnable(true, fwLib);
                    } else if (treeItem instanceof IdsPolicyObject) {
                        idsObj.clearStreamPolicy();
                        IdsPolicy idsPolicy = ((IdsPolicyObject)treeItem).getIdsPolicy();
                        idsObj.addStreamPolicy(idsPolicy);
                    }
                } else if (type.equals("remove")) {
                    if (appliedPolicyName.indexOf(treeItem.getName()) != -1) {
                        if (treeItem instanceof IdsLibraryObject) {
                            fwLib = ((IdsLibraryObject)treeItem).getFwIdsLibrary();
                            idsObj.setEnable(false, fwLib);
                        } else if (treeItem instanceof IdsPolicyObject) {
                            idsObj.clearStreamPolicy();
                        }
                    }
                } else {
                    if (infoObj == null) {
                        return null;
                    }
                    TreeItem toBeReplaced = PolicyHelper.getPolicyObject(infoObj);
                    if (appliedPolicyName.indexOf(toBeReplaced.getName()) != -1) {
                        if (treeItem instanceof IdsLibraryObject) {
                            FwIdsLibrary oldLib = ((IdsLibraryObject)toBeReplaced).getFwIdsLibrary();
                            FwIdsLibrary fwLib2 = ((IdsLibraryObject)treeItem).getFwIdsLibrary();
                            idsObj.setEnable(false, oldLib);
                            idsObj.setEnable(true, fwLib2);
                        } else if (treeItem instanceof IdsPolicyObject) {
                            idsObj.clearStreamPolicy();
                            IdsPolicy idsPolicy = ((IdsPolicyObject)treeItem).getIdsPolicy();
                            idsObj.addStreamPolicy(idsPolicy);
                        }
                    }
                }
                newObj.setIDS(idsObj);
                PolicyHandler.updateGroupPolicy(newObj);
                list.add(grpObject);
            }
            return new ApplyMessageObject(list, type);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    public static ApplyMessageObject applyLuContentPolicy(TreeModel treeModel, TreeItem treeItem, String type, ObjInfoObject infoObj) {
        ArrayList<AbstractSelectableUIObject> list = new ArrayList<AbstractSelectableUIObject>();
        try {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)((DefaultTreeModel)treeModel).getRoot();
            if (parentNode == null) {
                return null;
            }
            ArrayList<TreeNode> nodeList = Collections.list(parentNode.breadthFirstEnumeration());
            Iterator nodeIt = nodeList.iterator();
            while (nodeIt.hasNext()) {
                GroupObject grpObject;
                Object obj = ((DefaultMutableTreeNode)nodeIt.next()).getUserObject();
                if (!(obj instanceof GroupObject) || !(grpObject = (GroupObject)obj).isSelected() || !grpObject.isDirty()) continue;
                GroupPolicyObject grpPolicyObj = PolicyHandler.getGroupPolicyByGroupFromDB(grpObject);
                LuContentSelection luSelection = grpPolicyObj.getLuContentSelection();
                boolean isApplied = false;
                if (type.equals("apply")) {
                    boolean isNew = false;
                    if (luSelection == null) {
                        luSelection = new LuContentSelection();
                        isNew = true;
                    }
                    ObjReference objRef = new ObjReference();
                    objRef.setName("LuContentPolicyApplied");
                    objRef.setTargetType("LuContentPolicy");
                    objRef.setTargetId(treeItem.getId());
                    luSelection.setObjReference(objRef);
                    if (isNew) {
                        grpPolicyObj.setLuContentSelection(luSelection);
                    }
                    isApplied = true;
                } else if (type.equals("remove")) {
                    grpPolicyObj.setLuContentSelection(null);
                    isApplied = true;
                } else if (type.equals("replace")) {
                    ObjReference objRef;
                    ObjReference objReference = objRef = luSelection == null ? null : luSelection.getObjReference();
                    if (objRef != null && objRef.getTargetId().equals(treeItem.getId())) {
                        objRef.setTargetId(infoObj.getId());
                        isApplied = true;
                    }
                }
                if (!isApplied) continue;
                PolicyHandler.updateGroupPolicy(grpPolicyObj);
                list.add(grpObject);
            }
            return new ApplyMessageObject(list, type);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    public static void updateLocationObject(LocationObject locObj) {
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        try {
            PolicyHandler.addNewObject(locObj.getNewObjSet().values(), locObj.getDeletedObj(), updateList);
            PolicyHandler.updateChangedObject(locObj.getChangedObjSet().values(), locObj.getDeletedObj(), updateList);
            PolicyHandler.deleteDeletedObject(locObj.getDeletedObjSet().values(), updateList);
            DataobjectManager.getInstance().updateObject("Merge", updateList);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private static PolicyInt getPolicyObject(LocationObject locObj, PolicyInt policy) {
        if (locObj instanceof QuarantineLocationObject) {
            String policyTypeName = null;
            String policyTargetType = policy.getTargetType();
            if (policyTargetType.equals("AvPolicy")) {
                policyTypeName = "QuarantineAvPolicyApplied";
            } else if (policyTargetType.equals("FwFirewallPolicy")) {
                policyTypeName = "QuarantineFWPolicyApplied";
            } else if (policyTargetType.equals("OpAppProtectionPolicy")) {
                policyTypeName = "QuarantineOSPPolicyApplied";
            } else if (policyTargetType.equals("LuPolicy")) {
                policyTypeName = "QuarantineLuPolicyApplied";
            } else if (policyTargetType.equals("PolicyOverride")) {
                policyTypeName = "QuarantineCePolicyApplied";
            } else if (policyTargetType.equals("IdsPolicy")) {
                policyTypeName = "QuarantineIdsPolicyApplied";
            } else if (policyTargetType.equals("NtrPolicy")) {
                policyTypeName = "QuarantineNtrPolicyApplied";
            }
            if (policyTypeName == null) {
                return policy;
            }
            PolicyInt policyObj = PolicyIntObjectBase.getPolicyObject(policyTypeName);
            policyObj.setSchemaObj(policy.getSchemaObj());
            return policyObj;
        }
        return policy;
    }

    private static int getItemType(LocationObject locObj, int itemType) {
        if (locObj instanceof QuarantineLocationObject) {
            if (itemType == 134) {
                return 153;
            }
            if (itemType == 43) {
                return 121;
            }
            if (itemType == 63) {
                return 123;
            }
            if (itemType == 144) {
                return 155;
            }
            if (itemType == 128) {
                return 157;
            }
            if (itemType == 137) {
                return 159;
            }
            if (itemType == 65) {
                return 161;
            }
            if (itemType == 171) {
                return 173;
            }
        }
        return itemType;
    }

    private static List<FirewallRule> getFwPolicyRules(FwFirewallPolicy fwPolicy) throws ConsoleException {
        ArrayList<FirewallRule> rules = new ArrayList<FirewallRule>();
        if (fwPolicy == null) {
            return rules;
        }
        FirewallRuleSystem ruleSystem = fwPolicy.getOptFirewallRuleSystem();
        if (ruleSystem != null) {
            EnforcedFirewallRuleArray enforcedRule;
            BaselineFirewallRuleArray baseRule = ruleSystem.getOptBaselineFirewallRuleArray();
            if (baseRule != null) {
                rules.addAll(baseRule.getFirewallRule());
            }
            if ((enforcedRule = ruleSystem.getOptEnforcedFirewallRuleArray()) != null) {
                rules.addAll(enforcedRule.getFirewallRule());
            }
        }
        return rules;
    }
}

