/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.common;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.explorer.common.ExplorerConstants;
import com.sygate.scm.console.ui.policy.explorer.common.dlg.LearnApplicationDialog;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.ui.util.TaskPanelBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;

public abstract class NonAppliablePolicyPanelBase
extends TaskPanelBase
implements ExplorerConstants,
TaskPanel,
ContentSensitiveHelpPage {
    private static final boolean canExport = false;
    private static final long serialVersionUID = 1L;
    protected JTable jTTable = new StripesTable(true, true);

    public boolean getCanExport() {
        return false;
    }

    public boolean isSupportAboutDialog() {
        return false;
    }

    @Override
    public void refresh() {
        this.updateTitle(this.getTitleName());
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        try {
            this.refreshModelAndSortData(model);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NonAppliablePolicyPanelBase.consoleError"), 0);
        }
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
        ListSelectionListener[] listeners;
        DefaultListSelectionModel selModel = (DefaultListSelectionModel)this.jTTable.getSelectionModel();
        for (ListSelectionListener listener2 : listeners = selModel.getListSelectionListeners()) {
            if (listener != listener2) continue;
            return;
        }
        selModel.addListSelectionListener(listener);
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        this.refresh();
        if (taskIndex == 0) {
            this.doAdd();
        } else if (taskIndex == 14) {
            new LearnApplicationDialog();
        } else {
            int selRowCount = this.jTTable.getSelectedRowCount();
            if (selRowCount == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyPoolPane.policyDeleted"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "PolicyPoolPane.message"), 0);
                return;
            }
            if (taskIndex == 3 && this.isEditActionEnabled()) {
                this.doEdit();
            } else if (taskIndex == 4 && this.isDeleteActionEnabled()) {
                this.doDelete();
            } else if (taskIndex == 5) {
                this.doExport();
            } else if (taskIndex == 2) {
                this.doAbout();
            }
        }
        this.refresh();
    }

    @Override
    public int getTableSelectedItem() {
        if (this.jTTable.getSelectedRow() == -1) {
            return -1;
        }
        return this.getItemType();
    }

    protected void setColumnRenderers(JTable thisTable) {
    }

    @Override
    protected Component getContentPanel() {
        SortableTableModel model = new SortableTableModel();
        model.setColumnNames(this.getTableColumnName());
        model.setColumnMapping(this.getTableColumnMapping());
        model.addMouseListenerToHeaderInTable(this.jTTable);
        this.jTTable.setModel(model);
        this.jTTable.getSelectionModel().setSelectionMode(0);
        TableCellListener tableCellListener = new TableCellListener();
        this.jTTable.addMouseListener(tableCellListener);
        this.jTTable.addMouseMotionListener(tableCellListener);
        this.setColumnRenderers(this.jTTable);
        JScrollPane pane = UIUtilities.createScrollPaneWithoutBoard(this.jTTable);
        pane.addMouseListener(tableCellListener);
        UIUtilities.resizeColumns(this.jTTable, this.getTableColumnWidths(), pane.getWidth());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(pane);
        return panel;
    }

    @Override
    protected String getTitleName() {
        String title = this.getPolicyTypeName();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            Object[] obj = new Object[]{title};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "NonAppliablePolicyPanelBase.readOnlyTitle");
            title = MessageFormat.format(str, obj);
        }
        return title;
    }

    protected abstract void refreshModel(SortableTableModel var1) throws ConsoleException;

    protected abstract String getHTMLName();

    protected abstract String getTitleAndDescription();

    protected abstract String[] getTableColumnName();

    protected abstract int[] getTableColumnMapping();

    protected abstract float[] getTableColumnWidths();

    protected abstract int getItemType();

    protected abstract boolean isActionEnabled();

    protected boolean isEditActionEnabled() {
        return this.isActionEnabled();
    }

    protected String getEditDisabledToolTip() {
        return "";
    }

    protected boolean isDeleteActionEnabled() {
        return this.isActionEnabled();
    }

    protected String getDeleteDisabledToolTip() {
        return "";
    }

    protected abstract void doAdd();

    protected abstract void doEdit();

    protected abstract void doDelete();

    protected void doExport() {
    }

    protected void doAbout() {
    }

    protected abstract String getPolicyTypeName();

    protected abstract void retrieveTableSelection(TableRow var1);

    protected void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            int row = this.jTTable.rowAtPoint(e.getPoint());
            if (row != -1) {
                this.jTTable.setRowSelectionInterval(row, row);
            }
            new TablePopupMenu(this.isEditActionEnabled(), this.getEditDisabledToolTip(), this.isDeleteActionEnabled(), this.getDeleteDisabledToolTip()).show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void mouseMoved(MouseEvent e) {
    }

    private void refreshModelAndSortData(SortableTableModel model) throws ConsoleException {
        TableRow selectedRow = this.getSelectedRow();
        this.refreshModel(model);
        model.sortTable(model.getSortedColumn(), model.getIsAscending());
        this.retrieveTableSelection(selectedRow);
    }

    private TableRow getSelectedRow() {
        int selRow = this.jTTable.getSelectedRow();
        if (selRow == -1) {
            return null;
        }
        SortableTableModel model = (SortableTableModel)this.jTTable.getModel();
        return model.getRow(selRow);
    }

    private class TablePopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        public TablePopupMenu(boolean canEdit, String nonEditableToolTip, boolean canDelete, String nonDeletableToolTip) {
            JMenuItem add = new JMenuItem(UIText.get(5));
            add.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NonAppliablePolicyPanelBase.this.executeTask(0, null);
                }
            });
            JMenuItem delete = new JMenuItem(UIText.get(769));
            delete.setEnabled(canDelete);
            if (!canDelete && null != nonDeletableToolTip && nonDeletableToolTip.length() > 0) {
                delete.setToolTipText(nonDeletableToolTip);
            }
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NonAppliablePolicyPanelBase.this.executeTask(4, null);
                }
            });
            JMenuItem edit = new JMenuItem(UIText.get(1024));
            edit.setEnabled(canEdit);
            if (!canEdit && null != nonEditableToolTip && nonEditableToolTip.length() > 0) {
                edit.setToolTipText(nonEditableToolTip);
            }
            edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NonAppliablePolicyPanelBase.this.executeTask(3, null);
                }
            });
            JMenuItem export = new JMenuItem(UIText.get(1031));
            export.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NonAppliablePolicyPanelBase.this.executeTask(5, null);
                }
            });
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            boolean isReadOnly = AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context);
            if (!isReadOnly) {
                this.add(add);
            }
            this.add(edit);
            if (!isReadOnly) {
                this.add(delete);
            }
            export.setEnabled(NonAppliablePolicyPanelBase.this.jTTable.getSelectedRow() != -1);
            if (NonAppliablePolicyPanelBase.this.getCanExport()) {
                this.add(export);
            }
            if (NonAppliablePolicyPanelBase.this.isSupportAboutDialog()) {
                JMenuItem props = new JMenuItem(UIText.get(3851));
                props.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NonAppliablePolicyPanelBase.this.executeTask(2, null);
                    }
                });
                props.setEnabled(NonAppliablePolicyPanelBase.this.jTTable.getSelectedRow() != -1);
                this.add(props);
            }
        }
    }

    private class TableCellListener
    extends MouseAdapter {
        private TableCellListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            NonAppliablePolicyPanelBase.this.mouseClicked(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            NonAppliablePolicyPanelBase.this.mouseMoved(e);
        }
    }
}

