/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AbstractSelectableUIObject;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class LocationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int POLICY = 0;
    public static final int IPS_LIBRARY = 1;
    public static final int SERVER_LIST = 2;
    private static final String[] POLICY_COLUMN_NAME = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LocationTableModel.column.groupPath"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LocationTableModel.column.location")};
    private static final String[] SERVER_LIST_COLUMN_NAME = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LocationTableModel.column.groupPath"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LocationTableModel.column.location")};
    private static final String[] IPS_LIB_COLUMN_NAME = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LocationTableModel.column.groupPath")};
    private List<?> rowList;
    private int type;

    public LocationTableModel(int type, List<Object> rowList) {
        this.type = type;
        this.rowList = rowList;
    }

    @Override
    public int getRowCount() {
        return this.rowList.size();
    }

    @Override
    public int getColumnCount() {
        return this.type == 1 ? IPS_LIB_COLUMN_NAME.length : POLICY_COLUMN_NAME.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List row;
        List list = row = this.rowList.size() > rowIndex ? (List)this.rowList.get(rowIndex) : null;
        if (row == null) {
            return "";
        }
        Object value = row.get(columnIndex);
        if (value == null) {
            return "";
        }
        if (value instanceof AbstractSelectableUIObject) {
            return ((AbstractSelectableUIObject)value).getAppliedPolicyName();
        }
        return value;
    }

    @Override
    public String getColumnName(int column) {
        switch (this.type) {
            case 0: {
                return POLICY_COLUMN_NAME[column];
            }
            case 1: {
                return IPS_LIB_COLUMN_NAME[column];
            }
        }
        return SERVER_LIST_COLUMN_NAME[column];
    }

    public boolean isCurrentPolicy(int rowIndex, int columnIndex) {
        List row;
        List list = row = this.rowList.size() > rowIndex ? (List)this.rowList.get(rowIndex) : null;
        if (row == null) {
            return false;
        }
        return ((AbstractSelectableUIObject)row.get(columnIndex)).isCurrentPolicy();
    }
}

