/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.common.AppliablePolicy;
import com.sygate.scm.console.ui.policy.explorer.common.CheckItemTreeCellRenderer;
import com.sygate.scm.console.ui.policy.explorer.common.CheckServerItemTreeCellRenderer;
import com.sygate.scm.console.ui.policy.explorer.common.LocationCheckBoxTree;
import com.sygate.scm.console.ui.policy.explorer.common.LocationTableModel;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyUtil;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SwingWorker;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class LocationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<String> jCmbViewType = new JComboBox<String>(new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LocationPanel.label.byTree"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LocationPanel.label.byList")});
    private LocationCheckBoxTree locationTree = new LocationCheckBoxTree(null, false, false);
    private JTable locationTable = new StripesTable();
    private JPanel locationPanel = new JPanel(new CardLayout());
    private AppliablePolicy policy;
    private TreeModel appliedToTreeModel;

    public LocationPanel(AppliablePolicy policy) {
        this.initialize();
        if (policy != null) {
            this.setObject(policy);
        }
    }

    public void setObject(AppliablePolicy policy) {
        this.policy = policy;
    }

    public void refresh() {
        String text = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.loadingMsg");
        this.locationTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(text)));
        SwingWorker worker = new SwingWorker(){
            private Exception exception = null;
            private TreeModel treeModel = null;

            public Object construct() {
                try {
                    this.treeModel = LocationPanel.this.getTreeModel(LocationPanel.this.policy);
                }
                catch (Exception e) {
                    this.exception = e;
                }
                return this.treeModel;
            }

            public void finished() {
                try {
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    LocationPanel.this.locationTree.setCellRenderer(LocationPanel.this.getTreeCellRenderer(LocationPanel.this.policy));
                    LocationPanel.this.locationTree.setModel(this.treeModel);
                    UIUtilities.expandAllNodesInTree(LocationPanel.this.locationTree);
                    int tableModelType = LocationPanel.this.getTableModelType(LocationPanel.this.policy);
                    LocationTableModel model = (LocationTableModel)LocationPanel.this.locationTree.getTableModel(tableModelType);
                    LocationPanel.this.locationTable.setModel(model);
                    UIUtilities.resizeColumns(LocationPanel.this.locationTable, new float[]{0.3f, 0.2f}, LocationPanel.this.locationTable.getPreferredScrollableViewportSize().width);
                }
                catch (Exception e) {
                    this.handleExcpetion(e);
                }
                finally {
                    AjaxSwingManager.endOperation();
                    AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
                }
            }

            private void handleExcpetion(Exception ex) {
                if (ex == null) {
                    return;
                }
                String errorText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.av.av", "AvPolicyDialog.policyLocationErrorMsg");
                JOptionPane.showMessageDialog(Manager.getFrame(), errorText, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.policy", "PolicyPanel.errorMsg"), 0);
                LoggerUtilities.logException((Throwable)ex);
            }
        };
        AjaxSwingManager.beginOperation();
        worker.start();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.jCmbViewType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CardLayout cl = (CardLayout)LocationPanel.this.locationPanel.getLayout();
                    cl.show(LocationPanel.this.locationPanel, String.valueOf(LocationPanel.this.jCmbViewType.getSelectedIndex()));
                }
            }
        });
        this.add((Component)this.getLocationPanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public JPanel getTopPanel() {
        JPanel panel = new JPanel();
        if (!LicenseObject.getInstance().isSBProduct()) {
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(Box.createGlue());
            panel.add(this.jCmbViewType);
        }
        return panel;
    }

    private JPanel getLocationPanel() {
        this.locationTree.setVisibleRowCount(10);
        this.locationTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 20, 5));
        Dimension size = this.locationTable.getPreferredScrollableViewportSize();
        this.locationTable.setPreferredScrollableViewportSize(new Dimension(size.width * 2 / 3, (this.locationTable.getRowHeight() + this.locationTable.getRowMargin()) * 5 * 2));
        this.locationPanel.add((Component)new JScrollPane(this.locationTree), String.valueOf("0"));
        this.locationPanel.add((Component)new JScrollPane(this.locationTable), String.valueOf("1"));
        this.locationPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 30, 0));
        return this.locationPanel;
    }

    private int getTableModelType(AppliablePolicy policy) {
        switch (policy.getItemType()) {
            case 60: {
                return 2;
            }
            case 65: 
            case 148: {
                return 1;
            }
        }
        return 0;
    }

    private CheckItemTreeCellRenderer getTreeCellRenderer(AppliablePolicy policy) {
        switch (policy.getItemType()) {
            case 60: {
                return new CheckServerItemTreeCellRenderer(false);
            }
        }
        return new CheckItemTreeCellRenderer(false, true);
    }

    private TreeModel getTreeModel(AppliablePolicy policy) {
        return this.getTreeModel(policy, false);
    }

    private TreeModel getTreeModel(AppliablePolicy policy, boolean refresh) {
        if (!refresh && this.appliedToTreeModel != null) {
            return this.appliedToTreeModel;
        }
        TreeModel retValue = null;
        switch (policy.getItemType()) {
            case 65: 
            case 148: {
                retValue = PolicyUtil.getGroupTreeModel(policy, true);
                break;
            }
            default: {
                retValue = !LicenseObject.getInstance().isSBProduct() ? PolicyUtil.getLocTreeModel(policy, false, false, false) : PolicyUtil.getGroupTreeModel(policy, true);
            }
        }
        this.appliedToTreeModel = retValue;
        return this.appliedToTreeModel;
    }
}

