/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.AbstractSelectableUIObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.explorer.common.CheckItemTreeCellRenderer;
import com.sygate.scm.console.ui.policy.explorer.common.LocationTableModel;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LocationCheckBoxTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private boolean isLocationTreeEditable;
    private boolean makeEditingRecursive;
    private boolean enableLocationOperation;

    public LocationCheckBoxTree() {
        this(null, null, false, false);
    }

    public LocationCheckBoxTree(CheckItemTreeCellRenderer renderer, boolean isLocationTreeEditable) {
        this(renderer, null, isLocationTreeEditable, false);
    }

    public LocationCheckBoxTree(CheckItemTreeCellRenderer renderer, boolean isTreeEditable, boolean makeRecursive) {
        this(renderer, null, isTreeEditable, makeRecursive);
    }

    public LocationCheckBoxTree(CheckItemTreeCellRenderer renderer, TreeModel model, boolean isTreeEditable, boolean makeEditingRecursive) {
        this(renderer, null, isTreeEditable, makeEditingRecursive, true);
    }

    public LocationCheckBoxTree(CheckItemTreeCellRenderer renderer, TreeModel model, boolean isTreeEditable, boolean makeEditingRecursive, boolean enableLocationOperation) {
        try {
            this.isLocationTreeEditable = isTreeEditable;
            this.makeEditingRecursive = makeEditingRecursive;
            this.enableLocationOperation = enableLocationOperation;
            if (null != model) {
                this.setModel(model);
            }
            if (null != renderer) {
                this.setCellRenderer(renderer);
            }
            if (isTreeEditable) {
                this.addMouseListener(new CheckBoxTreeCellListener(this));
            }
            this.setShowsRootHandles(true);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    private void markObjectDirty(AbstractSelectableUIObject obj) {
        if (obj instanceof LocationObject) {
            LocationObject locObj = (LocationObject)obj;
            locObj.setDirty();
        } else if (obj instanceof GroupObject) {
            GroupObject grpObj = (GroupObject)obj;
            grpObj.setDirty();
        }
    }

    private void checkrequiredsubgroups(DefaultMutableTreeNode node, boolean selected, boolean shouldcount) {
        try {
            int count = node.getChildCount();
            if (count == 0) {
                node = new DefaultMutableTreeNode(node.getParent());
                count = node.getChildCount();
            }
            for (int i = 0; i < count; ++i) {
                GroupObject gp;
                DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)node.getChildAt(i);
                AbstractSelectableUIObject uiObj = (AbstractSelectableUIObject)aNode.getUserObject();
                if (uiObj instanceof LocationObject) {
                    uiObj.setSelected(uiObj.canIndirectiveSelectable() && selected);
                    if (shouldcount) {
                        this.markObjectDirty(uiObj);
                    }
                }
                if (!(uiObj instanceof GroupObject) || !(gp = (GroupObject)uiObj).isInherited()) continue;
                uiObj.setSelected(selected);
                this.checkrequiredsubgroups(aNode, selected, false);
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        this.repaint();
    }

    private void checkrequiredsubgroups1(DefaultMutableTreeNode node, boolean selected, boolean isPrentGroupInherit, String selectObjId) {
        try {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)node.getChildAt(i);
                AbstractSelectableUIObject uiObj = (AbstractSelectableUIObject)aNode.getUserObject();
                if (uiObj instanceof LocationObject) {
                    LocationObject locobj = (LocationObject)uiObj;
                    if (isPrentGroupInherit && locobj.getId().equals(selectObjId)) {
                        uiObj.setSelected(uiObj.canIndirectiveSelectable() && selected);
                    }
                }
                if (!(uiObj instanceof GroupObject)) continue;
                GroupObject gp = (GroupObject)uiObj;
                this.checkrequiredsubgroups1(aNode, selected, gp.isInherited(), selectObjId);
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        this.repaint();
    }

    private boolean isObjectSelected(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node != null && node.getUserObject() instanceof AbstractSelectableUIObject) {
            return ((AbstractSelectableUIObject)node.getUserObject()).isCurrentPolicy();
        }
        return false;
    }

    private ArrayList<Object> getRow(int modelType, TreePath path) {
        ArrayList<Object> row = new ArrayList<Object>(modelType == 1 ? 2 : 3);
        Object[] objList = path.getPath();
        String locPath = "";
        StringBuilder locBuf = new StringBuilder();
        String locName = "";
        AbstractSelectableUIObject appliedPolicy = null;
        boolean foundLocation = false;
        for (int i = 0; i < path.getPathCount(); ++i) {
            DefaultMutableTreeNode nd = (DefaultMutableTreeNode)objList[i];
            TreeItem obj = (TreeItem)nd.getUserObject();
            if (obj.getItemType() == 22) {
                locName = obj.getName();
                foundLocation = true;
            } else if (nd.isRoot()) {
                locBuf.append(obj.getName());
            } else {
                locBuf.append("/");
                locBuf.append(obj.getName());
            }
            if (!(obj instanceof AbstractSelectableUIObject)) continue;
            appliedPolicy = (AbstractSelectableUIObject)((Object)obj);
        }
        locPath = locBuf.toString();
        if (modelType != 1 && modelType != 2 && !foundLocation) {
            return null;
        }
        row.add(locPath);
        if (modelType != 1) {
            row.add(locName);
        }
        row.add(appliedPolicy);
        return row;
    }

    public boolean isLocationTreeEditable() {
        return this.isLocationTreeEditable;
    }

    public boolean isTreeEditingRecursive() {
        return this.isLocationTreeEditable;
    }

    public void setMakeEditingRecursive(boolean makeEditingRecursive) {
        this.makeEditingRecursive = makeEditingRecursive;
    }

    public boolean setEnabledAll(DefaultMutableTreeNode nodeParent, boolean isEnabled) {
        if (nodeParent == null) {
            return false;
        }
        TreePath[] treePaths = LocationCheckBoxTree.getAllPaths(nodeParent);
        for (int i = 0; i < treePaths.length; ++i) {
            AbstractSelectableUIObject uiObject;
            if (treePaths[i] == null) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePaths[i].getLastPathComponent();
            uiObject.setSelected((uiObject = (AbstractSelectableUIObject)node.getUserObject()).canIndirectiveSelectable() && isEnabled);
            this.markObjectDirty(uiObject);
        }
        this.repaint();
        return true;
    }

    public TableModel getTableModel(int modelType) {
        TreePath[] pathArray = this.getAllPaths();
        ArrayList<Object> rowList = new ArrayList<Object>();
        for (int i = 0; i < pathArray.length; ++i) {
            ArrayList<Object> row;
            if (!this.isObjectSelected(pathArray[i]) || (row = this.getRow(modelType, pathArray[i])) == null) continue;
            rowList.add(row);
        }
        return new LocationTableModel(modelType, rowList);
    }

    public TreePath[] getAllPaths() {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        LocationCheckBoxTree.getPaths(new TreePath(root), list);
        return list.toArray(new TreePath[list.size()]);
    }

    public static TreePath[] getAllPaths(TreeNode root) {
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        LocationCheckBoxTree.getPaths(new TreePath(root), list);
        return list.toArray(new TreePath[list.size()]);
    }

    public static void getPaths(TreePath parent, List<TreePath> list) {
        list.add(parent);
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                LocationCheckBoxTree.getPaths(path, list);
            }
        }
    }

    private class SelectionPopup
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;
        DefaultMutableTreeNode node;
        AbstractSelectableUIObject selectableUIObject;
        JMenuItem select = null;
        JMenuItem unselect = null;

        public SelectionPopup(boolean hasChildren) {
            this.select = new JMenuItem(LicenseObject.getInstance().isSBProduct() && !hasChildren ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LocationCheckBoxTree.menu.select") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LocationCheckBoxTree.menu.selectRecursively"));
            this.unselect = new JMenuItem(LicenseObject.getInstance().isSBProduct() && !hasChildren ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LocationCheckBoxTree.menu.unselect") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "LocationCheckBoxTree.menu.unselectRecursively"));
            this.select.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectionPopup.this.select_actionPerformed();
                }
            });
            this.unselect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectionPopup.this.unselect_actionPerformed();
                }
            });
            this.add(this.select);
            this.add(this.unselect);
        }

        private void select_actionPerformed() {
            this.selectableUIObject.setSelected(true);
            LocationCheckBoxTree.this.setEnabledAll(this.node, true);
        }

        private void unselect_actionPerformed() {
            this.selectableUIObject.setSelected(false);
            LocationCheckBoxTree.this.setEnabledAll(this.node, false);
        }

        public void setTreeNode(DefaultMutableTreeNode node, AbstractSelectableUIObject selectableUIObject) {
            this.selectableUIObject = selectableUIObject;
            this.node = node;
        }

        public void setSelectEnabled(boolean isEnabled) {
            this.select.setEnabled(isEnabled);
        }

        public void setUnselectEnabled(boolean isEnabled) {
            this.unselect.setEnabled(isEnabled);
        }
    }

    private class CheckBoxTreeCellListener
    extends MouseAdapter {
        JTree tree;

        CheckBoxTreeCellListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AbstractSelectableUIObject uiObj;
            if (e.getModifiers() == 4) {
                return;
            }
            if (!this.tree.isEnabled()) {
                return;
            }
            int x = e.getX();
            int y = e.getY();
            int row = this.tree.getRowForLocation(x, y);
            TreePath path = this.tree.getPathForLocation(x, y);
            Rectangle rect = this.tree.getPathBounds(path);
            if (path == null) {
                return;
            }
            Rectangle rectangle = this.tree.getRowBounds(row);
            int startX = rectangle.x;
            CheckItemTreeCellRenderer renderer = (CheckItemTreeCellRenderer)this.tree.getCellRenderer();
            int width = renderer.getCheckBoxWidth();
            int endX = startX + width;
            if (x < startX || x > endX) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object obj = node.getUserObject();
            if (obj instanceof AbstractSelectableUIObject && (uiObj = (AbstractSelectableUIObject)node.getUserObject()).canDirectiveSelectable()) {
                if (!LocationCheckBoxTree.this.enableLocationOperation && uiObj instanceof LocationObject && ((LocationObject)uiObj).isExternalCommunicationGlobal()) {
                    return;
                }
                uiObj.setSelected(!uiObj.isSelected());
                if (uiObj instanceof GroupObject) {
                    LocationCheckBoxTree.this.checkrequiredsubgroups(node, uiObj.isSelected(), true);
                } else if (uiObj instanceof LocationObject) {
                    LocationObject locobj = (LocationObject)uiObj;
                    node = (DefaultMutableTreeNode)path.getParentPath().getLastPathComponent();
                    LocationCheckBoxTree.this.checkrequiredsubgroups1(node, uiObj.isSelected(), false, locobj.getId());
                }
                LocationCheckBoxTree.this.markObjectDirty(uiObj);
                this.tree.repaint(rect);
                if (LocationCheckBoxTree.this.makeEditingRecursive) {
                    LocationCheckBoxTree.this.setEnabledAll(node, uiObj.isSelected());
                }
            }
        }

        private void showPopup(MouseEvent e) {
            DefaultMutableTreeNode node = this.getNode(e);
            if (node != null) {
                SelectionPopup popup = new SelectionPopup(node.getChildCount() > 0);
                Object obj = node.getUserObject();
                if (obj instanceof AbstractSelectableUIObject) {
                    AbstractSelectableUIObject selectableUIObject = (AbstractSelectableUIObject)node.getUserObject();
                    popup.setTreeNode(node, selectableUIObject);
                    if (!LocationCheckBoxTree.this.enableLocationOperation && obj instanceof LocationObject && ((LocationObject)obj).isExternalCommunicationGlobal()) {
                        popup.setSelectEnabled(false);
                        popup.setUnselectEnabled(false);
                    } else if (selectableUIObject.canDirectiveSelectable()) {
                        boolean isSelected = selectableUIObject.isSelected();
                        popup.setSelectEnabled(!isSelected);
                        popup.setUnselectEnabled(isSelected);
                    } else {
                        popup.setSelectEnabled(false);
                        popup.setUnselectEnabled(false);
                    }
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private DefaultMutableTreeNode getNode(MouseEvent e) {
            if (!this.tree.isEnabled()) {
                return null;
            }
            TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            return node;
        }
    }
}

