/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.common;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.AbstractSelectableUIObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.logicobject.QuarantineLocationObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.explorer.common.CheckRendererComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class CheckItemTreeCellRenderer
extends CheckRendererComponent
implements TreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static ImageIcon locationIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("location.png")));
    private static ImageIcon locationCheckedIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("location_applied.png")));
    private static ImageIcon locationGrayIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("location_gray.png")));
    private static ImageIcon locationCheckedGrayIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("location_applied_gray.png")));
    private static ImageIcon computerGroupIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("client_group_16.png")));
    private static ImageIcon computerGroupCheckedIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("computergroup_applied.png")));
    private static ImageIcon quarantineIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("hosts.png")));
    private boolean showCheckbox;
    private boolean onlyShowCurrent;
    private boolean enableInheritLocation;

    public CheckItemTreeCellRenderer() {
        this(true, false);
    }

    public CheckItemTreeCellRenderer(boolean showCheckbox) {
        this(showCheckbox, false);
    }

    public CheckItemTreeCellRenderer(boolean showCheckbox, boolean showSelected) {
        this(showCheckbox, showSelected, true);
    }

    public CheckItemTreeCellRenderer(boolean showCheckbox, boolean showSelected, boolean enableInheritLocation) {
        this.showCheckbox = showCheckbox;
        this.onlyShowCurrent = showSelected;
        this.enableInheritLocation = enableInheritLocation;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.label.setFont(tree.getFont());
        Object userObj = ((DefaultMutableTreeNode)value).getUserObject();
        boolean isQuarantine = userObj instanceof QuarantineLocationObject;
        boolean isGroupObject = false;
        boolean isClientControl = false;
        if (userObj instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)userObj;
            this.label.setText(treeItem.getName());
            switch (treeItem.getItemType()) {
                case 22: {
                    if (userObj instanceof AbstractSelectableUIObject && !((AbstractSelectableUIObject)userObj).canDirectiveSelectable()) {
                        this.label.setIcon(this.getIcon(treeItem, locationCheckedGrayIcon, locationGrayIcon));
                    } else if (!this.enableInheritLocation && ((LocationObject)userObj).isExternalCommunicationGlobal()) {
                        this.label.setIcon(this.getIcon(treeItem, locationCheckedGrayIcon, locationGrayIcon));
                    } else {
                        this.label.setIcon(this.getIcon(treeItem, locationCheckedIcon, locationIcon));
                    }
                    isClientControl = ((LocationObject)treeItem).getUserInterfaceObject().getMode() == 0;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 307: {
                    this.label.setIcon(this.getIcon(treeItem, computerGroupCheckedIcon, computerGroupIcon));
                    isGroupObject = true;
                    break;
                }
            }
        } else {
            this.setDefaultIcons(tree, value, isSelected, expanded, leaf, row, hasFocus);
        }
        if (userObj instanceof AbstractSelectableUIObject) {
            AbstractSelectableUIObject selectableUiObj = (AbstractSelectableUIObject)userObj;
            this.check.setSelected(selectableUiObj.isSelected());
            if (!this.enableInheritLocation && userObj instanceof TreeItem && ((TreeItem)userObj).getItemType() == 22 && ((LocationObject)userObj).isExternalCommunicationGlobal()) {
                this.check.setEnabled(false);
            } else {
                this.check.setEnabled(selectableUiObj.canDirectiveSelectable());
            }
            if (!this.onlyShowCurrent) {
                GroupObject grObj;
                String fm;
                String str;
                Object[] obj = new Object[]{this.label.getText()};
                if (isClientControl) {
                    str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "CheckItemTreeCellRenderer.inClientControlModel");
                    fm = MessageFormat.format(str, obj);
                    this.label.setText(fm);
                }
                if (!this.check.isEnabled() && isGroupObject && (grObj = (GroupObject)userObj).isInherited()) {
                    str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "CheckItemTreeCellRenderer.inheritFromParent");
                    fm = MessageFormat.format(str, obj);
                    this.label.setText(fm);
                }
            }
            if (selectableUiObj.isCurrentPolicy()) {
                this.label.setFont(this.label.getFont().deriveFont(1));
            }
            if (!selectableUiObj.canDirectiveSelectable()) {
                if (isSelected) {
                    this.label.setBackground(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    this.label.setBackground(UIManager.getColor("Tree.background"));
                }
                this.label.setForeground(UIManager.getColor("Label.disabledForeground"));
                if (isQuarantine) {
                    this.label.setForeground(Color.PINK);
                }
                return this;
            }
        }
        if (isSelected) {
            this.label.setBackground(UIManager.getColor("Tree.selectionBackground"));
            this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
        } else {
            this.label.setBackground(UIManager.getColor("Tree.background"));
            this.label.setForeground(UIManager.getColor("Tree.textForeground"));
        }
        if (isQuarantine) {
            this.label.setForeground(Color.RED);
            this.label.setIcon(quarantineIcon);
        }
        return this;
    }

    private void setDefaultIcons(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, hasFocus);
        this.label.setText(stringValue);
    }

    @Override
    public void doLayout() {
        Dimension d_check = this.check.getPreferredSize();
        Dimension d_label = this.label.getPreferredSize();
        int y_check = 0;
        int y_label = 0;
        if (d_check.height < d_label.height) {
            y_check = (d_label.height - d_check.height) / 2;
        } else {
            y_label = (d_check.height - d_label.height) / 2;
        }
        if (this.showCheckbox) {
            this.check.setVisible(true);
            this.check.setLocation(0, y_check);
            this.check.setBounds(0, y_check, d_check.width, d_check.height);
            this.label.setLocation(d_check.width, y_label);
            this.label.setBounds(d_check.width, y_label, d_label.width, d_label.height);
        } else {
            this.check.setVisible(false);
            this.label.setLocation(0, y_check);
            this.label.setBounds(0, y_check, d_label.width, d_label.height);
        }
    }

    private Icon getIcon(TreeItem treeItem, Icon checkedIcon, Icon nonCheckedIcon) {
        boolean isApplied = ((AbstractSelectableUIObject)((Object)treeItem)).isApplied();
        boolean isCurrent = ((AbstractSelectableUIObject)((Object)treeItem)).isCurrentPolicy();
        boolean isChecked = this.onlyShowCurrent ? isApplied && isCurrent : isApplied;
        return isChecked ? checkedIcon : nonCheckedIcon;
    }
}

