/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.common;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.EnabledObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.monitor.MonitorAgent;
import com.sygate.scm.common.util.ConfigObjectUtils;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.explorer.adaptive.AdaptivePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.av.AVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.av.AvPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.av.BaseAVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.av.LinuxAVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.av.MacAVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.common.PolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.common.dlg.PolicyApplyDialog;
import com.sygate.scm.console.ui.policy.explorer.fw.FwPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.hi.HostIntegrityPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.ids.IDSLibraryHandler;
import com.sygate.scm.console.ui.policy.explorer.ids.IdsPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.lu.LuContentPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.lu.LuPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.mem.MemPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.ntr.NtrPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.osp.OpAppProtectionPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.override.OverridePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.sle.ServerListHandler;
import com.sygate.scm.console.ui.policy.explorer.up.UpgradePolicyHandler;
import com.sygate.scm.console.ui.policy.override.OverridePolicyDialog;
import com.sygate.scm.console.ui.policy.override.logicobject.OverridePolicyObject;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.MessageHandler;
import com.sygate.scm.console.util.TopicEvent;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import java.awt.Cursor;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public abstract class BasePolicyHandler {
    protected PolicyPoolPane policyPoolPane;
    protected boolean checkApplied;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");
    private String uiRequestEventId = null;
    private String className = null;
    private String scenarioName = null;

    public static BasePolicyHandler getInstance(int type) {
        switch (type) {
            case 125: 
            case 134: {
                return AvPolicyHandler.getInstance();
            }
            case 128: 
            case 136: {
                return OverridePolicyHandler.getInstance();
            }
            case 309: 
            case 310: {
                return UpgradePolicyHandler.getInstance();
            }
            case 43: 
            case 57: {
                return FwPolicyHandler.getInstance();
            }
            case 56: 
            case 58: {
                return HostIntegrityPolicyHandler.getInstance();
            }
            case 63: 
            case 64: {
                return OpAppProtectionPolicyHandler.getInstance();
            }
            case 60: 
            case 61: {
                return ServerListHandler.getInstance();
            }
            case 65: 
            case 66: {
                return IDSLibraryHandler.getInstance();
            }
            case 143: 
            case 305: {
                return IdsPolicyHandler.getInstance();
            }
            case 129: 
            case 142: {
                return AVScanPoolHandler.getInstance();
            }
            case 400: {
                return MacAVScanPoolHandler.getInstance();
            }
            case 406: {
                return LinuxAVScanPoolHandler.getInstance();
            }
            case 144: 
            case 145: {
                return LuPolicyHandler.getInstance();
            }
            case 148: 
            case 149: {
                return LuContentPolicyHandler.getInstance();
            }
            case 401: {
                return BaseAVScanPoolHandler.getInstance();
            }
            case 169: 
            case 170: {
                return MemPolicyHandler.getInstance();
            }
            case 171: 
            case 172: {
                return NtrPolicyHandler.getInstance();
            }
            case 313: 
            case 314: {
                return AdaptivePolicyHandler.getInstance();
            }
        }
        return null;
    }

    public PolicyPoolPane getPolicyPoolPane(TreeItem treeItem) {
        this.policyPoolPane.updateObject();
        this.updatePolicyPoolPaneTitle(treeItem.getName());
        return this.policyPoolPane;
    }

    public void addPolicy(AppliablePolicyPool pool, JComponent source) {
        PolicyObjectBase policyObj;
        block10: {
            if (this.hasReadOnlyPermission()) {
                return;
            }
            if (!this.hasLicense(false)) {
                return;
            }
            policyObj = null;
            try {
                int platformType = 1;
                if (source instanceof PolicyPoolPane) {
                    platformType = ((PolicyPoolPane)source).getosSpecificPolicyIdentifier();
                    ((PolicyPoolPane)source).setosSpecificPolicyIdentifier(1);
                }
                switch (platformType) {
                    case 1: {
                        policyObj = this.getNewPolicy(pool);
                        break;
                    }
                    case 2: {
                        policyObj = this.getNewPolicy(pool, platformType);
                        break;
                    }
                    case 3: {
                        policyObj = this.getNewPolicy(pool, platformType);
                        break;
                    }
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("BasePolicyHandler.error"), 0);
                if (!ex.needRelogin()) break block10;
                Manager.getFrame().showLoginPanel();
            }
        }
        this.addPolicy(source, policyObj);
    }

    public void editPolicy(JComponent source, AppliablePolicyPool pool, PolicyObjectBase policy) {
        block5: {
            try {
                PolicyObjectBase newPolicy = this.getEditPolicy(source, pool, policy);
                if (this.className == null) {
                    String tempName = this.getClass().getName();
                    this.className = tempName.substring(tempName.lastIndexOf(46) + 1);
                }
                MonitorAgent.getInstance().startScenario(this.className + "_EditPolicy", "SEPM_Java");
                this.uiRequestEventId = MonitorAgent.getInstance().startEvent("UIRequest", null);
                if (newPolicy != null) {
                    boolean skipEqualsCheck = newPolicy.isAnyObjectSetModified();
                    if (!skipEqualsCheck && ConfigObjectUtils.isEqualObj((Object)newPolicy.getSchemaObj(), (Object)policy.getSchemaObj())) {
                        newPolicy.setSchemaObj(policy.getSchemaObj());
                    }
                    this.getPolicyPoolObject().updatePolicyObject(newPolicy);
                    this.updatePolicyObject(policy, newPolicy);
                    this.policyChanged(source, "edited", policy);
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("BasePolicyHandler.error"), 0);
                if (!ex.needRelogin()) break block5;
                Manager.getFrame().showLoginPanel();
            }
        }
        MonitorAgent.getInstance().stopEvent(this.uiRequestEventId);
        MonitorAgent.getInstance().stopScenario(this.className + "_EditPolicy");
    }

    public void deletePolicy(JComponent source, PolicyObjectBase policy) {
        this.deletePolicy(source, policy, false);
    }

    public void deletePolicy(JComponent source, PolicyObjectBase policy, boolean deleteSilently) {
        block8: {
            if (this.hasReadOnlyPermission()) {
                return;
            }
            if (!this.isCorrectPolicyType(policy)) {
                return;
            }
            try {
                if (!deleteSilently) {
                    Object[] obj = new Object[]{policy.getName()};
                    String str = this.getDeletePolicyMessage();
                    String fm = MessageFormat.format(str, obj);
                    int res = JOptionPane.showConfirmDialog(Manager.getFrame(), fm, this.getDeletePolicyTitle(), 0);
                    if (res != 0) {
                        return;
                    }
                }
                PolicyPoolPane superPanel = (PolicyPoolPane)source;
                superPanel.updateObject();
                if (superPanel.policyInUse()) {
                    return;
                }
                MonitorAgent.getInstance().startScenario(policy.getName() + " delete", "SEPM_Java");
                String eventId = MonitorAgent.getInstance().startEvent("UIRequest", null);
                this.getPolicyPoolObject().deletePolicyObject(policy);
                this.policyChanged(source, "deleted", policy);
                MonitorAgent.getInstance().stopEvent(eventId);
                MonitorAgent.getInstance().stopScenario(policy.getName() + " delete");
            }
            catch (ConcurrentModificationException cme) {
                LoggerUtilities.logException((Throwable)cme);
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("BasePolicyHandler.error"), 0);
                if (!ex.needRelogin()) break block8;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void pastePolicy(JComponent source) {
        block5: {
            if (this.hasReadOnlyPermission()) {
                return;
            }
            try {
                if (PolicyHandler.hasCopiedObject(this.getPolicyObjectClass())) {
                    PolicyObjectBase newObj = (PolicyObjectBase)PolicyHandler.getPastedObject();
                    String name = newObj.getName();
                    Object[] obj = new Object[]{name};
                    String msg = MSG_RES.getString("BasePolicyHandler.copy_of");
                    String fm = MessageFormat.format(msg, obj);
                    int i = 2;
                    while (!this.getPolicyPoolObject().checkNewName(newObj, fm)) {
                        obj = new Object[]{i, name};
                        msg = MSG_RES.getString("BasePolicyHandler.copy_i_of");
                        fm = MessageFormat.format(msg, obj);
                        ++i;
                    }
                    newObj.setName(fm);
                    this.addPolicy(source, newObj, true);
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("BasePolicyHandler.error"), 0);
                if (!ex.needRelogin()) break block5;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void applyPolicy(PolicyObjectBase policy) {
        block5: {
            if (!this.isCorrectPolicyType(policy) || !this.hasLicense(false)) {
                return;
            }
            try {
                if (!this.canBeApplied()) {
                    MultiLineMsgBox optionPane = new MultiLineMsgBox(Manager.getFrame(), this.getApplyPolicyTitle());
                    optionPane.init(this.getCannotApplyPolicyMsg(), 60, 0, -1);
                    optionPane.show();
                    return;
                }
                this.checkAppliedPolicyEnableStatus(policy, false, true, MSG_RES.getString("BasePolicyHandler.newPolicyDisabledQuestion"));
                PolicyApplyDialog dlg = this.createPolicyApplyDialog(this.getApplyPolicyTitle(), "apply", policy);
                if (dlg.isOk()) {
                    MonitorAgent.getInstance().startScenario(policy.getName() + " assign", "SEPM_Java");
                    String eventId = MonitorAgent.getInstance().startEvent("UIRequest", null);
                    this.getPolicyPoolObject().submitActionsToPolicyLogs(policy, "applied");
                    this.policyChanged(policy, "applied", policy);
                    MonitorAgent.getInstance().stopEvent(eventId);
                    MonitorAgent.getInstance().stopScenario(policy.getName() + " assign");
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("BasePolicyHandler.error"), 0);
                if (!ex.needRelogin()) break block5;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void replacePolicy(PolicyObjectBase policy) {
        block5: {
            if (!this.isCorrectPolicyType(policy) || !this.hasLicense(false)) {
                return;
            }
            try {
                AppliablePolicyPool policyPoolObj = this.getPolicyPoolObject();
                ObjInfoObject[] infoObj = policyPoolObj.getInfoObjectList();
                if (infoObj.length < 2) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), this.getReplacePolicyMessage(), this.getReplacePolicyTitle(), 0);
                    return;
                }
                PolicyApplyDialog dlg = this.createPolicyReplaceDialog(this.getReplacePolicyTitle(), "replace", policy, infoObj);
                if (dlg.isOk()) {
                    policyPoolObj.submitActionsToPolicyLogs(policy, "replaced");
                    this.policyChanged(policy, "applied", policy);
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("BasePolicyHandler.error"), 0);
                if (!ex.needRelogin()) break block5;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void withdrawPolicy(PolicyObjectBase policy) {
        block7: {
            String infoString = "";
            int type = policy.getItemType();
            if (!this.isCorrectPolicyType(policy)) {
                return;
            }
            if (type == 134) {
                infoString = MSG_RES.getString("BasePolicyHandler.cannotWithrawAV");
                JOptionPane.showMessageDialog(Manager.getFrame(), infoString, MSG_RES.getString("BasePolicyHandler.InfoDlgTitle"), 2);
                return;
            }
            if (type == 144) {
                infoString = MSG_RES.getString("BasePolicyHandler.cannotWithrawLU");
                JOptionPane.showMessageDialog(Manager.getFrame(), infoString, MSG_RES.getString("BasePolicyHandler.InfoDlgTitle"), 2);
                return;
            }
            if (type == 169) {
                infoString = MSG_RES.getString("BasePolicyHandler.cannotWithrawMEM");
                JOptionPane.showMessageDialog(Manager.getFrame(), infoString, MSG_RES.getString("BasePolicyHandler.InfoDlgTitle"), 2);
                return;
            }
            try {
                PolicyApplyDialog dlg = this.createPolicyApplyDialog(this.getWithdrawPolicyTitle(), "remove", policy);
                if (dlg.isOk()) {
                    this.getPolicyPoolObject().updatePolicyObject(policy);
                    this.policyChanged(policy, "applied", policy);
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("BasePolicyHandler.error"), 0);
                if (!(ex instanceof ConsoleException) || !((ConsoleException)ex).needRelogin()) break block7;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    public void importPolicy(JComponent source) {
        if (this.hasReadOnlyPermission()) {
            return;
        }
        PolicyObjectBase policyObj = this.importPolicy();
        if (policyObj == null) {
            return;
        }
        this.addPolicy(source, policyObj);
    }

    public void importPolicy(JComponent source, File file) {
        PolicyObjectBase policyObj;
        if (this.hasReadOnlyPermission()) {
            return;
        }
        PolicyObjectBase policyObjectBase = policyObj = file == null ? this.importPolicy() : this.importPolicy(file);
        if (policyObj == null) {
            return;
        }
        this.addPolicy(source, policyObj);
    }

    protected void handleCustomImportConfiguration(ConfigObject policyObj) {
    }

    public void exportPolicy(JComponent source, PolicyObjectBase policy) {
        block3: {
            ConsoleLogger.log("BasePolicyHandler >> exportPolicy: source: " + source.getName() + ", policy: " + policy.getName());
            boolean isSuccess = PolicyHandler.exportPolicy((ConfigObject)policy.getSchemaObj(), policy.getName(), this.getImportExportFileChooser(false));
            if (isSuccess) {
                try {
                    this.getPolicyPoolObject().submitActionsToPolicyLogs(policy, "exported");
                    this.policyPoolPane.updateObject();
                }
                catch (ConsoleException ex) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("BasePolicyHandler.error"), 0);
                    if (!ex.needRelogin()) break block3;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
    }

    public abstract boolean hasLicense(boolean var1);

    protected boolean addPolicy(JComponent source, PolicyObjectBase policy) {
        return this.addPolicy(source, policy, false);
    }

    protected boolean addPolicy(JComponent source, PolicyObjectBase policy, boolean isPaste) {
        if (this.className == null) {
            String tempName = this.getClass().getName();
            this.className = tempName.substring(tempName.lastIndexOf(46) + 1);
        }
        MonitorAgent.getInstance().startScenario(this.className + "_AddPolicy", "SEPM_Java");
        this.uiRequestEventId = MonitorAgent.getInstance().startEvent("UIRequest", null);
        if (!this.isCorrectPolicyType(policy)) {
            return false;
        }
        try {
            TopLevelObject domain;
            if (policy.getSchemaObj() != null && policy.getSchemaObj().getMetadataAttributes() != null) {
                policy.getSchemaObj().getMetadataAttributes().setOwner(null);
            }
            AppliablePolicyPool policyPoolObj = (domain = policy.getChangedObjSet().get(DataobjectManager.getInstance().getLoginInformation().getOptDomainGUID())) != null ? this.getPolicyPoolObject((SemDomain)domain) : this.getPolicyPoolObject();
            List<String> nameList = policyPoolObj.getAllName(policy);
            String newName = PolicyHandler.validatePolicyName(policy.getName(), nameList, this.getPolicyNameLength());
            if (newName == null) {
                return false;
            }
            policy.setName(newName);
            policyPoolObj.addPolicyObject(policy, isPaste);
            this.policyChanged(source, "added", policy);
            if (this.checkApplied) {
                PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
                if (AuthorizationManager.getInstance().checkPermission(context, (Permission)AuthorizationManager.SpecialPermission.ONE_GROUP_FULL_ACCESS)) {
                    PolicyObjectBase policyObj = null;
                    try {
                        String type = policy.getSchemaObj().getObjectTypeName();
                        String guid = policy.getSchemaObj().getId();
                        TopLevelObject topLevelObject = DataobjectManager.getInstance().getObjectByGUID(type, guid);
                        if (topLevelObject != null) {
                            policyObj = this.createPolicyObject((ConfigObject)topLevelObject);
                        }
                        if (policyObj == null) {
                            ConsoleException ex = new ConsoleException("Reloading the policy object return null!");
                            ex.setNeedRelogin(false);
                            throw ex;
                        }
                        this.checkApplied(policyObj);
                    }
                    catch (ConsoleException ex) {
                        JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("BasePolicyHandler.error"), 0);
                        if (ex.needRelogin()) {
                            Manager.getFrame().showLoginPanel();
                        }
                    }
                }
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSG_RES.getString("BasePolicyHandler.error"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            return false;
        }
        MonitorAgent.getInstance().stopEvent(this.uiRequestEventId);
        MonitorAgent.getInstance().stopScenario(this.className + "_AddPolicy");
        return true;
    }

    protected void updatePolicyObject(PolicyObjectBase policy, PolicyObjectBase newPolicy) {
        if (newPolicy == null) {
            policy.setCreator(AdminObject.retrieveCurrentAdminObject().getName());
        } else {
            policy.setSchemaObj(newPolicy.getSchemaObj());
        }
    }

    protected void updatePolicyPoolPaneTitle(String name) {
        this.policyPoolPane.setTitle(this.getPolicyPoolPaneTitle(name));
    }

    protected String getPolicyPoolPaneTitle(String name) {
        return name;
    }

    protected PolicyObjectBase importPolicy() {
        ConfigObject obj = PolicyHandler.importPolicy(this.getImportExportFileChooser(true));
        this.handleCustomImportConfiguration(obj);
        return this.importPolicy(obj);
    }

    protected PolicyObjectBase importPolicy(File file) {
        ConfigObject obj = PolicyHandler.importPolicy(file);
        this.handleCustomImportConfiguration(obj);
        return this.importPolicy(obj);
    }

    protected String getDeletePolicyMessage() {
        return MSG_RES.getString("BasePolicyHandler.deletePolicy_");
    }

    protected String getDeletePolicyTitle() {
        return MSG_RES.getString("BasePolicyHandler.deletePolicy");
    }

    protected PolicyApplyDialog createPolicyApplyDialog(String title, String type, PolicyObjectBase policy) {
        return new PolicyApplyDialog(title, type, policy);
    }

    protected PolicyApplyDialog createPolicyReplaceDialog(String title, String type, PolicyObjectBase policy, ObjInfoObject[] objArr) {
        return new PolicyApplyDialog(title, type, (TreeItem)policy, objArr);
    }

    protected PolicyObjectBase getNewPolicy(AppliablePolicyPool pool) throws ConsoleException {
        Cursor curCursor = Manager.getFrame().getCursor();
        Manager.getFrame().setCursor(new Cursor(3));
        BasePolicyDialog dlg = this.getNewPolicyDialog(pool);
        PolicyObjectBase newPolicy = (PolicyObjectBase)((Object)dlg.createNewPolicy(pool));
        Manager.getFrame().setCursor(curCursor);
        MonitorAgent.getInstance().stopEvent(this.uiRequestEventId);
        MonitorAgent.getInstance().stopScenario(this.scenarioName);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            this.checkApplied = true;
        }
        return dlg.isOk() ? newPolicy : null;
    }

    protected PolicyObjectBase getNewPolicy(AppliablePolicyPool pool, Integer osSpecificIdentifier) throws ConsoleException {
        ConsoleLogger.log("PolicyObjectBase >> getNewPolicy, osSpecificIdentifier: " + osSpecificIdentifier);
        return this.getNewPolicy(pool);
    }

    protected PolicyObjectBase getEditPolicy(JComponent source, AppliablePolicyPool pool, PolicyObjectBase policy) throws ConsoleException {
        TimeCounter c = new TimeCounter();
        BasePolicyDialog dlg = this.getEditPolicyDialog(pool);
        dlg.setTitle(policy.getName());
        PolicyObjectBase newPolicy = (PolicyObjectBase)((Object)dlg.createNewPolicy(policy.getCopyOfPolicyObject()));
        ConsoleLogger.log("BasePolicyHandler::getEditPolicy: " + c + ", source: " + source.getName());
        MonitorAgent.getInstance().stopEvent(this.uiRequestEventId);
        MonitorAgent.getInstance().stopScenario(this.scenarioName);
        if (dlg instanceof OverridePolicyDialog && newPolicy instanceof OverridePolicyObject) {
            OverridePolicyObject overridePolicy = (OverridePolicyObject)policy;
            dlg.setReadOnly(overridePolicy.isExclusiveEdit());
        }
        ReadOnlyUtils.disableAbsPolicyEditorDlgIfNeeded(dlg);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            if (!dlg.isReadOnly()) {
                this.checkAppliedPolicyEnableStatus(newPolicy, true, false, MSG_RES.getString("BasePolicyHandler.policyDisabledAssignedQuestion"));
            }
            return newPolicy;
        }
        return null;
    }

    private void checkApplied(PolicyObjectBase policy) {
        this.checkApplied = false;
        if (0 == JOptionPane.showConfirmDialog(Manager.getFrame(), MSG_RES.getString("BasePolicyHandler.applyPolicyQuestion"), MSG_RES.getString("BasePolicyHandler.applyPolicyTitle"), 0)) {
            this.applyPolicy(policy);
        }
    }

    protected void checkAppliedPolicyEnableStatus(PolicyObjectBase policy, boolean checkAssignStatus, boolean saveChanges, String message) {
        try {
            HashMap<String, Integer> mapCount;
            if (!(policy.getSchemaObj() instanceof EnabledObject)) {
                ConsoleLogger.log("BasePolicyHandler >> checkAppliedPolicyEnableStatus, This policy not an EnabledObject, Name: " + policy.getName());
                return;
            }
            EnabledObject enabledObject = (EnabledObject)policy.getSchemaObj();
            if (Utility.getBooleanValue((Boolean)enabledObject.getOptEnable(), (Boolean)enabledObject.getDefEnable())) {
                ConsoleLogger.log("BasePolicyHandler >> checkAppliedPolicyEnableStatus, This policy is enabled Name: " + policy.getName());
                return;
            }
            boolean popupWarning = true;
            if (checkAssignStatus && ((mapCount = DataobjectManager.getInstance().getPoliciesAppliedCount(Arrays.asList(policy.getId()))) == null || mapCount.get(policy.getId()) <= 0)) {
                popupWarning = false;
            }
            if (popupWarning && 0 == JOptionPane.showConfirmDialog(Manager.getFrame(), message, MSG_RES.getString("BasePolicyHandler.policyDisabledTitle"), 0)) {
                ((EnabledObject)policy.getSchemaObj()).setOptEnable(Boolean.valueOf(true));
                ConsoleLogger.log("BasePolicyHandler >> checkAppliedPolicyEnableStatus, enabled the policy: " + policy.getName());
                if (saveChanges) {
                    DataobjectManager.getInstance().updateObject("Merge", policy.getSchemaObj());
                    ConsoleLogger.log("BasePolicyHandler >> checkAppliedPolicyEnableStatus, Saved policy: " + policy.getName());
                }
            }
        }
        catch (ConsoleException e) {
            ConsoleLogger.log("BasePolicyHandler >> checkAppliedPolicyEnableStatus, Error: " + e.getMessage());
        }
    }

    protected boolean hasReadOnlyPermission() {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("BasePolicyHandler.readOnlyPolicyPermission"), MSG_RES.getString("BasePolicyHandler.readOnlyPolicy"), 0);
            return true;
        }
        return false;
    }

    protected JFileChooser getImportExportFileChooser(boolean isImport) {
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(this.getImportExportFileFilter(isImport));
        return chooser;
    }

    public FileFilter getImportExportFileFilter(boolean isImport) {
        ConsoleLogger.log("BasePolicyHandler >> getImportExportFileFilter, isImport: " + isImport);
        return PolicyHandler.getExportFileFilter();
    }

    protected abstract BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool var1) throws ConsoleException;

    protected abstract BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool var1) throws ConsoleException;

    protected abstract List<Class<? extends PolicyObjectBase>> getPolicyObjectClass();

    protected abstract int getPolicyNameLength();

    protected abstract boolean isCorrectPolicyType(PolicyObjectBase var1);

    protected abstract String getApplyPolicyTitle();

    protected abstract String getReplacePolicyTitle();

    protected abstract String getReplacePolicyMessage();

    protected abstract String getWithdrawPolicyTitle();

    protected abstract String getImportFailMessage();

    protected boolean canBeApplied() throws ConsoleException {
        return true;
    }

    protected String getCannotApplyPolicyMsg() {
        return MSG_RES.getString("BasePolicyHandler.cannotApplyPolicy_Msg");
    }

    protected abstract PolicyObjectBase createPolicyObject(ConfigObject var1);

    protected abstract PolicyObjectBase getPolicyObject(ObjInfoObject var1) throws ConsoleException;

    protected abstract AppliablePolicyPool getPolicyPoolObject() throws ConsoleException;

    protected abstract AppliablePolicyPool getPolicyPoolObject(SemDomain var1) throws ConsoleException;

    private void policyChanged(Object source, String eventType, PolicyObjectBase policy) {
        TopicEvent topicEvt = new TopicEvent(source, eventType, policy);
        MessageHandler.getInstance().sendMessage(topicEvt);
    }

    private PolicyObjectBase importPolicy(ConfigObject obj) {
        if (obj == null) {
            return null;
        }
        PolicyObjectBase policyObj = this.createPolicyObject(obj);
        if (policyObj == null) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("BasePolicyHandler.failedToImportThePolicy"), MSG_RES.getString("BasePolicyHandler.error"), 0);
            return null;
        }
        policyObj.addNewObj((TopLevelObject)obj);
        return policyObj;
    }
}

