/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.av;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.LinuxAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.AdminScanDialog;
import com.sygate.scm.console.ui.policy.av.logicobject.AdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.av.logicobject.LinuxAdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.LinuxAdminDefinedScanPoolObject;
import com.sygate.scm.console.ui.policy.explorer.av.AVScanPoolPane;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;

public class LinuxAVScanPoolHandler
extends BasePolicyHandler {
    private MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");
    private static LinuxAVScanPoolHandler handler;

    private LinuxAVScanPoolHandler() {
        this.policyPoolPane = new AVScanPoolPane();
    }

    public static synchronized LinuxAVScanPoolHandler getInstance() {
        if (handler == null) {
            handler = new LinuxAVScanPoolHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        return true;
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return null;
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return null;
    }

    @Override
    protected PolicyObjectBase getNewPolicy(AppliablePolicyPool pool) throws ConsoleException {
        AdminScanDialog dlg = new AdminScanDialog(this.res.getString("AVScanPoolHandler.scanAdd"), false, null, null, false, false, false, true, 3);
        dlg.setObject((LinuxAdminDefinedScanPoolObject)pool);
        LinuxAdminDefinedScan defaultScan = this.getDefaultLinuxAdminDefinedScan(pool);
        dlg.setObject(defaultScan);
        dlg.setVisible(true);
        LinuxAdminDefinedScan ads = dlg.getLinuxObject();
        ads.setId(GUIDGenerator.getInstance().getGUIDString());
        LinuxAdminDefinedScanObject scanObj = new LinuxAdminDefinedScanObject(ads);
        return dlg.isOk() ? scanObj : null;
    }

    public LinuxAdminDefinedScan getDefaultLinuxAdminDefinedScan(AppliablePolicyPool pool) {
        LinuxAdminDefinedScan defaultScan = null;
        try {
            defaultScan = PolicyHandler.getDefaultLinuxAdminDefinedScan();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            defaultScan = new LinuxAdminDefinedScan();
        }
        defaultScan.setName(this.getNextScanName((LinuxAdminDefinedScanPoolObject)pool));
        return defaultScan;
    }

    private String getNextScanName(LinuxAdminDefinedScanPoolObject scanPoolObj) {
        int newLastNumber = 0;
        Object newName = this.res.getString("AVScanPoolHandler.new.scanName");
        List<ObjInfoObject> objInfoList = Arrays.asList(scanPoolObj.getInfoObjectList());
        for (int i = 0; i < objInfoList.size(); ++i) {
            ObjInfoObject objInfo = objInfoList.get(i);
            if (!objInfo.getName().startsWith((String)newName)) continue;
            if (objInfo.getName().length() == ((String)newName).length()) {
                newLastNumber = Math.max(1, newLastNumber);
            }
            String prepend = objInfo.getName().substring(((String)newName).length()).trim();
            try {
                if (prepend.length() <= 0) continue;
                int number = Integer.parseInt(prepend);
                newLastNumber = Math.max(number, newLastNumber);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (newLastNumber > 0) {
            newName = (String)newName + " " + (newLastNumber + 1);
        }
        return newName;
    }

    @Override
    protected PolicyObjectBase getEditPolicy(JComponent source, AppliablePolicyPool pool, PolicyObjectBase policy) throws ConsoleException {
        AdminScanDialog dlg = new AdminScanDialog(this.res.getString("AVScanPoolHandler.scanEdit"), false, null, null, false, false, false, true, 3);
        dlg.setObject((LinuxAdminDefinedScanPoolObject)pool);
        dlg.setObject((LinuxAdminDefinedScan)policy.getCopyOfPolicyObject());
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            ReadOnlyUtils.disableDialog(dlg);
        }
        dlg.setVisible(true);
        LinuxAdminDefinedScan ads = dlg.getLinuxObject();
        LinuxAdminDefinedScanObject scanObj = new LinuxAdminDefinedScanObject(ads);
        return dlg.isOk() ? scanObj : null;
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(AdminDefinedScanObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 255;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof LinuxAdminDefinedScanObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return "blah";
    }

    @Override
    protected String getReplacePolicyTitle() {
        return "blah";
    }

    @Override
    protected String getReplacePolicyMessage() {
        return "blah";
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return "blah";
    }

    @Override
    protected String getImportFailMessage() {
        return "blah";
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof LinuxAdminDefinedScan) {
            return new LinuxAdminDefinedScanObject((LinuxAdminDefinedScan)obj);
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        return new AdminDefinedScanObject(DataobjectManager.getInstance().getAdminDefinedScan(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return AdminDefinedScanPoolObject.getPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new AdminDefinedScanPoolObject(domain);
    }

    protected boolean isAnyPolicyInUse(PolicyObjectBase policy) {
        return false;
    }

    @Override
    protected String getDeletePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AVScanPolicyHandler.deleteScanMsg");
    }

    @Override
    protected String getDeletePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AVScanPolicyHandler.deleteScheduledScan");
    }
}

