/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.av;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.AdminDefinedScan;
import com.sygate.scm.common.configobject.schema.LinuxAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.av.admindefinedscan.AdminScanDialog;
import com.sygate.scm.console.ui.policy.av.logicobject.AdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.LinuxAdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.MacAdminDefinedScanObject;
import com.sygate.scm.console.ui.policy.av.logicobject.ScheduleScanPoolObject;
import com.sygate.scm.console.ui.policy.explorer.av.AVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.av.AVScanPoolPane;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class BaseAVScanPoolHandler
extends BasePolicyHandler {
    private MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer");
    private static BaseAVScanPoolHandler handler;
    private Map<Integer, BasePolicyHandler> osDependentPolicyHandlers = new HashMap<Integer, BasePolicyHandler>();
    private static final String NOT_IMPLEMENTED = "Not Implemented";
    private Map<Integer, Integer> mapPlatformToTreeItem = new HashMap<Integer, Integer>();

    private BaseAVScanPoolHandler() {
        this.policyPoolPane = new AVScanPoolPane();
    }

    private void initOSSpecificHandlers() {
        this.osDependentPolicyHandlers.put(129, BasePolicyHandler.getInstance(129));
        this.osDependentPolicyHandlers.put(400, BasePolicyHandler.getInstance(400));
        this.osDependentPolicyHandlers.put(406, BasePolicyHandler.getInstance(406));
        this.mapPlatformToTreeItem.put(1, 129);
        this.mapPlatformToTreeItem.put(2, 400);
        this.mapPlatformToTreeItem.put(3, 406);
    }

    public static synchronized BaseAVScanPoolHandler getInstance() {
        if (handler == null) {
            handler = new BaseAVScanPoolHandler();
            handler.initOSSpecificHandlers();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        return true;
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return null;
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return null;
    }

    private Integer getPolicyType(PolicyObjectBase policy) {
        Integer itemType = null;
        if (policy instanceof AdminDefinedScanObject) {
            itemType = 129;
        } else if (policy instanceof MacAdminDefinedScanObject) {
            itemType = 400;
        } else if (policy instanceof LinuxAdminDefinedScanObject) {
            itemType = 406;
        }
        return itemType;
    }

    private Integer getPlatFormType(Integer itemType) {
        for (Map.Entry<Integer, Integer> entry : this.mapPlatformToTreeItem.entrySet()) {
            if (!itemType.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getNewPolicy(AppliablePolicyPool pool, Integer platformType) throws ConsoleException {
        return this.getNewPolicy(pool);
    }

    @Override
    protected PolicyObjectBase getNewPolicy(AppliablePolicyPool pool) throws ConsoleException {
        AdminScanDialog dlg = new AdminScanDialog(this.res.getString("AVScanPoolHandler.scanAdd"), false, false, (ScheduleScanPoolObject)pool, 1);
        int platFormType = 1;
        BasePolicyHandler bph = BaseAVScanPoolHandler.getBasePolicyHandler(platFormType);
        AppliablePolicyPool osSpecificPoolObject = BaseAVScanPoolHandler.getOSSpecificPoolObject(platFormType, (ScheduleScanPoolObject)pool);
        AdminDefinedScan defaultScan = ((AVScanPoolHandler)bph).getDefaultAdminDefinedScan(osSpecificPoolObject);
        dlg.setObject(defaultScan);
        dlg.setVisible(true);
        PolicyObjectBase scanObj = null;
        platFormType = dlg.getSelectedPlatFormType();
        switch (platFormType) {
            case 1: {
                AdminDefinedScan ads = dlg.getObject();
                ads.setId(GUIDGenerator.getInstance().getGUIDString());
                scanObj = new AdminDefinedScanObject(ads);
                break;
            }
            case 2: {
                MacAdminDefinedScan macAds = dlg.getMacObject();
                macAds.setId(GUIDGenerator.getInstance().getGUIDString());
                scanObj = new MacAdminDefinedScanObject(macAds);
                break;
            }
            case 3: {
                LinuxAdminDefinedScan linuxAds = dlg.getLinuxObject();
                linuxAds.setId(GUIDGenerator.getInstance().getGUIDString());
                scanObj = new LinuxAdminDefinedScanObject(linuxAds);
                break;
            }
        }
        return dlg.isOk() ? scanObj : null;
    }

    public static synchronized BasePolicyHandler getBasePolicyHandler(int platFormType) {
        Integer itemType = BaseAVScanPoolHandler.getInstance().mapPlatformToTreeItem.get(platFormType);
        BasePolicyHandler bph = BaseAVScanPoolHandler.handler.osDependentPolicyHandlers.get(itemType);
        return bph;
    }

    public static AppliablePolicyPool getOSSpecificPoolObject(int platFormType, ScheduleScanPoolObject pool) {
        Integer itemType = BaseAVScanPoolHandler.getInstance().mapPlatformToTreeItem.get(platFormType);
        AppliablePolicyPool osSpecificPoolObject = pool.getConfigObjectPool(itemType);
        return osSpecificPoolObject;
    }

    @Override
    protected PolicyObjectBase getEditPolicy(JComponent source, AppliablePolicyPool pool, PolicyObjectBase policy) throws ConsoleException {
        Integer itemType = this.getPolicyType(policy);
        Integer platFormType = this.getPlatFormType(itemType);
        String title = null;
        switch (platFormType) {
            case 1: {
                title = this.res.getString("AVScanPoolHandler.scanEdit");
                break;
            }
            case 2: {
                title = this.res.getString("MacAVScanPoolHandler.scanEdit");
                break;
            }
            case 3: {
                title = this.res.getString("AVScanPoolHandler.scanEdit");
                break;
            }
        }
        AdminScanDialog dlg = new AdminScanDialog(title, false, false, true, (ScheduleScanPoolObject)pool, (int)platFormType);
        switch (platFormType) {
            case 1: {
                dlg.setObject((AdminDefinedScan)policy.getCopyOfPolicyObject());
                break;
            }
            case 2: {
                dlg.setObject((MacAdminDefinedScan)policy.getCopyOfPolicyObject());
                break;
            }
            case 3: {
                dlg.setObject((LinuxAdminDefinedScan)policy.getCopyOfPolicyObject());
                break;
            }
        }
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            ReadOnlyUtils.disableDialog(dlg);
        }
        dlg.setVisible(true);
        PolicyObjectBase scanObj = null;
        if (platFormType.intValue() != dlg.getSelectedPlatFormType()) {
            boolean policyAdditionSuccessful;
            platFormType = dlg.getSelectedPlatFormType();
            switch (platFormType) {
                case 1: {
                    AdminDefinedScan ads = dlg.getObject();
                    ads.setId(GUIDGenerator.getInstance().getGUIDString());
                    scanObj = new AdminDefinedScanObject(ads);
                    break;
                }
                case 2: {
                    MacAdminDefinedScan macAds = dlg.getMacObject();
                    macAds.setId(GUIDGenerator.getInstance().getGUIDString());
                    scanObj = new MacAdminDefinedScanObject(macAds);
                    break;
                }
                case 3: {
                    LinuxAdminDefinedScan linuxAds = dlg.getLinuxObject();
                    linuxAds.setId(GUIDGenerator.getInstance().getGUIDString());
                    scanObj = new LinuxAdminDefinedScanObject(linuxAds);
                    break;
                }
            }
            if (dlg.isOk() && (policyAdditionSuccessful = this.addPolicy(source, scanObj))) {
                this.deletePolicy(source, policy, true);
            }
            scanObj = null;
        } else {
            switch (platFormType) {
                case 1: {
                    AdminDefinedScan ads = dlg.getObject();
                    scanObj = new AdminDefinedScanObject(ads);
                    break;
                }
                case 2: {
                    MacAdminDefinedScan macAds = dlg.getMacObject();
                    scanObj = new MacAdminDefinedScanObject(macAds);
                    break;
                }
                case 3: {
                    LinuxAdminDefinedScan linuxAds = dlg.getLinuxObject();
                    scanObj = new LinuxAdminDefinedScanObject(linuxAds);
                    break;
                }
            }
        }
        return dlg.isOk() ? scanObj : null;
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(AdminDefinedScanObject.class, MacAdminDefinedScanObject.class, LinuxAdminDefinedScanObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 255;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof AdminDefinedScanObject || policyObj instanceof MacAdminDefinedScanObject || policyObj instanceof LinuxAdminDefinedScanObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return NOT_IMPLEMENTED;
    }

    @Override
    protected String getReplacePolicyTitle() {
        return NOT_IMPLEMENTED;
    }

    @Override
    protected String getReplacePolicyMessage() {
        return NOT_IMPLEMENTED;
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return NOT_IMPLEMENTED;
    }

    @Override
    protected String getImportFailMessage() {
        return NOT_IMPLEMENTED;
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof AdminDefinedScan) {
            return new AdminDefinedScanObject((AdminDefinedScan)obj);
        }
        if (obj instanceof MacAdminDefinedScan) {
            return new MacAdminDefinedScanObject((MacAdminDefinedScan)obj);
        }
        if (obj instanceof LinuxAdminDefinedScan) {
            return new LinuxAdminDefinedScanObject((LinuxAdminDefinedScan)obj);
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        PolicyObjectBase pob = null;
        int itemType = infoObj.getItemType();
        switch (itemType) {
            case 129: {
                pob = new AdminDefinedScanObject(DataobjectManager.getInstance().getAdminDefinedScan(infoObj.getId()));
                break;
            }
            case 400: {
                pob = new MacAdminDefinedScanObject(DataobjectManager.getInstance().getMacAdminDefinedScan(infoObj.getId()));
                break;
            }
            case 406: {
                pob = new LinuxAdminDefinedScanObject(DataobjectManager.getInstance().getLinuxAdminDefinedScan(infoObj.getId()));
                break;
            }
        }
        return pob;
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return ScheduleScanPoolObject.getPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new ScheduleScanPoolObject(domain);
    }

    protected boolean isAnyPolicyInUse(PolicyObjectBase policy) {
        return false;
    }

    @Override
    protected String getDeletePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AVScanPolicyHandler.deleteScanMsg");
    }

    @Override
    protected String getDeletePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AVScanPolicyHandler.deleteScheduledScan");
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        return new MessageResourcesFile("com.sygate.scm.console.ui.policy.explorer.explorer").getString("BaseAVScanPoolHandler.title");
    }
}

