/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.av;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.ApAction;
import com.sygate.scm.common.configobject.schema.ApActions;
import com.sygate.scm.common.configobject.schema.ApScanOptions;
import com.sygate.scm.common.configobject.schema.AvFileAp;
import com.sygate.scm.common.configobject.schema.AvPolicy;
import com.sygate.scm.common.configobject.schema.HppPolicy;
import com.sygate.scm.common.configobject.schema.MacAdminDefinedScan;
import com.sygate.scm.common.configobject.schema.MacAvAutoProtect;
import com.sygate.scm.common.configobject.schema.MacAvScanPolicy;
import com.sygate.scm.common.configobject.schema.MacCommandScan;
import com.sygate.scm.common.configobject.schema.MacGeneralScanSettings;
import com.sygate.scm.common.configobject.schema.OptimizedMountScan;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.util.PolicyUtils;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.ObjInfoObject;
import com.sygate.scm.console.logicobject.PolicyObjectBase;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.av.AvPolicyDialog;
import com.sygate.scm.console.ui.policy.av.logicobject.AvPolicyObject;
import com.sygate.scm.console.ui.policy.av.logicobject.AvPolicyPoolObject;
import com.sygate.scm.console.ui.policy.explorer.av.AvPolicyPoolPane;
import com.sygate.scm.console.ui.policy.explorer.common.BasePolicyHandler;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.AVUtility;
import com.sygate.scm.util.GUID;
import com.sygate.scm.util.LoggerUtilities;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AvPolicyHandler
extends BasePolicyHandler {
    private static final String PAGE_NAME = "policypage";
    private static final String AUTOMATION_ID_AV_POLICY_POOL_PANE = "AvPolicyPoolPane";
    public static final MessageResourcesFile TEMPLATE_RES = new MessageResourcesFile("com.sygate.scm.util.template.template");
    private static AvPolicyHandler handler;

    private AvPolicyHandler() {
        this.policyPoolPane = new AvPolicyPoolPane();
        UIUtilities.setName(this.policyPoolPane, PAGE_NAME, UIUtilities.ComponentType.JPANEL, AUTOMATION_ID_AV_POLICY_POOL_PANE);
    }

    public static synchronized AvPolicyHandler getInstance() {
        if (handler == null) {
            handler = new AvPolicyHandler();
        }
        return handler;
    }

    public static synchronized void clearInstance() {
        handler = null;
    }

    @Override
    public boolean hasLicense(boolean justCheckLicense) {
        return true;
    }

    @Override
    protected BasePolicyDialog getNewPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new AvPolicyDialog(pool);
    }

    @Override
    protected BasePolicyDialog getEditPolicyDialog(AppliablePolicyPool pool) throws ConsoleException {
        return new AvPolicyDialog(pool, true);
    }

    @Override
    protected List<Class<? extends PolicyObjectBase>> getPolicyObjectClass() {
        return Arrays.asList(AvPolicyObject.class);
    }

    @Override
    protected int getPolicyNameLength() {
        return 255;
    }

    @Override
    protected boolean isCorrectPolicyType(PolicyObjectBase policyObj) {
        return policyObj instanceof AvPolicyObject;
    }

    @Override
    protected String getApplyPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AvPolicyHandler.applyAvPolicy");
    }

    @Override
    protected String getReplacePolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AvPolicyHandler.replaceAvPolicy");
    }

    @Override
    protected String getReplacePolicyMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AvPolicyHandler.thisIsTheOnlyAvPolicyIn");
    }

    @Override
    protected String getWithdrawPolicyTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AvPolicyHandler.withdrawAvPolicy");
    }

    @Override
    protected String getImportFailMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AvPolicyHandler.failedToImportThePolicy");
    }

    @Override
    protected String getPolicyPoolPaneTitle(String name) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "AvPolicyPoolPane.title.avPolicies");
    }

    @Override
    protected PolicyObjectBase createPolicyObject(ConfigObject obj) {
        if (obj instanceof AvPolicy) {
            return new AvPolicyObject((TopLevelObject)((AvPolicy)obj));
        }
        return null;
    }

    @Override
    protected PolicyObjectBase getPolicyObject(ObjInfoObject infoObj) throws ConsoleException {
        return new AvPolicyObject((TopLevelObject)DataobjectManager.getInstance().getAvPolicy(infoObj.getId()));
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject() throws ConsoleException {
        return AvPolicyPoolObject.getPolicyPool();
    }

    @Override
    protected AppliablePolicyPool getPolicyPoolObject(SemDomain domain) throws ConsoleException {
        return new AvPolicyPoolObject(domain);
    }

    @Override
    public void handleCustomImportConfiguration(ConfigObject policyObj) {
        if (policyObj == null) {
            LoggerUtilities.log((String)"handleCustomImportConfiguration: AV policy null ");
            return;
        }
        if (!(policyObj instanceof AvPolicy)) {
            LoggerUtilities.log((String)("handleCustomImportConfiguration: AV policy incorrect: " + policyObj.getClass().getName()));
            return;
        }
        HashMap<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();
        AvPolicy avPolicyDef = null;
        try {
            avPolicyDef = PolicyHandler.getDefaultAvPolicy(newObjList);
        }
        catch (Exception e1) {
            LoggerUtilities.log((String)"AvPolicyHandler.handleCustomImportConfiguration::Exception while fetching default Av Policy");
            LoggerUtilities.logException((Throwable)e1);
        }
        if (avPolicyDef == null) {
            LoggerUtilities.log((String)"Error received null AV Policy object from policy handler");
            return;
        }
        AvPolicy avPol = (AvPolicy)policyObj;
        this.fixAvPolicyForMac(avPol, avPolicyDef, newObjList);
        this.fixAutoProtectForMac(avPol);
        this.fixOptimizedScanForMac(avPol, avPolicyDef);
        this.fixAPActionsForMac(avPol, avPolicyDef);
        this.fixAPRiskActionsForMac(avPol, avPolicyDef);
        this.fixCommandScanForMac(avPol, avPolicyDef);
        Optional.ofNullable(avPol.getOptHppPolicy()).map(HppPolicy::getOptBASHPolicy).ifPresent(PolicyUtils::updateBASHOptionsInAvPolicy);
    }

    private void fixAvPolicyForMac(AvPolicy avPol, AvPolicy avPolicyDef, Map<String, TopLevelObject> newObjList) {
        try {
            boolean saveAds = false;
            if (avPol.getOptMacAvGeneral() == null && avPolicyDef.getOptMacAvGeneral() != null) {
                avPol.setOptMacAvGeneral(avPolicyDef.getOptMacAvGeneral());
                LoggerUtilities.log((String)"Added Mac general section");
            }
            if (avPol.getOptMacAvAutoProtect() == null && avPolicyDef.getOptMacAvAutoProtect() != null) {
                avPol.setOptMacAvAutoProtect(avPolicyDef.getOptMacAvAutoProtect());
                LoggerUtilities.log((String)"Added Mac AP section");
            }
            if (avPol.getOptMacAvScanPolicy() == null && avPolicyDef.getOptMacAvScanPolicy() != null) {
                avPol.setOptMacAvScanPolicy(avPolicyDef.getOptMacAvScanPolicy());
                saveAds = true;
                LoggerUtilities.log((String)"Added Mac Scan section");
            }
            if (saveAds && null != newObjList && newObjList.size() > 0) {
                DataobjectManager dom = DataobjectManager.getInstance();
                GUID scanOwner = new GUID(avPol.getId());
                for (TopLevelObject tlo : newObjList.values()) {
                    if (!(tlo instanceof MacAdminDefinedScan)) continue;
                    tlo.getMetadataAttributes().setOwner(scanOwner);
                    dom.addObject(tlo);
                }
            }
        }
        catch (Exception e) {
            LoggerUtilities.log((String)"ERROR: Exception adding default Mac AV tag to legacy AV policy being imported");
            LoggerUtilities.logException((Throwable)e);
        }
    }

    private void fixAutoProtectForMac(AvPolicy avPol) {
        ApScanOptions apScanOptions;
        AvFileAp avFileAp;
        MacAvAutoProtect macAvAutoProtect = avPol.getOptMacAvAutoProtect();
        if (macAvAutoProtect != null && (avFileAp = macAvAutoProtect.getOptAvFileAp()) != null && (apScanOptions = avFileAp.getOptApScanOptions()) != null && ApScanOptions.DO_NOT_SCAN.equals(apScanOptions.getWhereToScanFiles())) {
            avFileAp.setOptEnable(Boolean.FALSE);
            apScanOptions.setWhereToScanFiles(apScanOptions.getDefWhereToScanFiles());
        }
    }

    private void fixOptimizedScanForMac(AvPolicy avPol, AvPolicy avPolicyDef) {
        OptimizedMountScan optimizedMountScan;
        AvFileAp avFileAp;
        MacAvAutoProtect macAvAutoProtect = avPol.getOptMacAvAutoProtect();
        MacAvAutoProtect defaultMacAvAutoProtect = avPolicyDef.getOptMacAvAutoProtect();
        if (macAvAutoProtect != null && defaultMacAvAutoProtect != null && (avFileAp = macAvAutoProtect.getOptAvFileAp()) != null && (optimizedMountScan = avFileAp.getOptOptimizedMountScan()) == null) {
            try {
                AvFileAp defaultAvFileAp = defaultMacAvAutoProtect.getOptAvFileAp();
                if (defaultAvFileAp != null) {
                    avFileAp.setOptOptimizedMountScan(defaultAvFileAp.getOptOptimizedMountScan());
                }
            }
            catch (Exception e) {
                LoggerUtilities.log((String)"AvPolicyHandler.handleCustomImportConfiguration()::Exception whle setting OptimizedMountScan in Av policy");
                LoggerUtilities.logException((Throwable)e);
            }
        }
    }

    private void fixAPActionsForMac(AvPolicy avPol, AvPolicy avPolicyDef) {
        AvFileAp avFileAp;
        MacAvAutoProtect macAvAutoProtect = avPol.getOptMacAvAutoProtect();
        if (macAvAutoProtect != null && (avFileAp = macAvAutoProtect.getOptAvFileAp()) != null) {
            ApActions apActions = avFileAp.getOptApActions();
            if (apActions == null) {
                apActions = Optional.of(avPolicyDef).map(AvPolicy::getOptMacAvAutoProtect).map(MacAvAutoProtect::getOptAvFileAp).map(AvFileAp::getOptApActions).orElse(null);
                if (apActions == null) {
                    apActions = AVUtility.getInstance().getDefaultMacApActions();
                }
                avFileAp.setOptApActions(apActions);
            } else if (apActions.getSecurityRiskGroupCount() == 0) {
                Boolean autoRepairInfectedFiles = Optional.of(apActions).map(ApActions::getOptAutoRepairInfectedFiles).orElseGet(() -> ((ApActions)apActions).getDefAutoRepairInfectedFiles());
                Boolean quarantineUnrepairableFiles = Optional.of(apActions).map(ApActions::getOptQuarantineUnrepairableFiles).orElseGet(() -> ((ApActions)apActions).getDefQuarantineUnrepairableFiles());
                ApActions defaultApActions = Optional.of(avPolicyDef).map(AvPolicy::getOptMacAvAutoProtect).map(MacAvAutoProtect::getOptAvFileAp).map(AvFileAp::getOptApActions).orElse(null);
                apActions = AVUtility.getInstance().getDefaultMacApActions();
                avFileAp.setOptApActions(apActions);
                this.updateApActions(apActions, defaultApActions, autoRepairInfectedFiles, quarantineUnrepairableFiles);
            }
        }
    }

    private void fixAPRiskActionsForMac(AvPolicy avPol, AvPolicy avPolicyDef) {
        block2: {
            ApActions apActions;
            MacGeneralScanSettings scanSettings;
            block3: {
                MacAvScanPolicy macAvScanPolicy = avPol.getOptMacAvScanPolicy();
                if (macAvScanPolicy == null || (scanSettings = macAvScanPolicy.getOptMacGeneralScanSettings()) == null) break block2;
                apActions = scanSettings.getOptApActions();
                if (apActions == null) break block3;
                if (apActions.getSecurityRiskGroupCount() != 0) break block2;
            }
            Boolean autoRepairInfectedFiles = Optional.of(scanSettings).map(MacGeneralScanSettings::getOptAutoRepairInfectedFiles).orElseGet(() -> ((MacGeneralScanSettings)scanSettings).getDefAutoRepairInfectedFiles());
            Boolean quarantineUnrepairableFiles = Optional.of(scanSettings).map(MacGeneralScanSettings::getOptQuarantineUnrepairableFiles).orElseGet(() -> ((MacGeneralScanSettings)scanSettings).getDefQuarantineUnrepairableFiles());
            ApActions defaultApActions = Optional.of(avPolicyDef).map(AvPolicy::getOptMacAvScanPolicy).map(MacAvScanPolicy::getOptMacGeneralScanSettings).map(MacGeneralScanSettings::getOptApActions).orElse(null);
            apActions = AVUtility.getInstance().getDefaultMacApActions();
            scanSettings.setOptApActions(apActions);
            this.updateApActions(apActions, defaultApActions, autoRepairInfectedFiles, quarantineUnrepairableFiles);
        }
    }

    private void fixCommandScanForMac(AvPolicy avPol, AvPolicy avPolicyDef) {
        block2: {
            ApActions apActions;
            MacGeneralScanSettings scanSettings;
            block3: {
                MacCommandScan macCommandScan;
                MacAvScanPolicy macAvScanPolicy = avPol.getOptMacAvScanPolicy();
                if (macAvScanPolicy == null || (macCommandScan = macAvScanPolicy.getOptMacCommandScan()) == null || (scanSettings = macCommandScan.getOptMacGeneralScanSettings()) == null) break block2;
                apActions = scanSettings.getOptApActions();
                if (apActions == null) break block3;
                if (apActions.getSecurityRiskGroupCount() != 0) break block2;
            }
            Boolean autoRepairInfectedFiles = Optional.of(scanSettings).map(MacGeneralScanSettings::getOptAutoRepairInfectedFiles).orElseGet(() -> ((MacGeneralScanSettings)scanSettings).getDefAutoRepairInfectedFiles());
            Boolean quarantineUnrepairableFiles = Optional.of(scanSettings).map(MacGeneralScanSettings::getOptQuarantineUnrepairableFiles).orElseGet(() -> ((MacGeneralScanSettings)scanSettings).getDefQuarantineUnrepairableFiles());
            ApActions defaultApActions = Optional.of(avPolicyDef).map(AvPolicy::getOptMacAvScanPolicy).map(MacAvScanPolicy::getOptMacCommandScan).map(MacCommandScan::getOptMacGeneralScanSettings).map(MacGeneralScanSettings::getOptApActions).orElse(null);
            apActions = AVUtility.getInstance().getDefaultMacApActions();
            scanSettings.setOptApActions(apActions);
            this.updateApActions(apActions, defaultApActions, autoRepairInfectedFiles, quarantineUnrepairableFiles);
        }
    }

    private void updateApActions(ApActions apActions, ApActions defaultApActions, boolean autoRepairInfectedFiles, boolean quarantineUnrepairableFiles) {
        ApAction destApAction = apActions.getSecurityRiskGroup(0).getApAction();
        if (defaultApActions != null) {
            ApAction sourceApAction = defaultApActions.getSecurityRiskGroup(0).getApAction();
            destApAction.setOptLockFirstAction(sourceApAction.getOptLockFirstAction());
            destApAction.setOptLockSecondAction(sourceApAction.getOptLockSecondAction());
        }
        if (autoRepairInfectedFiles) {
            destApAction.setFirstAction(ApAction.CLEAN);
            if (quarantineUnrepairableFiles) {
                destApAction.setSecondAction(ApAction.QUARANTINE);
            } else {
                destApAction.setSecondAction(ApAction.LOG_ONLY);
            }
        } else {
            destApAction.setFirstAction(ApAction.LOG_ONLY);
            destApAction.setSecondAction(ApAction.LOG_ONLY);
        }
    }
}

