/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.explorer.app.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ApplicationObject;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.explorer.app.data.AppTableModel;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class ApplicationObjectDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    JPanel contentPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel bottomPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    JTextField fileNameTextField = new JTextField();
    JLabel nameLbl = new JLabel();
    JLabel dscrLbl = new JLabel();
    JLabel sizeLbl = new JLabel();
    JLabel lastModLbl = new JLabel();
    JLabel chkSumLbl = new JLabel();
    JTextField dscrTextField = new JTextField();
    JTextField szTextField = new JTextField();
    JTextField lastModTextField = new JTextField();
    JTextField chkSumTextField = new JTextField();
    JButton cancelButton = new JButton();
    JButton okButton = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Border border1;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    private AppTableModel appTableModel = null;
    boolean isEditAction = false;
    int editRowIndex = -1;

    public ApplicationObjectDialog(Frame frame, String title, boolean modal, AppTableModel model) {
        this(frame, title, modal, model, false, -1);
    }

    public ApplicationObjectDialog(Frame frame, String title, boolean modal, AppTableModel model, boolean editAction, int whichRow) {
        super(frame, title, modal);
        this.appTableModel = model;
        this.isEditAction = editAction;
        this.editRowIndex = whichRow;
        try {
            this.jbInit();
            this.initDialog();
            this.pack();
            UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.okButton);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public ApplicationObjectDialog() {
        this((Frame)null, "", false, (AppTableModel)null);
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void okButton_actionPerformed(ActionEvent e) {
        boolean isValid = this.validateInput();
        if (!isValid) {
            return;
        }
        if (!this.validateFileName(this.fileNameTextField.getText())) {
            return;
        }
        try {
            this.checkLastModifyDate();
            int checksumLen = this.chkSumTextField.getText().trim().length();
            if (checksumLen > 0 && checksumLen != 32) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.fingerprintIsA128BitHexNumber"), this.chkSumTextField);
            }
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.error"), 0);
            ex.getErrorComponent().requestFocus();
            return;
        }
        ApplicationObject appObj = null;
        if (this.isEditAction && this.editRowIndex > -1) {
            appObj = this.appTableModel.getApplicationObjectAt(this.editRowIndex);
            this.setAppObject(appObj);
            this.appTableModel.updateApplicationObjectAtRow(this.editRowIndex);
        } else {
            appObj = new ApplicationObject();
            this.setAppObject(appObj);
            this.appTableModel.addAppObject(appObj);
        }
        this.dispose();
    }

    private void initDialog() {
        if (this.isEditAction && this.editRowIndex > -1) {
            ApplicationObject appObj = this.appTableModel.getApplicationObjectAt(this.editRowIndex);
            this.fileNameTextField.setText(appObj.getFileName());
            this.dscrTextField.setText(appObj.getFileDescription());
            this.szTextField.setText(Long.valueOf(appObj.getSize()).toString());
            this.chkSumTextField.setText(appObj.getMd5Checksum());
            this.lastModTextField.setText(appObj.getModifyDate());
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(333, 300));
        this.border1 = new EtchedBorder(0, UIColorUtilities.TITLED_BORDER_HIGHLIGHT, UIColorUtilities.TITLED_BORDER_SHADOW);
        this.contentPanel.setLayout(this.borderLayout1);
        this.mainPanel.setLayout(this.gridBagLayout2);
        this.nameLbl.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.label.fileName"));
        this.dscrLbl.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.label.description"));
        this.sizeLbl.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.label.size"));
        this.lastModLbl.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.label.lastModified"));
        this.chkSumLbl.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.label.fingerprint"));
        this.fileNameTextField.setText("");
        RestrictedPlainDocument doc4 = new RestrictedPlainDocument(260);
        doc4.setValidator("\"?<>|", false);
        this.fileNameTextField.setDocument(doc4);
        this.dscrTextField.setText("");
        RestrictedPlainDocument doc3 = new RestrictedPlainDocument(1024);
        this.dscrTextField.setDocument(doc3);
        NumberPlainDocument doc = new NumberPlainDocument(Long.MAX_VALUE);
        this.szTextField.setDocument(doc);
        this.szTextField.setText("");
        this.lastModTextField.setText("");
        RestrictedPlainDocument doc2 = new RestrictedPlainDocument(10);
        this.lastModTextField.setDocument(doc2);
        this.chkSumTextField.setText("");
        RestrictedPlainDocument doc1 = new RestrictedPlainDocument(32);
        this.fileNameTextField.setPreferredSize(new Dimension(240, 20));
        doc1.setValidator("1234567890ABCDEFabcdef", true);
        this.chkSumTextField.setDocument(doc1);
        this.bottomPanel.setLayout(this.gridBagLayout1);
        this.cancelButton.setMnemonic(UIText.getHotKey(512));
        this.cancelButton.setText(UIText.get(512));
        this.cancelButton.addActionListener(new NewAppDialog_cancelButton_actionAdapter(this));
        this.okButton.setMnemonic(UIText.getHotKey(3584));
        this.okButton.setText(UIText.get(3584));
        this.okButton.addActionListener(new NewAppDialog_okButton_actionAdapter(this));
        this.bottomPanel.setBorder(this.border1);
        this.getContentPane().add(this.contentPanel);
        this.contentPanel.add((Component)this.bottomPanel, "South");
        this.contentPanel.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.sizeLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.mainPanel.add((Component)this.lastModLbl, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.mainPanel.add((Component)this.chkSumLbl, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
        this.mainPanel.add((Component)this.nameLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
        this.mainPanel.add((Component)this.dscrLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.mainPanel.add((Component)this.fileNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 10), 0, 0));
        this.mainPanel.add((Component)this.dscrTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.mainPanel.add((Component)this.chkSumTextField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 10, 10), 0, 0));
        this.mainPanel.add((Component)this.lastModTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.mainPanel.add((Component)this.szTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.bottomPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 10, 10), 0, 0));
        this.bottomPanel.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 10, 5), 0, 0));
    }

    private void setAppObject(ApplicationObject appObj) {
        appObj.setFileName(this.fileNameTextField.getText());
        appObj.setFileDescription(this.dscrTextField.getText());
        String szText = this.szTextField.getText();
        long size = szText.equals("") ? -1L : Long.parseLong(szText);
        appObj.setSize(size);
        appObj.setMd5Checksum(this.chkSumTextField.getText());
        appObj.setModifyDate(this.lastModTextField.getText());
    }

    private boolean validateInput() {
        String name = this.fileNameTextField.getText();
        String dscr = this.dscrTextField.getText();
        String sz = this.szTextField.getText();
        String lm = this.lastModTextField.getText();
        String chkSum = this.chkSumTextField.getText();
        if (name.equals("") && dscr.equals("") && chkSum.equals("") && sz.equals("") && lm.equals("")) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.oneOrMoreFieldsMustBeEntered"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.application"), 0);
            this.fileNameTextField.requestFocus(true);
            return false;
        }
        return true;
    }

    private boolean validateFileName(String fileName) {
        if (fileName.trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.filenameFieldCannotBeEmpty"));
            this.fileNameTextField.requestFocus();
            return false;
        }
        if (fileName.indexOf("*") != -1 && fileName.length() > 1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.invalidFilename"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.error"), 0);
            this.fileNameTextField.requestFocus();
            return false;
        }
        return true;
    }

    private void checkLastModifyDate() throws GUICheckException {
        boolean MONTH = false;
        boolean DAY = true;
        int YEAR = 2;
        String text = this.lastModTextField.getText();
        if (text.trim().length() == 0) {
            return;
        }
        text = text.trim();
        int col = 0;
        StringTokenizer st = new StringTokenizer(text, "/");
        while (st.hasMoreTokens()) {
            String part = st.nextToken();
            switch (col) {
                case 0: {
                    Object[] obj = new Object[]{part};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.monthShouldBe");
                    String fm = MessageFormat.format(str, obj);
                    try {
                        int month;
                        if (!(part.equals("*") || (month = Integer.parseInt(part)) >= 1 && month <= 12)) {
                            throw new GUICheckException(fm, this.lastModTextField);
                        }
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new GUICheckException(fm, this.lastModTextField);
                    }
                }
                case 1: {
                    Object[] obj1 = new Object[]{part};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.dayShouldBe");
                    String fm = MessageFormat.format(str, obj1);
                    if (part.equals("*")) break;
                    try {
                        int day = Integer.parseInt(part);
                        if (day < 1 || day > 31) {
                            throw new GUICheckException(fm, this.lastModTextField);
                        }
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new GUICheckException(fm, this.lastModTextField);
                    }
                }
                case 2: {
                    Object[] obj2 = new Object[]{part};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.yearShouldBe");
                    String fm = MessageFormat.format(str, obj2);
                    if (part.equals("*")) break;
                    try {
                        int year = Integer.parseInt(part);
                        if (year < 1000 || year > 9999) {
                            throw new GUICheckException(fm, this.lastModTextField);
                        }
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new GUICheckException(fm, this.lastModTextField);
                    }
                }
                default: {
                    throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.dataFormatShouldBe"), this.lastModTextField);
                }
            }
            ++col;
        }
        if (col < 3) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.dataFormatShouldBe"), this.lastModTextField);
        }
        if (text.endsWith("/")) {
            throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.explorer.explorer", "ApplicationObjectDialog.dataFormatShouldBe"), this.lastModTextField);
        }
    }

    static class NewAppDialog_okButton_actionAdapter
    implements ActionListener {
        ApplicationObjectDialog adaptee;

        NewAppDialog_okButton_actionAdapter(ApplicationObjectDialog adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.okButton_actionPerformed(e);
        }
    }

    static class NewAppDialog_cancelButton_actionAdapter
    implements ActionListener {
        ApplicationObjectDialog adaptee;

        NewAppDialog_cancelButton_actionAdapter(ApplicationObjectDialog adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.cancelButton_actionPerformed(e);
        }
    }
}

